/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.protocol;

import endpoints.repackaged.org.apache.http.Header;
import endpoints.repackaged.org.apache.http.HttpEntity;
import endpoints.repackaged.org.apache.http.HttpException;
import endpoints.repackaged.org.apache.http.HttpRequest;
import endpoints.repackaged.org.apache.http.HttpResponse;
import endpoints.repackaged.org.apache.http.HttpResponseInterceptor;
import endpoints.repackaged.org.apache.http.HttpVersion;
import endpoints.repackaged.org.apache.http.ProtocolVersion;
import endpoints.repackaged.org.apache.http.protocol.HttpContext;
import java.io.IOException;

public class ResponseConnControl
implements HttpResponseInterceptor {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header header;
        HttpRequest request;
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 503 || status == 501) {
            response.setHeader("Connection", "Close");
            return;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
            if (entity.getContentLength() < 0L && (!entity.isChunked() || ver.lessEquals(HttpVersion.HTTP_1_0))) {
                response.setHeader("Connection", "Close");
                return;
            }
        }
        if ((request = (HttpRequest)context.getAttribute("http.request")) != null && (header = request.getFirstHeader("Connection")) != null) {
            response.setHeader("Connection", header.getValue());
        }
    }
}

