/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.jose4j.json;

import endpoints.repackaged.org.jose4j.json.internal.json_simple.JSONValue;
import endpoints.repackaged.org.jose4j.json.internal.json_simple.parser.ContainerFactory;
import endpoints.repackaged.org.jose4j.json.internal.json_simple.parser.JSONParser;
import endpoints.repackaged.org.jose4j.json.internal.json_simple.parser.ParseException;
import endpoints.repackaged.org.jose4j.lang.JoseException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        @Override
        public List creatArrayContainer() {
            return new ArrayList();
        }

        @Override
        public Map createObjectContainer() {
            return new DupeKeyDisallowingLinkedHashMap();
        }
    };

    public static Map<String, Object> parseJson(String jsonString) throws JoseException {
        try {
            JSONParser parser = new JSONParser();
            return (DupeKeyDisallowingLinkedHashMap)parser.parse(jsonString, CONTAINER_FACTORY);
        }
        catch (ParseException | IllegalArgumentException e) {
            throw new JoseException("Parsing error: " + e, e);
        }
    }

    public static String toJson(Map<String, ?> map) {
        return JSONValue.toJSONString(map);
    }

    public static void writeJson(Map<String, ?> map, Writer w) throws IOException {
        JSONValue.writeJSONString(map, w);
    }

    static class DupeKeyDisallowingLinkedHashMap
    extends LinkedHashMap<String, Object> {
        DupeKeyDisallowingLinkedHashMap() {
        }

        @Override
        public Object put(String key, Object value) {
            if (this.containsKey(key)) {
                throw new IllegalArgumentException("An entry for '" + key + "' already exists. Names must be unique.");
            }
            return super.put(key, value);
        }
    }
}

