/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.jose4j.jwk;

import endpoints.repackaged.org.jose4j.jwk.EllipticCurveJsonWebKey;
import endpoints.repackaged.org.jose4j.jwk.PublicJsonWebKey;
import endpoints.repackaged.org.jose4j.keys.EcKeyUtil;
import endpoints.repackaged.org.jose4j.lang.JoseException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECParameterSpec;

public class EcJwkGenerator {
    public static EllipticCurveJsonWebKey generateJwk(ECParameterSpec spec) throws JoseException {
        return EcJwkGenerator.generateJwk(spec, null, null);
    }

    public static EllipticCurveJsonWebKey generateJwk(ECParameterSpec spec, String provider, SecureRandom secureRandom) throws JoseException {
        EcKeyUtil keyUtil = new EcKeyUtil(provider, secureRandom);
        KeyPair keyPair = keyUtil.generateKeyPair(spec);
        PublicKey publicKey = keyPair.getPublic();
        EllipticCurveJsonWebKey ecJwk = (EllipticCurveJsonWebKey)PublicJsonWebKey.Factory.newPublicJwk(publicKey);
        ecJwk.setPrivateKey(keyPair.getPrivate());
        return ecJwk;
    }
}

