/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.jose4j.keys.resolvers;

import endpoints.repackaged.org.jose4j.jwk.HttpsJwks;
import endpoints.repackaged.org.jose4j.jwk.JsonWebKey;
import endpoints.repackaged.org.jose4j.jwk.VerificationJwkSelector;
import endpoints.repackaged.org.jose4j.jws.JsonWebSignature;
import endpoints.repackaged.org.jose4j.jwx.JsonWebStructure;
import endpoints.repackaged.org.jose4j.keys.resolvers.VerificationKeyResolver;
import endpoints.repackaged.org.jose4j.lang.JoseException;
import endpoints.repackaged.org.jose4j.lang.UnresolvableKeyException;
import endpoints.repackaged.org.slf4j.Logger;
import endpoints.repackaged.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.security.Key;
import java.util.List;

public class HttpsJwksVerificationKeyResolver
implements VerificationKeyResolver {
    private static final Logger log = LoggerFactory.getLogger(HttpsJwksVerificationKeyResolver.class);
    private VerificationJwkSelector verificationJwkSelector = new VerificationJwkSelector();
    private HttpsJwks httpsJkws;
    private boolean disambiguateWithVerifySignature;

    public HttpsJwksVerificationKeyResolver(HttpsJwks httpsJkws) {
        this.httpsJkws = httpsJkws;
    }

    @Override
    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        JsonWebKey theChosenOne;
        List<JsonWebKey> jsonWebKeys;
        try {
            jsonWebKeys = this.httpsJkws.getJsonWebKeys();
            theChosenOne = this.select(jws, jsonWebKeys);
            if (theChosenOne == null) {
                log.debug("Refreshing JWKs from {} as no suitable verification key for JWS w/ header {} was found in {}", this.httpsJkws.getLocation(), jws.getHeaders().getFullHeaderAsJsonString(), jsonWebKeys);
                this.httpsJkws.refresh();
                jsonWebKeys = this.httpsJkws.getJsonWebKeys();
                theChosenOne = this.select(jws, jsonWebKeys);
            }
        }
        catch (JoseException | IOException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable verification key for JWS w/ header ").append(jws.getHeaders().getFullHeaderAsJsonString());
            sb.append(" due to an unexpected exception (").append(e).append(") while obtaining or using keys from JWKS endpoint at ").append(this.httpsJkws.getLocation());
            throw new UnresolvableKeyException(sb.toString(), e);
        }
        if (theChosenOne == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find a suitable verification key for JWS w/ header ").append(jws.getHeaders().getFullHeaderAsJsonString());
            sb.append(" from JWKs ").append(jsonWebKeys).append(" obtained from ").append(this.httpsJkws.getLocation());
            throw new UnresolvableKeyException(sb.toString());
        }
        return theChosenOne.getKey();
    }

    private JsonWebKey select(JsonWebSignature jws, List<JsonWebKey> jsonWebKeys) throws JoseException {
        if (this.disambiguateWithVerifySignature) {
            return this.verificationJwkSelector.selectWithVerifySignatureDisambiguate(jws, jsonWebKeys);
        }
        return this.verificationJwkSelector.select(jws, jsonWebKeys);
    }

    public void setDisambiguateWithVerifySignature(boolean disambiguateWithVerifySignature) {
        this.disambiguateWithVerifySignature = disambiguateWithVerifySignature;
    }
}

