/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.BaseFileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.CharsetDecoder;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;

public abstract class BaseFileObject
implements JavaFileObject {
    protected final JavacFileManager fileManager;

    protected BaseFileObject(JavacFileManager javacFileManager) {
        this.fileManager = javacFileManager;
    }

    public abstract String getShortName();

    public String toString() {
        String string = String.valueOf(String.valueOf(this.getClass().getSimpleName()));
        String string2 = String.valueOf(String.valueOf(this.getName()));
        return new StringBuilder(2 + string.length() + string2.length()).append(string).append("[").append(string2).append("]").toString();
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public Reader openReader(boolean bl) throws IOException {
        return new InputStreamReader(this.openInputStream(), this.getDecoder(bl));
    }

    protected CharsetDecoder getDecoder(boolean bl) {
        throw new UnsupportedOperationException();
    }

    protected abstract String inferBinaryName(Iterable<? extends File> var1);

    protected static JavaFileObject.Kind getKind(String string) {
        return BaseFileManager.getKind(string);
    }

    protected static String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }

    protected static URI createJarUri(File file, String string) {
        URI uRI = file.toURI().normalize();
        String string2 = string.startsWith("/") ? "!" : "!/";
        try {
            String string3 = String.valueOf(String.valueOf(uRI));
            String string4 = String.valueOf(String.valueOf(string2));
            String string5 = String.valueOf(String.valueOf(string));
            return new URI(new StringBuilder(4 + string3.length() + string4.length() + string5.length()).append("jar:").append(string3).append(string4).append(string5).toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            String string6 = String.valueOf(String.valueOf(uRI));
            String string7 = String.valueOf(String.valueOf(string2));
            String string8 = String.valueOf(String.valueOf(string));
            throw new CannotCreateUriError(new StringBuilder(0 + string6.length() + string7.length() + string8.length()).append(string6).append(string7).append(string8).toString(), uRISyntaxException);
        }
    }

    public static String getSimpleName(FileObject fileObject) {
        URI uRI = fileObject.toUri();
        String string = uRI.getSchemeSpecificPart();
        return string.substring(string.lastIndexOf("/") + 1);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected static class CannotCreateUriError
    extends Error {
        private static final long serialVersionUID = 9101708840997613546L;

        public CannotCreateUriError(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

