/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class ClassReader {
    protected static final Context.Key<ClassReader> classReaderKey = new Context.Key();
    public static final int INITIAL_BUFFER_SIZE = 65520;
    Annotate annotate;
    boolean verbose;
    boolean checkClassFile;
    public boolean readAllOfClassFile = false;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAnnotations;
    boolean allowSimplifiedVarargs;
    boolean lintClassfile;
    boolean allowDefaultMethods;
    public boolean saveParameterNames;
    private boolean cacheCompletionFailure;
    public boolean preferSource;
    public final Profile profile;
    final Log log;
    Symtab syms;
    Types types;
    final Names names;
    final Name completionFailureName;
    private final JavaFileManager fileManager;
    JCDiagnostic.Factory diagFactory;
    public SourceCompleter sourceCompleter = null;
    private Map<Name, Symbol.ClassSymbol> classes;
    private Map<Name, Symbol.PackageSymbol> packages;
    protected Scope typevars;
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    byte[] buf = new byte[65520];
    protected int bp;
    Object[] poolObj;
    int[] poolIdx;
    int majorVersion;
    int minorVersion;
    int[] parameterNameIndices;
    boolean haveParameterNameIndices;
    boolean sawMethodParameters;
    Set<Name> warnedAttrs = new HashSet<Name>();
    private final Symbol.Completer thisCompleter = new Symbol.Completer(){

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            ClassReader.this.complete(symbol);
        }
    };
    byte[] signature;
    int sigp;
    int siglimit;
    boolean sigEnterPhase = false;
    byte[] signatureBuffer = new byte[0];
    int sbp = 0;
    protected Set<AttributeKind> CLASS_ATTRIBUTE = EnumSet.of(AttributeKind.CLASS);
    protected Set<AttributeKind> MEMBER_ATTRIBUTE = EnumSet.of(AttributeKind.MEMBER);
    protected Set<AttributeKind> CLASS_OR_MEMBER_ATTRIBUTE = EnumSet.of(AttributeKind.CLASS, AttributeKind.MEMBER);
    protected Map<Name, AttributeReader> attributeReaders = new HashMap<Name, AttributeReader>();
    private boolean readingClassAttr = false;
    private List<Type> missingTypeVariables = List.nil();
    private List<Type> foundTypeVariables = List.nil();
    private boolean filling = false;
    private Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, (JCDiagnostic)null);
    protected JavaFileManager.Location currentLoc;
    private boolean verbosePath;

    public static ClassReader instance(Context context) {
        ClassReader classReader = context.get(classReaderKey);
        if (classReader == null) {
            classReader = new ClassReader(context, true);
        }
        return classReader;
    }

    public void init(Symtab symtab) {
        this.init(symtab, true);
    }

    private void init(Symtab symtab, boolean bl) {
        if (this.classes != null) {
            return;
        }
        if (bl) {
            Assert.check(this.packages == null || this.packages == symtab.packages);
            this.packages = symtab.packages;
            Assert.check(this.classes == null || this.classes == symtab.classes);
            this.classes = symtab.classes;
        } else {
            this.packages = new HashMap<Name, Symbol.PackageSymbol>();
            this.classes = new HashMap<Name, Symbol.ClassSymbol>();
        }
        this.packages.put(this.names.empty, symtab.rootPackage);
        symtab.rootPackage.completer = this.thisCompleter;
        symtab.unnamedPackage.completer = this.thisCompleter;
    }

    protected ClassReader(Context context, boolean bl) {
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        this.verbosePath = true;
        if (bl) {
            context.put(classReaderKey, this);
        }
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.init(this.syms, bl);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.annotate = Annotate.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.checkClassFile = options.isSet("-checkclassfile");
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowVarargs = source.allowVarargs();
        this.allowAnnotations = source.allowAnnotations();
        this.allowSimplifiedVarargs = source.allowSimplifiedVarargs();
        this.allowDefaultMethods = source.allowDefaultMethods();
        this.saveParameterNames = options.isSet("save-parameter-names");
        this.cacheCompletionFailure = options.isUnset("dev");
        this.preferSource = "source".equals(options.get("-Xprefer"));
        this.profile = Profile.instance(context);
        this.completionFailureName = options.isSet("failcomplete") ? this.names.fromString(options.get("failcomplete")) : null;
        this.typevars = new Scope(this.syms.noSymbol);
        this.lintClassfile = Lint.instance(context).isEnabled(Lint.LintCategory.CLASSFILE);
        this.initAttributeReaders();
    }

    private void enterMember(Symbol.ClassSymbol classSymbol, Symbol symbol) {
        if ((symbol.flags_field & 0x80001000L) != 4096L || symbol.name.startsWith(this.names.lambda)) {
            classSymbol.members_field.enter(symbol);
        }
    }

    private JCDiagnostic createBadClassFileDiagnostic(JavaFileObject javaFileObject, JCDiagnostic jCDiagnostic) {
        String string = javaFileObject.getKind() == JavaFileObject.Kind.SOURCE ? "bad.source.file.header" : "bad.class.file.header";
        return this.diagFactory.fragment(string, javaFileObject, jCDiagnostic);
    }

    public BadClassFile badClassFile(String string, Object ... objectArray) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFile, this.diagFactory.fragment(string, objectArray));
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextByte() {
        return this.buf[this.bp++] & 0xFF;
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    int getInt(int n) {
        return ((this.buf[n] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + (this.buf[n + 3] & 0xFF);
    }

    long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int n = 1;
        block7: while (n < this.poolIdx.length) {
            this.poolIdx[n++] = this.bp;
            byte by = this.buf[this.bp++];
            switch (by) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.bp += 2;
                    continue block7;
                }
                case 15: {
                    this.bp += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.bp += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++n;
                    continue block7;
                }
            }
            throw this.badClassFile("bad.const.pool.tag.at", Byte.toString(by), Integer.toString(this.bp - 1));
        }
    }

    Object readPool(int n) {
        Object object = this.poolObj[n];
        if (object != null) {
            return object;
        }
        int n2 = this.poolIdx[n];
        if (n2 == 0) {
            return null;
        }
        byte by = this.buf[n2];
        switch (by) {
            case 1: {
                this.poolObj[n] = this.names.fromUtf(this.buf, n2 + 3, this.getChar(n2 + 1));
                break;
            }
            case 2: {
                throw this.badClassFile("unicode.str.not.supported", new Object[0]);
            }
            case 7: {
                this.poolObj[n] = this.readClassOrType(this.getChar(n2 + 1));
                break;
            }
            case 8: {
                this.poolObj[n] = this.readName(this.getChar(n2 + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.VarSymbol(0L, nameAndType.name, nameAndType.uniqueType.type, classSymbol);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.MethodSymbol(0L, nameAndType.name, nameAndType.uniqueType.type, classSymbol);
                break;
            }
            case 12: {
                this.poolObj[n] = new ClassFile.NameAndType(this.readName(this.getChar(n2 + 1)), this.readType(this.getChar(n2 + 3)), this.types);
                break;
            }
            case 3: {
                this.poolObj[n] = this.getInt(n2 + 1);
                break;
            }
            case 4: {
                this.poolObj[n] = new Float(this.getFloat(n2 + 1));
                break;
            }
            case 5: {
                this.poolObj[n] = new Long(this.getLong(n2 + 1));
                break;
            }
            case 6: {
                this.poolObj[n] = new Double(this.getDouble(n2 + 1));
                break;
            }
            case 15: {
                this.skipBytes(4);
                break;
            }
            case 16: {
                this.skipBytes(3);
                break;
            }
            case 18: {
                this.skipBytes(5);
                break;
            }
            default: {
                throw this.badClassFile("bad.const.pool.tag", Byte.toString(by));
            }
        }
        return this.poolObj[n];
    }

    Type readType(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToType(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Object readClassOrType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        int n3 = n2 + 3;
        Assert.check(this.buf[n3] == 91 || this.buf[n3 + c - 1] != 59);
        return this.buf[n3] == 91 || this.buf[n3 + c - 1] == 59 ? this.sigToType(this.buf, n3, c) : this.enterClass(this.names.fromUtf(ClassFile.internalize(this.buf, n3, c)));
    }

    List<Type> readTypeParams(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToTypeParams(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Symbol.ClassSymbol readClassSymbol(int n) {
        return (Symbol.ClassSymbol)this.readPool(n);
    }

    Name readName(int n) {
        return (Name)this.readPool(n);
    }

    Type sigToType(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToType();
    }

    Type sigToType() {
        switch ((char)this.signature[this.sigp]) {
            case 'T': {
                ++this.sigp;
                int n = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.sigEnterPhase ? Type.noType : this.findTypeVar(this.names.fromUtf(this.signature, n, this.sigp - 1 - n));
            }
            case '+': {
                ++this.sigp;
                Type type = this.sigToType();
                return new Type.WildcardType(type, BoundKind.EXTENDS, this.syms.boundClass);
            }
            case '*': {
                ++this.sigp;
                return new Type.WildcardType(this.syms.objectType, BoundKind.UNBOUND, this.syms.boundClass);
            }
            case '-': {
                ++this.sigp;
                Type type = this.sigToType();
                return new Type.WildcardType(type, BoundKind.SUPER, this.syms.boundClass);
            }
            case 'B': {
                ++this.sigp;
                return this.syms.byteType;
            }
            case 'C': {
                ++this.sigp;
                return this.syms.charType;
            }
            case 'D': {
                ++this.sigp;
                return this.syms.doubleType;
            }
            case 'F': {
                ++this.sigp;
                return this.syms.floatType;
            }
            case 'I': {
                ++this.sigp;
                return this.syms.intType;
            }
            case 'J': {
                ++this.sigp;
                return this.syms.longType;
            }
            case 'L': {
                Type type = this.classSigToType();
                if (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    throw this.badClassFile("deprecated inner class signature syntax (please recompile from source)", new Object[0]);
                }
                return type;
            }
            case 'S': {
                ++this.sigp;
                return this.syms.shortType;
            }
            case 'V': {
                ++this.sigp;
                return this.syms.voidType;
            }
            case 'Z': {
                ++this.sigp;
                return this.syms.booleanType;
            }
            case '[': {
                ++this.sigp;
                return new Type.ArrayType(this.sigToType(), this.syms.arrayClass);
            }
            case '(': {
                ++this.sigp;
                List<Type> list = this.sigToTypes(')');
                Type type = this.sigToType();
                List<Type> list2 = List.nil();
                while (this.signature[this.sigp] == 94) {
                    ++this.sigp;
                    list2 = list2.prepend(this.sigToType());
                }
                List<Type> list3 = list2;
                while (list3.nonEmpty()) {
                    if (((Type)list3.head).hasTag(TypeTag.TYPEVAR)) {
                        ((Type)list3.head).tsym.flags_field |= 0x800000000000L;
                    }
                    list3 = list3.tail;
                }
                return new Type.MethodType(list, type, list2.reverse(), this.syms.methodClass);
            }
            case '<': {
                this.typevars = this.typevars.dup(this.currentOwner);
                Type.ForAll forAll = new Type.ForAll(this.sigToTypeParams(), this.sigToType());
                this.typevars = this.typevars.leave();
                return forAll;
            }
        }
        throw this.badClassFile("bad.signature", Convert.utf2string(this.signature, this.sigp, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type classSigToType() {
        if (this.signature[this.sigp] != 76) {
            throw this.badClassFile("bad.class.signature", Convert.utf2string(this.signature, this.sigp, 10));
        }
        ++this.sigp;
        Type type = Type.noType;
        int n = this.sbp;
        block13: while (true) {
            byte by = this.signature[this.sigp++];
            switch (by) {
                case 59: {
                    Symbol.ClassSymbol classSymbol = this.enterClass(this.names.fromUtf(this.signatureBuffer, n, this.sbp - n));
                    try {
                        Type type2 = type == Type.noType ? classSymbol.erasure(this.types) : new Type.ClassType(type, List.nil(), classSymbol);
                        return type2;
                    }
                    finally {
                        this.sbp = n;
                    }
                }
                case 60: {
                    Symbol.ClassSymbol classSymbol = this.enterClass(this.names.fromUtf(this.signatureBuffer, n, this.sbp - n));
                    type = new Type.ClassType(type, this.sigToTypes('>'), classSymbol){
                        boolean completed;
                        {
                            this.completed = false;
                        }

                        @Override
                        public Type getEnclosingType() {
                            if (!this.completed) {
                                this.completed = true;
                                this.tsym.complete();
                                Type type = this.tsym.type.getEnclosingType();
                                if (type != Type.noType) {
                                    List<Type> list = super.getEnclosingType().allparams();
                                    List<Type> list2 = type.allparams();
                                    if (list2.length() != list.length()) {
                                        super.setEnclosingType(ClassReader.this.types.erasure(type));
                                    } else {
                                        super.setEnclosingType(ClassReader.this.types.subst(type, list2, list));
                                    }
                                } else {
                                    super.setEnclosingType(Type.noType);
                                }
                            }
                            return super.getEnclosingType();
                        }

                        @Override
                        public void setEnclosingType(Type type) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    switch (this.signature[this.sigp++]) {
                        case 59: {
                            if (this.sigp < this.signature.length && this.signature[this.sigp] == 46) {
                                this.sigp += this.sbp - n + 3;
                                this.signatureBuffer[this.sbp++] = 36;
                                continue block13;
                            }
                            this.sbp = n;
                            return type;
                        }
                        case 46: {
                            this.signatureBuffer[this.sbp++] = 36;
                            continue block13;
                        }
                    }
                    throw new AssertionError(this.signature[this.sigp - 1]);
                }
                case 46: {
                    Symbol.ClassSymbol classSymbol;
                    if (type != Type.noType) {
                        classSymbol = this.enterClass(this.names.fromUtf(this.signatureBuffer, n, this.sbp - n));
                        type = new Type.ClassType(type, List.nil(), classSymbol);
                    }
                    this.signatureBuffer[this.sbp++] = 36;
                    continue block13;
                }
                case 47: {
                    this.signatureBuffer[this.sbp++] = 46;
                    continue block13;
                }
            }
            this.signatureBuffer[this.sbp++] = by;
        }
    }

    List<Type> sigToTypes(char c) {
        List<Object> list;
        List<Object> list2 = list = List.of(null);
        while (this.signature[this.sigp] != c) {
            list2 = list2.setTail(List.of(this.sigToType()));
        }
        ++this.sigp;
        return list.tail;
    }

    List<Type> sigToTypeParams(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        List<Type> list = List.nil();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            int n = this.sigp;
            this.sigEnterPhase = true;
            while (this.signature[this.sigp] != 62) {
                list = list.prepend(this.sigToTypeParam());
            }
            this.sigEnterPhase = false;
            this.sigp = n;
            while (this.signature[this.sigp] != 62) {
                this.sigToTypeParam();
            }
            ++this.sigp;
        }
        return list.reverse();
    }

    Type sigToTypeParam() {
        Type.TypeVar typeVar;
        int n = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = this.names.fromUtf(this.signature, n, this.sigp - n);
        if (this.sigEnterPhase) {
            typeVar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.typevars.enter(typeVar.tsym);
        } else {
            typeVar = (Type.TypeVar)this.findTypeVar(name);
        }
        List<Type> list = List.nil();
        boolean bl = false;
        if (this.signature[this.sigp] == 58 && this.signature[this.sigp + 1] == 58) {
            ++this.sigp;
            bl = true;
        }
        while (this.signature[this.sigp] == 58) {
            ++this.sigp;
            list = list.prepend(this.sigToType());
        }
        if (!this.sigEnterPhase) {
            this.types.setBounds(typeVar, list.reverse(), bl);
        }
        return typeVar;
    }

    Type findTypeVar(Name name) {
        Scope.Entry entry = this.typevars.lookup(name);
        if (entry.scope != null) {
            return entry.sym.type;
        }
        if (this.readingClassAttr) {
            Type.TypeVar typeVar = new Type.TypeVar(name, this.currentOwner, this.syms.botType);
            this.missingTypeVariables = this.missingTypeVariables.prepend(typeVar);
            return typeVar;
        }
        throw this.badClassFile("undecl.type.var", name);
    }

    private void initAttributeReaders() {
        AttributeReader[] attributeReaderArray;
        for (AttributeReader attributeReader : attributeReaderArray = new AttributeReader[]{new AttributeReader(this.names.Code, ClassFile.Version.V45_3, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                if (ClassReader.this.readAllOfClassFile || ClassReader.this.saveParameterNames) {
                    ((Symbol.MethodSymbol)symbol).code = ClassReader.this.readCode(symbol);
                } else {
                    ClassReader.this.bp += n;
                }
            }
        }, new AttributeReader(this.names.ConstantValue, ClassFile.Version.V45_3, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                Object object = ClassReader.this.readPool(ClassReader.this.nextChar());
                if ((symbol.flags() & 0x10L) != 0L) {
                    ((Symbol.VarSymbol)symbol).setData(object);
                }
            }
        }, new AttributeReader(this.names.Deprecated, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                symbol.flags_field |= 0x20000L;
            }
        }, new AttributeReader(this.names.Exceptions, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                int n2 = ClassReader.this.nextChar();
                List<Type> list = List.nil();
                for (int i = 0; i < n2; ++i) {
                    list = list.prepend(ClassReader.this.readClassSymbol((int)ClassReader.this.nextChar()).type);
                }
                if (symbol.type.getThrownTypes().isEmpty()) {
                    symbol.type.asMethodType().thrown = list.reverse();
                }
            }
        }, new AttributeReader(this.names.InnerClasses, ClassFile.Version.V45_3, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                ClassReader.this.readInnerClasses(classSymbol);
            }
        }, new AttributeReader(this.names.LocalVariableTable, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                int n2 = ClassReader.this.bp + n;
                if (ClassReader.this.saveParameterNames && !ClassReader.this.sawMethodParameters) {
                    int n3 = ClassReader.this.nextChar();
                    for (int i = 0; i < n3; ++i) {
                        char c = ClassReader.this.nextChar();
                        char c2 = ClassReader.this.nextChar();
                        char c3 = ClassReader.this.nextChar();
                        char c4 = ClassReader.this.nextChar();
                        char c5 = ClassReader.this.nextChar();
                        if (c != '\u0000') continue;
                        if (c5 >= ClassReader.this.parameterNameIndices.length) {
                            int n4 = Math.max(c5, ClassReader.this.parameterNameIndices.length + 8);
                            ClassReader.this.parameterNameIndices = Arrays.copyOf(ClassReader.this.parameterNameIndices, n4);
                        }
                        ClassReader.this.parameterNameIndices[c5] = c3;
                        ClassReader.this.haveParameterNameIndices = true;
                    }
                }
                ClassReader.this.bp = n2;
            }
        }, new AttributeReader(this.names.MethodParameters, ClassFile.Version.V52, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                int n2 = ClassReader.this.bp + n;
                if (ClassReader.this.saveParameterNames) {
                    ClassReader.this.sawMethodParameters = true;
                    int n3 = ClassReader.this.nextByte();
                    ClassReader.this.parameterNameIndices = new int[n3];
                    ClassReader.this.haveParameterNameIndices = true;
                    for (int i = 0; i < n3; ++i) {
                        char c = ClassReader.this.nextChar();
                        char c2 = ClassReader.this.nextChar();
                        ClassReader.this.parameterNameIndices[i] = c;
                    }
                }
                ClassReader.this.bp = n2;
            }
        }, new AttributeReader(this.names.SourceFile, ClassFile.Version.V45_3, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                Name name = ClassReader.this.readName(ClassReader.this.nextChar());
                classSymbol.sourcefile = new SourceFileObject(name, classSymbol.flatname);
                String string = name.toString();
                if (classSymbol.owner.kind == 1 && string.endsWith(".java") && !string.equals(String.valueOf(classSymbol.name.toString()).concat(".java"))) {
                    classSymbol.flags_field |= 0x100000000000L;
                }
            }
        }, new AttributeReader(this.names.Synthetic, ClassFile.Version.V45_3, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                if (ClassReader.this.allowGenerics || (symbol.flags_field & 0x80000000L) == 0L) {
                    symbol.flags_field |= 0x1000L;
                }
            }
        }, new AttributeReader(this.names.EnclosingMethod, ClassFile.Version.V49, (Set)this.CLASS_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                int n2 = ClassReader.this.bp + n;
                ClassReader.this.readEnclosingMethodAttr(symbol);
                ClassReader.this.bp = n2;
            }
        }, new AttributeReader(this.names.Signature, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected boolean accepts(AttributeKind attributeKind) {
                return super.accepts(attributeKind) && ClassReader.this.allowGenerics;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void read(Symbol symbol, int n) {
                if (symbol.kind == 2) {
                    Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                    ClassReader.this.readingClassAttr = true;
                    try {
                        Type.ClassType classType = (Type.ClassType)classSymbol.type;
                        Assert.check(classSymbol == ClassReader.this.currentOwner);
                        classType.typarams_field = ClassReader.this.readTypeParams(ClassReader.this.nextChar());
                        classType.supertype_field = ClassReader.this.sigToType();
                        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                        while (ClassReader.this.sigp != ClassReader.this.siglimit) {
                            listBuffer.append(ClassReader.this.sigToType());
                        }
                        classType.interfaces_field = listBuffer.toList();
                    }
                    finally {
                        ClassReader.this.readingClassAttr = false;
                    }
                } else {
                    List<Type> list = symbol.type.getThrownTypes();
                    symbol.type = ClassReader.this.readType(ClassReader.this.nextChar());
                    if (symbol.kind == 16 && symbol.type.getThrownTypes().isEmpty()) {
                        symbol.type.asMethodType().thrown = list;
                    }
                }
            }
        }, new AttributeReader(this.names.AnnotationDefault, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachAnnotationDefault(symbol);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachAnnotations(symbol);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachParameterAnnotations(symbol);
            }
        }, new AttributeReader(this.names.RuntimeVisibleAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachAnnotations(symbol);
            }
        }, new AttributeReader(this.names.RuntimeVisibleParameterAnnotations, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachParameterAnnotations(symbol);
            }
        }, new AttributeReader(this.names.Annotation, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                if (ClassReader.this.allowAnnotations) {
                    symbol.flags_field |= 0x2000L;
                }
            }
        }, new AttributeReader(this.names.Bridge, ClassFile.Version.V49, (Set)this.MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                symbol.flags_field |= 0x80000000L;
                if (!ClassReader.this.allowGenerics) {
                    symbol.flags_field &= 0xFFFFFFFFFFFFEFFFL;
                }
            }
        }, new AttributeReader(this.names.Enum, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                symbol.flags_field |= 0x4000L;
            }
        }, new AttributeReader(this.names.Varargs, ClassFile.Version.V49, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                if (ClassReader.this.allowVarargs) {
                    symbol.flags_field |= 0x400000000L;
                }
            }
        }, new AttributeReader(this.names.RuntimeVisibleTypeAnnotations, ClassFile.Version.V52, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachTypeAnnotations(symbol);
            }
        }, new AttributeReader(this.names.RuntimeInvisibleTypeAnnotations, ClassFile.Version.V52, (Set)this.CLASS_OR_MEMBER_ATTRIBUTE){

            @Override
            protected void read(Symbol symbol, int n) {
                ClassReader.this.attachTypeAnnotations(symbol);
            }
        }}) {
            this.attributeReaders.put(attributeReader.name, attributeReader);
        }
    }

    void unrecognized(Name name) {
        if (this.checkClassFile) {
            this.printCCF("ccf.unrecognized.attribute", name);
        }
    }

    protected void readEnclosingMethodAttr(Symbol symbol) {
        symbol.owner.members().remove(symbol);
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
        Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
        ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.nextChar());
        if (classSymbol2.members_field == null) {
            throw this.badClassFile("bad.enclosing.class", classSymbol, classSymbol2);
        }
        Symbol.MethodSymbol methodSymbol = this.findMethod(nameAndType, classSymbol2.members_field, classSymbol.flags());
        if (nameAndType != null && methodSymbol == null) {
            throw this.badClassFile("bad.enclosing.method", classSymbol);
        }
        classSymbol.name = this.simpleBinaryName(classSymbol.flatname, classSymbol2.flatname);
        classSymbol.owner = methodSymbol != null ? methodSymbol : classSymbol2;
        classSymbol.fullname = classSymbol.name.isEmpty() ? this.names.empty : Symbol.ClassSymbol.formFullName(classSymbol.name, classSymbol.owner);
        if (methodSymbol != null) {
            ((Type.ClassType)symbol.type).setEnclosingType(methodSymbol.type);
        } else if ((classSymbol.flags_field & 8L) == 0L) {
            ((Type.ClassType)symbol.type).setEnclosingType(classSymbol2.type);
        } else {
            ((Type.ClassType)symbol.type).setEnclosingType(Type.noType);
        }
        this.enterTypevars(classSymbol);
        if (!this.missingTypeVariables.isEmpty()) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type : this.missingTypeVariables) {
                listBuffer.append(this.findTypeVar(type.tsym.name));
            }
            this.foundTypeVariables = listBuffer.toList();
        } else {
            this.foundTypeVariables = List.nil();
        }
    }

    private Name simpleBinaryName(Name name, Name name2) {
        int n;
        String string = name.toString().substring(name2.toString().length());
        if (string.length() < 1 || string.charAt(0) != '$') {
            throw this.badClassFile("bad.enclosing.method", name);
        }
        for (n = 1; n < string.length() && ClassReader.isAsciiDigit(string.charAt(n)); ++n) {
        }
        return this.names.fromString(string.substring(n));
    }

    private Symbol.MethodSymbol findMethod(ClassFile.NameAndType nameAndType, Scope scope, long l) {
        if (nameAndType == null) {
            return null;
        }
        Type.MethodType methodType = nameAndType.uniqueType.type.asMethodType();
        Scope.Entry entry = scope.lookup(nameAndType.name);
        while (entry.scope != null) {
            if (entry.sym.kind == 16 && this.isSameBinaryType(entry.sym.type.asMethodType(), methodType)) {
                return (Symbol.MethodSymbol)entry.sym;
            }
            entry = entry.next();
        }
        if (nameAndType.name != this.names.init) {
            return null;
        }
        if ((l & 0x200L) != 0L) {
            return null;
        }
        if (nameAndType.uniqueType.type.getParameterTypes().isEmpty()) {
            return null;
        }
        nameAndType.setType(new Type.MethodType(nameAndType.uniqueType.type.getParameterTypes().tail, nameAndType.uniqueType.type.getReturnType(), nameAndType.uniqueType.type.getThrownTypes(), this.syms.methodClass));
        return this.findMethod(nameAndType, scope, l);
    }

    private boolean isSameBinaryType(Type.MethodType methodType, Type.MethodType methodType2) {
        List<Type> list = this.types.erasure((List<Type>)methodType.getParameterTypes()).prepend(this.types.erasure(methodType.getReturnType()));
        List<Type> list2 = ((List)methodType2.getParameterTypes()).prepend(methodType2.getReturnType());
        while (!list.isEmpty() && !list2.isEmpty()) {
            if (((Type)list.head).tsym != ((Type)list2.head).tsym) {
                return false;
            }
            list = list.tail;
            list2 = list2.tail;
        }
        return list.isEmpty() && list2.isEmpty();
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    void readMemberAttrs(Symbol symbol) {
        this.readAttrs(symbol, AttributeKind.MEMBER);
    }

    void readAttrs(Symbol symbol, AttributeKind attributeKind) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            int n2 = this.nextInt();
            AttributeReader attributeReader = this.attributeReaders.get(name);
            if (attributeReader != null && attributeReader.accepts(attributeKind)) {
                attributeReader.read(symbol, n2);
                continue;
            }
            this.unrecognized(name);
            this.bp += n2;
        }
    }

    void readClassAttrs(Symbol.ClassSymbol classSymbol) {
        this.readAttrs(classSymbol, AttributeKind.CLASS);
    }

    Code readCode(Symbol symbol) {
        this.nextChar();
        this.nextChar();
        int n = this.nextInt();
        this.bp += n;
        char c = this.nextChar();
        this.bp += c * 8;
        this.readMemberAttrs(symbol);
        return null;
    }

    void attachAnnotations(Symbol symbol) {
        int n = this.nextChar();
        if (n != 0) {
            ListBuffer<CompoundAnnotationProxy> listBuffer = new ListBuffer<CompoundAnnotationProxy>();
            for (int i = 0; i < n; ++i) {
                CompoundAnnotationProxy compoundAnnotationProxy = this.readCompoundAnnotation();
                if (compoundAnnotationProxy.type.tsym == this.syms.proprietaryType.tsym) {
                    symbol.flags_field |= 0x4000000000L;
                    continue;
                }
                if (compoundAnnotationProxy.type.tsym == this.syms.profileType.tsym) {
                    if (this.profile == Profile.DEFAULT) continue;
                    for (Pair<Name, Attribute> pair : compoundAnnotationProxy.values) {
                        if (pair.fst != this.names.value || !(pair.snd instanceof Attribute.Constant)) continue;
                        Attribute.Constant constant = (Attribute.Constant)pair.snd;
                        if (constant.type != this.syms.intType || (Integer)constant.value <= this.profile.value) continue;
                        symbol.flags_field |= 0x200000000000L;
                    }
                    continue;
                }
                listBuffer.append(compoundAnnotationProxy);
            }
            this.annotate.normal(new AnnotationCompleter(symbol, listBuffer.toList()));
        }
    }

    void attachParameterAnnotations(Symbol symbol) {
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        int n = this.buf[this.bp++] & 0xFF;
        List<Symbol.VarSymbol> list = methodSymbol.params();
        int n2 = 0;
        while (list.tail != null) {
            this.attachAnnotations((Symbol)list.head);
            list = list.tail;
            ++n2;
        }
        if (n2 != n) {
            throw this.badClassFile("bad.runtime.invisible.param.annotations", methodSymbol);
        }
    }

    void attachTypeAnnotations(Symbol symbol) {
        int n = this.nextChar();
        if (n != 0) {
            ListBuffer<TypeAnnotationProxy> listBuffer = new ListBuffer<TypeAnnotationProxy>();
            for (int i = 0; i < n; ++i) {
                listBuffer.append(this.readTypeAnnotation());
            }
            this.annotate.normal(new TypeAnnotationCompleter(symbol, listBuffer.toList()));
        }
    }

    void attachAnnotationDefault(Symbol symbol) {
        Attribute attribute;
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
        methodSymbol.defaultValue = attribute = this.readAttributeValue();
        this.annotate.normal(new AnnotationDefaultCompleter(methodSymbol, attribute));
    }

    Type readTypeOrClassSymbol(int n) {
        if (this.buf[this.poolIdx[n]] == 7) {
            return this.readClassSymbol((int)n).type;
        }
        return this.readType(n);
    }

    Type readEnumType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        if (this.buf[n2 + c + 2] != 59) {
            return this.enterClass((Name)this.readName((int)n)).type;
        }
        return this.readType(n);
    }

    CompoundAnnotationProxy readCompoundAnnotation() {
        Type type = this.readTypeOrClassSymbol(this.nextChar());
        int n = this.nextChar();
        ListBuffer<Pair<Name, Attribute>> listBuffer = new ListBuffer<Pair<Name, Attribute>>();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            Attribute attribute = this.readAttributeValue();
            listBuffer.append(new Pair<Name, Attribute>(name, attribute));
        }
        return new CompoundAnnotationProxy(type, listBuffer.toList());
    }

    TypeAnnotationProxy readTypeAnnotation() {
        TypeAnnotationPosition typeAnnotationPosition = this.readPosition();
        CompoundAnnotationProxy compoundAnnotationProxy = this.readCompoundAnnotation();
        return new TypeAnnotationProxy(compoundAnnotationProxy, typeAnnotationPosition);
    }

    TypeAnnotationPosition readPosition() {
        int n;
        TargetType targetType;
        int n2 = this.nextByte();
        if (!TargetType.isValidTargetTypeValue(n2)) {
            throw this.badClassFile("bad.type.annotation.value", String.format("0x%02X", n2));
        }
        TypeAnnotationPosition typeAnnotationPosition = new TypeAnnotationPosition();
        typeAnnotationPosition.type = targetType = TargetType.fromTargetTypeValue(n2);
        switch (targetType) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                typeAnnotationPosition.offset = this.nextChar();
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                n = this.nextChar();
                typeAnnotationPosition.lvarOffset = new int[n];
                typeAnnotationPosition.lvarLength = new int[n];
                typeAnnotationPosition.lvarIndex = new int[n];
                for (int i = 0; i < n; ++i) {
                    typeAnnotationPosition.lvarOffset[i] = this.nextChar();
                    typeAnnotationPosition.lvarLength[i] = this.nextChar();
                    typeAnnotationPosition.lvarIndex[i] = this.nextChar();
                }
                break;
            }
            case EXCEPTION_PARAMETER: {
                typeAnnotationPosition.exception_index = this.nextChar();
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                typeAnnotationPosition.parameter_index = this.nextByte();
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                typeAnnotationPosition.parameter_index = this.nextByte();
                typeAnnotationPosition.bound_index = this.nextByte();
                break;
            }
            case CLASS_EXTENDS: {
                typeAnnotationPosition.type_index = this.nextChar();
                break;
            }
            case THROWS: {
                typeAnnotationPosition.type_index = this.nextChar();
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                typeAnnotationPosition.parameter_index = this.nextByte();
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                typeAnnotationPosition.offset = this.nextChar();
                typeAnnotationPosition.type_index = this.nextByte();
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"jvm.ClassReader: UNKNOWN target type should never occur!");
            }
            default: {
                String string = String.valueOf(String.valueOf(typeAnnotationPosition));
                throw new AssertionError((Object)new StringBuilder(51 + string.length()).append("jvm.ClassReader: Unknown target type for position: ").append(string).toString());
            }
        }
        n = this.nextByte();
        ListBuffer<Integer> listBuffer = new ListBuffer<Integer>();
        for (int i = 0; i < n * 2; ++i) {
            listBuffer = listBuffer.append(this.nextByte());
        }
        typeAnnotationPosition.location = TypeAnnotationPosition.getTypePathFromBinary(listBuffer.toList());
        return typeAnnotationPosition;
    }

    Attribute readAttributeValue() {
        char c = (char)this.buf[this.bp++];
        switch (c) {
            case 'B': {
                return new Attribute.Constant(this.syms.byteType, this.readPool(this.nextChar()));
            }
            case 'C': {
                return new Attribute.Constant(this.syms.charType, this.readPool(this.nextChar()));
            }
            case 'D': {
                return new Attribute.Constant(this.syms.doubleType, this.readPool(this.nextChar()));
            }
            case 'F': {
                return new Attribute.Constant(this.syms.floatType, this.readPool(this.nextChar()));
            }
            case 'I': {
                return new Attribute.Constant(this.syms.intType, this.readPool(this.nextChar()));
            }
            case 'J': {
                return new Attribute.Constant(this.syms.longType, this.readPool(this.nextChar()));
            }
            case 'S': {
                return new Attribute.Constant(this.syms.shortType, this.readPool(this.nextChar()));
            }
            case 'Z': {
                return new Attribute.Constant(this.syms.booleanType, this.readPool(this.nextChar()));
            }
            case 's': {
                return new Attribute.Constant(this.syms.stringType, this.readPool(this.nextChar()).toString());
            }
            case 'e': {
                return new EnumAttributeProxy(this.readEnumType(this.nextChar()), this.readName(this.nextChar()));
            }
            case 'c': {
                return new Attribute.Class(this.types, this.readTypeOrClassSymbol(this.nextChar()));
            }
            case '[': {
                int n = this.nextChar();
                ListBuffer<Attribute> listBuffer = new ListBuffer<Attribute>();
                for (int i = 0; i < n; ++i) {
                    listBuffer.append(this.readAttributeValue());
                }
                return new ArrayAttributeProxy(listBuffer.toList());
            }
            case '@': {
                return this.readCompoundAnnotation();
            }
        }
        char c2 = c;
        throw new AssertionError((Object)new StringBuilder(26).append("unknown annotation tag '").append(c2).append("'").toString());
    }

    Symbol.VarSymbol readField() {
        long l = this.adjustFieldFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(l, name, type, this.currentOwner);
        this.readMemberAttrs(varSymbol);
        return varSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol.MethodSymbol readMethod() {
        Symbol.MethodSymbol methodSymbol;
        long l = this.adjustMethodFlags(this.nextChar());
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        if (this.currentOwner.isInterface() && (l & 0x400L) == 0L && !name.equals(this.names.clinit)) {
            if (this.majorVersion > Target.JDK1_8.majorVersion || this.majorVersion == Target.JDK1_8.majorVersion && this.minorVersion >= Target.JDK1_8.minorVersion) {
                if ((l & 8L) == 0L) {
                    this.currentOwner.flags_field |= 0x80000000000L;
                    l |= 0x80000000400L;
                }
            } else {
                throw this.badClassFile((l & 8L) == 0L ? "invalid.default.interface" : "invalid.static.interface", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion));
            }
        }
        if (name == this.names.init && this.currentOwner.hasOuterInstance() && !this.currentOwner.name.isEmpty()) {
            type = new Type.MethodType(this.adjustMethodParams(l, type.getParameterTypes()), type.getReturnType(), type.getThrownTypes(), this.syms.methodClass);
        }
        if (this.types.isSignaturePolymorphic(methodSymbol = new Symbol.MethodSymbol(l, name, type, this.currentOwner))) {
            methodSymbol.flags_field |= 0x400000000000L;
        }
        if (this.saveParameterNames) {
            this.initParameterNames(methodSymbol);
        }
        Symbol symbol = this.currentOwner;
        this.currentOwner = methodSymbol;
        try {
            this.readMemberAttrs(methodSymbol);
        }
        finally {
            this.currentOwner = symbol;
        }
        if (this.saveParameterNames) {
            this.setParameterNames(methodSymbol, type);
        }
        return methodSymbol;
    }

    private List<Type> adjustMethodParams(long l, List<Type> list) {
        boolean bl;
        boolean bl2 = bl = (l & 0x400000000L) != 0L;
        if (bl) {
            Type type = list.last();
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type2 : list) {
                listBuffer.append(type2 != type ? type2 : ((Type.ArrayType)type2).makeVarargs());
            }
            list = listBuffer.toList();
        }
        return list.tail;
    }

    void initParameterNames(Symbol.MethodSymbol methodSymbol) {
        int n = Code.width(methodSymbol.type.getParameterTypes()) + 4;
        if (this.parameterNameIndices == null || this.parameterNameIndices.length < n) {
            this.parameterNameIndices = new int[n];
        } else {
            Arrays.fill(this.parameterNameIndices, 0);
        }
        this.haveParameterNameIndices = false;
        this.sawMethodParameters = false;
    }

    void setParameterNames(Symbol.MethodSymbol methodSymbol, Type type) {
        if (!this.haveParameterNameIndices) {
            return;
        }
        int n = 0;
        if (!this.sawMethodParameters) {
            int n2 = n = (methodSymbol.flags() & 8L) == 0L ? 1 : 0;
            if (methodSymbol.name == this.names.init && this.currentOwner.hasOuterInstance() && !this.currentOwner.name.isEmpty()) {
                ++n;
            }
            if (methodSymbol.type != type) {
                int n3 = Code.width(type.getParameterTypes()) - Code.width(methodSymbol.type.getParameterTypes());
                n += n3;
            }
        }
        List<Name> list = List.nil();
        int n4 = n;
        for (Type type2 : methodSymbol.type.getParameterTypes()) {
            int n5 = n4 < this.parameterNameIndices.length ? this.parameterNameIndices[n4] : 0;
            Name name = n5 == 0 ? this.names.empty : this.readName(n5);
            list = list.prepend(name);
            n4 += Code.width(type2);
        }
        methodSymbol.savedParameterNames = list.reverse();
    }

    void skipBytes(int n) {
        this.bp += n;
    }

    void skipMember() {
        this.bp += 6;
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.bp += 2;
            int n2 = this.nextInt();
            this.bp += n2;
        }
    }

    protected void enterTypevars(Type type) {
        if (type.getEnclosingType() != null && type.getEnclosingType().hasTag(TypeTag.CLASS)) {
            this.enterTypevars(type.getEnclosingType());
        }
        List<Type> list = type.getTypeArguments();
        while (list.nonEmpty()) {
            this.typevars.enter(((Type)list.head).tsym);
            list = list.tail;
        }
    }

    protected void enterTypevars(Symbol symbol) {
        if (symbol.owner.kind == 16) {
            this.enterTypevars(symbol.owner);
            this.enterTypevars(symbol.owner.owner);
        }
        this.enterTypevars(symbol.type);
    }

    void readClass(Symbol.ClassSymbol classSymbol) {
        int n;
        int n2;
        int n3;
        Symbol.ClassSymbol classSymbol2;
        Type.ClassType classType = (Type.ClassType)classSymbol.type;
        classSymbol.members_field = new Scope(classSymbol);
        this.typevars = this.typevars.dup(this.currentOwner);
        if (classType.getEnclosingType().hasTag(TypeTag.CLASS)) {
            this.enterTypevars(classType.getEnclosingType());
        }
        long l = this.adjustClassFlags(this.nextChar());
        if (classSymbol.owner.kind == 1) {
            classSymbol.flags_field = l;
        }
        if (classSymbol != (classSymbol2 = this.readClassSymbol(this.nextChar()))) {
            throw this.badClassFile("class.file.wrong.class", classSymbol2.flatname);
        }
        int n4 = this.bp;
        this.nextChar();
        char c = this.nextChar();
        this.bp += c * 2;
        int n5 = this.nextChar();
        for (n3 = 0; n3 < n5; ++n3) {
            this.skipMember();
        }
        n3 = this.nextChar();
        for (n2 = 0; n2 < n3; ++n2) {
            this.skipMember();
        }
        this.readClassAttrs(classSymbol);
        if (this.readAllOfClassFile) {
            for (n2 = 1; n2 < this.poolObj.length; ++n2) {
                this.readPool(n2);
            }
            classSymbol.pool = new Pool(this.poolObj.length, this.poolObj, this.types);
        }
        this.bp = n4;
        n2 = this.nextChar();
        if (classType.supertype_field == null) {
            classType.supertype_field = n2 == 0 ? Type.noType : this.readClassSymbol(n2).erasure(this.types);
        }
        n2 = this.nextChar();
        List<Type> list = List.nil();
        for (n = 0; n < n2; ++n) {
            Type type = this.readClassSymbol(this.nextChar()).erasure(this.types);
            list = list.prepend(type);
        }
        if (classType.interfaces_field == null) {
            classType.interfaces_field = list.reverse();
        }
        Assert.check(n5 == this.nextChar());
        for (n = 0; n < n5; ++n) {
            this.enterMember(classSymbol, this.readField());
        }
        Assert.check(n3 == this.nextChar());
        for (n = 0; n < n3; ++n) {
            this.enterMember(classSymbol, this.readMethod());
        }
        this.typevars = this.typevars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
            Name name = this.readName(this.nextChar());
            if (name == null) {
                name = this.names.empty;
            }
            long l = this.adjustClassFlags(this.nextChar());
            if (classSymbol2 == null) continue;
            if (name == this.names.empty) {
                name = this.names.one;
            }
            Symbol.ClassSymbol classSymbol3 = this.enterClass(name, classSymbol2);
            if ((l & 8L) == 0L) {
                ((Type.ClassType)classSymbol3.type).setEnclosingType(classSymbol2.type);
                if (classSymbol3.erasure_field != null) {
                    ((Type.ClassType)classSymbol3.erasure_field).setEnclosingType(this.types.erasure(classSymbol2.type));
                }
            }
            if (classSymbol != classSymbol2) continue;
            classSymbol3.flags_field = l;
            this.enterMember(classSymbol, classSymbol3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readClassFile(Symbol.ClassSymbol classSymbol) throws IOException {
        int n = this.nextInt();
        if (n != -889275714) {
            throw this.badClassFile("illegal.start.of.class.file", new Object[0]);
        }
        this.minorVersion = this.nextChar();
        this.majorVersion = this.nextChar();
        int n2 = Target.MAX().majorVersion;
        int n3 = Target.MAX().minorVersion;
        if (this.majorVersion > n2 || this.majorVersion * 1000 + this.minorVersion < Target.MIN().majorVersion * 1000 + Target.MIN().minorVersion) {
            if (this.majorVersion != n2 + 1) throw this.badClassFile("wrong.version", Integer.toString(this.majorVersion), Integer.toString(this.minorVersion), Integer.toString(n2), Integer.toString(n3));
            this.log.warning("big.major.version", this.currentClassFile, this.majorVersion, n2);
        } else if (this.checkClassFile && this.majorVersion == n2 && this.minorVersion > n3) {
            this.printCCF("found.later.version", Integer.toString(this.minorVersion));
        }
        this.indexPool();
        if (this.signatureBuffer.length < this.bp) {
            int n4 = Integer.highestOneBit(this.bp) << 1;
            this.signatureBuffer = new byte[n4];
        }
        this.readClass(classSymbol);
    }

    long adjustFieldFlags(long l) {
        return l;
    }

    long adjustMethodFlags(long l) {
        if ((l & 0x40L) != 0L) {
            l &= 0xFFFFFFFFFFFFFFBFL;
            l |= 0x80000000L;
            if (!this.allowGenerics) {
                l &= 0xFFFFFFFFFFFFEFFFL;
            }
        }
        if ((l & 0x80L) != 0L) {
            l &= 0xFFFFFFFFFFFFFF7FL;
            l |= 0x400000000L;
        }
        return l;
    }

    long adjustClassFlags(long l) {
        return l & 0xFFFFFFFFFFFFFFDFL;
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol symbol) {
        Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(0L, name, symbol);
        if (symbol.kind == 1) {
            Assert.checkNull((Object)this.classes.get(classSymbol.flatname), classSymbol);
        }
        classSymbol.completer = this.thisCompleter;
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol typeSymbol) {
        Name name2 = Symbol.TypeSymbol.formFlatName(name, typeSymbol);
        Symbol.ClassSymbol classSymbol = this.classes.get(name2);
        if (classSymbol == null) {
            classSymbol = this.defineClass(name, typeSymbol);
            this.classes.put(name2, classSymbol);
        } else if ((classSymbol.name != name || classSymbol.owner != typeSymbol) && typeSymbol.kind == 2 && classSymbol.owner.kind == 1) {
            classSymbol.owner.members().remove(classSymbol);
            classSymbol.name = name;
            classSymbol.owner = typeSymbol;
            classSymbol.fullname = Symbol.ClassSymbol.formFullName(name, typeSymbol);
        }
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name, JavaFileObject javaFileObject) {
        Symbol.ClassSymbol classSymbol = this.classes.get(name);
        if (classSymbol != null) {
            String string = Log.format("%s: completer = %s; class file = %s; source file = %s", classSymbol.fullname, classSymbol.completer, classSymbol.classfile, classSymbol.sourcefile);
            throw new AssertionError((Object)string);
        }
        Name name2 = Convert.packagePart(name);
        Symbol.PackageSymbol packageSymbol = name2.isEmpty() ? this.syms.unnamedPackage : this.enterPackage(name2);
        classSymbol = this.defineClass(Convert.shortName(name), packageSymbol);
        classSymbol.classfile = javaFileObject;
        this.classes.put(name, classSymbol);
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name) {
        Symbol.ClassSymbol classSymbol = this.classes.get(name);
        if (classSymbol == null) {
            return this.enterClass(name, (JavaFileObject)null);
        }
        return classSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(Symbol symbol) throws Symbol.CompletionFailure {
        if (symbol.kind == 2) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
            classSymbol.members_field = new Scope.ErrorScope(classSymbol);
            this.annotate.enterStart();
            try {
                this.completeOwners(classSymbol.owner);
                this.completeEnclosing(classSymbol);
            }
            finally {
                this.annotate.enterDoneWithoutFlush();
            }
            this.fillIn(classSymbol);
        } else if (symbol.kind == 1) {
            Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)symbol;
            try {
                this.fillIn(packageSymbol);
            }
            catch (IOException iOException) {
                throw new Symbol.CompletionFailure(symbol, iOException.getLocalizedMessage()).initCause(iOException);
            }
        }
        if (!this.filling) {
            this.annotate.flush();
        }
    }

    private void completeOwners(Symbol symbol) {
        if (symbol.kind != 1) {
            this.completeOwners(symbol.owner);
        }
        symbol.complete();
    }

    private void completeEnclosing(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner.kind == 1) {
            Symbol symbol = classSymbol.owner;
            for (Name name : Convert.enclosingCandidates(Convert.shortName(classSymbol.name))) {
                Symbol symbol2 = symbol.members().lookup((Name)name).sym;
                if (symbol2 == null) {
                    symbol2 = this.classes.get(Symbol.TypeSymbol.formFlatName(name, symbol));
                }
                if (symbol2 == null) continue;
                symbol2.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillIn(Symbol.ClassSymbol classSymbol) {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure((Symbol)classSymbol, "user-selected completion failure by class name");
        }
        this.currentOwner = classSymbol;
        this.warnedAttrs.clear();
        JavaFileObject javaFileObject = classSymbol.classfile;
        if (javaFileObject != null) {
            JavaFileObject javaFileObject2 = this.currentClassFile;
            try {
                Object object;
                Object object2;
                if (this.filling) {
                    object2 = String.valueOf(String.valueOf(javaFileObject.toUri()));
                    object = String.valueOf(String.valueOf(javaFileObject2));
                    Assert.error(new StringBuilder(16 + ((String)object2).length() + ((String)object).length()).append("Filling ").append((String)object2).append(" during ").append((String)object).toString());
                }
                this.currentClassFile = javaFileObject;
                if (this.verbose) {
                    this.log.printVerbose("loading", this.currentClassFile.toString());
                }
                if (javaFileObject.getKind() == JavaFileObject.Kind.CLASS) {
                    this.filling = true;
                    try {
                        this.bp = 0;
                        this.buf = ClassReader.readInputStream(this.buf, javaFileObject.openInputStream());
                        this.readClassFile(classSymbol);
                        if (!this.missingTypeVariables.isEmpty() && !this.foundTypeVariables.isEmpty()) {
                            object2 = this.missingTypeVariables;
                            object = this.foundTypeVariables;
                            this.missingTypeVariables = List.nil();
                            this.foundTypeVariables = List.nil();
                            this.filling = false;
                            Type.ClassType classType = (Type.ClassType)this.currentOwner.type;
                            classType.supertype_field = this.types.subst(classType.supertype_field, (List<Type>)object2, (List<Type>)object);
                            classType.interfaces_field = this.types.subst(classType.interfaces_field, (List<Type>)object2, (List<Type>)object);
                            return;
                        }
                        if (this.missingTypeVariables.isEmpty() == this.foundTypeVariables.isEmpty()) return;
                        object2 = ((Type)this.missingTypeVariables.head).tsym.name;
                        throw this.badClassFile("undecl.type.var", object2);
                    }
                    finally {
                        this.missingTypeVariables = List.nil();
                        this.foundTypeVariables = List.nil();
                        this.filling = false;
                    }
                } else if (this.sourceCompleter != null) {
                    this.sourceCompleter.complete(classSymbol);
                    return;
                } else {
                    object2 = String.valueOf(String.valueOf(javaFileObject.toUri()));
                    throw new IllegalStateException(new StringBuilder(34 + ((String)object2).length()).append("Source completer required to read ").append((String)object2).toString());
                }
            }
            catch (IOException iOException) {
                throw this.badClassFile("unable.to.access.file", iOException.getMessage());
            }
            finally {
                this.currentClassFile = javaFileObject2;
            }
        }
        JCDiagnostic jCDiagnostic = this.diagFactory.fragment("class.file.not.found", classSymbol.flatname);
        throw this.newCompletionFailure(classSymbol, jCDiagnostic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readInputStream(byte[] byArray, InputStream inputStream) throws IOException {
        try {
            byArray = ClassReader.ensureCapacity(byArray, inputStream.available());
            int n = inputStream.read(byArray);
            int n2 = 0;
            while (n != -1) {
                byArray = ClassReader.ensureCapacity(byArray, n2 += n);
                n = inputStream.read(byArray, n2, byArray.length - n2);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] ensureCapacity(byte[] byArray, int n) {
        if (byArray.length <= n) {
            byte[] byArray2 = byArray;
            byArray = new byte[Integer.highestOneBit(n) << 1];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        return byArray;
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.TypeSymbol typeSymbol, JCDiagnostic jCDiagnostic) {
        if (!this.cacheCompletionFailure) {
            return new Symbol.CompletionFailure((Symbol)typeSymbol, jCDiagnostic);
        }
        Symbol.CompletionFailure completionFailure = this.cachedCompletionFailure;
        completionFailure.sym = typeSymbol;
        completionFailure.diag = jCDiagnostic;
        return completionFailure;
    }

    public Symbol.ClassSymbol loadClass(Name name) throws Symbol.CompletionFailure {
        boolean bl = this.classes.get(name) == null;
        Symbol.ClassSymbol classSymbol = this.enterClass(name);
        if (classSymbol.members_field == null && classSymbol.completer != null) {
            try {
                classSymbol.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                if (bl) {
                    this.classes.remove(name);
                }
                throw completionFailure;
            }
        }
        return classSymbol;
    }

    public boolean packageExists(Name name) {
        return this.enterPackage(name).exists();
    }

    public Symbol.PackageSymbol enterPackage(Name name) {
        Symbol.PackageSymbol packageSymbol = this.packages.get(name);
        if (packageSymbol == null) {
            Assert.check(!name.isEmpty(), "rootPackage missing!");
            packageSymbol = new Symbol.PackageSymbol(Convert.shortName(name), this.enterPackage(Convert.packagePart(name)));
            packageSymbol.completer = this.thisCompleter;
            this.packages.put(name, packageSymbol);
        }
        return packageSymbol;
    }

    public Symbol.PackageSymbol enterPackage(Name name, Symbol.PackageSymbol packageSymbol) {
        return this.enterPackage(Symbol.TypeSymbol.formFullName(name, packageSymbol));
    }

    protected void includeClassFile(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject) {
        Symbol.ClassSymbol classSymbol;
        Object object;
        if ((packageSymbol.flags_field & 0x800000L) == 0L) {
            object = packageSymbol;
            while (object != null && object.kind == 1) {
                object.flags_field |= 0x800000L;
                object = object.owner;
            }
        }
        int n = (object = javaFileObject.getKind()) == JavaFileObject.Kind.CLASS ? 0x2000000 : 0x4000000;
        String string = this.fileManager.inferBinaryName(this.currentLoc, javaFileObject);
        int n2 = string.lastIndexOf(".");
        Name name = this.names.fromString(string.substring(n2 + 1));
        boolean bl = name == this.names.package_info;
        Symbol.ClassSymbol classSymbol2 = classSymbol = bl ? packageSymbol.package_info : (Symbol.ClassSymbol)packageSymbol.members_field.lookup((Name)name).sym;
        if (classSymbol == null) {
            classSymbol = this.enterClass(name, packageSymbol);
            if (classSymbol.classfile == null) {
                classSymbol.classfile = javaFileObject;
            }
            if (bl) {
                packageSymbol.package_info = classSymbol;
            } else if (classSymbol.owner == packageSymbol) {
                packageSymbol.members_field.enter(classSymbol);
            }
        } else if (classSymbol.classfile != null && (classSymbol.flags_field & (long)n) == 0L && (classSymbol.flags_field & 0x6000000L) != 0L) {
            classSymbol.classfile = this.preferredFileObject(javaFileObject, classSymbol.classfile);
        }
        classSymbol.flags_field |= (long)n;
    }

    protected JavaFileObject preferredFileObject(JavaFileObject javaFileObject, JavaFileObject javaFileObject2) {
        long l;
        if (this.preferSource) {
            return javaFileObject.getKind() == JavaFileObject.Kind.SOURCE ? javaFileObject : javaFileObject2;
        }
        long l2 = javaFileObject.getLastModified();
        return l2 > (l = javaFileObject2.getLastModified()) ? javaFileObject : javaFileObject2;
    }

    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
    }

    protected void extraFileActions(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject) {
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol) throws IOException {
        if (packageSymbol.members_field == null) {
            packageSymbol.members_field = new Scope(packageSymbol);
        }
        String string = packageSymbol.fullname.toString();
        EnumSet<JavaFileObject.Kind> enumSet = this.getPackageFileKinds();
        this.fillIn(packageSymbol, StandardLocation.PLATFORM_CLASS_PATH, this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, string, EnumSet.of(JavaFileObject.Kind.CLASS), false));
        EnumSet<JavaFileObject.Kind> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean bl = !enumSet2.isEmpty();
        EnumSet<JavaFileObject.Kind> enumSet3 = EnumSet.copyOf(enumSet);
        enumSet3.remove((Object)JavaFileObject.Kind.CLASS);
        boolean bl2 = !enumSet3.isEmpty();
        boolean bl3 = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH);
        if (this.verbose && this.verbosePath && this.fileManager instanceof StandardJavaFileManager) {
            List<Object> list;
            StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)this.fileManager;
            if (bl3 && bl2) {
                list = List.nil();
                for (File file : standardJavaFileManager.getLocation(StandardLocation.SOURCE_PATH)) {
                    list = list.prepend(file);
                }
                this.log.printVerbose("sourcepath", list.reverse().toString());
            } else if (bl2) {
                list = List.nil();
                for (File file : standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH)) {
                    list = list.prepend(file);
                }
                this.log.printVerbose("sourcepath", list.reverse().toString());
            }
            if (bl) {
                list = List.nil();
                for (File file : standardJavaFileManager.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) {
                    list = list.prepend(file);
                }
                for (File file : standardJavaFileManager.getLocation(StandardLocation.CLASS_PATH)) {
                    list = list.prepend(file);
                }
                this.log.printVerbose("classpath", list.reverse().toString());
            }
        }
        if (bl2 && !bl3) {
            this.fillIn(packageSymbol, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, string, enumSet, false));
        } else {
            if (bl) {
                this.fillIn(packageSymbol, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, string, enumSet2, false));
            }
            if (bl2) {
                this.fillIn(packageSymbol, StandardLocation.SOURCE_PATH, this.fileManager.list(StandardLocation.SOURCE_PATH, string, enumSet3, false));
            }
        }
        this.verbosePath = false;
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol, JavaFileManager.Location location, Iterable<JavaFileObject> iterable) {
        this.currentLoc = location;
        block3: for (JavaFileObject javaFileObject : iterable) {
            switch (javaFileObject.getKind()) {
                case CLASS: 
                case SOURCE: {
                    String string = this.fileManager.inferBinaryName(this.currentLoc, javaFileObject);
                    String string2 = string.substring(string.lastIndexOf(".") + 1);
                    if (!SourceVersion.isIdentifier(string2) && !string2.equals("package-info")) continue block3;
                    this.includeClassFile(packageSymbol, javaFileObject);
                    continue block3;
                }
            }
            this.extraFileActions(packageSymbol, javaFileObject);
        }
    }

    private void printCCF(String string, Object object) {
        this.log.printLines(string, object);
    }

    private static class SourceFileObject
    extends BaseFileObject {
        private Name name;
        private Name flatname;

        public SourceFileObject(Name name, Name name2) {
            super(null);
            this.name = name;
            this.flatname = name2;
        }

        @Override
        public URI toUri() {
            try {
                return new URI(null, this.name.toString(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new BaseFileObject.CannotCreateUriError(this.name.toString(), uRISyntaxException);
            }
        }

        @Override
        public String getName() {
            return this.name.toString();
        }

        @Override
        public String getShortName() {
            return this.getName();
        }

        @Override
        public JavaFileObject.Kind getKind() {
            return SourceFileObject.getKind(this.getName());
        }

        @Override
        public InputStream openInputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OutputStream openOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharBuffer getCharContent(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reader openReader(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Writer openWriter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean delete() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> iterable) {
            return this.flatname.toString();
        }

        @Override
        public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
            return true;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SourceFileObject)) {
                return false;
            }
            SourceFileObject sourceFileObject = (SourceFileObject)object;
            return this.name.equals(sourceFileObject.name);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static interface SourceCompleter {
        public void complete(Symbol.ClassSymbol var1) throws Symbol.CompletionFailure;
    }

    class TypeAnnotationCompleter
    extends AnnotationCompleter {
        List<TypeAnnotationProxy> proxies;

        TypeAnnotationCompleter(Symbol symbol, List<TypeAnnotationProxy> list) {
            super(symbol, List.nil());
            this.proxies = list;
        }

        List<Attribute.TypeCompound> deproxyTypeCompoundList(List<TypeAnnotationProxy> list) {
            ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
            for (TypeAnnotationProxy typeAnnotationProxy : list) {
                Attribute.Compound compound = this.deproxyCompound(typeAnnotationProxy.compound);
                Attribute.TypeCompound typeCompound = new Attribute.TypeCompound(compound, typeAnnotationProxy.position);
                listBuffer.add(typeCompound);
            }
            return listBuffer.toList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JavaFileObject javaFileObject = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                List<Attribute.TypeCompound> list = this.deproxyTypeCompoundList(this.proxies);
                this.sym.setTypeAttributes(list.prependList(this.sym.getRawTypeAttributes()));
            }
            finally {
                ClassReader.this.currentClassFile = javaFileObject;
            }
        }
    }

    class AnnotationCompleter
    extends AnnotationDeproxy
    implements Annotate.Worker {
        final Symbol sym;
        final List<CompoundAnnotationProxy> l;
        final JavaFileObject classFile;

        @Override
        public String toString() {
            String string = String.valueOf(String.valueOf(this.sym.owner));
            String string2 = String.valueOf(String.valueOf(this.sym));
            String string3 = String.valueOf(String.valueOf(this.l));
            return new StringBuilder(29 + string.length() + string2.length() + string3.length()).append(" ClassReader annotate ").append(string).append(".").append(string2).append(" with ").append(string3).toString();
        }

        AnnotationCompleter(Symbol symbol, List<CompoundAnnotationProxy> list) {
            this.sym = symbol;
            this.l = list;
            this.classFile = ClassReader.this.currentClassFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JavaFileObject javaFileObject = ClassReader.this.currentClassFile;
            try {
                ClassReader.this.currentClassFile = this.classFile;
                List<Attribute.Compound> list = this.deproxyCompoundList(this.l);
                if (this.sym.annotationsPendingCompletion()) {
                    this.sym.setDeclarationAttributes(list);
                } else {
                    this.sym.appendAttributes(list);
                }
            }
            finally {
                ClassReader.this.currentClassFile = javaFileObject;
            }
        }
    }

    class AnnotationDefaultCompleter
    extends AnnotationDeproxy
    implements Annotate.Worker {
        final Symbol.MethodSymbol sym;
        final Attribute value;
        final JavaFileObject classFile;

        @Override
        public String toString() {
            String string = String.valueOf(String.valueOf(this.sym.owner));
            String string2 = String.valueOf(String.valueOf(this.sym));
            String string3 = String.valueOf(String.valueOf(this.value));
            return new StringBuilder(36 + string.length() + string2.length() + string3.length()).append(" ClassReader store default for ").append(string).append(".").append(string2).append(" is ").append(string3).toString();
        }

        AnnotationDefaultCompleter(Symbol.MethodSymbol methodSymbol, Attribute attribute) {
            this.classFile = ClassReader.this.currentClassFile;
            this.sym = methodSymbol;
            this.value = attribute;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JavaFileObject javaFileObject = ClassReader.this.currentClassFile;
            try {
                this.sym.defaultValue = null;
                ClassReader.this.currentClassFile = this.classFile;
                this.sym.defaultValue = this.deproxy(this.sym.type.getReturnType(), this.value);
            }
            finally {
                ClassReader.this.currentClassFile = javaFileObject;
            }
        }
    }

    class AnnotationDeproxy
    implements ProxyVisitor {
        private Symbol.ClassSymbol requestingOwner;
        Attribute result;
        Type type;

        AnnotationDeproxy() {
            this.requestingOwner = ClassReader.this.currentOwner.kind == 16 ? ClassReader.this.currentOwner.enclClass() : (Symbol.ClassSymbol)ClassReader.this.currentOwner;
        }

        List<Attribute.Compound> deproxyCompoundList(List<CompoundAnnotationProxy> list) {
            ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
            List<CompoundAnnotationProxy> list2 = list;
            while (list2.nonEmpty()) {
                listBuffer.append(this.deproxyCompound((CompoundAnnotationProxy)list2.head));
                list2 = list2.tail;
            }
            return listBuffer.toList();
        }

        Attribute.Compound deproxyCompound(CompoundAnnotationProxy compoundAnnotationProxy) {
            ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> listBuffer = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
            List<Pair<Name, Attribute>> list = compoundAnnotationProxy.values;
            while (list.nonEmpty()) {
                Symbol.MethodSymbol methodSymbol = this.findAccessMethod(compoundAnnotationProxy.type, (Name)((Pair)list.head).fst);
                listBuffer.append(new Pair<Symbol.MethodSymbol, Attribute>(methodSymbol, this.deproxy(methodSymbol.type.getReturnType(), (Attribute)((Pair)list.head).snd)));
                list = list.tail;
            }
            return new Attribute.Compound(compoundAnnotationProxy.type, listBuffer.toList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Symbol.MethodSymbol findAccessMethod(Type type, Name name) {
            AnnoConstruct annoConstruct;
            Object object;
            Symbol.CompletionFailure completionFailure = null;
            try {
                object = type.tsym.members().lookup(name);
                while (((Scope.Entry)object).scope != null) {
                    annoConstruct = ((Scope.Entry)object).sym;
                    if (annoConstruct.kind == 16 && annoConstruct.type.getParameterTypes().length() == 0) {
                        return (Symbol.MethodSymbol)annoConstruct;
                    }
                    object = ((Scope.Entry)object).next();
                }
            }
            catch (Symbol.CompletionFailure completionFailure2) {
                completionFailure = completionFailure2;
            }
            object = ClassReader.this.log.useSource(this.requestingOwner.classfile);
            try {
                if (completionFailure == null) {
                    ClassReader.this.log.warning("annotation.method.not.found", type, name);
                } else {
                    ClassReader.this.log.warning("annotation.method.not.found.reason", type, name, completionFailure.getDetailValue());
                }
            }
            finally {
                ClassReader.this.log.useSource((JavaFileObject)object);
            }
            annoConstruct = new Type.MethodType(List.nil(), ClassReader.this.syms.botType, List.nil(), ClassReader.this.syms.methodClass);
            return new Symbol.MethodSymbol(1025L, name, (Type)annoConstruct, type.tsym);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Attribute deproxy(Type type, Attribute attribute) {
            Type type2 = this.type;
            try {
                this.type = type;
                attribute.accept(this);
                Attribute attribute2 = this.result;
                return attribute2;
            }
            finally {
                this.type = type2;
            }
        }

        @Override
        public void visitConstant(Attribute.Constant constant) {
            this.result = constant;
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            this.result = clazz;
        }

        @Override
        public void visitEnum(Attribute.Enum enum_) {
            throw new AssertionError();
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            throw new AssertionError();
        }

        @Override
        public void visitArray(Attribute.Array array) {
            throw new AssertionError();
        }

        @Override
        public void visitError(Attribute.Error error) {
            throw new AssertionError();
        }

        @Override
        public void visitEnumAttributeProxy(EnumAttributeProxy enumAttributeProxy) {
            Symbol.TypeSymbol typeSymbol = enumAttributeProxy.enumType.tsym;
            Symbol.VarSymbol varSymbol = null;
            Symbol.CompletionFailure completionFailure = null;
            try {
                Scope.Entry entry = typeSymbol.members().lookup(enumAttributeProxy.enumerator);
                while (entry.scope != null) {
                    if (entry.sym.kind == 4) {
                        varSymbol = (Symbol.VarSymbol)entry.sym;
                        break;
                    }
                    entry = entry.next();
                }
            }
            catch (Symbol.CompletionFailure completionFailure2) {
                completionFailure = completionFailure2;
            }
            if (varSymbol == null) {
                if (completionFailure != null) {
                    ClassReader.this.log.warning("unknown.enum.constant.reason", ClassReader.this.currentClassFile, typeSymbol, enumAttributeProxy.enumerator, completionFailure.getDiagnostic());
                } else {
                    ClassReader.this.log.warning("unknown.enum.constant", ClassReader.this.currentClassFile, typeSymbol, enumAttributeProxy.enumerator);
                }
                this.result = new Attribute.Enum(typeSymbol.type, new Symbol.VarSymbol(0L, enumAttributeProxy.enumerator, ClassReader.this.syms.botType, typeSymbol));
            } else {
                this.result = new Attribute.Enum(typeSymbol.type, varSymbol);
            }
        }

        @Override
        public void visitArrayAttributeProxy(ArrayAttributeProxy arrayAttributeProxy) {
            int n = arrayAttributeProxy.values.length();
            Attribute[] attributeArray = new Attribute[n];
            Type type = ClassReader.this.types.elemtype(this.type);
            int n2 = 0;
            List<Attribute> list = arrayAttributeProxy.values;
            while (list.nonEmpty()) {
                attributeArray[n2++] = this.deproxy(type, (Attribute)list.head);
                list = list.tail;
            }
            this.result = new Attribute.Array(this.type, attributeArray);
        }

        @Override
        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy compoundAnnotationProxy) {
            this.result = this.deproxyCompound(compoundAnnotationProxy);
        }
    }

    static class TypeAnnotationProxy {
        final CompoundAnnotationProxy compound;
        final TypeAnnotationPosition position;

        public TypeAnnotationProxy(CompoundAnnotationProxy compoundAnnotationProxy, TypeAnnotationPosition typeAnnotationPosition) {
            this.compound = compoundAnnotationProxy;
            this.position = typeAnnotationPosition;
        }
    }

    static class CompoundAnnotationProxy
    extends Attribute {
        final List<Pair<Name, Attribute>> values;

        public CompoundAnnotationProxy(Type type, List<Pair<Name, Attribute>> list) {
            super(type);
            this.values = list;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitCompoundAnnotationProxy(this);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("@");
            stringBuilder.append(this.type.tsym.getQualifiedName());
            stringBuilder.append("/*proxy*/{");
            boolean bl = true;
            List<Pair<Name, Attribute>> list = this.values;
            while (list.nonEmpty()) {
                Pair pair = (Pair)list.head;
                if (!bl) {
                    stringBuilder.append(",");
                }
                bl = false;
                stringBuilder.append((CharSequence)pair.fst);
                stringBuilder.append("=");
                stringBuilder.append(pair.snd);
                list = list.tail;
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    static class ArrayAttributeProxy
    extends Attribute {
        List<Attribute> values;

        ArrayAttributeProxy(List<Attribute> list) {
            super(null);
            this.values = list;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitArrayAttributeProxy(this);
        }

        @Override
        public String toString() {
            String string = String.valueOf(String.valueOf(this.values));
            return new StringBuilder(2 + string.length()).append("{").append(string).append("}").toString();
        }
    }

    static class EnumAttributeProxy
    extends Attribute {
        Type enumType;
        Name enumerator;

        public EnumAttributeProxy(Type type, Name name) {
            super(null);
            this.enumType = type;
            this.enumerator = name;
        }

        @Override
        public void accept(Attribute.Visitor visitor) {
            ((ProxyVisitor)visitor).visitEnumAttributeProxy(this);
        }

        @Override
        public String toString() {
            String string = String.valueOf(String.valueOf(this.enumType));
            String string2 = String.valueOf(String.valueOf(this.enumerator));
            return new StringBuilder(15 + string.length() + string2.length()).append("/*proxy enum*/").append(string).append(".").append(string2).toString();
        }
    }

    static interface ProxyVisitor
    extends Attribute.Visitor {
        public void visitEnumAttributeProxy(EnumAttributeProxy var1);

        public void visitArrayAttributeProxy(ArrayAttributeProxy var1);

        public void visitCompoundAnnotationProxy(CompoundAnnotationProxy var1);
    }

    protected abstract class AttributeReader {
        protected final Name name;
        protected final ClassFile.Version version;
        protected final Set<AttributeKind> kinds;

        protected AttributeReader(Name name, ClassFile.Version version2, Set<AttributeKind> set) {
            this.name = name;
            this.version = version2;
            this.kinds = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean accepts(AttributeKind attributeKind) {
            if (this.kinds.contains((Object)attributeKind)) {
                if (ClassReader.this.majorVersion > this.version.major || ClassReader.this.majorVersion == this.version.major && ClassReader.this.minorVersion >= this.version.minor) {
                    return true;
                }
                if (ClassReader.this.lintClassfile && !ClassReader.this.warnedAttrs.contains(this.name)) {
                    JavaFileObject javaFileObject = ClassReader.this.log.useSource(ClassReader.this.currentClassFile);
                    try {
                        ClassReader.this.log.warning(Lint.LintCategory.CLASSFILE, (JCDiagnostic.DiagnosticPosition)null, "future.attr", this.name, this.version.major, this.version.minor, ClassReader.this.majorVersion, ClassReader.this.minorVersion);
                    }
                    finally {
                        ClassReader.this.log.useSource(javaFileObject);
                    }
                    ClassReader.this.warnedAttrs.add(this.name);
                }
            }
            return false;
        }

        protected abstract void read(Symbol var1, int var2);
    }

    protected static enum AttributeKind {
        CLASS,
        MEMBER;

    }

    public class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.TypeSymbol typeSymbol, JavaFileObject javaFileObject, JCDiagnostic jCDiagnostic) {
            super((Symbol)typeSymbol, ClassReader.this.createBadClassFileDiagnostic(javaFileObject, jCDiagnostic));
        }
    }
}

