/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Items;
import com.sun.tools.javac.jvm.LVTRanges;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.FilteredMemberList;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ElementKind;

public class Gen
extends JCTree.Visitor {
    protected static final Context.Key<Gen> genKey = new Context.Key();
    private final Log log;
    private final Symtab syms;
    private final Check chk;
    private final Resolve rs;
    private final TreeMaker make;
    private final Names names;
    private final Target target;
    private final Type stringBufferType;
    private final Map<Type, Symbol> stringBufferAppend;
    private Name accessDollar;
    private final Types types;
    private final Lower lower;
    private final boolean allowGenerics;
    private final boolean generateIproxies;
    private final Code.StackMapFormat stackMap;
    private final Type methodType;
    private Pool pool;
    private LVTRanges lvtRanges;
    private final boolean typeAnnoAsserts;
    private final boolean lineDebugInfo;
    private final boolean varDebugInfo;
    private final boolean genCrt;
    private final boolean debugCode;
    private final boolean allowInvokedynamic;
    private final int jsrlimit;
    private boolean useJsrLocally;
    private Code code;
    private Items items;
    private Env<AttrContext> attrEnv;
    private JCTree.JCCompilationUnit toplevel;
    private int nerrs = 0;
    EndPosTable endPosTable;
    Env<GenContext> env;
    Type pt;
    Items.Item result;
    private ClassReferenceVisitor classReferenceVisitor = new ClassReferenceVisitor();

    public static Gen instance(Context context) {
        Gen gen = context.get(genKey);
        if (gen == null) {
            gen = new Gen(context);
        }
        return gen;
    }

    protected Gen(Context context) {
        context.put(genKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.chk = Check.instance(context);
        this.rs = Resolve.instance(context);
        this.make = TreeMaker.instance(context);
        this.target = Target.instance(context);
        this.types = Types.instance(context);
        this.methodType = new Type.MethodType(null, null, null, this.syms.methodClass);
        this.allowGenerics = Source.instance(context).allowGenerics();
        this.stringBufferType = this.target.useStringBuilder() ? this.syms.stringBuilderType : this.syms.stringBufferType;
        this.stringBufferAppend = new HashMap<Type, Symbol>();
        char c = this.target.syntheticNameChar();
        this.accessDollar = this.names.fromString(new StringBuilder(7).append("access").append(c).toString());
        this.lower = Lower.instance(context);
        Options options = Options.instance(context);
        this.lineDebugInfo = options.isUnset(Option.G_CUSTOM) || options.isSet(Option.G_CUSTOM, "lines");
        boolean bl = this.varDebugInfo = options.isUnset(Option.G_CUSTOM) ? options.isSet(Option.G) : options.isSet(Option.G_CUSTOM, "vars");
        if (this.varDebugInfo) {
            this.lvtRanges = LVTRanges.instance(context);
        }
        this.genCrt = options.isSet(Option.XJCOV);
        this.debugCode = options.isSet("debugcode");
        this.allowInvokedynamic = this.target.hasInvokedynamic() || options.isSet("invokedynamic");
        this.pool = new Pool(this.types);
        this.typeAnnoAsserts = options.isSet("TypeAnnotationAsserts");
        boolean bl2 = this.generateIproxies = this.target.requiresIproxy() || options.isSet("miranda");
        this.stackMap = this.target.generateStackMapTable() ? Code.StackMapFormat.JSR202 : (this.target.generateCLDCStackmap() ? Code.StackMapFormat.CLDC : Code.StackMapFormat.NONE);
        int n = 50;
        String string = options.get("jsrlimit");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.jsrlimit = n;
        this.useJsrLocally = false;
    }

    void loadIntConst(int n) {
        this.items.makeImmediateItem(this.syms.intType, n).load();
    }

    public static int zero(int n) {
        switch (n) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 14;
            }
        }
        throw new AssertionError((Object)"zero");
    }

    public static int one(int n) {
        return Gen.zero(n) + 1;
    }

    void emitMinusOne(int n) {
        if (n == 1) {
            this.items.makeImmediateItem(this.syms.longType, new Long(-1L)).load();
        } else {
            this.code.emitop0(2);
        }
    }

    Symbol binaryQualifier(Symbol symbol, Type type) {
        if (type.hasTag(TypeTag.ARRAY)) {
            if (symbol == this.syms.lengthVar || symbol.owner != this.syms.arrayClass) {
                return symbol;
            }
            Symbol.TypeSymbol typeSymbol = this.target.arrayBinaryCompatibility() ? new Symbol.ClassSymbol(1L, type.tsym.name, type, this.syms.noSymbol) : this.syms.objectType.tsym;
            return symbol.clone(typeSymbol);
        }
        if (symbol.owner == type.tsym || (symbol.flags() & 0x1008L) == 4104L) {
            return symbol;
        }
        if (!this.target.obeyBinaryCompatibility()) {
            return this.rs.isAccessible(this.attrEnv, (Symbol.TypeSymbol)symbol.owner) ? symbol : symbol.clone(type.tsym);
        }
        if (!this.target.interfaceFieldsBinaryCompatibility() && (symbol.owner.flags() & 0x200L) != 0L && symbol.kind == 4) {
            return symbol;
        }
        if (symbol.owner == this.syms.objectType.tsym) {
            return symbol;
        }
        if (!this.target.interfaceObjectOverridesBinaryCompatibility() && (symbol.owner.flags() & 0x200L) != 0L && this.syms.objectType.tsym.members().lookup((Name)symbol.name).scope != null) {
            return symbol;
        }
        return symbol.clone(type.tsym);
    }

    int makeRef(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        this.checkDimension(diagnosticPosition, type);
        if (type.isAnnotated()) {
            return this.pool.put(type);
        }
        return this.pool.put(type.hasTag(TypeTag.CLASS) ? type.tsym : type);
    }

    private void checkDimension(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type) {
        switch (type.getTag()) {
            case METHOD: {
                this.checkDimension(diagnosticPosition, type.getReturnType());
                List<Type> list = type.getParameterTypes();
                while (list.nonEmpty()) {
                    this.checkDimension(diagnosticPosition, (Type)list.head);
                    list = list.tail;
                }
                break;
            }
            case ARRAY: {
                if (this.types.dimensions(type) <= 255) break;
                this.log.error(diagnosticPosition, "limit.dimensions", new Object[0]);
                ++this.nerrs;
                break;
            }
        }
    }

    Items.LocalItem makeTemp(Type type) {
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(4096L, this.names.empty, type, this.env.enclMethod.sym);
        this.code.newLocal(varSymbol);
        return this.items.makeLocalItem(varSymbol);
    }

    void callMethod(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Name name, List<Type> list, boolean bl) {
        Symbol.MethodSymbol methodSymbol = this.rs.resolveInternalMethod(diagnosticPosition, this.attrEnv, type, name, list, null);
        if (bl) {
            this.items.makeStaticItem(methodSymbol).invoke();
        } else {
            this.items.makeMemberItem(methodSymbol, name == this.names.init).invoke();
        }
    }

    private boolean isAccessSuper(JCTree.JCMethodDecl jCMethodDecl) {
        return (jCMethodDecl.mods.flags & 0x1000L) != 0L && this.isOddAccessName(jCMethodDecl.name);
    }

    private boolean isOddAccessName(Name name) {
        return name.startsWith(this.accessDollar) && (name.getByteAt(name.getByteLength() - 1) & 1) == 1;
    }

    void genFinalizer(Env<GenContext> env) {
        if (this.code.isAlive() && ((GenContext)env.info).finalize != null) {
            ((GenContext)env.info).finalize.gen();
        }
    }

    Env<GenContext> unwind(JCTree jCTree, Env<GenContext> env) {
        Env<GenContext> env2 = env;
        while (true) {
            this.genFinalizer(env2);
            if (env2.tree == jCTree) break;
            env2 = env2.next;
        }
        return env2;
    }

    void endFinalizerGap(Env<GenContext> env) {
        if (((GenContext)env.info).gaps != null && ((GenContext)env.info).gaps.length() % 2 == 1) {
            ((GenContext)env.info).gaps.append(this.code.curCP());
        }
    }

    void endFinalizerGaps(Env<GenContext> env, Env<GenContext> env2) {
        Env<GenContext> env3 = null;
        while (env3 != env2) {
            this.endFinalizerGap(env);
            env3 = env;
            env = env.next;
        }
    }

    boolean hasFinally(JCTree jCTree, Env<GenContext> env) {
        while (env.tree != jCTree) {
            if (env.tree.hasTag(JCTree.Tag.TRY) && ((GenContext)env.info).finalize.hasFinalizer()) {
                return true;
            }
            env = env.next;
        }
        return false;
    }

    List<JCTree> normalizeDefs(List<JCTree> list, Symbol.ClassSymbol classSymbol) {
        Object object;
        List<JCTree.JCStatement> list2;
        ListBuffer<Object> listBuffer = new ListBuffer<Object>();
        ListBuffer<Attribute.TypeCompound> listBuffer2 = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Object> listBuffer3 = new ListBuffer<Object>();
        ListBuffer<Attribute.TypeCompound> listBuffer4 = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<JCTree> listBuffer5 = new ListBuffer<JCTree>();
        Object object2 = list;
        while (((List)object2).nonEmpty()) {
            list2 = (JCTree)((List)object2).head;
            switch (((JCTree)((Object)list2)).getTag()) {
                case BLOCK: {
                    object = (JCTree.JCBlock)((Object)list2);
                    if ((((JCTree.JCBlock)object).flags & 8L) != 0L) {
                        listBuffer3.append(object);
                        break;
                    }
                    listBuffer.append(object);
                    break;
                }
                case METHODDEF: {
                    listBuffer5.append((JCTree)((Object)list2));
                    break;
                }
                case VARDEF: {
                    JCTree.JCStatement jCStatement;
                    JCTree jCTree = (JCTree.JCVariableDecl)((Object)list2);
                    Symbol.VarSymbol varSymbol = ((JCTree.JCVariableDecl)jCTree).sym;
                    this.checkDimension(jCTree.pos(), varSymbol.type);
                    if (((JCTree.JCVariableDecl)jCTree).init == null) break;
                    if ((varSymbol.flags() & 8L) == 0L) {
                        jCStatement = this.make.at(jCTree.pos()).Assignment(varSymbol, ((JCTree.JCVariableDecl)jCTree).init);
                        listBuffer.append(jCStatement);
                        this.endPosTable.replaceTree(jCTree, jCStatement);
                        listBuffer2.addAll((Collection<Attribute.TypeCompound>)this.getAndRemoveNonFieldTAs(varSymbol));
                        break;
                    }
                    if (varSymbol.getConstValue() == null) {
                        jCStatement = this.make.at(((JCTree.JCVariableDecl)jCTree).pos).Assignment(varSymbol, ((JCTree.JCVariableDecl)jCTree).init);
                        listBuffer3.append(jCStatement);
                        this.endPosTable.replaceTree(jCTree, jCStatement);
                        listBuffer4.addAll((Collection<Attribute.TypeCompound>)this.getAndRemoveNonFieldTAs(varSymbol));
                        break;
                    }
                    this.checkStringConstant(((JCTree.JCVariableDecl)jCTree).init.pos(), varSymbol.getConstValue());
                    break;
                }
                default: {
                    Assert.error();
                }
            }
            object2 = ((List)object2).tail;
        }
        if (listBuffer.length() != 0) {
            object2 = listBuffer.toList();
            listBuffer2.addAll((Collection<Attribute.TypeCompound>)classSymbol.getInitTypeAttributes());
            list2 = listBuffer2.toList();
            for (JCTree jCTree : listBuffer5) {
                this.normalizeMethod((JCTree.JCMethodDecl)jCTree, (List<JCTree.JCStatement>)object2, (List<Attribute.TypeCompound>)list2);
            }
        }
        if (listBuffer3.length() != 0) {
            object2 = new Symbol.MethodSymbol(8L | classSymbol.flags() & 0x800L, this.names.clinit, new Type.MethodType(List.nil(), this.syms.voidType, List.nil(), this.syms.methodClass), classSymbol);
            classSymbol.members().enter((Symbol)object2);
            list2 = listBuffer3.toList();
            object = this.make.at(((JCTree.JCStatement)list2.head).pos()).Block(0L, list2);
            ((JCTree.JCBlock)object).endpos = TreeInfo.endPos(list2.last());
            listBuffer5.append(this.make.MethodDef((Symbol.MethodSymbol)object2, (JCTree.JCBlock)object));
            if (!listBuffer4.isEmpty()) {
                ((Symbol)object2).appendUniqueTypeAttributes(listBuffer4.toList());
            }
            if (!classSymbol.getClassInitTypeAttributes().isEmpty()) {
                ((Symbol)object2).appendUniqueTypeAttributes(classSymbol.getClassInitTypeAttributes());
            }
        }
        return listBuffer5.toList();
    }

    private List<Attribute.TypeCompound> getAndRemoveNonFieldTAs(Symbol.VarSymbol varSymbol) {
        List<Attribute.TypeCompound> list = varSymbol.getRawTypeAttributes();
        ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Attribute.TypeCompound> listBuffer2 = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound typeCompound : list) {
            if (typeCompound.getPosition().type == TargetType.FIELD) {
                listBuffer.add(typeCompound);
                continue;
            }
            if (this.typeAnnoAsserts) {
                Assert.error("Type annotation does not have a valid positior");
            }
            listBuffer2.add(typeCompound);
        }
        varSymbol.setTypeAttributes(listBuffer.toList());
        return listBuffer2.toList();
    }

    private void checkStringConstant(JCDiagnostic.DiagnosticPosition diagnosticPosition, Object object) {
        if (this.nerrs != 0 || object == null || !(object instanceof String) || ((String)object).length() < 65535) {
            return;
        }
        this.log.error(diagnosticPosition, "limit.string", new Object[0]);
        ++this.nerrs;
    }

    void normalizeMethod(JCTree.JCMethodDecl jCMethodDecl, List<JCTree.JCStatement> list, List<Attribute.TypeCompound> list2) {
        if (jCMethodDecl.name == this.names.init && TreeInfo.isInitialConstructor(jCMethodDecl)) {
            List<JCTree.JCStatement> list3 = jCMethodDecl.body.stats;
            ListBuffer listBuffer = new ListBuffer();
            if (list3.nonEmpty()) {
                while (TreeInfo.isSyntheticInit((JCTree)list3.head)) {
                    listBuffer.append(list3.head);
                    list3 = list3.tail;
                }
                listBuffer.append(list3.head);
                list3 = list3.tail;
                while (list3.nonEmpty() && TreeInfo.isSyntheticInit((JCTree)list3.head)) {
                    listBuffer.append(list3.head);
                    list3 = list3.tail;
                }
                listBuffer.appendList(list);
                while (list3.nonEmpty()) {
                    listBuffer.append(list3.head);
                    list3 = list3.tail;
                }
            }
            jCMethodDecl.body.stats = listBuffer.toList();
            if (jCMethodDecl.body.endpos == -1) {
                jCMethodDecl.body.endpos = TreeInfo.endPos(jCMethodDecl.body.stats.last());
            }
            jCMethodDecl.sym.appendUniqueTypeAttributes(list2);
        }
    }

    void implementInterfaceMethods(Symbol.ClassSymbol classSymbol) {
        this.implementInterfaceMethods(classSymbol, classSymbol);
    }

    void implementInterfaceMethods(Symbol.ClassSymbol classSymbol, Symbol.ClassSymbol classSymbol2) {
        List<Type> list = this.types.interfaces(classSymbol.type);
        while (list.nonEmpty()) {
            Symbol.ClassSymbol classSymbol3 = (Symbol.ClassSymbol)((Type)list.head).tsym;
            Scope.Entry entry = classSymbol3.members().elems;
            while (entry != null) {
                if (entry.sym.kind == 16 && (entry.sym.flags() & 8L) == 0L) {
                    Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)entry.sym;
                    Symbol.MethodSymbol methodSymbol2 = methodSymbol.binaryImplementation(classSymbol2, this.types);
                    if (methodSymbol2 == null) {
                        this.addAbstractMethod(classSymbol2, methodSymbol);
                    } else if ((methodSymbol2.flags() & 0x200000L) != 0L) {
                        this.adjustAbstractMethod(classSymbol2, methodSymbol2, methodSymbol);
                    }
                }
                entry = entry.sibling;
            }
            this.implementInterfaceMethods(classSymbol3, classSymbol2);
            list = list.tail;
        }
    }

    private void addAbstractMethod(Symbol.ClassSymbol classSymbol, Symbol.MethodSymbol methodSymbol) {
        Symbol.MethodSymbol methodSymbol2 = new Symbol.MethodSymbol(methodSymbol.flags() | 0x200000L | 0x1000L, methodSymbol.name, methodSymbol.type, classSymbol);
        classSymbol.members().enter(methodSymbol2);
    }

    private void adjustAbstractMethod(Symbol.ClassSymbol classSymbol, Symbol.MethodSymbol methodSymbol, Symbol.MethodSymbol methodSymbol2) {
        Type.MethodType methodType = (Type.MethodType)methodSymbol.type;
        Type type = this.types.memberType(classSymbol.type, methodSymbol2);
        methodType.thrown = this.chk.intersect((List<Type>)methodType.getThrownTypes(), type.getThrownTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genDef(JCTree jCTree, Env<GenContext> env) {
        Env<GenContext> env2 = this.env;
        try {
            this.env = env;
            jCTree.accept(this);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(jCTree.pos(), completionFailure);
        }
        finally {
            this.env = env2;
        }
    }

    public void genStat(JCTree jCTree, Env<GenContext> env, int n) {
        if (!this.genCrt) {
            this.genStat(jCTree, env);
            return;
        }
        int n2 = this.code.curCP();
        this.genStat(jCTree, env);
        if (jCTree.hasTag(JCTree.Tag.BLOCK)) {
            n |= 2;
        }
        this.code.crt.put(jCTree, n, n2, this.code.curCP());
    }

    public void genStat(JCTree jCTree, Env<GenContext> env) {
        if (this.code.isAlive()) {
            this.code.statBegin(jCTree.pos);
            this.genDef(jCTree, env);
        } else if (((GenContext)env.info).isSwitch && jCTree.hasTag(JCTree.Tag.VARDEF)) {
            this.code.newLocal(((JCTree.JCVariableDecl)jCTree).sym);
        }
    }

    public void genStats(List<JCTree.JCStatement> list, Env<GenContext> env, int n) {
        if (!this.genCrt) {
            this.genStats(list, env);
            return;
        }
        if (list.length() == 1) {
            this.genStat((JCTree)list.head, env, n | 1);
        } else {
            int n2 = this.code.curCP();
            this.genStats(list, env);
            this.code.crt.put(list, n, n2, this.code.curCP());
        }
    }

    public void genStats(List<? extends JCTree> list, Env<GenContext> env) {
        List<JCTree> list2 = list;
        while (list2.nonEmpty()) {
            this.genStat((JCTree)list2.head, env, 1);
            list2 = list2.tail;
        }
    }

    public Items.CondItem genCond(JCTree jCTree, int n) {
        if (!this.genCrt) {
            return this.genCond(jCTree, false);
        }
        int n2 = this.code.curCP();
        Items.CondItem condItem = this.genCond(jCTree, (n & 8) != 0);
        this.code.crt.put(jCTree, n, n2, this.code.curCP());
        return condItem;
    }

    public Items.CondItem genCond(JCTree jCTree, boolean bl) {
        JCTree jCTree2 = TreeInfo.skipParens(jCTree);
        if (jCTree2.hasTag(JCTree.Tag.CONDEXPR)) {
            JCTree.JCConditional jCConditional = (JCTree.JCConditional)jCTree2;
            Items.CondItem condItem = this.genCond((JCTree)jCConditional.cond, 8);
            if (condItem.isTrue()) {
                this.code.resolve(condItem.trueJumps);
                Items.CondItem condItem2 = this.genCond((JCTree)jCConditional.truepart, 16);
                if (bl) {
                    condItem2.tree = jCConditional.truepart;
                }
                return condItem2;
            }
            if (condItem.isFalse()) {
                this.code.resolve(condItem.falseJumps);
                Items.CondItem condItem3 = this.genCond((JCTree)jCConditional.falsepart, 16);
                if (bl) {
                    condItem3.tree = jCConditional.falsepart;
                }
                return condItem3;
            }
            Code.Chain chain = condItem.jumpFalse();
            this.code.resolve(condItem.trueJumps);
            Items.CondItem condItem4 = this.genCond((JCTree)jCConditional.truepart, 16);
            if (bl) {
                condItem4.tree = jCConditional.truepart;
            }
            Code.Chain chain2 = condItem4.jumpFalse();
            this.code.resolve(condItem4.trueJumps);
            Code.Chain chain3 = this.code.branch(167);
            this.code.resolve(chain);
            Items.CondItem condItem5 = this.genCond((JCTree)jCConditional.falsepart, 16);
            Items.CondItem condItem6 = this.items.makeCondItem(condItem5.opcode, Code.mergeChains(chain3, condItem5.trueJumps), Code.mergeChains(chain2, condItem5.falseJumps));
            if (bl) {
                condItem6.tree = jCConditional.falsepart;
            }
            return condItem6;
        }
        Items.CondItem condItem = this.genExpr(jCTree, this.syms.booleanType).mkCond();
        if (bl) {
            condItem.tree = jCTree;
        }
        return condItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Items.Item genExpr(JCTree jCTree, Type type) {
        Type type2 = this.pt;
        try {
            if (jCTree.type.constValue() != null) {
                jCTree.accept(this.classReferenceVisitor);
                this.checkStringConstant(jCTree.pos(), jCTree.type.constValue());
                this.result = this.items.makeImmediateItem(jCTree.type, jCTree.type.constValue());
            } else {
                this.pt = type;
                jCTree.accept(this);
            }
            Items.Item item = this.result.coerce(type);
            return item;
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(jCTree.pos(), completionFailure);
            this.code.state.stacksize = 1;
            Items.Item item = this.items.makeStackItem(type);
            return item;
        }
        finally {
            this.pt = type2;
        }
    }

    public void genArgs(List<JCTree.JCExpression> list, List<Type> list2) {
        List<JCTree.JCExpression> list3 = list;
        while (list3.nonEmpty()) {
            this.genExpr((JCTree)list3.head, (Type)list2.head).load();
            list2 = list2.tail;
            list3 = list3.tail;
        }
        Assert.check(list2.isEmpty());
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        Env<GenContext> env = this.env.dup(jCMethodDecl);
        env.enclMethod = jCMethodDecl;
        this.pt = jCMethodDecl.sym.erasure(this.types).getReturnType();
        this.checkDimension(jCMethodDecl.pos(), jCMethodDecl.sym.erasure(this.types));
        this.genMethod(jCMethodDecl, env, false);
    }

    void genMethod(JCTree.JCMethodDecl jCMethodDecl, Env<GenContext> env, boolean bl) {
        Symbol.MethodSymbol methodSymbol = jCMethodDecl.sym;
        int n = 0;
        if (methodSymbol.isConstructor()) {
            ++n;
            if (methodSymbol.enclClass().isInner() && !methodSymbol.enclClass().isStatic()) {
                ++n;
            }
        } else if ((jCMethodDecl.mods.flags & 8L) == 0L) {
            ++n;
        }
        if (Code.width(this.types.erasure(env.enclMethod.sym.type).getParameterTypes()) + n > 255) {
            this.log.error(jCMethodDecl.pos(), "limit.parameters", new Object[0]);
            ++this.nerrs;
        } else if (jCMethodDecl.body != null) {
            int n2 = this.initCode(jCMethodDecl, env, bl);
            try {
                this.genStat(jCMethodDecl.body, env);
            }
            catch (CodeSizeOverflow codeSizeOverflow) {
                n2 = this.initCode(jCMethodDecl, env, bl);
                this.genStat(jCMethodDecl.body, env);
            }
            if (this.code.state.stacksize != 0) {
                this.log.error(jCMethodDecl.body.pos(), "stack.sim.error", jCMethodDecl);
                throw new AssertionError();
            }
            if (this.code.isAlive()) {
                this.code.statBegin(TreeInfo.endPos(jCMethodDecl.body));
                if (env.enclMethod == null || env.enclMethod.sym.type.getReturnType().hasTag(TypeTag.VOID)) {
                    this.code.emitop0(177);
                } else {
                    int n3 = this.code.entryPoint();
                    Items.CondItem condItem = this.items.makeCondItem(167);
                    this.code.resolve(condItem.jumpTrue(), n3);
                }
            }
            if (this.genCrt) {
                this.code.crt.put(jCMethodDecl.body, 2, n2, this.code.curCP());
            }
            this.code.endScopes(0);
            if (this.code.checkLimits(jCMethodDecl.pos(), this.log)) {
                ++this.nerrs;
                return;
            }
            if (!bl && this.code.fatcode) {
                this.genMethod(jCMethodDecl, env, true);
            }
            if (this.stackMap == Code.StackMapFormat.JSR202) {
                this.code.lastFrame = null;
                this.code.frameBeforeLast = null;
            }
            this.code.compressCatchTable();
            this.code.fillExceptionParameterPositions();
        }
    }

    private int initCode(JCTree.JCMethodDecl jCMethodDecl, Env<GenContext> env, boolean bl) {
        List list;
        Symbol.MethodSymbol methodSymbol = jCMethodDecl.sym;
        methodSymbol.code = this.code = new Code(methodSymbol, bl, this.lineDebugInfo ? this.toplevel.lineMap : null, this.varDebugInfo, this.stackMap, this.debugCode, this.genCrt ? new CRTable(jCMethodDecl, env.toplevel.endPositions) : null, this.syms, this.types, this.pool, this.varDebugInfo ? this.lvtRanges : null);
        this.items = new Items(this.pool, this.code, this.syms, this.types);
        if (this.code.debugCode) {
            list = String.valueOf(String.valueOf(methodSymbol));
            String string = String.valueOf(String.valueOf(jCMethodDecl));
            System.err.println(new StringBuilder(10 + ((String)((Object)list)).length() + string.length()).append((String)((Object)list)).append(" for body ").append(string).toString());
        }
        if ((jCMethodDecl.mods.flags & 8L) == 0L) {
            list = methodSymbol.owner.type;
            if (methodSymbol.isConstructor() && list != this.syms.objectType) {
                list = UninitializedType.uninitializedThis((Type)((Object)list));
            }
            this.code.setDefined(this.code.newLocal(new Symbol.VarSymbol(16L, this.names._this, (Type)((Object)list), methodSymbol.owner)));
        }
        list = jCMethodDecl.params;
        while (list.nonEmpty()) {
            this.checkDimension(((JCTree.JCVariableDecl)list.head).pos(), ((JCTree.JCVariableDecl)list.head).sym.type);
            this.code.setDefined(this.code.newLocal(((JCTree.JCVariableDecl)list.head).sym));
            list = list.tail;
        }
        int n = this.genCrt ? this.code.curCP() : 0;
        this.code.entryPoint();
        this.code.pendingStackMap = false;
        return n;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        Symbol.VarSymbol varSymbol = jCVariableDecl.sym;
        this.code.newLocal(varSymbol);
        if (jCVariableDecl.init != null) {
            this.checkStringConstant(jCVariableDecl.init.pos(), varSymbol.getConstValue());
            if (varSymbol.getConstValue() == null || this.varDebugInfo) {
                this.genExpr(jCVariableDecl.init, varSymbol.erasure(this.types)).load();
                this.items.makeLocalItem(varSymbol).store();
            }
        }
        this.checkDimension(jCVariableDecl.pos(), varSymbol.type);
    }

    @Override
    public void visitSkip(JCTree.JCSkip jCSkip) {
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        int n = this.code.nextreg;
        Env<GenContext> env = this.env.dup(jCBlock, new GenContext());
        this.genStats(jCBlock.stats, env);
        if (!this.env.tree.hasTag(JCTree.Tag.METHODDEF)) {
            this.code.statBegin(jCBlock.endpos);
            this.code.endScopes(n);
            this.code.pendingStatPos = -1;
        }
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        this.genLoop(jCDoWhileLoop, jCDoWhileLoop.body, jCDoWhileLoop.cond, List.nil(), false);
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        this.genLoop(jCWhileLoop, jCWhileLoop.body, jCWhileLoop.cond, List.nil(), true);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        int n = this.code.nextreg;
        this.genStats(jCForLoop.init, this.env);
        this.genLoop(jCForLoop, jCForLoop.body, jCForLoop.cond, jCForLoop.step, true);
        this.code.endScopes(n);
    }

    private void genLoop(JCTree.JCStatement jCStatement, JCTree.JCStatement jCStatement2, JCTree.JCExpression jCExpression, List<JCTree.JCExpressionStatement> list, boolean bl) {
        Env<GenContext> env = this.env.dup(jCStatement, new GenContext());
        int n = this.code.entryPoint();
        if (bl) {
            Items.CondItem condItem;
            if (jCExpression != null) {
                this.code.statBegin(jCExpression.pos);
                condItem = this.genCond((JCTree)TreeInfo.skipParens(jCExpression), 8);
            } else {
                condItem = this.items.makeCondItem(167);
            }
            Code.Chain chain = condItem.jumpFalse();
            this.code.resolve(condItem.trueJumps);
            this.genStat(jCStatement2, env, 17);
            if (this.varDebugInfo) {
                this.checkLoopLocalVarRangeEnding(jCStatement, jCStatement2, LoopLocalVarRangeEndingPoint.BEFORE_STEPS);
            }
            this.code.resolve(((GenContext)env.info).cont);
            this.genStats(list, env);
            if (this.varDebugInfo) {
                this.checkLoopLocalVarRangeEnding(jCStatement, jCStatement2, LoopLocalVarRangeEndingPoint.AFTER_STEPS);
            }
            this.code.resolve(this.code.branch(167), n);
            this.code.resolve(chain);
        } else {
            Items.CondItem condItem;
            this.genStat(jCStatement2, env, 17);
            if (this.varDebugInfo) {
                this.checkLoopLocalVarRangeEnding(jCStatement, jCStatement2, LoopLocalVarRangeEndingPoint.BEFORE_STEPS);
            }
            this.code.resolve(((GenContext)env.info).cont);
            this.genStats(list, env);
            if (this.varDebugInfo) {
                this.checkLoopLocalVarRangeEnding(jCStatement, jCStatement2, LoopLocalVarRangeEndingPoint.AFTER_STEPS);
            }
            if (jCExpression != null) {
                this.code.statBegin(jCExpression.pos);
                condItem = this.genCond((JCTree)TreeInfo.skipParens(jCExpression), 8);
            } else {
                condItem = this.items.makeCondItem(167);
            }
            this.code.resolve(condItem.jumpTrue(), n);
            this.code.resolve(condItem.falseJumps);
        }
        this.code.resolve(((GenContext)env.info).exit);
    }

    private void checkLoopLocalVarRangeEnding(JCTree jCTree, JCTree jCTree2, LoopLocalVarRangeEndingPoint loopLocalVarRangeEndingPoint) {
        if (this.varDebugInfo && this.lvtRanges.containsKey(this.code.meth, jCTree2)) {
            switch (loopLocalVarRangeEndingPoint) {
                case BEFORE_STEPS: {
                    if (jCTree.hasTag(JCTree.Tag.FORLOOP)) break;
                    this.code.closeAliveRanges(jCTree2);
                    break;
                }
                case AFTER_STEPS: {
                    if (!jCTree.hasTag(JCTree.Tag.FORLOOP)) break;
                    this.code.closeAliveRanges(jCTree2);
                }
            }
        }
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        throw new AssertionError();
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        Env<GenContext> env = this.env.dup(jCLabeledStatement, new GenContext());
        this.genStat(jCLabeledStatement.body, env, 1);
        this.code.resolve(((GenContext)env.info).exit);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        int n = this.code.nextreg;
        Assert.check(!jCSwitch.selector.type.hasTag(TypeTag.CLASS));
        int n2 = this.genCrt ? this.code.curCP() : 0;
        Items.Item item = this.genExpr(jCSwitch.selector, this.syms.intType);
        List<JCTree.JCCase> list = jCSwitch.cases;
        if (list.isEmpty()) {
            item.load().drop();
            if (this.genCrt) {
                this.code.crt.put(TreeInfo.skipParens(jCSwitch.selector), 8, n2, this.code.curCP());
            }
        } else {
            int n3;
            item.load();
            if (this.genCrt) {
                this.code.crt.put(TreeInfo.skipParens(jCSwitch.selector), 8, n2, this.code.curCP());
            }
            Env<GenContext> env = this.env.dup(jCSwitch, new GenContext());
            ((GenContext)env.info).isSwitch = true;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MIN_VALUE;
            int n6 = 0;
            int[] nArray = new int[list.length()];
            int n7 = -1;
            List<JCTree.JCCase> list2 = list;
            for (int i = 0; i < nArray.length; ++i) {
                if (((JCTree.JCCase)list2.head).pat != null) {
                    int n8;
                    nArray[i] = n8 = ((Number)((JCTree.JCCase)list2.head).pat.type.constValue()).intValue();
                    if (n8 < n4) {
                        n4 = n8;
                    }
                    if (n5 < n8) {
                        n5 = n8;
                    }
                    ++n6;
                } else {
                    Assert.check(n7 == -1);
                    n7 = i;
                }
                list2 = list2.tail;
            }
            long l = 4L + ((long)n5 - (long)n4 + 1L);
            long l2 = 3L;
            long l3 = 3L + 2L * (long)n6;
            long l4 = n6;
            int n9 = n6 > 0 && l + 3L * l2 <= l3 + 3L * l4 ? 170 : 171;
            int n10 = this.code.curCP();
            this.code.emitop0(n9);
            this.code.align(4);
            int n11 = this.code.curCP();
            int[] nArray2 = null;
            this.code.emit4(-1);
            if (n9 == 170) {
                this.code.emit4(n4);
                this.code.emit4(n5);
                for (long i = (long)n4; i <= (long)n5; ++i) {
                    this.code.emit4(-1);
                }
            } else {
                this.code.emit4(n6);
                for (int i = 0; i < n6; ++i) {
                    this.code.emit4(-1);
                    this.code.emit4(-1);
                }
                nArray2 = new int[nArray.length];
            }
            Code.State state = this.code.state.dup();
            this.code.markDead();
            list2 = list;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                JCTree.JCCase jCCase = (JCTree.JCCase)list2.head;
                list2 = list2.tail;
                int n12 = this.code.entryPoint(state);
                if (n3 != n7) {
                    if (n9 == 170) {
                        this.code.put4(n11 + 4 * (nArray[n3] - n4 + 3), n12 - n10);
                    } else {
                        nArray2[n3] = n12 - n10;
                    }
                } else {
                    this.code.put4(n11, n12 - n10);
                }
                this.genStats(jCCase.stats, env, 16);
                if (!this.varDebugInfo || !this.lvtRanges.containsKey(this.code.meth, jCCase.stats.last())) continue;
                this.code.closeAliveRanges(jCCase.stats.last());
            }
            this.code.resolve(((GenContext)env.info).exit);
            if (this.code.get4(n11) == -1) {
                this.code.put4(n11, this.code.entryPoint(state) - n10);
            }
            if (n9 == 170) {
                n3 = this.code.get4(n11);
                for (long i = (long)n4; i <= (long)n5; ++i) {
                    int n13 = (int)((long)n11 + 4L * (i - (long)n4 + 3L));
                    if (this.code.get4(n13) != -1) continue;
                    this.code.put4(n13, n3);
                }
            } else {
                if (n7 >= 0) {
                    for (n3 = n7; n3 < nArray.length - 1; ++n3) {
                        nArray[n3] = nArray[n3 + 1];
                        nArray2[n3] = nArray2[n3 + 1];
                    }
                }
                if (n6 > 0) {
                    Gen.qsort2(nArray, nArray2, 0, n6 - 1);
                }
                for (n3 = 0; n3 < n6; ++n3) {
                    int n14 = n11 + 8 * (n3 + 1);
                    this.code.put4(n14, nArray[n3]);
                    this.code.put4(n14 + 4, nArray2[n3]);
                }
            }
        }
        this.code.endScopes(n);
    }

    static void qsort2(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = nArray[(n3 + n4) / 2];
        while (true) {
            if (nArray[n3] < n5) {
                ++n3;
                continue;
            }
            while (n5 < nArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                int n7 = nArray2[n3];
                nArray2[n3] = nArray2[n4];
                nArray2[n4] = n7;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            Gen.qsort2(nArray, nArray2, n, n4);
        }
        if (n3 < n2) {
            Gen.qsort2(nArray, nArray2, n3, n2);
        }
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        int n = this.code.nextreg;
        final Items.LocalItem localItem = this.makeTemp(this.syms.objectType);
        this.genExpr(jCSynchronized.lock, jCSynchronized.lock.type).load().duplicate();
        localItem.store();
        this.code.emitop0(194);
        this.code.state.lock(localItem.reg);
        final Env<GenContext> env = this.env.dup(jCSynchronized, new GenContext());
        ((GenContext)env.info).finalize = new GenFinalizer(){

            @Override
            void gen() {
                this.genLast();
                Assert.check(((GenContext)env.info).gaps.length() % 2 == 0);
                ((GenContext)env.info).gaps.append(Gen.this.code.curCP());
            }

            @Override
            void genLast() {
                if (Gen.this.code.isAlive()) {
                    localItem.load();
                    Gen.this.code.emitop0(195);
                    ((Gen)Gen.this).code.state.unlock(localItem.reg);
                }
            }
        };
        ((GenContext)env.info).gaps = new ListBuffer();
        this.genTry(jCSynchronized.body, List.nil(), env);
        this.code.endScopes(n);
    }

    @Override
    public void visitTry(final JCTree.JCTry jCTry) {
        final Env<GenContext> env = this.env.dup(jCTry, new GenContext());
        final Env<GenContext> env2 = this.env;
        if (!this.useJsrLocally) {
            this.useJsrLocally = this.stackMap == Code.StackMapFormat.NONE && (this.jsrlimit <= 0 || this.jsrlimit < 100 && this.estimateCodeComplexity(jCTry.finalizer) > this.jsrlimit);
        }
        ((GenContext)env.info).finalize = new GenFinalizer(){

            @Override
            void gen() {
                if (Gen.this.useJsrLocally) {
                    if (jCTry.finalizer != null) {
                        Code.State state = ((Gen)Gen.this).code.state.dup();
                        state.push(Code.jsrReturnValue);
                        ((GenContext)env.info).cont = new Code.Chain(Gen.this.code.emitJump(168), ((GenContext)env.info).cont, state);
                    }
                    Assert.check(((GenContext)env.info).gaps.length() % 2 == 0);
                    ((GenContext)env.info).gaps.append(Gen.this.code.curCP());
                } else {
                    Assert.check(((GenContext)env.info).gaps.length() % 2 == 0);
                    ((GenContext)env.info).gaps.append(Gen.this.code.curCP());
                    this.genLast();
                }
            }

            @Override
            void genLast() {
                if (jCTry.finalizer != null) {
                    Gen.this.genStat(jCTry.finalizer, env2, 2);
                }
            }

            @Override
            boolean hasFinalizer() {
                return jCTry.finalizer != null;
            }
        };
        ((GenContext)env.info).gaps = new ListBuffer();
        this.genTry(jCTry.body, jCTry.catchers, env);
    }

    void genTry(JCTree jCTree, List<JCTree.JCCatch> list, Env<GenContext> env) {
        int n = this.code.nextreg;
        int n2 = this.code.curCP();
        Code.State state = this.code.state.dup();
        this.genStat(jCTree, env, 2);
        int n3 = this.code.curCP();
        boolean bl = ((GenContext)env.info).finalize != null && ((GenContext)env.info).finalize.hasFinalizer();
        List<Integer> list2 = ((GenContext)env.info).gaps.toList();
        this.code.statBegin(TreeInfo.endPos(jCTree));
        this.genFinalizer(env);
        this.code.statBegin(TreeInfo.endPos(env.tree));
        Code.Chain chain = this.code.branch(167);
        if (this.varDebugInfo && this.lvtRanges.containsKey(this.code.meth, jCTree)) {
            this.code.closeAliveRanges(jCTree);
        }
        this.endFinalizerGap(env);
        if (n2 != n3) {
            List<JCTree.JCCatch> list3 = list;
            while (list3.nonEmpty()) {
                this.code.entryPoint(state, ((JCTree.JCCatch)list3.head).param.sym.type);
                this.genCatch((JCTree.JCCatch)list3.head, env, n2, n3, list2);
                this.genFinalizer(env);
                if (bl || list3.tail.nonEmpty()) {
                    this.code.statBegin(TreeInfo.endPos(env.tree));
                    chain = Code.mergeChains(chain, this.code.branch(167));
                }
                this.endFinalizerGap(env);
                list3 = list3.tail;
            }
        }
        if (bl) {
            this.code.newRegSegment();
            int n4 = this.code.entryPoint(state, this.syms.throwableType);
            int n5 = n2;
            while (((GenContext)env.info).gaps.nonEmpty()) {
                int n6 = ((GenContext)env.info).gaps.next();
                this.registerCatch(jCTree.pos(), n5, n6, n4, 0);
                n5 = ((GenContext)env.info).gaps.next();
            }
            this.code.statBegin(TreeInfo.finalizerPos(env.tree));
            this.code.markStatBegin();
            Items.LocalItem localItem = this.makeTemp(this.syms.throwableType);
            ((Items.Item)localItem).store();
            this.genFinalizer(env);
            ((Items.Item)localItem).load();
            this.registerCatch(jCTree.pos(), n5, ((GenContext)env.info).gaps.next(), n4, 0);
            this.code.emitop0(191);
            this.code.markDead();
            if (((GenContext)env.info).cont != null) {
                this.code.resolve(((GenContext)env.info).cont);
                this.code.statBegin(TreeInfo.finalizerPos(env.tree));
                this.code.markStatBegin();
                Items.LocalItem localItem2 = this.makeTemp(this.syms.throwableType);
                localItem2.store();
                ((GenContext)env.info).finalize.genLast();
                this.code.emitop1w(169, localItem2.reg);
                this.code.markDead();
            }
        }
        this.code.resolve(chain);
        this.code.endScopes(n);
    }

    void genCatch(JCTree.JCCatch jCCatch, Env<GenContext> env, int n, int n2, List<Integer> list) {
        if (n != n2) {
            int n3;
            List<JCTree.JCExpression> list2;
            List<JCTree.JCExpression> list3 = list2 = TreeInfo.isMultiCatch(jCCatch) ? ((JCTree.JCTypeUnion)jCCatch.param.vartype).alternatives : List.of(jCCatch.param.vartype);
            while (list.nonEmpty()) {
                for (JCTree.JCExpression jCExpression : list2) {
                    n3 = this.makeRef(jCCatch.pos(), jCExpression.type);
                    int n4 = (Integer)list.head;
                    this.registerCatch(jCCatch.pos(), n, n4, this.code.curCP(), n3);
                    if (!jCExpression.type.isAnnotated()) continue;
                    for (Attribute.TypeCompound typeCompound : jCExpression.type.getAnnotationMirrors()) {
                        typeCompound.position.type_index = n3;
                    }
                }
                list = list.tail;
                n = (Integer)list.head;
                list = list.tail;
            }
            if (n < n2) {
                for (JCTree.JCExpression jCExpression : list2) {
                    n3 = this.makeRef(jCCatch.pos(), jCExpression.type);
                    this.registerCatch(jCCatch.pos(), n, n2, this.code.curCP(), n3);
                    if (!jCExpression.type.isAnnotated()) continue;
                    for (Object object : jCExpression.type.getAnnotationMirrors()) {
                        ((Attribute.TypeCompound)object).position.type_index = n3;
                    }
                }
            }
            Symbol.VarSymbol varSymbol = jCCatch.param.sym;
            this.code.statBegin(jCCatch.pos);
            this.code.markStatBegin();
            int n5 = this.code.nextreg;
            n3 = this.code.newLocal(varSymbol);
            this.items.makeLocalItem(varSymbol).store();
            this.code.statBegin(TreeInfo.firstStatPos(jCCatch.body));
            this.genStat(jCCatch.body, env, 2);
            this.code.endScopes(n5);
            this.code.statBegin(TreeInfo.endPos(jCCatch.body));
        }
    }

    void registerCatch(JCDiagnostic.DiagnosticPosition diagnosticPosition, int n, int n2, int n3, int n4) {
        char c = (char)n;
        char c2 = (char)n2;
        char c3 = (char)n3;
        if (c == n && c2 == n2 && c3 == n3) {
            this.code.addCatch(c, c2, c3, (char)n4);
        } else {
            if (!this.useJsrLocally && !this.target.generateStackMapTable()) {
                this.useJsrLocally = true;
                throw new CodeSizeOverflow();
            }
            this.log.error(diagnosticPosition, "limit.code.too.large.for.try.stmt", new Object[0]);
            ++this.nerrs;
        }
    }

    int estimateCodeComplexity(JCTree jCTree) {
        if (jCTree == null) {
            return 0;
        }
        class ComplexityScanner
        extends TreeScanner {
            int complexity = 0;

            ComplexityScanner() {
            }

            @Override
            public void scan(JCTree jCTree) {
                if (this.complexity > Gen.this.jsrlimit) {
                    return;
                }
                super.scan(jCTree);
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            }

            @Override
            public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
                super.visitDoLoop(jCDoWhileLoop);
                ++this.complexity;
            }

            @Override
            public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
                super.visitWhileLoop(jCWhileLoop);
                ++this.complexity;
            }

            @Override
            public void visitForLoop(JCTree.JCForLoop jCForLoop) {
                super.visitForLoop(jCForLoop);
                ++this.complexity;
            }

            @Override
            public void visitSwitch(JCTree.JCSwitch jCSwitch) {
                super.visitSwitch(jCSwitch);
                this.complexity += 5;
            }

            @Override
            public void visitCase(JCTree.JCCase jCCase) {
                super.visitCase(jCCase);
                ++this.complexity;
            }

            @Override
            public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
                super.visitSynchronized(jCSynchronized);
                this.complexity += 6;
            }

            @Override
            public void visitTry(JCTree.JCTry jCTry) {
                super.visitTry(jCTry);
                if (jCTry.finalizer != null) {
                    this.complexity += 6;
                }
            }

            @Override
            public void visitCatch(JCTree.JCCatch jCCatch) {
                super.visitCatch(jCCatch);
                this.complexity += 2;
            }

            @Override
            public void visitConditional(JCTree.JCConditional jCConditional) {
                super.visitConditional(jCConditional);
                this.complexity += 2;
            }

            @Override
            public void visitIf(JCTree.JCIf jCIf) {
                super.visitIf(jCIf);
                this.complexity += 2;
            }

            @Override
            public void visitBreak(JCTree.JCBreak jCBreak) {
                super.visitBreak(jCBreak);
                ++this.complexity;
            }

            @Override
            public void visitContinue(JCTree.JCContinue jCContinue) {
                super.visitContinue(jCContinue);
                ++this.complexity;
            }

            @Override
            public void visitReturn(JCTree.JCReturn jCReturn) {
                super.visitReturn(jCReturn);
                ++this.complexity;
            }

            @Override
            public void visitThrow(JCTree.JCThrow jCThrow) {
                super.visitThrow(jCThrow);
                ++this.complexity;
            }

            @Override
            public void visitAssert(JCTree.JCAssert jCAssert) {
                super.visitAssert(jCAssert);
                this.complexity += 5;
            }

            @Override
            public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
                super.visitApply(jCMethodInvocation);
                this.complexity += 2;
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass jCNewClass) {
                this.scan(jCNewClass.encl);
                this.scan(jCNewClass.args);
                this.complexity += 2;
            }

            @Override
            public void visitNewArray(JCTree.JCNewArray jCNewArray) {
                super.visitNewArray(jCNewArray);
                this.complexity += 5;
            }

            @Override
            public void visitAssign(JCTree.JCAssign jCAssign) {
                super.visitAssign(jCAssign);
                ++this.complexity;
            }

            @Override
            public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
                super.visitAssignop(jCAssignOp);
                this.complexity += 2;
            }

            @Override
            public void visitUnary(JCTree.JCUnary jCUnary) {
                ++this.complexity;
                if (jCUnary.type.constValue() == null) {
                    super.visitUnary(jCUnary);
                }
            }

            @Override
            public void visitBinary(JCTree.JCBinary jCBinary) {
                ++this.complexity;
                if (jCBinary.type.constValue() == null) {
                    super.visitBinary(jCBinary);
                }
            }

            @Override
            public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
                super.visitTypeTest(jCInstanceOf);
                ++this.complexity;
            }

            @Override
            public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
                super.visitIndexed(jCArrayAccess);
                ++this.complexity;
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
                super.visitSelect(jCFieldAccess);
                if (jCFieldAccess.sym.kind == 4) {
                    ++this.complexity;
                }
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                if (jCIdent.sym.kind == 4) {
                    ++this.complexity;
                    if (jCIdent.type.constValue() == null && jCIdent.sym.owner.kind == 2) {
                        ++this.complexity;
                    }
                }
            }

            @Override
            public void visitLiteral(JCTree.JCLiteral jCLiteral) {
                ++this.complexity;
            }

            @Override
            public void visitTree(JCTree jCTree) {
            }

            @Override
            public void visitWildcard(JCTree.JCWildcard jCWildcard) {
                throw new AssertionError((Object)this.getClass().getName());
            }
        }
        ComplexityScanner complexityScanner = new ComplexityScanner();
        jCTree.accept(complexityScanner);
        return complexityScanner.complexity;
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        int n = this.code.nextreg;
        Code.Chain chain = null;
        Items.CondItem condItem = this.genCond((JCTree)TreeInfo.skipParens(jCIf.cond), 8);
        Code.Chain chain2 = condItem.jumpFalse();
        if (!condItem.isFalse()) {
            this.code.resolve(condItem.trueJumps);
            this.genStat(jCIf.thenpart, this.env, 17);
            chain = this.code.branch(167);
            if (this.varDebugInfo && this.lvtRanges.containsKey(this.code.meth, jCIf.thenpart)) {
                this.code.closeAliveRanges(jCIf.thenpart, chain != null && jCIf.elsepart == null ? chain.pc : this.code.cp);
            }
        }
        if (chain2 != null) {
            this.code.resolve(chain2);
            if (jCIf.elsepart != null) {
                this.genStat(jCIf.elsepart, this.env, 17);
                if (this.varDebugInfo && this.lvtRanges.containsKey(this.code.meth, jCIf.elsepart)) {
                    this.code.closeAliveRanges(jCIf.elsepart);
                }
            }
        }
        this.code.resolve(chain);
        this.code.endScopes(n);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        JCTree.JCExpression jCExpression = jCExpressionStatement.expr;
        switch (jCExpression.getTag()) {
            case POSTINC: {
                ((JCTree.JCUnary)jCExpression).setTag(JCTree.Tag.PREINC);
                break;
            }
            case POSTDEC: {
                ((JCTree.JCUnary)jCExpression).setTag(JCTree.Tag.PREDEC);
            }
        }
        this.genExpr(jCExpressionStatement.expr, jCExpressionStatement.expr.type).drop();
    }

    @Override
    public void visitBreak(JCTree.JCBreak jCBreak) {
        Env<GenContext> env = this.unwind(jCBreak.target, this.env);
        Assert.check(this.code.state.stacksize == 0);
        ((GenContext)env.info).addExit(this.code.branch(167));
        this.endFinalizerGaps(this.env, env);
    }

    @Override
    public void visitContinue(JCTree.JCContinue jCContinue) {
        Env<GenContext> env = this.unwind(jCContinue.target, this.env);
        Assert.check(this.code.state.stacksize == 0);
        ((GenContext)env.info).addCont(this.code.branch(167));
        this.endFinalizerGaps(this.env, env);
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        Env<GenContext> env;
        int n = this.code.nextreg;
        if (jCReturn.expr != null) {
            Items.Item item = this.genExpr(jCReturn.expr, this.pt).load();
            if (this.hasFinally(this.env.enclMethod, this.env)) {
                item = this.makeTemp(this.pt);
                item.store();
            }
            env = this.unwind(this.env.enclMethod, this.env);
            item.load();
            this.code.emitop0(172 + Code.truncate(Code.typecode(this.pt)));
        } else {
            int n2 = this.code.pendingStatPos;
            env = this.unwind(this.env.enclMethod, this.env);
            this.code.pendingStatPos = n2;
            this.code.emitop0(177);
        }
        this.endFinalizerGaps(this.env, env);
        this.code.endScopes(n);
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        this.genExpr(jCThrow.expr, jCThrow.expr.type).load();
        this.code.emitop0(191);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        this.setTypeAnnotationPositions(jCMethodInvocation.pos);
        Items.Item item = this.genExpr(jCMethodInvocation.meth, this.methodType);
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)TreeInfo.symbol(jCMethodInvocation.meth);
        this.genArgs(jCMethodInvocation.args, methodSymbol.externalType(this.types).getParameterTypes());
        if (!methodSymbol.isDynamic()) {
            this.code.statBegin(jCMethodInvocation.pos);
        }
        this.result = item.invoke();
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        int n;
        Code.Chain chain = null;
        Items.CondItem condItem = this.genCond((JCTree)jCConditional.cond, 8);
        Code.Chain chain2 = condItem.jumpFalse();
        if (!condItem.isFalse()) {
            this.code.resolve(condItem.trueJumps);
            n = this.genCrt ? this.code.curCP() : 0;
            this.genExpr(jCConditional.truepart, this.pt).load();
            this.code.state.forceStackTop(jCConditional.type);
            if (this.genCrt) {
                this.code.crt.put(jCConditional.truepart, 16, n, this.code.curCP());
            }
            chain = this.code.branch(167);
        }
        if (chain2 != null) {
            this.code.resolve(chain2);
            n = this.genCrt ? this.code.curCP() : 0;
            this.genExpr(jCConditional.falsepart, this.pt).load();
            this.code.state.forceStackTop(jCConditional.type);
            if (this.genCrt) {
                this.code.crt.put(jCConditional.falsepart, 16, n, this.code.curCP());
            }
        }
        this.code.resolve(chain);
        this.result = this.items.makeStackItem(this.pt);
    }

    private void setTypeAnnotationPositions(int n) {
        Symbol.MethodSymbol methodSymbol = this.code.meth;
        boolean bl = this.code.meth.getKind() == ElementKind.CONSTRUCTOR || this.code.meth.getKind() == ElementKind.STATIC_INIT;
        for (Attribute.TypeCompound object : methodSymbol.getRawTypeAttributes()) {
            if (object.hasUnknownPosition()) {
                object.tryFixPosition();
            }
            if (!object.position.matchesPos(n)) continue;
            object.position.updatePosOffset(this.code.cp);
        }
        if (!bl) {
            return;
        }
        for (Attribute.TypeCompound typeCompound : methodSymbol.owner.getRawTypeAttributes()) {
            if (typeCompound.hasUnknownPosition()) {
                typeCompound.tryFixPosition();
            }
            if (!typeCompound.position.matchesPos(n)) continue;
            typeCompound.position.updatePosOffset(this.code.cp);
        }
        Symbol.ClassSymbol classSymbol = methodSymbol.enclClass();
        for (Symbol symbol : new FilteredMemberList(classSymbol.members())) {
            if (!symbol.getKind().isField()) continue;
            for (Attribute.TypeCompound typeCompound : symbol.getRawTypeAttributes()) {
                if (typeCompound.hasUnknownPosition()) {
                    typeCompound.tryFixPosition();
                }
                if (!typeCompound.position.matchesPos(n)) continue;
                typeCompound.position.updatePosOffset(this.code.cp);
            }
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        Assert.check(jCNewClass.encl == null && jCNewClass.def == null);
        this.setTypeAnnotationPositions(jCNewClass.pos);
        this.code.emitop2(187, this.makeRef(jCNewClass.pos(), jCNewClass.type));
        this.code.emitop0(89);
        this.genArgs(jCNewClass.args, jCNewClass.constructor.externalType(this.types).getParameterTypes());
        this.items.makeMemberItem(jCNewClass.constructor, true).invoke();
        this.result = this.items.makeStackItem(jCNewClass.type);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        this.setTypeAnnotationPositions(jCNewArray.pos);
        if (jCNewArray.elems != null) {
            Type type = this.types.elemtype(jCNewArray.type);
            this.loadIntConst(jCNewArray.elems.length());
            Items.Item item = this.makeNewArray(jCNewArray.pos(), jCNewArray.type, 1);
            int n = 0;
            List<JCTree.JCExpression> list = jCNewArray.elems;
            while (list.nonEmpty()) {
                item.duplicate();
                this.loadIntConst(n);
                ++n;
                this.genExpr((JCTree)list.head, type).load();
                this.items.makeIndexedItem(type).store();
                list = list.tail;
            }
            this.result = item;
        } else {
            List<JCTree.JCExpression> list = jCNewArray.dims;
            while (list.nonEmpty()) {
                this.genExpr((JCTree)list.head, this.syms.intType).load();
                list = list.tail;
            }
            this.result = this.makeNewArray(jCNewArray.pos(), jCNewArray.type, jCNewArray.dims.length());
        }
    }

    Items.Item makeNewArray(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, int n) {
        int n2;
        Type type2 = this.types.elemtype(type);
        if (this.types.dimensions(type) > 255) {
            this.log.error(diagnosticPosition, "limit.dimensions", new Object[0]);
            ++this.nerrs;
        }
        if ((n2 = Code.arraycode(type2)) == 0 || n2 == 1 && n == 1) {
            this.code.emitAnewarray(this.makeRef(diagnosticPosition, type2), type);
        } else if (n2 == 1) {
            this.code.emitMultianewarray(n, this.makeRef(diagnosticPosition, type), type);
        } else {
            this.code.emitNewarray(n2, type);
        }
        return this.items.makeStackItem(type);
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        this.result = this.genExpr(jCParens.expr, jCParens.expr.type);
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        Items.Item item = this.genExpr(jCAssign.lhs, jCAssign.lhs.type);
        this.genExpr(jCAssign.rhs, jCAssign.lhs.type).load();
        this.result = this.items.makeAssignItem(item);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        Items.Item item;
        Symbol.OperatorSymbol operatorSymbol = (Symbol.OperatorSymbol)jCAssignOp.operator;
        if (operatorSymbol.opcode == 256) {
            this.makeStringBuffer(jCAssignOp.pos());
            item = this.genExpr(jCAssignOp.lhs, jCAssignOp.lhs.type);
            if (item.width() > 0) {
                this.code.emitop0(90 + 3 * (item.width() - 1));
            }
            item.load();
            this.appendString(jCAssignOp.lhs);
            this.appendStrings(jCAssignOp.rhs);
            this.bufferToString(jCAssignOp.pos());
        } else {
            item = this.genExpr(jCAssignOp.lhs, jCAssignOp.lhs.type);
            if ((jCAssignOp.hasTag(JCTree.Tag.PLUS_ASG) || jCAssignOp.hasTag(JCTree.Tag.MINUS_ASG)) && item instanceof Items.LocalItem && jCAssignOp.lhs.type.getTag().isSubRangeOf(TypeTag.INT) && jCAssignOp.rhs.type.getTag().isSubRangeOf(TypeTag.INT) && jCAssignOp.rhs.type.constValue() != null) {
                int n = ((Number)jCAssignOp.rhs.type.constValue()).intValue();
                if (jCAssignOp.hasTag(JCTree.Tag.MINUS_ASG)) {
                    n = -n;
                }
                ((Items.LocalItem)item).incr(n);
                this.result = item;
                return;
            }
            item.duplicate();
            item.coerce((Type)operatorSymbol.type.getParameterTypes().head).load();
            this.completeBinop(jCAssignOp.lhs, jCAssignOp.rhs, operatorSymbol).coerce(jCAssignOp.lhs.type);
        }
        this.result = this.items.makeAssignItem(item);
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        Symbol.OperatorSymbol operatorSymbol = (Symbol.OperatorSymbol)jCUnary.operator;
        if (jCUnary.hasTag(JCTree.Tag.NOT)) {
            Items.CondItem condItem = this.genCond((JCTree)jCUnary.arg, false);
            this.result = condItem.negate();
        } else {
            Items.Item item = this.genExpr(jCUnary.arg, (Type)operatorSymbol.type.getParameterTypes().head);
            switch (jCUnary.getTag()) {
                case POS: {
                    this.result = item.load();
                    break;
                }
                case NEG: {
                    this.result = item.load();
                    this.code.emitop0(operatorSymbol.opcode);
                    break;
                }
                case COMPL: {
                    this.result = item.load();
                    this.emitMinusOne(item.typecode);
                    this.code.emitop0(operatorSymbol.opcode);
                    break;
                }
                case PREINC: 
                case PREDEC: {
                    item.duplicate();
                    if (item instanceof Items.LocalItem && (operatorSymbol.opcode == 96 || operatorSymbol.opcode == 100)) {
                        ((Items.LocalItem)item).incr(jCUnary.hasTag(JCTree.Tag.PREINC) ? 1 : -1);
                        this.result = item;
                        break;
                    }
                    item.load();
                    this.code.emitop0(Gen.one(item.typecode));
                    this.code.emitop0(operatorSymbol.opcode);
                    if (item.typecode != 0 && Code.truncate(item.typecode) == 0) {
                        this.code.emitop0(145 + item.typecode - 5);
                    }
                    this.result = this.items.makeAssignItem(item);
                    break;
                }
                case POSTINC: 
                case POSTDEC: {
                    item.duplicate();
                    if (item instanceof Items.LocalItem && (operatorSymbol.opcode == 96 || operatorSymbol.opcode == 100)) {
                        Items.Item item2 = item.load();
                        ((Items.LocalItem)item).incr(jCUnary.hasTag(JCTree.Tag.POSTINC) ? 1 : -1);
                        this.result = item2;
                        break;
                    }
                    Items.Item item3 = item.load();
                    item.stash(item.typecode);
                    this.code.emitop0(Gen.one(item.typecode));
                    this.code.emitop0(operatorSymbol.opcode);
                    if (item.typecode != 0 && Code.truncate(item.typecode) == 0) {
                        this.code.emitop0(145 + item.typecode - 5);
                    }
                    item.store();
                    this.result = item3;
                    break;
                }
                case NULLCHK: {
                    this.result = item.load();
                    this.code.emitop0(89);
                    this.genNullCheck(jCUnary.pos());
                    break;
                }
                default: {
                    Assert.error();
                }
            }
        }
    }

    private void genNullCheck(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        this.callMethod(diagnosticPosition, this.syms.objectType, this.names.getClass, List.nil(), false);
        this.code.emitop0(87);
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        Symbol.OperatorSymbol operatorSymbol = (Symbol.OperatorSymbol)jCBinary.operator;
        if (operatorSymbol.opcode == 256) {
            this.makeStringBuffer(jCBinary.pos());
            this.appendStrings(jCBinary);
            this.bufferToString(jCBinary.pos());
            this.result = this.items.makeStackItem(this.syms.stringType);
        } else if (jCBinary.hasTag(JCTree.Tag.AND)) {
            Items.CondItem condItem = this.genCond((JCTree)jCBinary.lhs, 8);
            if (!condItem.isFalse()) {
                Code.Chain chain = condItem.jumpFalse();
                this.code.resolve(condItem.trueJumps);
                Items.CondItem condItem2 = this.genCond((JCTree)jCBinary.rhs, 16);
                this.result = this.items.makeCondItem(condItem2.opcode, condItem2.trueJumps, Code.mergeChains(chain, condItem2.falseJumps));
            } else {
                this.result = condItem;
            }
        } else if (jCBinary.hasTag(JCTree.Tag.OR)) {
            Items.CondItem condItem = this.genCond((JCTree)jCBinary.lhs, 8);
            if (!condItem.isTrue()) {
                Code.Chain chain = condItem.jumpTrue();
                this.code.resolve(condItem.falseJumps);
                Items.CondItem condItem3 = this.genCond((JCTree)jCBinary.rhs, 16);
                this.result = this.items.makeCondItem(condItem3.opcode, Code.mergeChains(chain, condItem3.trueJumps), condItem3.falseJumps);
            } else {
                this.result = condItem;
            }
        } else {
            Items.Item item = this.genExpr(jCBinary.lhs, (Type)operatorSymbol.type.getParameterTypes().head);
            item.load();
            this.result = this.completeBinop(jCBinary.lhs, jCBinary.rhs, operatorSymbol);
        }
    }

    void makeStringBuffer(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        this.code.emitop2(187, this.makeRef(diagnosticPosition, this.stringBufferType));
        this.code.emitop0(89);
        this.callMethod(diagnosticPosition, this.stringBufferType, this.names.init, List.nil(), false);
    }

    void appendString(JCTree jCTree) {
        Type type = jCTree.type.baseType();
        if (!type.isPrimitive() && type.tsym != this.syms.stringType.tsym) {
            type = this.syms.objectType;
        }
        this.items.makeMemberItem(this.getStringBufferAppend(jCTree, type), false).invoke();
    }

    Symbol getStringBufferAppend(JCTree jCTree, Type type) {
        Assert.checkNull(type.constValue());
        Symbol symbol = this.stringBufferAppend.get(type);
        if (symbol == null) {
            symbol = this.rs.resolveInternalMethod(jCTree.pos(), this.attrEnv, this.stringBufferType, this.names.append, List.of(type), null);
            this.stringBufferAppend.put(type, symbol);
        }
        return symbol;
    }

    void appendStrings(JCTree jCTree) {
        if ((jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.PLUS) && jCTree.type.constValue() == null) {
            JCTree.JCBinary jCBinary = (JCTree.JCBinary)jCTree;
            if (jCBinary.operator.kind == 16 && ((Symbol.OperatorSymbol)jCBinary.operator).opcode == 256) {
                this.appendStrings(jCBinary.lhs);
                this.appendStrings(jCBinary.rhs);
                return;
            }
        }
        this.genExpr(jCTree, jCTree.type).load();
        this.appendString(jCTree);
    }

    void bufferToString(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        this.callMethod(diagnosticPosition, this.stringBufferType, this.names.toString, List.nil(), false);
    }

    Items.Item completeBinop(JCTree jCTree, JCTree jCTree2, Symbol.OperatorSymbol operatorSymbol) {
        Type.MethodType methodType = (Type.MethodType)operatorSymbol.type;
        int n = operatorSymbol.opcode;
        if (n >= 159 && n <= 164 && jCTree2.type.constValue() instanceof Number && ((Number)jCTree2.type.constValue()).intValue() == 0) {
            n += -6;
        } else if (n >= 165 && n <= 166 && TreeInfo.isNull(jCTree2)) {
            n += 33;
        } else {
            Type type = (Type)operatorSymbol.erasure((Types)this.types).getParameterTypes().tail.head;
            if (n >= 270 && n <= 275) {
                n += -150;
                type = this.syms.intType;
            }
            this.genExpr(jCTree2, type).load();
            if (n >= 512) {
                this.code.emitop0(n >> 9);
                n &= 0xFF;
            }
        }
        if (n >= 153 && n <= 166 || n == 198 || n == 199) {
            return this.items.makeCondItem(n);
        }
        this.code.emitop0(n);
        return this.items.makeStackItem(methodType.restype);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        this.setTypeAnnotationPositions(jCTypeCast.pos);
        this.result = this.genExpr(jCTypeCast.expr, jCTypeCast.clazz.type).load();
        if (!jCTypeCast.clazz.type.isPrimitive() && this.types.asSuper(jCTypeCast.expr.type, jCTypeCast.clazz.type.tsym) == null) {
            this.code.emitop2(192, this.makeRef(jCTypeCast.pos(), jCTypeCast.clazz.type));
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        throw new AssertionError((Object)this.getClass().getName());
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        this.setTypeAnnotationPositions(jCInstanceOf.pos);
        this.genExpr(jCInstanceOf.expr, jCInstanceOf.expr.type).load();
        this.code.emitop2(193, this.makeRef(jCInstanceOf.pos(), jCInstanceOf.clazz.type));
        this.result = this.items.makeStackItem(this.syms.booleanType);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        this.genExpr(jCArrayAccess.indexed, jCArrayAccess.indexed.type).load();
        this.genExpr(jCArrayAccess.index, this.syms.intType).load();
        this.result = this.items.makeIndexedItem(jCArrayAccess.type);
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        Symbol symbol = jCIdent.sym;
        if (jCIdent.name == this.names._this || jCIdent.name == this.names._super) {
            Items.Item item;
            Items.Item item2 = item = jCIdent.name == this.names._this ? this.items.makeThisItem() : this.items.makeSuperItem();
            if (symbol.kind == 16) {
                item.load();
                item = this.items.makeMemberItem(symbol, true);
            }
            this.result = item;
        } else if (symbol.kind == 4 && symbol.owner.kind == 16) {
            this.result = this.items.makeLocalItem((Symbol.VarSymbol)symbol);
        } else if (this.isInvokeDynamic(symbol)) {
            this.result = this.items.makeDynamicItem(symbol);
        } else if ((symbol.flags() & 8L) != 0L) {
            if (!this.isAccessSuper(this.env.enclMethod)) {
                symbol = this.binaryQualifier(symbol, this.env.enclClass.type);
            }
            this.result = this.items.makeStaticItem(symbol);
        } else {
            this.items.makeThisItem().load();
            symbol = this.binaryQualifier(symbol, this.env.enclClass.type);
            this.result = this.items.makeMemberItem(symbol, (symbol.flags() & 2L) != 0L);
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        Items.Item item;
        Symbol symbol = jCFieldAccess.sym;
        if (jCFieldAccess.name == this.names._class) {
            Assert.check(this.target.hasClassLiterals());
            this.code.emitLdc(this.makeRef(jCFieldAccess.pos(), jCFieldAccess.selected.type));
            this.result = this.items.makeStackItem(this.pt);
            return;
        }
        Symbol symbol2 = TreeInfo.symbol(jCFieldAccess.selected);
        boolean bl = symbol2 != null && (symbol2.kind == 2 || symbol2.name == this.names._super);
        boolean bl2 = this.isAccessSuper(this.env.enclMethod);
        Items.Item item2 = item = bl ? this.items.makeSuperItem() : this.genExpr(jCFieldAccess.selected, jCFieldAccess.selected.type);
        if (symbol.kind == 4 && ((Symbol.VarSymbol)symbol).getConstValue() != null) {
            if ((symbol.flags() & 8L) != 0L) {
                if (!(bl || symbol2 != null && symbol2.kind == 2)) {
                    item = item.load();
                }
                item.drop();
            } else {
                item.load();
                this.genNullCheck(jCFieldAccess.selected.pos());
            }
            this.result = this.items.makeImmediateItem(symbol.type, ((Symbol.VarSymbol)symbol).getConstValue());
        } else {
            if (this.isInvokeDynamic(symbol)) {
                this.result = this.items.makeDynamicItem(symbol);
                return;
            }
            if (((symbol = this.binaryQualifier(symbol, jCFieldAccess.selected.type)).flags() & 8L) != 0L) {
                if (!(bl || symbol2 != null && symbol2.kind == 2)) {
                    item = item.load();
                }
                item.drop();
                this.result = this.items.makeStaticItem(symbol);
            } else {
                item.load();
                if (symbol == this.syms.lengthVar) {
                    this.code.emitop0(190);
                    this.result = this.items.makeStackItem(this.syms.intType);
                } else {
                    this.result = this.items.makeMemberItem(symbol, (symbol.flags() & 2L) != 0L || bl || bl2);
                }
            }
        }
    }

    public boolean isInvokeDynamic(Symbol symbol) {
        return symbol.kind == 16 && ((Symbol.MethodSymbol)symbol).isDynamic();
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        if (jCLiteral.type.hasTag(TypeTag.BOT)) {
            this.code.emitop0(1);
            if (this.types.dimensions(this.pt) > 1) {
                this.code.emitop2(192, this.makeRef(jCLiteral.pos(), this.pt));
                this.result = this.items.makeStackItem(this.pt);
            } else {
                this.result = this.items.makeStackItem(jCLiteral.type);
            }
        } else {
            this.result = this.items.makeImmediateItem(jCLiteral.type, jCLiteral.value);
        }
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        int n = this.code.nextreg;
        this.genStats(letExpr.defs, this.env);
        this.result = this.genExpr(letExpr.expr, letExpr.expr.type).load();
        this.code.endScopes(n);
    }

    private void generateReferencesToPrunedTree(Symbol.ClassSymbol classSymbol, Pool pool) {
        List<JCTree> list = this.lower.prunedTree.get(classSymbol);
        if (list != null) {
            for (JCTree jCTree : list) {
                jCTree.accept(this.classReferenceVisitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean genClass(Env<AttrContext> env, JCTree.JCClassDecl jCClassDecl) {
        try {
            List<JCTree> list;
            this.attrEnv = env;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            this.toplevel = env.toplevel;
            this.endPosTable = this.toplevel.endPositions;
            if (this.generateIproxies && (classSymbol.flags() & 0x600L) == 1024L && !this.allowGenerics) {
                this.implementInterfaceMethods(classSymbol);
            }
            jCClassDecl.defs = this.normalizeDefs(jCClassDecl.defs, classSymbol);
            classSymbol.pool = this.pool;
            this.pool.reset();
            this.generateReferencesToPrunedTree(classSymbol, this.pool);
            Env<GenContext> env2 = new Env<GenContext>(jCClassDecl, new GenContext());
            env2.toplevel = env.toplevel;
            env2.enclClass = jCClassDecl;
            if (this.varDebugInfo && (jCClassDecl.sym.flags() & 0x1000L) == 0L) {
                list = LVTAssignAnalyzer.make(this.lvtRanges, this.syms, this.names);
                ((Flow.AbstractAssignAnalyzer)((Object)list)).analyzeTree(env2);
            }
            list = jCClassDecl.defs;
            while (list.nonEmpty()) {
                this.genDef((JCTree)list.head, env2);
                list = list.tail;
            }
            if (this.pool.numEntries() > 65535) {
                this.log.error(jCClassDecl.pos(), "limit.pool", new Object[0]);
                ++this.nerrs;
            }
            if (this.nerrs != 0) {
                list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF)) {
                        ((JCTree.JCMethodDecl)list.head).sym.code = null;
                    }
                    list = list.tail;
                }
            }
            jCClassDecl.defs = List.nil();
            boolean bl = this.nerrs == 0;
            return bl;
        }
        finally {
            this.attrEnv = null;
            this.env = null;
            this.toplevel = null;
            this.endPosTable = null;
            this.nerrs = 0;
        }
    }

    static class LVTAssignAnalyzer
    extends Flow.AbstractAssignAnalyzer<LVTAssignPendingExit> {
        final LVTBits lvtInits;
        final LVTRanges lvtRanges;
        Symbol.MethodSymbol currentMethod;

        private LVTAssignAnalyzer(LVTRanges lVTRanges, Symtab symtab, Names names) {
            super(new LVTBits(), symtab, names);
            this.lvtInits = (LVTBits)this.inits;
            this.lvtRanges = lVTRanges;
        }

        public static LVTAssignAnalyzer make(LVTRanges lVTRanges, Symtab symtab, Names names) {
            LVTAssignAnalyzer lVTAssignAnalyzer;
            lVTAssignAnalyzer.lvtInits.analyzer = lVTAssignAnalyzer = new LVTAssignAnalyzer(lVTRanges, symtab, names);
            return lVTAssignAnalyzer;
        }

        @Override
        protected void markDead(JCTree jCTree) {
            this.lvtInits.at(jCTree).inclRange(this.returnadr, this.nextadr);
            super.markDead(jCTree);
        }

        @Override
        protected void merge(JCTree jCTree) {
            this.lvtInits.at(jCTree);
            super.merge(jCTree);
        }

        boolean isSyntheticOrMandated(Symbol symbol) {
            return (symbol.flags() & 0x9000L) != 0L;
        }

        @Override
        protected boolean trackable(Symbol.VarSymbol varSymbol) {
            if (this.isSyntheticOrMandated(varSymbol)) {
                return false;
            }
            return super.trackable(varSymbol);
        }

        @Override
        protected void initParam(JCTree.JCVariableDecl jCVariableDecl) {
            if (!this.isSyntheticOrMandated(jCVariableDecl.sym)) {
                super.initParam(jCVariableDecl);
            }
        }

        @Override
        protected void assignToInits(JCTree jCTree, Bits bits) {
            this.lvtInits.at(jCTree);
            this.lvtInits.assign(bits);
        }

        @Override
        protected void andSetInits(JCTree jCTree, Bits bits) {
            this.lvtInits.at(jCTree);
            this.lvtInits.andSet(bits);
        }

        @Override
        protected void orSetInits(JCTree jCTree, Bits bits) {
            this.lvtInits.at(jCTree);
            this.lvtInits.orSet(bits);
        }

        @Override
        protected void exclVarFromInits(JCTree jCTree, int n) {
            this.lvtInits.at(jCTree);
            this.lvtInits.excl(n);
        }

        @Override
        protected LVTAssignPendingExit createNewPendingExit(JCTree jCTree, Bits bits, Bits bits2) {
            return new LVTAssignPendingExit(jCTree, bits, bits2);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            boolean bl;
            if ((jCMethodDecl.sym.flags() & 0x1000001000L) != 0L && (jCMethodDecl.sym.flags() & 0x2000000000000L) == 0L) {
                return;
            }
            if (jCMethodDecl.name.equals(this.names.clinit)) {
                return;
            }
            boolean bl2 = bl = (jCMethodDecl.sym.owner.flags() & 0x4000L) != 0L;
            if (bl && (jCMethodDecl.name.equals(this.names.valueOf) || jCMethodDecl.name.equals(this.names.values) || jCMethodDecl.name.equals(this.names.init))) {
                return;
            }
            this.currentMethod = jCMethodDecl.sym;
            super.visitMethodDef(jCMethodDecl);
        }

        public class LVTAssignPendingExit
        extends Flow.AssignAnalyzer.AssignPendingExit {
            LVTAssignPendingExit(JCTree jCTree, Bits bits, Bits bits2) {
                super(jCTree, bits, bits2);
            }

            @Override
            public void resolveJump(JCTree jCTree) {
                LVTAssignAnalyzer.this.lvtInits.at(jCTree);
                super.resolveJump(jCTree);
            }
        }

        static class LVTBits
        extends Bits {
            JCTree currentTree;
            LVTAssignAnalyzer analyzer;
            private int[] oldBits = null;
            Bits.BitsState stateBeforeOp;

            LVTBits() {
                super(false);
            }

            LVTBits(int[] nArray, Bits.BitsState bitsState) {
                super(nArray, bitsState);
            }

            @Override
            public void clear() {
                this.generalOp(null, -1, BitsOpKind.CLEAR);
            }

            @Override
            protected void internalReset() {
                super.internalReset();
                this.oldBits = null;
            }

            @Override
            public Bits assign(Bits bits) {
                this.oldBits = this.bits;
                this.stateBeforeOp = this.currentState;
                super.assign(bits);
                this.changed();
                return this;
            }

            @Override
            public void excludeFrom(int n) {
                this.generalOp(null, n, BitsOpKind.EXCL_RANGE);
            }

            @Override
            public void excl(int n) {
                Assert.check(n >= 0);
                this.generalOp(null, n, BitsOpKind.EXCL_BIT);
            }

            @Override
            public Bits andSet(Bits bits) {
                return this.generalOp(bits, -1, BitsOpKind.AND_SET);
            }

            @Override
            public Bits orSet(Bits bits) {
                return this.generalOp(bits, -1, BitsOpKind.OR_SET);
            }

            @Override
            public Bits diffSet(Bits bits) {
                return this.generalOp(bits, -1, BitsOpKind.DIFF_SET);
            }

            @Override
            public Bits xorSet(Bits bits) {
                return this.generalOp(bits, -1, BitsOpKind.XOR_SET);
            }

            private Bits generalOp(Bits bits, int n, BitsOpKind bitsOpKind) {
                Assert.check(this.currentState != Bits.BitsState.UNKNOWN);
                this.oldBits = this.dupBits();
                this.stateBeforeOp = this.currentState;
                switch (bitsOpKind) {
                    case AND_SET: {
                        super.andSet(bits);
                        break;
                    }
                    case OR_SET: {
                        super.orSet(bits);
                        break;
                    }
                    case XOR_SET: {
                        super.xorSet(bits);
                        break;
                    }
                    case DIFF_SET: {
                        super.diffSet(bits);
                        break;
                    }
                    case CLEAR: {
                        super.clear();
                        break;
                    }
                    case EXCL_BIT: {
                        super.excl(n);
                        break;
                    }
                    case EXCL_RANGE: {
                        super.excludeFrom(n);
                    }
                }
                this.changed();
                return this;
            }

            LVTBits at(JCTree jCTree) {
                this.currentTree = jCTree;
                return this;
            }

            LVTBits resetTree() {
                this.currentTree = null;
                return this;
            }

            public void changed() {
                if (this.currentTree != null && this.stateBeforeOp != Bits.BitsState.UNKNOWN && this.trackTree(this.currentTree)) {
                    List<Symbol.VarSymbol> list = this.analyzer.lvtRanges.getVars(this.analyzer.currentMethod, this.currentTree);
                    list = list != null ? list : List.nil();
                    for (JCTree.JCVariableDecl jCVariableDecl : this.analyzer.vardecls) {
                        if (jCVariableDecl == null) break;
                        if (!this.trackVar(jCVariableDecl.sym) || !this.bitChanged(jCVariableDecl.sym.adr)) continue;
                        list = list.prepend(jCVariableDecl.sym);
                    }
                    if (!list.isEmpty()) {
                        this.analyzer.lvtRanges.setEntry(this.analyzer.currentMethod, this.currentTree, list);
                    }
                }
            }

            boolean bitChanged(int n) {
                boolean bl = this.isMember(n);
                int[] nArray = this.bits;
                this.bits = this.oldBits;
                boolean bl2 = this.isMember(n);
                this.bits = nArray;
                return !bl && bl2;
            }

            boolean trackVar(Symbol.VarSymbol varSymbol) {
                return varSymbol.owner.kind == 16 && (varSymbol.flags() & 0x200040000L) == 0L && this.analyzer.trackable(varSymbol);
            }

            boolean trackTree(JCTree jCTree) {
                switch (jCTree.getTag()) {
                    case METHODDEF: 
                    case WHILELOOP: {
                        return false;
                    }
                }
                return true;
            }

            static enum BitsOpKind {
                INIT,
                CLEAR,
                INCL_BIT,
                EXCL_BIT,
                ASSIGN,
                AND_SET,
                OR_SET,
                DIFF_SET,
                XOR_SET,
                INCL_RANGE,
                EXCL_RANGE;

            }
        }
    }

    static class GenContext {
        Code.Chain exit = null;
        Code.Chain cont = null;
        GenFinalizer finalize = null;
        boolean isSwitch = false;
        ListBuffer<Integer> gaps = null;

        GenContext() {
        }

        void addExit(Code.Chain chain) {
            this.exit = Code.mergeChains(chain, this.exit);
        }

        void addCont(Code.Chain chain) {
            this.cont = Code.mergeChains(chain, this.cont);
        }
    }

    abstract class GenFinalizer {
        GenFinalizer() {
        }

        abstract void gen();

        abstract void genLast();

        boolean hasFinalizer() {
            return true;
        }
    }

    private static enum LoopLocalVarRangeEndingPoint {
        BEFORE_STEPS,
        AFTER_STEPS;

    }

    public static class CodeSizeOverflow
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
    }

    class ClassReferenceVisitor
    extends JCTree.Visitor {
        ClassReferenceVisitor() {
        }

        @Override
        public void visitTree(JCTree jCTree) {
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            jCBinary.lhs.accept(this);
            jCBinary.rhs.accept(this);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            if (jCFieldAccess.selected.type.hasTag(TypeTag.CLASS)) {
                Gen.this.makeRef(jCFieldAccess.selected.pos(), jCFieldAccess.selected.type);
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (jCIdent.sym.owner instanceof Symbol.ClassSymbol) {
                Gen.this.pool.put(jCIdent.sym.owner);
            }
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            jCConditional.cond.accept(this);
            jCConditional.truepart.accept(this);
            jCConditional.falsepart.accept(this);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            jCUnary.arg.accept(this);
        }

        @Override
        public void visitParens(JCTree.JCParens jCParens) {
            jCParens.expr.accept(this);
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
            jCTypeCast.expr.accept(this);
        }
    }
}

