/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.nio;

import com.sun.tools.javac.nio.JavacPathFileManager;
import com.sun.tools.javac.util.BaseFileManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

abstract class PathFileObject
implements JavaFileObject {
    private JavacPathFileManager fileManager;
    private Path path;

    static PathFileObject createDirectoryPathFileObject(JavacPathFileManager javacPathFileManager, final Path path, final Path path2) {
        return new PathFileObject(javacPathFileManager, path){

            @Override
            String inferBinaryName(Iterable<? extends Path> iterable) {
                return 1.toBinaryName(path2.relativize(path));
            }
        };
    }

    static PathFileObject createJarPathFileObject(JavacPathFileManager javacPathFileManager, final Path path) {
        return new PathFileObject(javacPathFileManager, path){

            @Override
            String inferBinaryName(Iterable<? extends Path> iterable) {
                return 2.toBinaryName(path);
            }
        };
    }

    static PathFileObject createSiblingPathFileObject(JavacPathFileManager javacPathFileManager, Path path, final String string) {
        return new PathFileObject(javacPathFileManager, path){

            @Override
            String inferBinaryName(Iterable<? extends Path> iterable) {
                return 3.toBinaryName(string, "/");
            }
        };
    }

    static PathFileObject createSimplePathFileObject(JavacPathFileManager javacPathFileManager, final Path path) {
        return new PathFileObject(javacPathFileManager, path){

            @Override
            String inferBinaryName(Iterable<? extends Path> iterable) {
                Path path5 = path.toAbsolutePath();
                for (Path path2 : iterable) {
                    Path path3 = path2.toAbsolutePath();
                    if (!path5.startsWith(path3)) continue;
                    try {
                        Path path4 = path3.relativize(path5);
                        if (path4 == null) continue;
                        return 4.toBinaryName(path4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                return null;
            }
        };
    }

    protected PathFileObject(JavacPathFileManager javacPathFileManager, Path path) {
        javacPathFileManager.getClass();
        path.getClass();
        this.fileManager = javacPathFileManager;
        this.path = path;
    }

    abstract String inferBinaryName(Iterable<? extends Path> var1);

    Path getPath() {
        return this.path;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return BaseFileManager.getKind(this.path.getFileName().toString());
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        string.getClass();
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String string2 = String.valueOf(string);
        String string3 = String.valueOf(kind.extension);
        String string4 = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        String string5 = this.path.getFileName().toString();
        if (string5.equals(string4)) {
            return true;
        }
        if (string5.equalsIgnoreCase(string4)) {
            try {
                return this.path.toRealPath(LinkOption.NOFOLLOW_LINKS).getFileName().toString().equals(string4);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }

    @Override
    public String getName() {
        return this.path.toString();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        return Files.newOutputStream(this.path, new OpenOption[0]);
    }

    @Override
    public Reader openReader(boolean bl) throws IOException {
        CharsetDecoder charsetDecoder = this.fileManager.getDecoder(this.fileManager.getEncodingName(), bl);
        return new InputStreamReader(this.openInputStream(), charsetDecoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getCharContent(boolean bl) throws IOException {
        CharBuffer charBuffer = this.fileManager.getCachedContent(this);
        if (charBuffer == null) {
            try (InputStream inputStream = this.openInputStream();){
                ByteBuffer byteBuffer = this.fileManager.makeByteBuffer(inputStream);
                JavaFileObject javaFileObject = this.fileManager.log.useSource(this);
                try {
                    charBuffer = this.fileManager.decode(byteBuffer, bl);
                }
                finally {
                    this.fileManager.log.useSource(javaFileObject);
                }
                this.fileManager.recycleByteBuffer(byteBuffer);
                if (!bl) {
                    this.fileManager.cache(this, charBuffer);
                }
            }
        }
        return charBuffer;
    }

    @Override
    public Writer openWriter() throws IOException {
        this.fileManager.flushCache(this);
        this.ensureParentDirectoriesExist();
        return new OutputStreamWriter(Files.newOutputStream(this.path, new OpenOption[0]), this.fileManager.getEncodingName());
    }

    @Override
    public long getLastModified() {
        try {
            return Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public boolean delete() {
        try {
            Files.delete(this.path);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean isSameFile(PathFileObject pathFileObject) {
        try {
            return Files.isSameFile(this.path, pathFileObject.path);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        return object instanceof PathFileObject && this.path.equals(((PathFileObject)object).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.getClass().getSimpleName()));
        String string2 = String.valueOf(String.valueOf(this.path));
        return new StringBuilder(2 + string.length() + string2.length()).append(string).append("[").append(string2).append("]").toString();
    }

    private void ensureParentDirectoriesExist() throws IOException {
        Path path = this.path.getParent();
        if (path != null) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
    }

    private long size() {
        try {
            return Files.size(this.path);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    protected static String toBinaryName(Path path) {
        return PathFileObject.toBinaryName(path.toString(), path.getFileSystem().getSeparator());
    }

    protected static String toBinaryName(String string, String string2) {
        return PathFileObject.removeExtension(string).replace(string2, ".");
    }

    protected static String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }
}

