/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.Assert;
import java.util.Arrays;
import java.util.Random;

public class Bits {
    private static final int wordlen = 32;
    private static final int wordshift = 5;
    private static final int wordmask = 31;
    public int[] bits = null;
    private static final int[] unassignedBits = new int[0];
    protected BitsState currentState;

    public Bits() {
        this(false);
    }

    public Bits(Bits bits) {
        this(bits.dup().bits, BitsState.getState(bits.bits, false));
    }

    public Bits(boolean bl) {
        this(unassignedBits, BitsState.getState(unassignedBits, bl));
    }

    protected Bits(int[] nArray, BitsState bitsState) {
        this.bits = nArray;
        this.currentState = bitsState;
        switch (bitsState) {
            case UNKNOWN: {
                this.bits = null;
                break;
            }
            case NORMAL: {
                Assert.check(nArray != unassignedBits);
            }
        }
    }

    protected void sizeTo(int n) {
        if (this.bits.length < n) {
            this.bits = Arrays.copyOf(this.bits, n);
        }
    }

    public void clear() {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = 0;
        }
        this.currentState = BitsState.NORMAL;
    }

    public void reset() {
        this.internalReset();
    }

    protected void internalReset() {
        this.bits = null;
        this.currentState = BitsState.UNKNOWN;
    }

    public boolean isReset() {
        return this.currentState == BitsState.UNKNOWN;
    }

    public Bits assign(Bits bits) {
        this.bits = bits.dup().bits;
        this.currentState = BitsState.NORMAL;
        return this;
    }

    public Bits dup() {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        Bits bits = new Bits();
        bits.bits = this.dupBits();
        this.currentState = BitsState.NORMAL;
        return bits;
    }

    protected int[] dupBits() {
        int[] nArray;
        if (this.currentState != BitsState.NORMAL) {
            nArray = this.bits;
        } else {
            nArray = new int[this.bits.length];
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
        }
        return nArray;
    }

    public void incl(int n) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        int n2 = n;
        Assert.check(n >= 0, new StringBuilder(22).append("Value of x ").append(n2).toString());
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] | 1 << (n & 0x1F);
        this.currentState = BitsState.NORMAL;
    }

    public void inclRange(int n, int n2) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        this.sizeTo((n2 >>> 5) + 1);
        for (int i = n; i < n2; ++i) {
            this.bits[i >>> 5] = this.bits[i >>> 5] | 1 << (i & 0x1F);
        }
        this.currentState = BitsState.NORMAL;
    }

    public void excludeFrom(int n) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        Bits bits = new Bits();
        bits.sizeTo(this.bits.length);
        bits.inclRange(0, n);
        this.internalAndSet(bits);
        this.currentState = BitsState.NORMAL;
    }

    public void excl(int n) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        Assert.check(n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] & ~(1 << (n & 0x1F));
        this.currentState = BitsState.NORMAL;
    }

    public boolean isMember(int n) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        return 0 <= n && n < this.bits.length << 5 && (this.bits[n >>> 5] & 1 << (n & 0x1F)) != 0;
    }

    public Bits andSet(Bits bits) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        this.internalAndSet(bits);
        this.currentState = BitsState.NORMAL;
        return this;
    }

    protected void internalAndSet(Bits bits) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = this.bits[i] & bits.bits[i];
        }
    }

    public Bits orSet(Bits bits) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = this.bits[i] | bits.bits[i];
        }
        this.currentState = BitsState.NORMAL;
        return this;
    }

    public Bits diffSet(Bits bits) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        for (int i = 0; i < this.bits.length; ++i) {
            if (i >= bits.bits.length) continue;
            this.bits[i] = this.bits[i] & ~bits.bits[i];
        }
        this.currentState = BitsState.NORMAL;
        return this;
    }

    public Bits xorSet(Bits bits) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        this.sizeTo(bits.bits.length);
        for (int i = 0; i < bits.bits.length; ++i) {
            this.bits[i] = this.bits[i] ^ bits.bits[i];
        }
        this.currentState = BitsState.NORMAL;
        return this;
    }

    private static int trailingZeroBits(int n) {
        Assert.check(true);
        if (n == 0) {
            return 32;
        }
        int n2 = 1;
        if ((n & 0xFFFF) == 0) {
            n2 += 16;
            n >>>= 16;
        }
        if ((n & 0xFF) == 0) {
            n2 += 8;
            n >>>= 8;
        }
        if ((n & 0xF) == 0) {
            n2 += 4;
            n >>>= 4;
        }
        if ((n & 3) == 0) {
            n2 += 2;
            n >>>= 2;
        }
        return n2 - (n & 1);
    }

    public int nextBit(int n) {
        Assert.check(this.currentState != BitsState.UNKNOWN);
        int n2 = n >>> 5;
        if (n2 >= this.bits.length) {
            return -1;
        }
        int n3 = this.bits[n2] & ~((1 << (n & 0x1F)) - 1);
        while (n3 == 0) {
            if (++n2 >= this.bits.length) {
                return -1;
            }
            n3 = this.bits[n2];
        }
        return (n2 << 5) + Bits.trailingZeroBits(n3);
    }

    public String toString() {
        if (this.bits != null && this.bits.length > 0) {
            char[] cArray = new char[this.bits.length * 32];
            for (int i = 0; i < this.bits.length * 32; ++i) {
                cArray[i] = this.isMember(i) ? 49 : 48;
            }
            return new String(cArray);
        }
        return "[]";
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        int n3;
        Random random = new Random();
        Bits bits = new Bits();
        for (n3 = 0; n3 < 125; ++n3) {
            while (bits.isMember(n2 = random.nextInt(250))) {
            }
            n = n2;
            System.out.println(new StringBuilder(18).append("adding ").append(n).toString());
            bits.incl(n2);
        }
        n3 = 0;
        n2 = bits.nextBit(0);
        while (n2 >= 0) {
            n = n2;
            System.out.println(new StringBuilder(17).append("found ").append(n).toString());
            ++n3;
            n2 = bits.nextBit(n2 + 1);
        }
        if (n3 != 125) {
            throw new Error();
        }
    }

    protected static enum BitsState {
        UNKNOWN,
        UNINIT,
        NORMAL;


        static BitsState getState(int[] nArray, boolean bl) {
            if (bl) {
                return UNKNOWN;
            }
            if (nArray != unassignedBits) {
                return NORMAL;
            }
            return UNINIT;
        }
    }
}

