/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.ServiceConfigurationError;

public final class ServiceLoader<S>
implements Iterable<S> {
    private static final String PREFIX = "META-INF/services/";
    private Class<S> service;
    private ClassLoader loader;
    private LinkedHashMap<String, S> providers = new LinkedHashMap();
    private LazyIterator lookupIterator;

    public void reload() {
        this.providers.clear();
        this.lookupIterator = new LazyIterator(this.service, this.loader);
    }

    private ServiceLoader(Class<S> clazz, ClassLoader classLoader) {
        this.service = Objects.requireNonNull(clazz, "Service interface cannot be null");
        this.loader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.reload();
    }

    private static void fail(Class<?> clazz, String string, Throwable throwable) throws ServiceConfigurationError {
        String string2 = String.valueOf(String.valueOf(clazz.getName()));
        String string3 = String.valueOf(String.valueOf(string));
        throw new ServiceConfigurationError(new StringBuilder(2 + string2.length() + string3.length()).append(string2).append(": ").append(string3).toString(), throwable);
    }

    private static void fail(Class<?> clazz, String string) throws ServiceConfigurationError {
        String string2 = String.valueOf(String.valueOf(clazz.getName()));
        String string3 = String.valueOf(String.valueOf(string));
        throw new ServiceConfigurationError(new StringBuilder(2 + string2.length() + string3.length()).append(string2).append(": ").append(string3).toString());
    }

    private static void fail(Class<?> clazz, URL uRL, int n, String string) throws ServiceConfigurationError {
        String string2 = String.valueOf(String.valueOf(uRL));
        int n2 = n;
        String string3 = String.valueOf(String.valueOf(string));
        ServiceLoader.fail(clazz, new StringBuilder(14 + string2.length() + string3.length()).append(string2).append(":").append(n2).append(": ").append(string3).toString());
    }

    private int parseLine(Class<?> clazz, URL uRL, BufferedReader bufferedReader, int n, List<String> list) throws IOException, ServiceConfigurationError {
        int n2;
        String string = bufferedReader.readLine();
        if (string == null) {
            return -1;
        }
        int n3 = string.indexOf(35);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if ((n2 = (string = string.trim()).length()) != 0) {
            int n4;
            if (string.indexOf(32) >= 0 || string.indexOf(9) >= 0) {
                ServiceLoader.fail(clazz, uRL, n, "Illegal configuration-file syntax");
            }
            if (!Character.isJavaIdentifierStart(n4 = string.codePointAt(0))) {
                String string2 = String.valueOf(string);
                ServiceLoader.fail(clazz, uRL, n, string2.length() != 0 ? "Illegal provider-class name: ".concat(string2) : new String("Illegal provider-class name: "));
            }
            for (int i = Character.charCount(n4); i < n2; i += Character.charCount(n4)) {
                n4 = string.codePointAt(i);
                if (Character.isJavaIdentifierPart(n4) || n4 == 46) continue;
                String string3 = String.valueOf(string);
                ServiceLoader.fail(clazz, uRL, n, string3.length() != 0 ? "Illegal provider-class name: ".concat(string3) : new String("Illegal provider-class name: "));
            }
            if (!this.providers.containsKey(string) && !list.contains(string)) {
                list.add(string);
            }
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<String> parse(Class<?> clazz, URL uRL) throws ServiceConfigurationError {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            int n = 1;
            while ((n = this.parseLine(clazz, uRL, bufferedReader, n, arrayList)) >= 0) {
            }
        }
        catch (IOException iOException) {
            ServiceLoader.fail(clazz, "Error reading configuration file", iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                ServiceLoader.fail(clazz, "Error closing configuration file", iOException);
            }
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            Iterator<Map.Entry<String, S>> knownProviders;
            {
                this.knownProviders = ServiceLoader.this.providers.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.knownProviders.hasNext()) {
                    return true;
                }
                return ServiceLoader.this.lookupIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.knownProviders.hasNext()) {
                    return this.knownProviders.next().getValue();
                }
                return ServiceLoader.this.lookupIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz, ClassLoader classLoader) {
        return new ServiceLoader<S>(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> load(Class<S> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(clazz, classLoader);
    }

    public static <S> ServiceLoader<S> loadInstalled(Class<S> clazz) {
        ClassLoader classLoader = null;
        for (ClassLoader classLoader2 = ClassLoader.getSystemClassLoader(); classLoader2 != null; classLoader2 = classLoader2.getParent()) {
            classLoader = classLoader2;
        }
        return ServiceLoader.load(clazz, classLoader);
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.service.getName()));
        return new StringBuilder(25 + string.length()).append("java.util.ServiceLoader[").append(string).append("]").toString();
    }

    private class LazyIterator
    implements Iterator<S> {
        Class<S> service;
        ClassLoader loader;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        String nextName = null;

        private LazyIterator(Class<S> clazz, ClassLoader classLoader) {
            this.service = clazz;
            this.loader = classLoader;
        }

        @Override
        public boolean hasNext() {
            if (this.nextName != null) {
                return true;
            }
            if (this.configs == null) {
                try {
                    String string;
                    String string2 = String.valueOf(this.service.getName());
                    String string3 = string = string2.length() != 0 ? ServiceLoader.PREFIX.concat(string2) : new String(ServiceLoader.PREFIX);
                    this.configs = this.loader == null ? ClassLoader.getSystemResources(string) : this.loader.getResources(string);
                }
                catch (IOException iOException) {
                    ServiceLoader.fail(this.service, "Error locating configuration files", iOException);
                }
            }
            while (this.pending == null || !this.pending.hasNext()) {
                if (!this.configs.hasMoreElements()) {
                    return false;
                }
                this.pending = ServiceLoader.this.parse(this.service, this.configs.nextElement());
            }
            this.nextName = this.pending.next();
            return true;
        }

        @Override
        public S next() {
            String string;
            String string2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String string3 = this.nextName;
            this.nextName = null;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string3, false, this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string2 = String.valueOf(String.valueOf(string3));
                ServiceLoader.fail(this.service, new StringBuilder(19 + string2.length()).append("Provider ").append(string2).append(" not found").toString());
            }
            if (!this.service.isAssignableFrom(clazz)) {
                string = String.valueOf(String.valueOf(string3));
                ServiceLoader.fail(this.service, new StringBuilder(23 + string.length()).append("Provider ").append(string).append(" not a subtype").toString());
            }
            try {
                string = this.service.cast(clazz.newInstance());
                ServiceLoader.this.providers.put(string3, string);
                return string;
            }
            catch (Throwable throwable) {
                string2 = String.valueOf(String.valueOf(string3));
                String string4 = String.valueOf(String.valueOf(throwable));
                ServiceLoader.fail(this.service, new StringBuilder(37 + string2.length() + string4.length()).append("Provider ").append(string2).append(" could not be instantiated: ").append(string4).toString(), throwable);
                throw new Error();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

