/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Convert;

public class Constants {
    public static Object decode(Object value, Type type) {
        if (value instanceof Integer) {
            int i = (Integer)value;
            switch (type.getTag()) {
                case BOOLEAN: {
                    return i != 0;
                }
                case CHAR: {
                    return Character.valueOf((char)i);
                }
                case BYTE: {
                    return (byte)i;
                }
                case SHORT: {
                    return (short)i;
                }
            }
        }
        return value;
    }

    public static String format(Object value, Type type) {
        value = Constants.decode(value, type);
        switch (type.getTag()) {
            case BYTE: {
                return Constants.formatByte((Byte)value);
            }
            case LONG: {
                return Constants.formatLong((Long)value);
            }
            case FLOAT: {
                return Constants.formatFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Constants.formatDouble((Double)value);
            }
            case CHAR: {
                return Constants.formatChar(((Character)value).charValue());
            }
        }
        if (value instanceof String) {
            return Constants.formatString((String)value);
        }
        String string = String.valueOf(String.valueOf(value));
        return new StringBuilder(0 + string.length()).append(string).toString();
    }

    public static String format(Object value) {
        String string;
        if (value instanceof Byte) {
            return Constants.formatByte((Byte)value);
        }
        if (value instanceof Short) {
            return Constants.formatShort((Short)value);
        }
        if (value instanceof Long) {
            return Constants.formatLong((Long)value);
        }
        if (value instanceof Float) {
            return Constants.formatFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return Constants.formatDouble((Double)value);
        }
        if (value instanceof Character) {
            return Constants.formatChar(((Character)value).charValue());
        }
        if (value instanceof String) {
            return Constants.formatString((String)value);
        }
        if (value instanceof Integer || value instanceof Boolean) {
            return value.toString();
        }
        if (value == null) {
            string = "is a null value.";
        } else {
            String string2 = String.valueOf(value.getClass().getName());
            string = string2.length() != 0 ? "has class ".concat(string2) : new String("has class ");
        }
        String string3 = String.valueOf(String.valueOf(string));
        throw new IllegalArgumentException(new StringBuilder(50 + string3.length()).append("Argument is not a primitive type or a string; it ").append(string3).append(".").toString());
    }

    private static String formatByte(byte b) {
        return String.format("(byte)0x%02x", b);
    }

    private static String formatShort(short s) {
        return String.format("(short)%d", s);
    }

    private static String formatLong(long lng) {
        long l = lng;
        return new StringBuilder(21).append(l).append("L").toString();
    }

    private static String formatFloat(float f) {
        if (Float.isNaN(f)) {
            return "0.0f/0.0f";
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? "-1.0f/0.0f" : "1.0f/0.0f";
        }
        float f2 = f;
        return new StringBuilder(16).append(f2).append("f").toString();
    }

    private static String formatDouble(double d) {
        if (Double.isNaN(d)) {
            return "0.0/0.0";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-1.0/0.0" : "1.0/0.0";
        }
        double d2 = d;
        return new StringBuilder(24).append(d2).toString();
    }

    private static String formatChar(char c) {
        String string = String.valueOf(String.valueOf(Convert.quote(c)));
        return new StringBuilder(2 + string.length()).append("'").append(string).append("'").toString();
    }

    private static String formatString(String s) {
        String string = String.valueOf(String.valueOf(Convert.quote(s)));
        return new StringBuilder(2 + string.length()).append("\"").append(string).append("\"").toString();
    }
}

