/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.comp;

import java.util.HashMap;
import java.util.Map;
import org.openjdk.tools.javac.code.Attribute;
import org.openjdk.tools.javac.code.Kinds;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Source;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.code.Type;
import org.openjdk.tools.javac.code.TypeTag;
import org.openjdk.tools.javac.code.Types;
import org.openjdk.tools.javac.comp.Annotate;
import org.openjdk.tools.javac.comp.AttrContext;
import org.openjdk.tools.javac.comp.CompileStates;
import org.openjdk.tools.javac.comp.Enter;
import org.openjdk.tools.javac.comp.Env;
import org.openjdk.tools.javac.comp.Resolve;
import org.openjdk.tools.javac.tree.JCTree;
import org.openjdk.tools.javac.tree.TreeInfo;
import org.openjdk.tools.javac.tree.TreeMaker;
import org.openjdk.tools.javac.tree.TreeTranslator;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.List;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Log;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javac.util.Pair;

public class TransTypes
extends TreeTranslator {
    protected static final Context.Key<TransTypes> transTypesKey = new Context.Key();
    private Names names;
    private Log log;
    private Symtab syms;
    private TreeMaker make;
    private Enter enter;
    private Types types;
    private Annotate annotate;
    private final Resolve resolve;
    private final CompileStates compileStates;
    private final boolean allowGraphInference;
    private final boolean allowInterfaceBridges;
    private final boolean skipDuplicateBridges;
    Map<Symbol.MethodSymbol, Pair<Symbol.MethodSymbol, Symbol.MethodSymbol>> bridgeSpans;
    private Type pt;
    JCTree currentMethod = null;
    private Env<AttrContext> env;
    private static final String statePreviousToFlowAssertMsg = "The current compile state [%s] of class %s is previous to FLOW";

    public static TransTypes instance(Context context) {
        TransTypes instance = context.get(transTypesKey);
        if (instance == null) {
            instance = new TransTypes(context);
        }
        return instance;
    }

    protected TransTypes(Context context) {
        context.put(transTypesKey, this);
        this.compileStates = CompileStates.instance(context);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.bridgeSpans = new HashMap<Symbol.MethodSymbol, Pair<Symbol.MethodSymbol, Symbol.MethodSymbol>>();
        this.types = Types.instance(context);
        this.make = TreeMaker.instance(context);
        this.resolve = Resolve.instance(context);
        Source source = Source.instance(context);
        this.allowInterfaceBridges = source.allowDefaultMethods();
        this.allowGraphInference = source.allowGraphInference();
        this.skipDuplicateBridges = Options.instance(context).getBoolean("skipDuplicateBridges", false);
        this.annotate = Annotate.instance(context);
    }

    JCTree.JCExpression cast(JCTree.JCExpression tree, Type target) {
        int oldpos = this.make.pos;
        this.make.at(tree.pos);
        if (!this.types.isSameType(tree.type, target)) {
            if (!this.resolve.isAccessible(this.env, target.tsym)) {
                this.resolve.logAccessErrorInternal(this.env, tree, target);
            }
            tree = this.make.TypeCast(this.make.Type(target), tree).setType(target);
        }
        this.make.pos = oldpos;
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCExpression coerce(Env<AttrContext> env, JCTree.JCExpression tree, Type target) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            JCTree.JCExpression jCExpression = this.coerce(tree, target);
            return jCExpression;
        }
        finally {
            this.env = prevEnv;
        }
    }

    JCTree.JCExpression coerce(JCTree.JCExpression tree, Type target) {
        Type btarget = target.baseType();
        if (tree.type.isPrimitive() == target.isPrimitive()) {
            return this.types.isAssignable(tree.type, btarget, this.types.noWarnings) ? tree : this.cast(tree, btarget);
        }
        return tree;
    }

    JCTree.JCExpression retype(JCTree.JCExpression tree, Type erasedType, Type target) {
        if (!erasedType.isPrimitive()) {
            if (target != null && target.isPrimitive()) {
                target = this.erasure(tree.type);
            }
            tree.type = erasedType;
            if (target != null) {
                return this.coerce(tree, target);
            }
        }
        return tree;
    }

    <T extends JCTree> List<T> translateArgs(List<T> _args, List<Type> parameters, Type varargsElement) {
        if (parameters.isEmpty()) {
            return _args;
        }
        List<Object> args = _args;
        while (parameters.tail.nonEmpty()) {
            args.head = this.translate((JCTree)args.head, (Type)parameters.head);
            args = args.tail;
            parameters = parameters.tail;
        }
        Type parameter = (Type)parameters.head;
        Assert.check(varargsElement != null || args.length() == 1);
        if (varargsElement != null) {
            while (args.nonEmpty()) {
                args.head = this.translate((JCTree)args.head, varargsElement);
                args = args.tail;
            }
        } else {
            args.head = this.translate((JCTree)args.head, parameter);
        }
        return _args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JCTree> List<T> translateArgs(List<T> _args, List<Type> parameters, Type varargsElement, Env<AttrContext> localEnv) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = localEnv;
            List<T> list = this.translateArgs(_args, parameters, varargsElement);
            return list;
        }
        finally {
            this.env = prevEnv;
        }
    }

    void addBridge(JCDiagnostic.DiagnosticPosition pos, Symbol.MethodSymbol meth, Symbol.MethodSymbol impl, Symbol.ClassSymbol origin, boolean hypothetical, ListBuffer<JCTree> bridges) {
        this.make.at(pos);
        Type origType = this.types.memberType(origin.type, meth);
        Type origErasure = this.erasure(origType);
        Type bridgeType = meth.erasure(this.types);
        long flags = impl.flags() & 7L | 0x1000L | 0x80000000L | (origin.isInterface() ? 0x80000000000L : 0L);
        if (hypothetical) {
            flags |= 0x2000000000L;
        }
        Symbol.MethodSymbol bridge = new Symbol.MethodSymbol(flags, meth.name, bridgeType, origin);
        bridge.params = this.createBridgeParams(impl, bridge, bridgeType);
        bridge.setAttributes(impl);
        if (!hypothetical) {
            JCTree.JCMethodDecl md = this.make.MethodDef(bridge, null);
            JCTree.JCExpression receiver = impl.owner == origin ? this.make.This(origin.erasure(this.types)) : this.make.Super(this.types.supertype((Type)origin.type).tsym.erasure(this.types), origin);
            Type calltype = this.erasure(impl.type.getReturnType());
            JCTree.JCMethodInvocation call = this.make.Apply(null, this.make.Select(receiver, impl).setType(calltype), this.translateArgs(this.make.Idents(md.params), origErasure.getParameterTypes(), null)).setType(calltype);
            JCTree.JCExpressionStatement stat = origErasure.getReturnType().hasTag(TypeTag.VOID) ? this.make.Exec(call) : this.make.Return(this.coerce(call, bridgeType.getReturnType()));
            md.body = this.make.Block(0L, List.of(stat));
            bridges.append(md);
        }
        origin.members().enter(bridge);
        this.bridgeSpans.put(bridge, new Pair<Symbol.MethodSymbol, Symbol.MethodSymbol>(meth, impl));
    }

    private List<Symbol.VarSymbol> createBridgeParams(Symbol.MethodSymbol impl, Symbol.MethodSymbol bridge, Type bridgeType) {
        List<Symbol.VarSymbol> bridgeParams = null;
        if (impl.params != null) {
            bridgeParams = List.nil();
            List<Symbol.VarSymbol> implParams = impl.params;
            Type.MethodType mType = (Type.MethodType)bridgeType;
            List<Type> argTypes = mType.argtypes;
            while (implParams.nonEmpty() && argTypes.nonEmpty()) {
                Symbol.VarSymbol param = new Symbol.VarSymbol(((Symbol.VarSymbol)implParams.head).flags() | 0x1000L | 0x200000000L, ((Symbol.VarSymbol)implParams.head).name, (Type)argTypes.head, bridge);
                param.setAttributes((Symbol)implParams.head);
                bridgeParams = bridgeParams.append(param);
                implParams = implParams.tail;
                argTypes = argTypes.tail;
            }
        }
        return bridgeParams;
    }

    void addBridgeIfNeeded(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        if (sym.kind == Kinds.Kind.MTH && sym.name != this.names.init && (sym.flags() & 0xAL) == 0L && (sym.flags() & 0x1000L) != 4096L && sym.isMemberOf(origin, this.types)) {
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
            Symbol.MethodSymbol bridge = meth.binaryImplementation(origin, this.types);
            Symbol.MethodSymbol impl = meth.implementation(origin, this.types, true);
            if (bridge == null || bridge == meth || impl != null && !bridge.owner.isSubClass(impl.owner, this.types)) {
                if (impl != null && this.isBridgeNeeded(meth, impl, origin.type)) {
                    this.addBridge(pos, meth, impl, origin, bridge == impl, bridges);
                } else if (impl == meth && impl.owner != origin && (impl.flags() & 0x10L) == 0L && (meth.flags() & 0x401L) == 1L && (origin.flags() & 1L) > (impl.owner.flags() & 1L)) {
                    this.addBridge(pos, meth, impl, origin, false, bridges);
                }
            } else if ((bridge.flags() & 0x1000L) == 4096L) {
                Symbol.MethodSymbol other;
                Pair<Symbol.MethodSymbol, Symbol.MethodSymbol> bridgeSpan = this.bridgeSpans.get(bridge);
                Symbol.MethodSymbol methodSymbol = other = bridgeSpan == null ? null : (Symbol.MethodSymbol)bridgeSpan.fst;
                if (!(other == null || other == meth || impl != null && impl.overrides(other, origin, this.types, true))) {
                    Symbol.MethodSymbol target;
                    Symbol.MethodSymbol methodSymbol2 = target = bridgeSpan == null ? null : (Symbol.MethodSymbol)bridgeSpan.snd;
                    if (target == null || !target.overrides(meth, origin, this.types, true, false)) {
                        this.log.error(pos, "name.clash.same.erasure.no.override", other, other.location(origin.type, this.types), meth, meth.location(origin.type, this.types));
                    }
                }
            } else if (!(bridge.overrides(meth, origin, this.types, true) || bridge.owner != origin && this.types.asSuper(bridge.owner.type, meth.owner) != null)) {
                this.log.error(pos, "name.clash.same.erasure.no.override", bridge, bridge.location(origin.type, this.types), meth, meth.location(origin.type, this.types));
            }
        }
    }

    private boolean isBridgeNeeded(Symbol.MethodSymbol method, Symbol.MethodSymbol impl, Type dest) {
        if (impl != method) {
            if (this.skipBridge(method, impl, dest)) {
                return false;
            }
            Type method_erasure = method.erasure(this.types);
            if (!this.isSameMemberWhenErased(dest, method, method_erasure)) {
                return true;
            }
            Type impl_erasure = impl.erasure(this.types);
            if (!this.isSameMemberWhenErased(dest, impl, impl_erasure)) {
                return true;
            }
            return !this.types.isSameType(impl_erasure.getReturnType(), method_erasure.getReturnType());
        }
        if ((method.flags() & 0x400L) != 0L) {
            return false;
        }
        return !this.isSameMemberWhenErased(dest, method, method.erasure(this.types));
    }

    private boolean isSameMemberWhenErased(Type type, Symbol.MethodSymbol method, Type erasure) {
        return this.types.isSameType(this.erasure(this.types.memberType(type, method)), erasure);
    }

    private boolean skipBridge(Symbol.MethodSymbol method, Symbol.MethodSymbol impl, Type dest) {
        if (!this.skipDuplicateBridges) {
            return false;
        }
        if (dest.tsym == impl.owner) {
            return false;
        }
        if (!this.types.isSubtype(this.types.erasure(impl.owner.type), this.types.erasure(method.owner.type))) {
            return false;
        }
        return impl.overrides(method, (Symbol.TypeSymbol)impl.owner, this.types, true);
    }

    void addBridges(JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol i, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        for (Symbol sym : i.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            this.addBridgeIfNeeded(pos, sym, origin, bridges);
        }
        List<Type> l = this.types.interfaces(i.type);
        while (l.nonEmpty()) {
            this.addBridges(pos, ((Type)l.head).tsym, origin, bridges);
            l = l.tail;
        }
    }

    void addBridges(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol origin, ListBuffer<JCTree> bridges) {
        Type st = this.types.supertype(origin.type);
        while (st.hasTag(TypeTag.CLASS)) {
            this.addBridges(pos, st.tsym, origin, bridges);
            st = this.types.supertype(st);
        }
        List<Type> l = this.types.interfaces(origin.type);
        while (l.nonEmpty()) {
            this.addBridges(pos, ((Type)l.head).tsym, origin, bridges);
            l = l.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JCTree> T translate(T tree, Type pt) {
        Type prevPt = this.pt;
        try {
            this.pt = pt;
            T t = this.translate(tree);
            return t;
        }
        finally {
            this.pt = prevPt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JCTree> List<T> translate(List<T> trees, Type pt) {
        List<T> res;
        Type prevPt = this.pt;
        try {
            this.pt = pt;
            res = this.translate(trees);
        }
        finally {
            this.pt = prevPt;
        }
        return res;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.translateClass(tree.sym);
        this.result = tree;
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        JCTree previousMethod = this.currentMethod;
        try {
            this.currentMethod = tree;
            tree.restype = this.translate(tree.restype, null);
            tree.typarams = List.nil();
            tree.params = this.translateVarDefs(tree.params);
            tree.recvparam = this.translate(tree.recvparam, null);
            tree.thrown = this.translate(tree.thrown, null);
            tree.body = this.translate(tree.body, tree.sym.erasure(this.types).getReturnType());
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
        finally {
            this.currentMethod = previousMethod;
        }
        for (Symbol sym : tree.sym.owner.members().getSymbolsByName(tree.name)) {
            if (sym == tree.sym || !this.types.isSameType(this.erasure(sym.type), tree.type)) continue;
            this.log.error(tree.pos(), "name.clash.same.erasure", tree.sym, sym);
            return;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        tree.vartype = this.translate(tree.vartype, null);
        tree.init = this.translate(tree.init, tree.sym.erasure(this.types));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        tree.body = this.translate(tree.body);
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        this.result = tree;
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        tree.init = this.translate(tree.init, null);
        if (tree.cond != null) {
            tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        }
        tree.step = this.translate(tree.step, null);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        tree.var = this.translate(tree.var, null);
        Type iterableType = tree.expr.type;
        tree.expr = this.translate(tree.expr, this.erasure(tree.expr.type));
        if (this.types.elemtype(tree.expr.type) == null) {
            tree.expr.type = iterableType;
        }
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        JCTree prevMethod = this.currentMethod;
        try {
            this.currentMethod = null;
            tree.params = this.translate(tree.params);
            tree.body = this.translate(tree.body, tree.body.type == null ? null : this.erasure(tree.body.type));
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
        finally {
            this.currentMethod = prevMethod;
        }
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        Type selsuper = this.types.supertype(tree.selector.type);
        boolean enumSwitch = selsuper != null && selsuper.tsym == this.syms.enumSym;
        Type.JCPrimitiveType target = enumSwitch ? this.erasure(tree.selector.type) : this.syms.intType;
        tree.selector = this.translate(tree.selector, (Type)target);
        tree.cases = this.translateCases(tree.cases);
        this.result = tree;
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        tree.pat = this.translate(tree.pat, null);
        tree.stats = this.translate(tree.stats);
        this.result = tree;
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        tree.lock = this.translate(tree.lock, this.erasure(tree.lock.type));
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        tree.resources = this.translate(tree.resources, this.syms.autoCloseableType);
        tree.body = this.translate(tree.body);
        tree.catchers = this.translateCatchers(tree.catchers);
        tree.finalizer = this.translate(tree.finalizer);
        this.result = tree;
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        tree.truepart = this.translate(tree.truepart, this.erasure(tree.type));
        tree.falsepart = this.translate(tree.falsepart, this.erasure(tree.type));
        tree.type = this.erasure(tree.type);
        this.result = this.retype(tree, tree.type, this.pt);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        tree.thenpart = this.translate(tree.thenpart);
        tree.elsepart = this.translate(tree.elsepart);
        this.result = tree;
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        tree.expr = this.translate(tree.expr, null);
        this.result = tree;
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        tree.expr = this.translate(tree.expr, this.currentMethod != null ? this.types.erasure(this.currentMethod.type).getReturnType() : null);
        this.result = tree;
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        tree.expr = this.translate(tree.expr, this.erasure(tree.expr.type));
        this.result = tree;
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        tree.cond = this.translate(tree.cond, (Type)this.syms.booleanType);
        if (tree.detail != null) {
            tree.detail = this.translate(tree.detail, this.erasure(tree.detail.type));
        }
        this.result = tree;
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        List<Type> argtypes;
        tree.meth = this.translate(tree.meth, null);
        Symbol meth = TreeInfo.symbol(tree.meth);
        Type mt = meth.erasure(this.types);
        boolean useInstantiatedPtArgs = this.allowGraphInference && !this.types.isSignaturePolymorphic((Symbol.MethodSymbol)meth.baseSymbol());
        List<Type> list = argtypes = useInstantiatedPtArgs ? tree.meth.type.getParameterTypes() : mt.getParameterTypes();
        if (meth.name == this.names.init && meth.owner == this.syms.enumSym) {
            argtypes = argtypes.tail.tail;
        }
        if (tree.varargsElement != null) {
            tree.varargsElement = this.types.erasure(tree.varargsElement);
        } else if (tree.args.length() != argtypes.length()) {
            this.log.error(tree.pos(), "method.invoked.with.incorrect.number.arguments", tree.args.length(), argtypes.length());
        }
        tree.args = this.translateArgs(tree.args, argtypes, tree.varargsElement);
        tree.type = this.types.erasure(tree.type);
        this.result = this.retype(tree, mt.getReturnType(), this.pt);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        if (tree.encl != null) {
            tree.encl = this.translate(tree.encl, this.erasure(tree.encl.type));
        }
        Type erasedConstructorType = tree.constructorType != null ? this.erasure(tree.constructorType) : null;
        List<Type> argtypes = erasedConstructorType != null && this.allowGraphInference ? erasedConstructorType.getParameterTypes() : tree.constructor.erasure(this.types).getParameterTypes();
        tree.clazz = this.translate(tree.clazz, null);
        if (tree.varargsElement != null) {
            tree.varargsElement = this.types.erasure(tree.varargsElement);
        }
        tree.args = this.translateArgs(tree.args, argtypes, tree.varargsElement);
        tree.def = this.translate(tree.def, null);
        if (erasedConstructorType != null) {
            tree.constructorType = erasedConstructorType;
        }
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        tree.elemtype = this.translate(tree.elemtype, null);
        this.translate(tree.dims, (Type)this.syms.intType);
        if (tree.type != null) {
            tree.elems = this.translate(tree.elems, this.erasure(this.types.elemtype(tree.type)));
            tree.type = this.erasure(tree.type);
        } else {
            tree.elems = this.translate(tree.elems, null);
        }
        this.result = tree;
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        tree.expr = this.translate(tree.expr, this.pt);
        tree.type = this.erasure(tree.expr.type);
        this.result = tree;
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        tree.lhs = this.translate(tree.lhs, null);
        tree.rhs = this.translate(tree.rhs, this.erasure(tree.lhs.type));
        tree.type = this.erasure(tree.lhs.type);
        this.result = this.retype(tree, tree.type, this.pt);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        tree.lhs = this.translate(tree.lhs, null);
        tree.rhs = this.translate(tree.rhs, (Type)tree.operator.type.getParameterTypes().tail.head);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        tree.arg = this.translate(tree.arg, tree.getTag() == JCTree.Tag.NULLCHK ? tree.type : (Type)tree.operator.type.getParameterTypes().head);
        this.result = tree;
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        tree.lhs = this.translate(tree.lhs, (Type)tree.operator.type.getParameterTypes().head);
        tree.rhs = this.translate(tree.rhs, (Type)tree.operator.type.getParameterTypes().tail.head);
        this.result = tree;
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
        List<Attribute.TypeCompound> mirrors = this.annotate.fromAnnotations(tree.annotations);
        tree.underlyingType = this.translate(tree.underlyingType);
        tree.type = tree.underlyingType.type.annotatedType(mirrors);
        this.result = tree;
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        tree.clazz = this.translate(tree.clazz, null);
        Type originalTarget = tree.type;
        tree.type = this.erasure(tree.type);
        JCTree.JCExpression newExpression = this.translate(tree.expr, tree.type);
        if (newExpression != tree.expr) {
            JCTree.JCTypeCast typeCast = newExpression.hasTag(JCTree.Tag.TYPECAST) ? (JCTree.JCTypeCast)newExpression : null;
            JCTree.JCExpression jCExpression = tree.expr = typeCast != null && this.types.isSameType(typeCast.type, originalTarget, true) ? typeCast.expr : newExpression;
        }
        if (originalTarget.isIntersection()) {
            Type.IntersectionClassType ict = (Type.IntersectionClassType)originalTarget;
            for (Type c : ict.getExplicitComponents()) {
                Type ec = this.erasure(c);
                if (this.types.isSameType(ec, tree.type)) continue;
                tree.expr = this.coerce(tree.expr, ec);
            }
        }
        this.result = tree;
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        tree.expr = this.translate(tree.expr, null);
        tree.clazz = this.translate(tree.clazz, null);
        this.result = tree;
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        tree.indexed = this.translate(tree.indexed, this.erasure(tree.indexed.type));
        tree.index = this.translate(tree.index, (Type)this.syms.intType);
        this.result = this.retype(tree, this.types.elemtype(tree.indexed.type), this.pt);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        this.result = tree;
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        Type et = tree.sym.erasure(this.types);
        if (tree.sym.kind == Kinds.Kind.TYP && tree.sym.type.hasTag(TypeTag.TYPEVAR)) {
            this.result = this.make.at(tree.pos).Type(et);
        } else if (tree.type.constValue() != null) {
            this.result = tree;
        } else if (tree.sym.kind == Kinds.Kind.VAR) {
            this.result = this.retype(tree, et, this.pt);
        } else {
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        Type t = this.types.skipTypeVars(tree.selected.type, false);
        tree.selected = t.isCompound() ? this.coerce(this.translate(tree.selected, this.erasure(tree.selected.type)), this.erasure(tree.sym.owner.type)) : this.translate(tree.selected, this.erasure(t));
        if (tree.type.constValue() != null) {
            this.result = tree;
        } else if (tree.sym.kind == Kinds.Kind.VAR) {
            this.result = this.retype(tree, tree.sym.erasure(this.types), this.pt);
        } else {
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        Type t = this.types.skipTypeVars(tree.expr.type, false);
        Type receiverTarget = t.isCompound() ? this.erasure(tree.sym.owner.type) : this.erasure(t);
        tree.expr = tree.kind == JCTree.JCMemberReference.ReferenceKind.UNBOUND ? this.make.Type(receiverTarget) : this.translate(tree.expr, receiverTarget);
        tree.type = this.erasure(tree.type);
        if (tree.varargsElement != null) {
            tree.varargsElement = this.erasure(tree.varargsElement);
        }
        this.result = tree;
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        tree.elemtype = this.translate(tree.elemtype, null);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        JCTree.JCExpression clazz = this.translate(tree.clazz, null);
        this.result = clazz;
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection tree) {
        tree.bounds = this.translate(tree.bounds, null);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    private Type erasure(Type t) {
        return this.types.erasure(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void translateClass(Symbol.ClassSymbol c) {
        boolean envHasCompState;
        Env<AttrContext> myEnv;
        Type st = this.types.supertype(c.type);
        if (st.hasTag(TypeTag.CLASS)) {
            this.translateClass((Symbol.ClassSymbol)st.tsym);
        }
        if ((myEnv = this.enter.getEnv(c)) == null || (c.flags_field & 0x4000000000000L) != 0L) {
            return;
        }
        c.flags_field |= 0x4000000000000L;
        boolean bl = envHasCompState = this.compileStates.get(myEnv) != null;
        if (!envHasCompState && c.outermostClass() == c) {
            Assert.error("No info for outermost class: " + myEnv.enclClass.sym);
        }
        if (envHasCompState && CompileStates.CompileState.FLOW.isAfter((CompileStates.CompileState)((Object)this.compileStates.get(myEnv)))) {
            Assert.error(String.format(statePreviousToFlowAssertMsg, this.compileStates.get(myEnv), myEnv.enclClass.sym));
        }
        Env<AttrContext> oldEnv = this.env;
        try {
            this.env = myEnv;
            TreeMaker savedMake = this.make;
            Type savedPt = this.pt;
            this.make = this.make.forToplevel(this.env.toplevel);
            this.pt = null;
            try {
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)this.env.tree;
                tree.typarams = List.nil();
                super.visitClassDef(tree);
                this.make.at(tree.pos);
                ListBuffer<JCTree> bridges = new ListBuffer<JCTree>();
                if (this.allowInterfaceBridges || (tree.sym.flags() & 0x200L) == 0L) {
                    this.addBridges(tree.pos(), c, bridges);
                }
                tree.defs = bridges.toList().prependList(tree.defs);
                tree.type = this.erasure(tree.type);
            }
            finally {
                this.make = savedMake;
                this.pt = savedPt;
            }
        }
        finally {
            this.env = oldEnv;
        }
    }

    public JCTree translateTopLevelClass(JCTree cdef, TreeMaker make) {
        this.make = make;
        this.pt = null;
        return this.translate(cdef, null);
    }
}

