/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.tools.example.debug.tty.Commands;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class VMConnection {
    private VirtualMachine vm;
    private Process process = null;
    private int outputCompleteCount = 0;
    private final Connector connector;
    private final Map<String, Connector.Argument> connectorArgs;
    private final int traceFlags;

    synchronized void notifyOutputComplete() {
        ++this.outputCompleteCount;
        this.notifyAll();
    }

    synchronized void waitOutputComplete() {
        if (this.process != null) {
            while (this.outputCompleteCount < 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private Connector findConnector(String name) {
        for (Connector connector : Bootstrap.virtualMachineManager().allConnectors()) {
            if (!connector.name().equals(name)) continue;
            return connector;
        }
        return null;
    }

    private Map<String, Connector.Argument> parseConnectorArgs(Connector connector, String argString) {
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        String regexPattern = "(quote=[^,]+,)|(\\w+=)(((\"[^\"]*\")|('[^']*')|([^,'\"]+))+,)";
        Pattern p = Pattern.compile(regexPattern);
        Matcher m = p.matcher(argString);
        while (m.find()) {
            Connector.Argument argument;
            int startPosition = m.start();
            int endPosition = m.end();
            if (startPosition > 0) {
                throw new IllegalArgumentException(MessageOutput.format("Illegal connector argument", argString));
            }
            String token = argString.substring(startPosition, endPosition);
            int index = token.indexOf(61);
            String name = token.substring(0, index);
            String value = token.substring(index + 1, token.length() - 1);
            if (name.equals("options")) {
                StringBuilder sb = new StringBuilder();
                for (String s : VMConnection.splitStringAtNonEnclosedWhiteSpace(value)) {
                    while (VMConnection.isEnclosed(s, "\"") || VMConnection.isEnclosed(s, "'")) {
                        s = s.substring(1, s.length() - 1);
                    }
                    sb.append(s);
                    sb.append(" ");
                }
                value = sb.toString();
            }
            if ((argument = arguments.get(name)) == null) {
                throw new IllegalArgumentException(MessageOutput.format("Argument is not defined for connector:", new Object[]{name, connector.name()}));
            }
            argument.setValue(value);
            argString = argString.substring(endPosition);
            m = p.matcher(argString);
        }
        if (!argString.equals(",") && argString.length() > 0) {
            throw new IllegalArgumentException(MessageOutput.format("Illegal connector argument", argString));
        }
        return arguments;
    }

    private static boolean isEnclosed(String value, String enclosingChar) {
        int lastIndex;
        return value.indexOf(enclosingChar) == 0 && (lastIndex = value.lastIndexOf(enclosingChar)) > 0 && lastIndex == value.length() - 1;
    }

    private static List<String> splitStringAtNonEnclosedWhiteSpace(String value) throws IllegalArgumentException {
        ArrayList<String> al = new ArrayList<String>();
        int startPosition = 0;
        int endPosition = 0;
        int SPACE = 32;
        int DOUBLEQ = 34;
        int SINGLEQ = 39;
        int enclosingTargetChar = 32;
        if (value == null) {
            throw new IllegalArgumentException(MessageOutput.format("value string is null"));
        }
        char[] arr = value.toCharArray();
        block4: for (int i = 0; i < arr.length; ++i) {
            switch (arr[i]) {
                case ' ': {
                    if (!VMConnection.isLastChar(arr, i)) continue block4;
                    endPosition = i;
                    break;
                }
                case '\"': 
                case '\'': {
                    if (enclosingTargetChar == arr[i] && VMConnection.isNextCharWhitespace(arr, i)) {
                        endPosition = i;
                        enclosingTargetChar = 32;
                        break;
                    }
                    if (enclosingTargetChar != 32 || !VMConnection.isPreviousCharWhitespace(arr, i)) continue block4;
                    startPosition = i;
                    if (value.indexOf(arr[i], i + 1) >= 0) {
                        enclosingTargetChar = arr[i];
                        continue block4;
                    }
                    if (!VMConnection.isNextCharWhitespace(arr, i)) continue block4;
                    endPosition = i;
                    break;
                }
                default: {
                    if (enclosingTargetChar != 32) continue block4;
                    if (VMConnection.isPreviousCharWhitespace(arr, i)) {
                        startPosition = i;
                    }
                    if (!VMConnection.isNextCharWhitespace(arr, i)) continue block4;
                    endPosition = i;
                }
            }
            if (startPosition > endPosition) {
                throw new IllegalArgumentException(MessageOutput.format("Illegal option values"));
            }
            al.add(value.substring(startPosition, ++endPosition));
            i = startPosition = endPosition;
        }
        return al;
    }

    private static boolean isPreviousCharWhitespace(char[] arr, int curr_pos) {
        return VMConnection.isCharWhitespace(arr, curr_pos - 1);
    }

    private static boolean isNextCharWhitespace(char[] arr, int curr_pos) {
        return VMConnection.isCharWhitespace(arr, curr_pos + 1);
    }

    private static boolean isCharWhitespace(char[] arr, int pos) {
        if (pos < 0 || pos >= arr.length) {
            return true;
        }
        return arr[pos] == ' ';
    }

    private static boolean isLastChar(char[] arr, int pos) {
        return pos + 1 == arr.length;
    }

    VMConnection(String connectSpec, int traceFlags) {
        String argString;
        String nameString;
        int index = connectSpec.indexOf(58);
        if (index == -1) {
            nameString = connectSpec;
            argString = "";
        } else {
            nameString = connectSpec.substring(0, index);
            argString = connectSpec.substring(index + 1);
        }
        this.connector = this.findConnector(nameString);
        if (this.connector == null) {
            throw new IllegalArgumentException(MessageOutput.format("No connector named:", nameString));
        }
        this.connectorArgs = this.parseConnectorArgs(this.connector, argString);
        this.traceFlags = traceFlags;
    }

    synchronized VirtualMachine open() {
        if (this.connector instanceof LaunchingConnector) {
            this.vm = this.launchTarget();
        } else if (this.connector instanceof AttachingConnector) {
            this.vm = this.attachTarget();
        } else if (this.connector instanceof ListeningConnector) {
            this.vm = this.listenTarget();
        } else {
            throw new InternalError(MessageOutput.format("Invalid connect type"));
        }
        this.vm.setDebugTraceMode(this.traceFlags);
        if (this.vm.canBeModified()) {
            this.setEventRequests(this.vm);
            this.resolveEventRequests();
        }
        if (Env.getSourcePath().length() == 0) {
            if (this.vm instanceof PathSearchingVirtualMachine) {
                PathSearchingVirtualMachine psvm = (PathSearchingVirtualMachine)this.vm;
                Env.setSourcePath(psvm.classPath());
            } else {
                Env.setSourcePath(".");
            }
        }
        return this.vm;
    }

    boolean setConnectorArg(String name, String value) {
        if (this.vm != null) {
            return false;
        }
        Connector.Argument argument = this.connectorArgs.get(name);
        if (argument == null) {
            return false;
        }
        argument.setValue(value);
        return true;
    }

    String connectorArg(String name) {
        Connector.Argument argument = this.connectorArgs.get(name);
        if (argument == null) {
            return "";
        }
        return argument.value();
    }

    public synchronized VirtualMachine vm() {
        if (this.vm == null) {
            throw new VMNotConnectedException();
        }
        return this.vm;
    }

    boolean isOpen() {
        return this.vm != null;
    }

    boolean isLaunch() {
        return this.connector instanceof LaunchingConnector;
    }

    public void disposeVM() {
        try {
            if (this.vm != null) {
                this.vm.dispose();
                this.vm = null;
            }
        }
        finally {
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
            this.waitOutputComplete();
        }
    }

    private void setEventRequests(VirtualMachine vm) {
        EventRequestManager erm = vm.eventRequestManager();
        Commands evaluator = new Commands();
        evaluator.commandCatchException(new StringTokenizer("uncaught java.lang.Throwable"));
        ThreadStartRequest tsr = erm.createThreadStartRequest();
        tsr.enable();
        ThreadDeathRequest tdr = erm.createThreadDeathRequest();
        tdr.enable();
    }

    private void resolveEventRequests() {
        Env.specList.resolveAll();
    }

    private void dumpStream(InputStream stream) throws IOException {
        block3: {
            BufferedReader in = new BufferedReader(new InputStreamReader(stream));
            try {
                int i;
                while ((i = in.read()) != -1) {
                    MessageOutput.printDirect((char)i);
                }
            }
            catch (IOException ex) {
                String s = ex.getMessage();
                if (s.startsWith("Bad file number")) break block3;
                throw ex;
            }
        }
    }

    private void displayRemoteOutput(final InputStream stream) {
        Thread thr = new Thread("output reader"){

            @Override
            public void run() {
                try {
                    VMConnection.this.dumpStream(stream);
                }
                catch (IOException ex) {
                    MessageOutput.fatalError("Failed reading output");
                }
                finally {
                    VMConnection.this.notifyOutputComplete();
                }
            }
        };
        thr.setPriority(9);
        thr.start();
    }

    private void dumpFailedLaunchInfo(Process process) {
        try {
            this.dumpStream(process.getErrorStream());
            this.dumpStream(process.getInputStream());
        }
        catch (IOException e) {
            MessageOutput.println("Unable to display process output:", e.getMessage());
        }
    }

    private VirtualMachine launchTarget() {
        LaunchingConnector launcher = (LaunchingConnector)this.connector;
        try {
            VirtualMachine vm = launcher.launch(this.connectorArgs);
            this.process = vm.process();
            this.displayRemoteOutput(this.process.getErrorStream());
            this.displayRemoteOutput(this.process.getInputStream());
            return vm;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            MessageOutput.fatalError("Unable to launch target VM.");
        }
        catch (IllegalConnectorArgumentsException icae) {
            icae.printStackTrace();
            MessageOutput.fatalError("Internal debugger error.");
        }
        catch (VMStartException vmse) {
            MessageOutput.println("vmstartexception", vmse.getMessage());
            MessageOutput.println();
            this.dumpFailedLaunchInfo(vmse.process());
            MessageOutput.fatalError("Target VM failed to initialize.");
        }
        return null;
    }

    private VirtualMachine attachTarget() {
        AttachingConnector attacher = (AttachingConnector)this.connector;
        try {
            return attacher.attach(this.connectorArgs);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            MessageOutput.fatalError("Unable to attach to target VM.");
        }
        catch (IllegalConnectorArgumentsException icae) {
            icae.printStackTrace();
            MessageOutput.fatalError("Internal debugger error.");
        }
        return null;
    }

    private VirtualMachine listenTarget() {
        ListeningConnector listener = (ListeningConnector)this.connector;
        try {
            String retAddress = listener.startListening(this.connectorArgs);
            MessageOutput.println("Listening at address:", retAddress);
            this.vm = listener.accept(this.connectorArgs);
            listener.stopListening(this.connectorArgs);
            return this.vm;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            MessageOutput.fatalError("Unable to attach to target VM.");
        }
        catch (IllegalConnectorArgumentsException icae) {
            icae.printStackTrace();
            MessageOutput.fatalError("Internal debugger error.");
        }
        return null;
    }
}

