/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FSInfo {
    public static FSInfo instance(Context context) {
        FSInfo instance = context.get(FSInfo.class);
        if (instance == null) {
            instance = new FSInfo();
        }
        return instance;
    }

    protected FSInfo() {
    }

    protected FSInfo(Context context) {
        context.put(FSInfo.class, this);
    }

    public Path getCanonicalFile(Path file) {
        try {
            return file.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return file.toAbsolutePath().normalize();
        }
    }

    public boolean exists(Path file) {
        return Files.exists(file, new LinkOption[0]);
    }

    public boolean isDirectory(Path file) {
        return Files.isDirectory(file, new LinkOption[0]);
    }

    public boolean isFile(Path file) {
        return Files.isRegularFile(file, new LinkOption[0]);
    }

    public List<Path> getJarClassPath(Path file) throws IOException {
        Path parent = file.getParent();
        try (JarFile jarFile = new JarFile(file.toFile());){
            Manifest man = jarFile.getManifest();
            if (man == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            Attributes attr = man.getMainAttributes();
            if (attr == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            String path = attr.getValue(Attributes.Name.CLASS_PATH);
            if (path == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            ArrayList<Path> list = new ArrayList<Path>();
            StringTokenizer st = new StringTokenizer(path);
            while (st.hasMoreTokens()) {
                String elt = st.nextToken();
                Path f = Paths.get(elt, new String[0]);
                if (!f.isAbsolute() && parent != null) {
                    f = parent.resolve(f).toAbsolutePath();
                }
                list.add(f);
            }
            ArrayList<Path> arrayList = list;
            return arrayList;
        }
    }
}

