/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ModuleReference;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.VirtualMachineImpl;

class ModuleReferenceImpl
extends ObjectReferenceImpl
implements ModuleReference {
    private String name;
    private ClassLoaderReference classLoader;
    private boolean cachedName = false;
    private boolean cachedClassLoader = false;

    protected ModuleReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    protected String description() {
        return "ModuleReference " + this.ref();
    }

    @Override
    public synchronized String name() {
        if (this.cachedName) {
            return this.name;
        }
        try {
            this.name = JDWP.ModuleReference.Name.process((VirtualMachineImpl)this.vm, (ModuleReferenceImpl)this).name;
            if (this.name != null && this.name.length() == 0) {
                this.name = null;
            }
            this.cachedName = true;
        }
        catch (JDWPException ex) {
            throw ex.toJDIException();
        }
        return this.name;
    }

    @Override
    public synchronized ClassLoaderReference classLoader() {
        if (this.cachedClassLoader) {
            return this.classLoader;
        }
        try {
            this.classLoader = JDWP.ModuleReference.ClassLoader.process((VirtualMachineImpl)this.vm, (ModuleReferenceImpl)this).classLoader;
            this.cachedClassLoader = true;
        }
        catch (JDWPException ex) {
            throw ex.toJDIException();
        }
        return this.classLoader;
    }

    @Override
    public synchronized boolean canRead(ModuleReference module) {
        boolean ret;
        try {
            ret = JDWP.ModuleReference.CanRead.process((VirtualMachineImpl)this.vm, (ModuleReferenceImpl)this, (ModuleReferenceImpl)((ModuleReferenceImpl)module)).canRead;
        }
        catch (JDWPException ex) {
            throw ex.toJDIException();
        }
        return ret;
    }
}

