/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.jdi.ConnectorImpl;
import com.sun.tools.jdi.SocketTransportService;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class ProcessAttachingConnector
extends ConnectorImpl
implements AttachingConnector {
    static final String ARG_PID = "pid";
    static final String ARG_TIMEOUT = "timeout";
    VirtualMachine vm;
    Transport transport;

    public ProcessAttachingConnector() {
        this.addStringArgument(ARG_PID, this.getString("process_attaching.pid.label"), this.getString("process_attaching.pid"), "", true);
        this.addIntegerArgument(ARG_TIMEOUT, this.getString("generic_attaching.timeout.label"), this.getString("generic_attaching.timeout"), "", false, 0, Integer.MAX_VALUE);
        this.transport = new Transport(){

            @Override
            public String name() {
                return "local";
            }
        };
    }

    @Override
    public com.sun.jdi.VirtualMachine attach(Map<String, ? extends Connector.Argument> args) throws IOException, IllegalConnectorArgumentsException {
        String pid = this.argument(ARG_PID, args).value();
        String t = this.argument(ARG_TIMEOUT, args).value();
        int timeout = 0;
        if (t.length() > 0) {
            timeout = Integer.decode(t);
        }
        String address = null;
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(pid);
            Properties props = vm.getAgentProperties();
            address = props.getProperty("sun.jdwp.listenerAddress");
        }
        catch (Exception x) {
            throw new IOException(x.getMessage());
        }
        finally {
            if (vm != null) {
                vm.detach();
            }
        }
        if (address == null) {
            throw new IOException("Not a debuggee, or not listening for debugger to attach");
        }
        int pos = address.indexOf(58);
        if (pos < 1) {
            throw new IOException("Unable to determine transport endpoint");
        }
        String lib = address.substring(0, pos);
        address = address.substring(pos + 1, address.length());
        TransportService ts = null;
        if (lib.equals("dt_socket")) {
            ts = new SocketTransportService();
        } else if (lib.equals("dt_shmem")) {
            try {
                Class<?> c = Class.forName("com.sun.tools.jdi.SharedMemoryTransportService");
                Object tmp = c.newInstance();
                ts = (TransportService)tmp;
            }
            catch (Exception c) {
                // empty catch block
            }
        }
        if (ts == null) {
            throw new IOException("Transport " + lib + " not recognized");
        }
        Connection connection = ((TransportService)ts).attach(address, timeout, 0L);
        return Bootstrap.virtualMachineManager().createVirtualMachine(connection);
    }

    @Override
    public String name() {
        return "com.sun.jdi.ProcessAttach";
    }

    @Override
    public String description() {
        return this.getString("process_attaching.description");
    }

    @Override
    public Transport transport() {
        if (this.transport == null) {
            return new Transport(){

                @Override
                public String name() {
                    return "local";
                }
            };
        }
        return this.transport;
    }
}

