/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jline.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jdk.internal.jline.console.KeyMap;
import jdk.internal.jline.console.Operation;
import jdk.internal.jline.internal.Log;

public class ConsoleKeys {
    private KeyMap keys;
    private Map<String, KeyMap> keyMaps;
    private Map<String, String> variables = new HashMap<String, String>();

    public ConsoleKeys(String appName, URL inputrcUrl) {
        this.keyMaps = KeyMap.keyMaps();
        this.loadKeys(appName, inputrcUrl);
    }

    protected boolean isViEditMode() {
        return this.keys.isViKeyMap();
    }

    protected boolean setKeyMap(String name) {
        KeyMap map = this.keyMaps.get(name);
        if (map == null) {
            return false;
        }
        this.keys = map;
        return true;
    }

    protected Map<String, KeyMap> getKeyMaps() {
        return this.keyMaps;
    }

    protected KeyMap getKeys() {
        return this.keys;
    }

    protected void setKeys(KeyMap keys) {
        this.keys = keys;
    }

    protected boolean getViEditMode() {
        return this.keys.isViKeyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys(String appName, URL inputrcUrl) {
        this.keys = this.keyMaps.get("emacs");
        try {
            InputStream input = inputrcUrl.openStream();
            try {
                this.loadKeys(input, appName);
                Log.debug("Loaded user configuration: ", inputrcUrl);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            if (inputrcUrl.getProtocol().equals("file")) {
                File file = new File(inputrcUrl.getPath());
                if (file.exists()) {
                    Log.warn("Unable to read user configuration: ", inputrcUrl, e);
                }
            }
            Log.warn("Unable to read user configuration: ", inputrcUrl, e);
        }
    }

    private void loadKeys(InputStream input, String appName) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        boolean parsing = true;
        ArrayList<Boolean> ifsStack = new ArrayList<Boolean>();
        while ((line = reader.readLine()) != null) {
            try {
                String val;
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                int i = 0;
                if (line.charAt(i) == '$') {
                    ++i;
                    while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                        ++i;
                    }
                    int s = i;
                    while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                        ++i;
                    }
                    String cmd = line.substring(s, i);
                    while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                        ++i;
                    }
                    s = i;
                    while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                        ++i;
                    }
                    String args = line.substring(s, i);
                    if ("if".equalsIgnoreCase(cmd)) {
                        ifsStack.add(parsing);
                        if (!parsing || args.startsWith("term=")) continue;
                        if (args.startsWith("mode=")) {
                            if (args.equalsIgnoreCase("mode=vi")) {
                                parsing = this.isViEditMode();
                                continue;
                            }
                            if (args.equals("mode=emacs")) {
                                parsing = !this.isViEditMode();
                                continue;
                            }
                            parsing = false;
                            continue;
                        }
                        parsing = args.equalsIgnoreCase(appName);
                        continue;
                    }
                    if ("else".equalsIgnoreCase(cmd)) {
                        if (ifsStack.isEmpty()) {
                            throw new IllegalArgumentException("$else found without matching $if");
                        }
                        boolean invert = true;
                        Iterator iterator = ifsStack.iterator();
                        while (iterator.hasNext()) {
                            boolean b = (Boolean)iterator.next();
                            if (b) continue;
                            invert = false;
                            break;
                        }
                        if (!invert) continue;
                        parsing = !parsing;
                        continue;
                    }
                    if ("endif".equalsIgnoreCase(cmd)) {
                        if (ifsStack.isEmpty()) {
                            throw new IllegalArgumentException("endif found without matching $if");
                        }
                        parsing = (Boolean)ifsStack.remove(ifsStack.size() - 1);
                        continue;
                    }
                    if (!"include".equalsIgnoreCase(cmd)) continue;
                }
                if (!parsing) continue;
                Object keySeq = "";
                if (line.charAt(i++) == '\"') {
                    boolean esc = false;
                    while (true) {
                        if (i >= line.length()) {
                            throw new IllegalArgumentException("Missing closing quote on line '" + line + "'");
                        }
                        if (esc) {
                            esc = false;
                        } else if (line.charAt(i) == '\\') {
                            esc = true;
                        } else if (line.charAt(i) == '\"') break;
                        ++i;
                    }
                }
                while (i < line.length() && line.charAt(i) != ':' && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                    ++i;
                }
                keySeq = line.substring(0, i);
                boolean equivalency = i + 1 < line.length() && line.charAt(i) == ':' && line.charAt(i + 1) == '=';
                ++i;
                if (equivalency) {
                    ++i;
                }
                if (((String)keySeq).equalsIgnoreCase("set")) {
                    while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                        ++i;
                    }
                    int s = i;
                    while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                        ++i;
                    }
                    String key = line.substring(s, i);
                    while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                        ++i;
                    }
                    s = i;
                    while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                        ++i;
                    }
                    val = line.substring(s, i);
                    this.setVar(key, val);
                    continue;
                }
                while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                    ++i;
                }
                int start = i;
                if (i < line.length() && (line.charAt(i) == '\'' || line.charAt(i) == '\"')) {
                    char delim = line.charAt(i++);
                    boolean esc = false;
                    while (i < line.length()) {
                        if (esc) {
                            esc = false;
                        } else if (line.charAt(i) == '\\') {
                            esc = true;
                        } else if (line.charAt(i) == delim) break;
                        ++i;
                    }
                }
                while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                    ++i;
                }
                val = line.substring(Math.min(start, line.length()), Math.min(i, line.length()));
                if (((String)keySeq).charAt(0) == '\"') {
                    keySeq = this.translateQuoted((String)keySeq);
                } else {
                    String keyName = ((String)keySeq).lastIndexOf(45) > 0 ? ((String)keySeq).substring(((String)keySeq).lastIndexOf(45) + 1) : keySeq;
                    char key = this.getKeyFromName(keyName);
                    keyName = ((String)keySeq).toLowerCase();
                    keySeq = "";
                    if (keyName.contains("meta-") || keyName.contains("m-")) {
                        keySeq = (String)keySeq + "\u001b";
                    }
                    if (keyName.contains("control-") || keyName.contains("c-") || keyName.contains("ctrl-")) {
                        key = (char)(Character.toUpperCase(key) & 0x1F);
                    }
                    keySeq = (String)keySeq + key;
                }
                if (val.length() > 0 && (val.charAt(0) == '\'' || val.charAt(0) == '\"')) {
                    this.keys.bind((CharSequence)keySeq, this.translateQuoted(val));
                    continue;
                }
                String operationName = val.replace('-', '_').toUpperCase();
                try {
                    this.keys.bind((CharSequence)keySeq, (Object)Operation.valueOf(operationName));
                }
                catch (IllegalArgumentException e) {
                    Log.info("Unable to bind key for unsupported operation: ", val);
                }
            }
            catch (IllegalArgumentException e) {
                Log.warn("Unable to parse user configuration: ", e);
            }
        }
    }

    private String translateQuoted(String keySeq) {
        String str = ((String)keySeq).substring(1, ((String)keySeq).length() - 1);
        keySeq = "";
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c == 92) {
                boolean meta;
                boolean ctrl = str.regionMatches(i, "\\C-", 0, 3) || str.regionMatches(i, "\\M-\\C-", 0, 6);
                if ((i += ((meta = str.regionMatches(i, "\\M-", 0, 3) || str.regionMatches(i, "\\C-\\M-", 0, 6)) ? 3 : 0) + (ctrl ? 3 : 0) + (!meta && !ctrl ? 1 : 0)) >= str.length()) break;
                c = str.charAt(i);
                if (meta) {
                    keySeq = (String)keySeq + "\u001b";
                }
                if (ctrl) {
                    char c2 = (char)(c = (char)(c == 63 ? 127 : (char)(Character.toUpperCase((char)c) & 0x1F)));
                }
                if (!meta && !ctrl) {
                    switch (c) {
                        case 97: {
                            c = 7;
                            break;
                        }
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 100: {
                            c = 127;
                            break;
                        }
                        case 101: {
                            c = 27;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 92: {
                            c = 92;
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int k;
                            int j;
                            c = 0;
                            for (j = 0; j < 3 && i < str.length() && (k = Character.digit(str.charAt(i), 8)) >= 0; ++j, ++i) {
                                c = (char)(c * 8 + k);
                            }
                            c = (char)(c & 0xFF);
                            break;
                        }
                        case 120: {
                            int k;
                            int j;
                            ++i;
                            c = 0;
                            for (j = 0; j < 2 && i < str.length() && (k = Character.digit(str.charAt(i), 16)) >= 0; ++j, ++i) {
                                c = (char)(c * 16 + k);
                            }
                            c = (char)(c & 0xFF);
                            break;
                        }
                        case 117: {
                            int k;
                            int j;
                            ++i;
                            c = 0;
                            for (j = 0; j < 4 && i < str.length() && (k = Character.digit(str.charAt(i), 16)) >= 0; ++j, ++i) {
                                c = (char)(c * 16 + k);
                            }
                            break;
                        }
                    }
                }
                keySeq = (String)keySeq + (char)c;
                continue;
            }
            keySeq = (String)keySeq + (char)c;
        }
        return keySeq;
    }

    private char getKeyFromName(String name) {
        if ("DEL".equalsIgnoreCase(name) || "Rubout".equalsIgnoreCase(name)) {
            return '\u007f';
        }
        if ("ESC".equalsIgnoreCase(name) || "Escape".equalsIgnoreCase(name)) {
            return '\u001b';
        }
        if ("LFD".equalsIgnoreCase(name) || "NewLine".equalsIgnoreCase(name)) {
            return '\n';
        }
        if ("RET".equalsIgnoreCase(name) || "Return".equalsIgnoreCase(name)) {
            return '\r';
        }
        if ("SPC".equalsIgnoreCase(name) || "Space".equalsIgnoreCase(name)) {
            return ' ';
        }
        if ("Tab".equalsIgnoreCase(name)) {
            return '\t';
        }
        return name.charAt(0);
    }

    private void setVar(String key, String val) {
        if ("keymap".equalsIgnoreCase(key)) {
            if (this.keyMaps.containsKey(val)) {
                this.keys = this.keyMaps.get(val);
            }
        } else if ("editing-mode".equals(key)) {
            if ("vi".equalsIgnoreCase(val)) {
                this.keys = this.keyMaps.get("vi-insert");
            } else if ("emacs".equalsIgnoreCase(key)) {
                this.keys = this.keyMaps.get("emacs");
            }
        } else if ("blink-matching-paren".equals(key)) {
            if ("on".equalsIgnoreCase(val)) {
                this.keys.setBlinkMatchingParen(true);
            } else if ("off".equalsIgnoreCase(val)) {
                this.keys.setBlinkMatchingParen(false);
            }
        }
        this.variables.put(key, val);
    }

    public String getVariable(String var) {
        return this.variables.get(var);
    }
}

