/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.builders;

import java.util.Set;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.MethodWriter;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractMemberBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.XMLNode;
import jdk.javadoc.internal.doclets.toolkit.util.DocFinder;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class MethodBuilder
extends AbstractMemberBuilder {
    private ExecutableElement currentMethod;
    private final TypeElement typeElement;
    private final VisibleMemberMap visibleMemberMap;
    private final MethodWriter writer;
    private final SortedSet<Element> methods;

    private MethodBuilder(AbstractBuilder.Context context, TypeElement typeElement, MethodWriter writer) {
        super(context);
        this.typeElement = typeElement;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.METHODS, this.configuration);
        this.methods = this.visibleMemberMap.getLeafClassMembers();
    }

    public static MethodBuilder getInstance(AbstractBuilder.Context context, TypeElement typeElement, MethodWriter writer) {
        return new MethodBuilder(context, typeElement, writer);
    }

    @Override
    public String getName() {
        return "MethodDetails";
    }

    public SortedSet<Element> members(TypeElement typeElement) {
        return this.visibleMemberMap.getMembersFor(typeElement);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return !this.methods.isEmpty();
    }

    public void buildMethodDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        if (!this.methods.isEmpty()) {
            Content methodDetailsTree = this.writer.getMethodDetailsTreeHeader(this.typeElement, memberDetailsTree);
            Set<Element> methodDetailSet = ((ConfigurationImpl)this.configuration).sortedMethodDetails ? this.methods : this.visibleMemberMap.getLeafClassMembersSourceOrder();
            for (Element e : methodDetailSet) {
                this.currentMethod = (ExecutableElement)e;
                Content methodDocTree = this.writer.getMethodDocTreeHeader(this.currentMethod, methodDetailsTree);
                this.buildChildren(node, methodDocTree);
                methodDetailsTree.addContent(this.writer.getMethodDoc(methodDocTree, this.currentMethod == this.methods.last()));
            }
            memberDetailsTree.addContent(this.writer.getMethodDetails(methodDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content methodDocTree) {
        methodDocTree.addContent(this.writer.getSignature(this.currentMethod));
    }

    public void buildDeprecationInfo(XMLNode node, Content methodDocTree) {
        this.writer.addDeprecated(this.currentMethod, methodDocTree);
    }

    public void buildMethodComments(XMLNode node, Content methodDocTree) {
        if (!this.configuration.nocomment) {
            ExecutableElement method = this.currentMethod;
            if (this.utils.getBody(this.currentMethod).isEmpty()) {
                DocFinder.Output docs = DocFinder.search(this.configuration, new DocFinder.Input(this.utils, this.currentMethod));
                if (docs.inlineTags != null && !docs.inlineTags.isEmpty()) {
                    method = (ExecutableElement)docs.holder;
                }
            }
            TypeMirror containingType = method.getEnclosingElement().asType();
            this.writer.addComments(containingType, method, methodDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content methodDocTree) {
        this.writer.addTags(this.currentMethod, methodDocTree);
    }

    public MethodWriter getWriter() {
        return this.writer;
    }
}

