/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.util;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.InlineTagTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTrees;
import com.sun.source.util.SimpleDocTreeVisitor;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.internal.doclets.toolkit.Configuration;

public class CommentHelper {
    public final TreePath path;
    public final DocCommentTree dctree;
    public final Element element;
    private Element overriddenElement;
    public static final String SPACER = " ";

    public CommentHelper(Configuration configuration, Element element, TreePath path, DocCommentTree dctree) {
        this.element = element;
        this.path = path;
        this.dctree = dctree;
    }

    public void setOverrideElement(Element ove) {
        if (this.element == ove) {
            throw new AssertionError((Object)"cannot set given element as overriden element");
        }
        this.overriddenElement = ove;
    }

    public String getTagName(DocTree dtree) {
        switch (dtree.getKind()) {
            case AUTHOR: 
            case DEPRECATED: 
            case PARAM: 
            case RETURN: 
            case SEE: 
            case SERIAL_DATA: 
            case SERIAL_FIELD: 
            case THROWS: 
            case UNKNOWN_BLOCK_TAG: 
            case VERSION: {
                return ((BlockTagTree)dtree).getTagName();
            }
            case UNKNOWN_INLINE_TAG: {
                return ((InlineTagTree)dtree).getTagName();
            }
            case ERRONEOUS: {
                return "erroneous";
            }
        }
        return dtree.getKind().tagName;
    }

    public boolean isTypeParameter(DocTree dtree) {
        if (dtree.getKind() == DocTree.Kind.PARAM) {
            return ((ParamTree)dtree).isTypeParameter();
        }
        return false;
    }

    public String getParameterName(DocTree dtree) {
        if (dtree.getKind() == DocTree.Kind.PARAM) {
            return ((ParamTree)dtree).getName().toString();
        }
        return null;
    }

    Element getElement(Configuration c, ReferenceTree rtree) {
        if (this.path == null) {
            TypeMirror symbol = c.utils.getSymbol(rtree.getSignature());
            if (symbol == null) {
                return null;
            }
            return c.root.getTypeUtils().asElement(symbol);
        }
        if (this.dctree == null && this.overriddenElement != null) {
            CommentHelper ovch = c.utils.getCommentHelper(this.overriddenElement);
            return ovch.getElement(c, rtree);
        }
        if (this.dctree == null) {
            return null;
        }
        DocTreePath docTreePath = DocTreePath.getPath(this.path, this.dctree, rtree);
        if (docTreePath == null) {
            if (this.overriddenElement != null) {
                CommentHelper ovch = c.utils.getCommentHelper(this.overriddenElement);
                return ovch.getElement(c, rtree);
            }
            return null;
        }
        DocTrees doctrees = c.root.getDocTrees();
        return doctrees.getElement(docTreePath);
    }

    public Element getException(Configuration c, DocTree dtree) {
        if (dtree.getKind() == DocTree.Kind.THROWS || dtree.getKind() == DocTree.Kind.EXCEPTION) {
            ThrowsTree tt = (ThrowsTree)dtree;
            ReferenceTree exceptionName = tt.getExceptionName();
            return this.getElement(c, exceptionName);
        }
        return null;
    }

    public List<? extends DocTree> getDescription(Configuration c, DocTree dtree) {
        return this.getTags(c, dtree);
    }

    public String getText(List<? extends DocTree> list) {
        StringBuilder sb = new StringBuilder();
        for (DocTree docTree : list) {
            sb.append((CharSequence)this.getText0(docTree));
        }
        return sb.toString();
    }

    public String getText(DocTree dt) {
        return this.getText0(dt).toString();
    }

    private StringBuilder getText0(DocTree dt) {
        final StringBuilder sb = new StringBuilder();
        new SimpleDocTreeVisitor<Void, Void>(){

            @Override
            public Void visitAttribute(AttributeTree node, Void p) {
                String quote;
                sb.append(CommentHelper.SPACER).append(node.getName());
                if (node.getValueKind() == AttributeTree.ValueKind.EMPTY) {
                    return null;
                }
                sb.append("=");
                switch (node.getValueKind()) {
                    case DOUBLE: {
                        quote = "\"";
                        break;
                    }
                    case SINGLE: {
                        quote = "'";
                        break;
                    }
                    default: {
                        quote = "";
                    }
                }
                sb.append(quote);
                node.getValue().stream().forEach(dt -> dt.accept(this, null));
                sb.append(quote);
                return null;
            }

            @Override
            public Void visitEndElement(EndElementTree node, Void p) {
                sb.append("</").append(node.getName()).append(">");
                return null;
            }

            @Override
            public Void visitEntity(EntityTree node, Void p) {
                sb.append(node.toString());
                return null;
            }

            @Override
            public Void visitLink(LinkTree node, Void p) {
                if (node.getReference() == null) {
                    return null;
                }
                node.getReference().accept(this, null);
                node.getLabel().stream().forEach(dt -> dt.accept(this, null));
                return null;
            }

            @Override
            public Void visitLiteral(LiteralTree node, Void p) {
                if (node.getKind() == DocTree.Kind.CODE) {
                    sb.append("<").append(node.getKind().tagName).append(">");
                }
                sb.append(node.getBody().toString());
                if (node.getKind() == DocTree.Kind.CODE) {
                    sb.append("</").append(node.getKind().tagName).append(">");
                }
                return null;
            }

            @Override
            public Void visitReference(ReferenceTree node, Void p) {
                sb.append(node.getSignature());
                return null;
            }

            @Override
            public Void visitSee(SeeTree node, Void p) {
                node.getReference().stream().forEach(dt -> dt.accept(this, null));
                return null;
            }

            @Override
            public Void visitSerial(SerialTree node, Void p) {
                node.getDescription().stream().forEach(dt -> dt.accept(this, null));
                return null;
            }

            @Override
            public Void visitStartElement(StartElementTree node, Void p) {
                sb.append("<");
                sb.append(node.getName());
                node.getAttributes().stream().forEach(dt -> dt.accept(this, null));
                sb.append(node.isSelfClosing() ? "/>" : ">");
                return null;
            }

            @Override
            public Void visitText(TextTree node, Void p) {
                sb.append(node.getBody());
                return null;
            }

            @Override
            public Void visitUnknownBlockTag(UnknownBlockTagTree node, Void p) {
                node.getContent().stream().forEach(dt -> dt.accept(this, null));
                return null;
            }

            @Override
            public Void visitValue(ValueTree node, Void p) {
                return node.getReference().accept(this, null);
            }

            @Override
            protected Void defaultAction(DocTree node, Void p) {
                sb.append(node.toString());
                return null;
            }
        }.visit(dt, null);
        return sb;
    }

    public String getLabel(final Configuration c, DocTree dtree) {
        return (String)new SimpleDocTreeVisitor<String, Void>(){

            @Override
            public String visitLink(LinkTree node, Void p) {
                StringBuilder sb = new StringBuilder();
                node.getLabel().stream().forEach(dt -> sb.append(CommentHelper.this.getText((DocTree)dt)));
                return sb.toString();
            }

            @Override
            public String visitSee(SeeTree node, Void p) {
                StringBuilder sb = new StringBuilder();
                node.getReference().stream().filter(dt -> c2.utils.isText((DocTree)dt)).forEach(dt -> sb.append(((TextTree)dt).getBody()));
                return sb.toString();
            }

            @Override
            protected String defaultAction(DocTree node, Void p) {
                return "";
            }
        }.visit(dtree, null);
    }

    public TypeElement getReferencedClass(Configuration c, DocTree dtree) {
        Element e = this.getReferencedElement(c, dtree);
        if (e == null) {
            return null;
        }
        if (c.utils.isTypeElement(e)) {
            return (TypeElement)e;
        }
        if (!c.utils.isPackage(e)) {
            return c.utils.getEnclosingTypeElement(e);
        }
        return null;
    }

    public String getReferencedClassName(Configuration c, DocTree dtree) {
        TypeElement e = this.getReferencedClass(c, dtree);
        if (e != null) {
            return c.utils.isTypeElement(e) ? c.utils.getSimpleName(e) : null;
        }
        String s = this.getReferencedSignature(dtree);
        if (s == null) {
            return null;
        }
        int n = s.indexOf("#");
        return n == -1 ? s : s.substring(0, n);
    }

    public Element getReferencedMember(Configuration c, DocTree dtree) {
        Element e = this.getReferencedElement(c, dtree);
        if (e == null) {
            return null;
        }
        return c.utils.isExecutableElement(e) || c.utils.isVariableElement(e) ? e : null;
    }

    public String getReferencedMemberName(DocTree dtree) {
        String s = this.getReferencedSignature(dtree);
        if (s == null) {
            return null;
        }
        int n = s.indexOf("#");
        return n == -1 ? null : s.substring(n + 1);
    }

    public String getReferencedMemberName(Configuration c, Element e) {
        if (e == null) {
            return null;
        }
        return c.utils.isExecutableElement(e) ? c.utils.getSimpleName(e) + c.utils.makeSignature((ExecutableElement)e, true, true) : c.utils.getSimpleName(e);
    }

    public PackageElement getReferencedPackage(Configuration c, DocTree dtree) {
        Element e = this.getReferencedElement(c, dtree);
        if (e != null) {
            return c.utils.containingPackage(e);
        }
        return null;
    }

    public List<? extends DocTree> getFirstSentenceTrees(Configuration c, List<? extends DocTree> body) {
        List<DocTree> firstSentence = c.root.getDocTrees().getFirstSentence(body);
        return firstSentence;
    }

    public List<? extends DocTree> getFirstSentenceTrees(Configuration c, DocTree dtree) {
        return this.getFirstSentenceTrees(c, this.getBody(c, dtree));
    }

    private Element getReferencedElement(final Configuration c, DocTree dtree) {
        return (Element)new SimpleDocTreeVisitor<Element, Void>(){

            @Override
            public Element visitSee(SeeTree node, Void p) {
                Iterator<? extends DocTree> iterator = node.getReference().iterator();
                if (iterator.hasNext()) {
                    DocTree dt = iterator.next();
                    return (Element)this.visit(dt, null);
                }
                return null;
            }

            @Override
            public Element visitLink(LinkTree node, Void p) {
                return (Element)this.visit(node.getReference(), null);
            }

            @Override
            public Element visitValue(ValueTree node, Void p) {
                return (Element)this.visit(node.getReference(), null);
            }

            @Override
            public Element visitReference(ReferenceTree node, Void p) {
                return CommentHelper.this.getElement(c, node);
            }

            @Override
            public Element visitSerialField(SerialFieldTree node, Void p) {
                return (Element)this.visit(node.getType(), null);
            }

            @Override
            protected Element defaultAction(DocTree node, Void p) {
                return null;
            }
        }.visit(dtree, null);
    }

    public String getReferencedSignature(DocTree dtree) {
        return (String)new SimpleDocTreeVisitor<String, Void>(){

            @Override
            public String visitSee(SeeTree node, Void p) {
                Iterator<? extends DocTree> iterator = node.getReference().iterator();
                if (iterator.hasNext()) {
                    DocTree dt = iterator.next();
                    return (String)this.visit(dt, null);
                }
                return null;
            }

            @Override
            public String visitLink(LinkTree node, Void p) {
                return (String)this.visit(node.getReference(), null);
            }

            @Override
            public String visitValue(ValueTree node, Void p) {
                return (String)this.visit(node.getReference(), null);
            }

            @Override
            public String visitReference(ReferenceTree node, Void p) {
                return node.getSignature();
            }

            @Override
            public String visitSerialField(SerialFieldTree node, Void p) {
                return (String)this.visit(node.getType(), null);
            }

            @Override
            protected String defaultAction(DocTree node, Void p) {
                return null;
            }
        }.visit(dtree, null);
    }

    public List<? extends DocTree> getReference(DocTree dtree) {
        return dtree.getKind() == DocTree.Kind.SEE ? ((SeeTree)dtree).getReference() : null;
    }

    public ReferenceTree getExceptionName(DocTree dtree) {
        return dtree.getKind() == DocTree.Kind.THROWS || dtree.getKind() == DocTree.Kind.EXCEPTION ? ((ThrowsTree)dtree).getExceptionName() : null;
    }

    public IdentifierTree getName(DocTree dtree) {
        switch (dtree.getKind()) {
            case PARAM: {
                return ((ParamTree)dtree).getName();
            }
            case SERIAL_FIELD: {
                return ((SerialFieldTree)dtree).getName();
            }
        }
        return null;
    }

    public List<? extends DocTree> getTags(final Configuration c, DocTree dtree) {
        return (List)new SimpleDocTreeVisitor<List<? extends DocTree>, Void>(){

            List<? extends DocTree> asList(String content) {
                ArrayList<TextTree> out = new ArrayList<TextTree>();
                out.add((TextTree)c.cmtUtils.makeTextTree(content));
                return out;
            }

            @Override
            public List<? extends DocTree> visitAuthor(AuthorTree node, Void p) {
                return node.getName();
            }

            @Override
            public List<? extends DocTree> visitComment(CommentTree node, Void p) {
                return this.asList(node.getBody());
            }

            @Override
            public List<? extends DocTree> visitDeprecated(DeprecatedTree node, Void p) {
                return node.getBody();
            }

            @Override
            public List<? extends DocTree> visitDocComment(DocCommentTree node, Void p) {
                return node.getBody();
            }

            @Override
            public List<? extends DocTree> visitLiteral(LiteralTree node, Void p) {
                return this.asList(node.getBody().getBody());
            }

            @Override
            public List<? extends DocTree> visitSince(SinceTree node, Void p) {
                return node.getBody();
            }

            @Override
            public List<? extends DocTree> visitText(TextTree node, Void p) {
                return this.asList(node.getBody());
            }

            @Override
            public List<? extends DocTree> visitVersion(VersionTree node, Void p) {
                return node.getBody();
            }

            @Override
            public List<? extends DocTree> visitParam(ParamTree node, Void p) {
                return node.getDescription();
            }

            @Override
            public List<? extends DocTree> visitReturn(ReturnTree node, Void p) {
                return node.getDescription();
            }

            @Override
            public List<? extends DocTree> visitSee(SeeTree node, Void p) {
                return node.getReference();
            }

            @Override
            public List<? extends DocTree> visitSerial(SerialTree node, Void p) {
                return node.getDescription();
            }

            @Override
            public List<? extends DocTree> visitSerialData(SerialDataTree node, Void p) {
                return node.getDescription();
            }

            @Override
            public List<? extends DocTree> visitSerialField(SerialFieldTree node, Void p) {
                return node.getDescription();
            }

            @Override
            public List<? extends DocTree> visitThrows(ThrowsTree node, Void p) {
                return node.getDescription();
            }

            @Override
            public List<? extends DocTree> visitUnknownBlockTag(UnknownBlockTagTree node, Void p) {
                return node.getContent();
            }

            @Override
            protected List<? extends DocTree> defaultAction(DocTree node, Void p) {
                return Collections.emptyList();
            }
        }.visit(dtree, null);
    }

    public List<? extends DocTree> getBody(Configuration c, DocTree dtree) {
        return this.getTags(c, dtree);
    }

    public ReferenceTree getType(DocTree dtree) {
        if (dtree.getKind() == DocTree.Kind.SERIAL_FIELD) {
            return ((SerialFieldTree)dtree).getType();
        }
        return null;
    }

    public DocTreePath getDocTreePath(DocTree dtree) {
        if (this.path == null || this.dctree == null || dtree == null) {
            return null;
        }
        return DocTreePath.getPath(this.path, this.dctree, dtree);
    }

    public Element getOverriddenElement() {
        return this.overriddenElement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CommentHelper{path=" + this.path + ", dctree=" + this.dctree);
        sb.append(", element=");
        sb.append(this.element.getEnclosingElement());
        sb.append("::");
        sb.append(this.element);
        sb.append(", overriddenElement=");
        if (this.overriddenElement != null) {
            sb.append(this.overriddenElement.getEnclosingElement());
            sb.append("::");
            sb.append(this.overriddenElement);
        } else {
            sb.append("<none>");
        }
        sb.append('}');
        return sb.toString();
    }
}

