/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.lang.model.type.TypeMirror;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.TaskFactory;
import jdk.jshell.TypePrinter;
import jdk.jshell.Util;
import jdk.jshell.Wrap;

class TreeDissector {
    private static final String OBJECT_TYPE = "Object";
    private final TaskFactory.BaseTask bt;
    private final ClassTree targetClass;
    private final CompilationUnitTree targetCompilationUnit;
    private SourcePositions theSourcePositions = null;
    private static final Predicate<? super Tree> isClassOrInterface = t -> t.getKind() == Tree.Kind.CLASS || t.getKind() == Tree.Kind.INTERFACE;

    private TreeDissector(TaskFactory.BaseTask bt, CompilationUnitTree targetCompilationUnit, ClassTree targetClass) {
        this.bt = bt;
        this.targetCompilationUnit = targetCompilationUnit;
        this.targetClass = targetClass;
    }

    static TreeDissector createByFirstClass(TaskFactory.BaseTask bt) {
        Util.Pair pair = TreeDissector.classes(bt.firstCuTree()).findFirst().orElseGet(() -> new Util.Pair<CompilationUnitTree, Object>(bt.firstCuTree(), null));
        return new TreeDissector(bt, (CompilationUnitTree)pair.first, (ClassTree)pair.second);
    }

    private static Stream<Util.Pair<CompilationUnitTree, ClassTree>> classes(CompilationUnitTree cut) {
        return cut == null ? Stream.empty() : cut.getTypeDecls().stream().filter(isClassOrInterface).map(decl -> new Util.Pair<CompilationUnitTree, ClassTree>(cut, (ClassTree)decl));
    }

    private static Stream<Util.Pair<CompilationUnitTree, ClassTree>> classes(Iterable<? extends CompilationUnitTree> cuts) {
        return Util.stream(cuts).flatMap(TreeDissector::classes);
    }

    static TreeDissector createBySnippet(TaskFactory.BaseTask bt, Snippet si) {
        String name = si.className();
        Util.Pair pair = TreeDissector.classes(bt.cuTrees()).filter(p -> ((ClassTree)p.second).getSimpleName().contentEquals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Class " + name + " is not found."));
        return new TreeDissector(bt, (CompilationUnitTree)pair.first, (ClassTree)pair.second);
    }

    Types types() {
        return this.bt.types();
    }

    Trees trees() {
        return this.bt.trees();
    }

    SourcePositions getSourcePositions() {
        if (this.theSourcePositions == null) {
            this.theSourcePositions = this.trees().getSourcePositions();
        }
        return this.theSourcePositions;
    }

    int getStartPosition(Tree tree) {
        return (int)this.getSourcePositions().getStartPosition(this.targetCompilationUnit, tree);
    }

    int getEndPosition(Tree tree) {
        return (int)this.getSourcePositions().getEndPosition(this.targetCompilationUnit, tree);
    }

    Wrap.Range treeToRange(Tree tree) {
        return new Wrap.Range(this.getStartPosition(tree), this.getEndPosition(tree));
    }

    Wrap.Range treeListToRange(List<? extends Tree> treeList) {
        int start = Integer.MAX_VALUE;
        int end = -1;
        for (Tree tree : treeList) {
            int tstart = this.getStartPosition(tree);
            int tend = this.getEndPosition(tree);
            if (tstart < start) {
                start = tstart;
            }
            if (tend <= end) continue;
            end = tend;
        }
        if (start == Integer.MAX_VALUE) {
            return null;
        }
        return new Wrap.Range(start, end);
    }

    Tree firstClassMember() {
        if (this.targetClass != null) {
            for (Tree tree : this.targetClass.getMembers()) {
                MethodTree mt;
                if (tree.getKind() == Tree.Kind.VARIABLE) {
                    return tree;
                }
                if (tree.getKind() != Tree.Kind.METHOD || Util.isDoIt((mt = (MethodTree)tree).getName()) || mt.getName().toString().equals("<init>")) continue;
                return mt;
            }
        }
        return null;
    }

    StatementTree firstStatement() {
        if (this.targetClass != null) {
            for (Tree tree : this.targetClass.getMembers()) {
                List<? extends StatementTree> stmts;
                MethodTree mt;
                if (tree.getKind() != Tree.Kind.METHOD || !Util.isDoIt((mt = (MethodTree)tree).getName()) || (stmts = mt.getBody().getStatements()).isEmpty()) continue;
                return stmts.get(0);
            }
        }
        return null;
    }

    VariableTree firstVariable() {
        if (this.targetClass != null) {
            for (Tree tree : this.targetClass.getMembers()) {
                if (tree.getKind() != Tree.Kind.VARIABLE) continue;
                VariableTree vt = (VariableTree)tree;
                return vt;
            }
        }
        return null;
    }

    ExpressionInfo typeOfReturnStatement(TaskFactory.AnalyzeTask at, JShell state) {
        ExpressionInfo ei = new ExpressionInfo();
        StatementTree unitTree = this.firstStatement();
        if (unitTree instanceof ReturnTree) {
            TypeMirror tm;
            TreePath viPath;
            ei.tree = ((ReturnTree)unitTree).getExpression();
            if (ei.tree != null && (viPath = this.trees().getPath(this.targetCompilationUnit, ei.tree)) != null && (tm = this.trees().getTypeMirror(viPath)) != null) {
                ei.typeName = TreeDissector.printType(at, state, tm);
                switch (tm.getKind()) {
                    case VOID: 
                    case NONE: 
                    case ERROR: 
                    case OTHER: {
                        break;
                    }
                    case NULL: {
                        ei.isNonVoid = true;
                        ei.typeName = OBJECT_TYPE;
                        break;
                    }
                    default: {
                        ei.isNonVoid = true;
                    }
                }
            }
        }
        return ei;
    }

    String typeOfMethod() {
        Tree unitTree = this.firstClassMember();
        if (unitTree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl mtree = (JCTree.JCMethodDecl)unitTree;
            Type mt = this.types().erasure(mtree.type);
            if (mt instanceof Type.MethodType) {
                return TreeDissector.signature(this.types(), (Type.MethodType)mt);
            }
        }
        return null;
    }

    static String signature(Types types, Type.MethodType mt) {
        TDSignatureGenerator sg = new TDSignatureGenerator(types);
        sg.assembleSig(mt);
        return sg.toString();
    }

    public static String printType(TaskFactory.AnalyzeTask at, JShell state, TypeMirror type) {
        Type typeImpl = (Type)type;
        TypePrinter tp = new TypePrinter(at.messages(), state.maps::fullClassNameAndPackageToClass, typeImpl);
        return tp.visit(typeImpl, Locale.getDefault());
    }

    private static class TDSignatureGenerator
    extends Types.SignatureGenerator {
        StringBuilder sb = new StringBuilder();

        TDSignatureGenerator(Types types) {
            super(types);
        }

        @Override
        protected void append(char ch) {
            this.sb.append(ch);
        }

        @Override
        protected void append(byte[] ba) {
            this.sb.append(new String(ba));
        }

        @Override
        protected void append(Name name) {
            this.sb.append(name);
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    static class ExpressionInfo {
        boolean isNonVoid;
        String typeName;
        ExpressionTree tree;
        String signature;

        ExpressionInfo() {
        }
    }
}

