/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayTypeImpl
extends ReferenceTypeImpl
implements ArrayType {
    protected ArrayTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    public ArrayReference newInstance(int length) {
        try {
            return (ArrayReference)((Object)JDWP.ArrayType.NewInstance.process((VirtualMachineImpl)this.vm, (ArrayTypeImpl)this, (int)length).newArray);
        }
        catch (JDWPException exc) {
            throw exc.toJDIException();
        }
    }

    @Override
    public String componentSignature() {
        return this.signature().substring(1);
    }

    @Override
    public String componentTypeName() {
        JNITypeParser parser = new JNITypeParser(this.componentSignature());
        return parser.typeName();
    }

    Type type() throws ClassNotLoadedException {
        return this.findType(this.componentSignature());
    }

    @Override
    void addVisibleMethods(Map<String, Method> map, Set<InterfaceType> seenInterfaces) {
    }

    @Override
    public List<Method> allMethods() {
        return new ArrayList<Method>(0);
    }

    Type findComponentType(String signature) throws ClassNotLoadedException {
        byte tag = (byte)signature.charAt(0);
        if (PacketStream.isObjectTag(tag)) {
            JNITypeParser parser = new JNITypeParser(this.componentSignature());
            List<ReferenceType> list = this.vm.classesByName(parser.typeName());
            for (ReferenceType type : list) {
                ClassLoaderReference cl = type.classLoader();
                if (!(cl == null ? this.classLoader() == null : cl.equals(this.classLoader()))) continue;
                return type;
            }
            throw new ClassNotLoadedException(this.componentTypeName());
        }
        return this.vm.primitiveTypeMirror(tag);
    }

    @Override
    public Type componentType() throws ClassNotLoadedException {
        return this.findComponentType(this.componentSignature());
    }

    static boolean isComponentAssignable(Type destination, Type source) {
        if (source instanceof PrimitiveType) {
            return source.equals(destination);
        }
        if (destination instanceof PrimitiveType) {
            return false;
        }
        ReferenceTypeImpl refSource = (ReferenceTypeImpl)source;
        ReferenceTypeImpl refDestination = (ReferenceTypeImpl)destination;
        return refSource.isAssignableTo(refDestination);
    }

    @Override
    boolean isAssignableTo(ReferenceType destType) {
        if (destType instanceof ArrayType) {
            try {
                Type destComponentType = ((ArrayType)destType).componentType();
                return ArrayTypeImpl.isComponentAssignable(destComponentType, this.componentType());
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
        }
        if (destType instanceof InterfaceType) {
            return destType.name().equals("java.lang.Cloneable");
        }
        return destType.name().equals("java.lang.Object");
    }

    List<ReferenceType> inheritedTypes() {
        return new ArrayList<ReferenceType>(0);
    }

    @Override
    void getModifiers() {
        if (this.modifiers != -1) {
            return;
        }
        try {
            Type t = this.componentType();
            if (t instanceof PrimitiveType) {
                this.modifiers = 17;
            } else {
                ReferenceType rt = (ReferenceType)t;
                this.modifiers = rt.modifiers();
            }
        }
        catch (ClassNotLoadedException cnle) {
            cnle.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "array class " + this.name() + " (" + this.loaderString() + ")";
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public boolean isVerified() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean failedToInitialize() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return false;
    }
}

