/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.InvokableTypeImpl;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.MethodImpl;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.ValueImpl;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class InterfaceTypeImpl
extends InvokableTypeImpl
implements InterfaceType {
    private SoftReference<List<InterfaceType>> superinterfacesRef = null;

    protected InterfaceTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    @Override
    public List<InterfaceType> superinterfaces() {
        List<InterfaceType> superinterfaces;
        List<InterfaceType> list = superinterfaces = this.superinterfacesRef == null ? null : this.superinterfacesRef.get();
        if (superinterfaces == null) {
            superinterfaces = this.getInterfaces();
            superinterfaces = Collections.unmodifiableList(superinterfaces);
            this.superinterfacesRef = new SoftReference<List<InterfaceType>>(superinterfaces);
        }
        return superinterfaces;
    }

    @Override
    public List<InterfaceType> subinterfaces() {
        ArrayList<InterfaceType> subs = new ArrayList<InterfaceType>();
        for (ReferenceType refType : this.vm.allClasses()) {
            InterfaceType interfaze;
            if (!(refType instanceof InterfaceType) || !(interfaze = (InterfaceType)refType).isPrepared() || !interfaze.superinterfaces().contains(this)) continue;
            subs.add(interfaze);
        }
        return subs;
    }

    @Override
    public List<ClassType> implementors() {
        ArrayList<ClassType> implementors = new ArrayList<ClassType>();
        for (ReferenceType refType : this.vm.allClasses()) {
            ClassType clazz;
            if (!(refType instanceof ClassType) || !(clazz = (ClassType)refType).isPrepared() || !clazz.interfaces().contains(this)) continue;
            implementors.add(clazz);
        }
        return implementors;
    }

    @Override
    public boolean isInitialized() {
        return this.isPrepared();
    }

    @Override
    public String toString() {
        return "interface " + this.name() + " (" + this.loaderString() + ")";
    }

    @Override
    InvokableTypeImpl.InvocationResult waitForReply(PacketStream stream) throws JDWPException {
        return new IResult(JDWP.InterfaceType.InvokeMethod.waitForReply(this.vm, stream));
    }

    @Override
    CommandSender getInvokeMethodSender(ThreadReferenceImpl thread, MethodImpl method, ValueImpl[] args, int options) {
        return () -> JDWP.InterfaceType.InvokeMethod.enqueueCommand(this.vm, this, thread, method.ref(), args, options);
    }

    @Override
    ClassType superclass() {
        return null;
    }

    @Override
    boolean isAssignableTo(ReferenceType type) {
        if (type.name().equals("java.lang.Object")) {
            return true;
        }
        return super.isAssignableTo(type);
    }

    @Override
    List<InterfaceType> interfaces() {
        return this.superinterfaces();
    }

    @Override
    boolean canInvoke(Method method) {
        return this.equals(method.declaringType());
    }

    private static class IResult
    implements InvokableTypeImpl.InvocationResult {
        private final JDWP.InterfaceType.InvokeMethod rslt;

        public IResult(JDWP.InterfaceType.InvokeMethod rslt) {
            this.rslt = rslt;
        }

        @Override
        public ObjectReferenceImpl getException() {
            return this.rslt.exception;
        }

        @Override
        public ValueImpl getResult() {
            return this.rslt.returnValue;
        }
    }
}

