/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import java.util.ArrayList;
import java.util.List;

public class JNITypeParser {
    static final char SIGNATURE_ENDCLASS = ';';
    static final char SIGNATURE_FUNC = '(';
    static final char SIGNATURE_ENDFUNC = ')';
    private String signature;
    private List<String> typeNameList;
    private List<String> signatureList;
    private int currentIndex;

    JNITypeParser(String signature) {
        this.signature = signature;
    }

    static String typeNameToSignature(String signature) {
        int firstIndex;
        StringBuilder sb = new StringBuilder();
        int index = firstIndex = signature.indexOf(91);
        while (index != -1) {
            sb.append('[');
            index = signature.indexOf(91, index + 1);
        }
        if (firstIndex != -1) {
            signature = signature.substring(0, firstIndex);
        }
        if (signature.equals("boolean")) {
            sb.append('Z');
        } else if (signature.equals("byte")) {
            sb.append('B');
        } else if (signature.equals("char")) {
            sb.append('C');
        } else if (signature.equals("short")) {
            sb.append('S');
        } else if (signature.equals("int")) {
            sb.append('I');
        } else if (signature.equals("long")) {
            sb.append('J');
        } else if (signature.equals("float")) {
            sb.append('F');
        } else if (signature.equals("double")) {
            sb.append('D');
        } else {
            sb.append('L');
            sb.append(signature.replace('.', '/'));
            sb.append(';');
        }
        return sb.toString();
    }

    String typeName() {
        return this.typeNameList().get(this.typeNameList().size() - 1);
    }

    List<String> argumentTypeNames() {
        return this.typeNameList().subList(0, this.typeNameList().size() - 1);
    }

    String signature() {
        return this.signatureList().get(this.signatureList().size() - 1);
    }

    List<String> argumentSignatures() {
        return this.signatureList().subList(0, this.signatureList().size() - 1);
    }

    int dimensionCount() {
        int count = 0;
        String signature = this.signature();
        while (signature.charAt(count) == '[') {
            ++count;
        }
        return count;
    }

    String componentSignature(int level) {
        return this.signature().substring(level);
    }

    private synchronized List<String> signatureList() {
        if (this.signatureList == null) {
            this.signatureList = new ArrayList<String>(10);
            this.currentIndex = 0;
            while (this.currentIndex < this.signature.length()) {
                String elem = this.nextSignature();
                this.signatureList.add(elem);
            }
            if (this.signatureList.size() == 0) {
                throw new IllegalArgumentException("Invalid JNI signature '" + this.signature + "'");
            }
        }
        return this.signatureList;
    }

    private synchronized List<String> typeNameList() {
        if (this.typeNameList == null) {
            this.typeNameList = new ArrayList<String>(10);
            this.currentIndex = 0;
            while (this.currentIndex < this.signature.length()) {
                String elem = this.nextTypeName();
                this.typeNameList.add(elem);
            }
            if (this.typeNameList.size() == 0) {
                throw new IllegalArgumentException("Invalid JNI signature '" + this.signature + "'");
            }
        }
        return this.typeNameList;
    }

    private String nextSignature() {
        char key = this.signature.charAt(this.currentIndex++);
        switch (key) {
            case '[': {
                return key + this.nextSignature();
            }
            case 'L': {
                int endClass = this.signature.indexOf(59, this.currentIndex);
                String retVal = this.signature.substring(this.currentIndex - 1, endClass + 1);
                this.currentIndex = endClass + 1;
                return retVal;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return String.valueOf(key);
            }
            case '(': 
            case ')': {
                return this.nextSignature();
            }
        }
        throw new IllegalArgumentException("Invalid JNI signature character '" + key + "'");
    }

    private String nextTypeName() {
        char key = this.signature.charAt(this.currentIndex++);
        switch (key) {
            case '[': {
                return this.nextTypeName() + "[]";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'L': {
                int endClass = this.signature.indexOf(59, this.currentIndex);
                String retVal = this.signature.substring(this.currentIndex, endClass);
                retVal = retVal.replace('/', '.');
                this.currentIndex = endClass + 1;
                return retVal;
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case '(': 
            case ')': {
                return this.nextTypeName();
            }
        }
        throw new IllegalArgumentException("Invalid JNI signature character '" + key + "'");
    }
}

