/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor9;
import jdk.javadoc.internal.doclets.formats.html.AbstractMemberWriter;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.DocletConstants;

public abstract class AbstractExecutableMemberWriter
extends AbstractMemberWriter {
    public AbstractExecutableMemberWriter(SubWriterHolderWriter writer, TypeElement typeElement) {
        super(writer, typeElement);
    }

    public AbstractExecutableMemberWriter(SubWriterHolderWriter writer) {
        super(writer);
    }

    protected void addTypeParameters(ExecutableElement member, Content htmltree) {
        Content typeParameters = this.getTypeParameters(member);
        if (!typeParameters.isEmpty()) {
            htmltree.addContent(typeParameters);
            htmltree.addContent(this.writer.getSpace());
        }
    }

    protected Content getTypeParameters(ExecutableElement member) {
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER_TYPE_PARAMS, member);
        return this.writer.getTypeParameterLinks(linkInfo);
    }

    @Override
    protected Content getDeprecatedLink(Element member) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.utils.getFullyQualifiedName(member));
        if (!this.utils.isConstructor(member)) {
            sb.append(".");
            sb.append(member.getSimpleName());
        }
        sb.append(this.utils.flatSignature((ExecutableElement)member));
        return this.writer.getDocLink(LinkInfoImpl.Kind.MEMBER, member, sb);
    }

    @Override
    protected void addSummaryLink(LinkInfoImpl.Kind context, TypeElement te, Element member, Content tdSummary) {
        ExecutableElement ee = (ExecutableElement)member;
        HtmlTree memberLink = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.writer.getDocLink(context, te, (Element)ee, this.name(ee), false));
        HtmlTree code = HtmlTree.CODE(memberLink);
        this.addParameters(ee, false, code, this.name(ee).length() - 1);
        tdSummary.addContent(code);
    }

    @Override
    protected void addInheritedSummaryLink(TypeElement te, Element member, Content linksTree) {
        linksTree.addContent(this.writer.getDocLink(LinkInfoImpl.Kind.MEMBER, te, member, this.name(member), false));
    }

    protected void addParam(ExecutableElement member, VariableElement param, boolean isVarArg, Content tree) {
        Content link = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.EXECUTABLE_MEMBER_PARAM, param.asType()).varargs(isVarArg));
        tree.addContent(link);
        if (this.name(param).length() > 0) {
            tree.addContent(this.writer.getSpace());
            tree.addContent(this.name(param));
        }
    }

    protected void addReceiverAnnotations(ExecutableElement member, TypeMirror rcvrType, List<? extends AnnotationMirror> annotationMirrors, Content tree) {
        this.writer.addReceiverAnnotationInfo(member, rcvrType, annotationMirrors, tree);
        tree.addContent(this.writer.getSpace());
        tree.addContent(this.utils.getTypeName(rcvrType, false));
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.RECEIVER_TYPE, rcvrType);
        tree.addContent(this.writer.getTypeParameterLinks(linkInfo));
        tree.addContent(this.writer.getSpace());
        tree.addContent("this");
    }

    protected void addParameters(ExecutableElement member, Content htmltree, int indentSize) {
        this.addParameters(member, true, htmltree, indentSize);
    }

    protected void addParameters(ExecutableElement member, boolean includeAnnotations, Content htmltree, int indentSize) {
        boolean foundAnnotations;
        htmltree.addContent("(");
        String sep = "";
        List<? extends VariableElement> parameters = member.getParameters();
        CharSequence indent = this.makeSpace(indentSize + 1);
        TypeMirror rcvrType = member.getReceiverType();
        if (includeAnnotations && rcvrType != null && this.utils.isAnnotated(rcvrType)) {
            List<? extends AnnotationMirror> annotationMirrors = rcvrType.getAnnotationMirrors();
            this.addReceiverAnnotations(member, rcvrType, annotationMirrors, htmltree);
            sep = "," + DocletConstants.NL + indent;
        }
        for (int paramstart = 0; paramstart < parameters.size(); ++paramstart) {
            htmltree.addContent(sep);
            VariableElement param = parameters.get(paramstart);
            if (param.getKind() == ElementKind.INSTANCE_INIT) continue;
            if (includeAnnotations && (foundAnnotations = this.writer.addAnnotationInfo(indent.length(), member, param, htmltree))) {
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
            }
            this.addParam(member, param, paramstart == parameters.size() - 1 && member.isVarArgs(), htmltree);
            break;
        }
        for (int i = paramstart + 1; i < parameters.size(); ++i) {
            htmltree.addContent(",");
            htmltree.addContent(DocletConstants.NL);
            htmltree.addContent(indent);
            if (includeAnnotations && (foundAnnotations = this.writer.addAnnotationInfo(indent.length(), member, parameters.get(i), htmltree))) {
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
            }
            this.addParam(member, parameters.get(i), i == parameters.size() - 1 && member.isVarArgs(), htmltree);
        }
        htmltree.addContent(")");
    }

    protected void addExceptions(ExecutableElement member, Content htmltree, int indentSize) {
        List<? extends TypeMirror> exceptions = member.getThrownTypes();
        if (!exceptions.isEmpty()) {
            CharSequence indent = this.makeSpace(indentSize + 1 - 7);
            htmltree.addContent(DocletConstants.NL);
            htmltree.addContent(indent);
            htmltree.addContent("throws ");
            indent = this.makeSpace(indentSize + 1);
            Content link = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, exceptions.get(0)));
            htmltree.addContent(link);
            for (int i = 1; i < exceptions.size(); ++i) {
                htmltree.addContent(",");
                htmltree.addContent(DocletConstants.NL);
                htmltree.addContent(indent);
                Content exceptionLink = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, exceptions.get(i)));
                htmltree.addContent(exceptionLink);
            }
        }
    }

    protected TypeElement implementsMethodInIntfac(ExecutableElement method, List<TypeElement> intfacs) {
        for (TypeElement intf : intfacs) {
            List<ExecutableElement> methods = this.utils.getMethods(intf);
            if (methods.isEmpty()) continue;
            for (ExecutableElement md : methods) {
                if (!this.name(md).equals(this.name(method)) || !md.toString().equals(method.toString())) continue;
                return intf;
            }
        }
        return null;
    }

    protected String getErasureAnchor(ExecutableElement executableElement) {
        final StringBuilder buf = new StringBuilder(this.name(executableElement) + "(");
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean foundTypeVariable = false;
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            TypeMirror t = parameters.get(i).asType();
            SimpleTypeVisitor9<Boolean, Void> stv = new SimpleTypeVisitor9<Boolean, Void>(){
                boolean foundTypeVariable = false;

                @Override
                public Boolean visitArray(ArrayType t, Void p) {
                    this.visit(t.getComponentType());
                    buf.append(AbstractExecutableMemberWriter.this.utils.getDimension(t));
                    return this.foundTypeVariable;
                }

                @Override
                public Boolean visitTypeVariable(TypeVariable t, Void p) {
                    buf.append(AbstractExecutableMemberWriter.this.utils.asTypeElement(t).getQualifiedName());
                    this.foundTypeVariable = true;
                    return this.foundTypeVariable;
                }

                @Override
                public Boolean visitDeclared(DeclaredType t, Void p) {
                    buf.append(AbstractExecutableMemberWriter.this.utils.getQualifiedTypeName(t));
                    return this.foundTypeVariable;
                }

                @Override
                protected Boolean defaultAction(TypeMirror e, Void p) {
                    buf.append(e);
                    return this.foundTypeVariable;
                }
            };
            boolean isTypeVariable = (Boolean)stv.visit(t);
            if (foundTypeVariable) continue;
            foundTypeVariable = isTypeVariable;
        }
        buf.append(")");
        return foundTypeVariable ? this.writer.getName(buf.toString()) : null;
    }
}

