/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.internal.doclets.formats.html.AllClassesFrameWriter;
import jdk.javadoc.internal.doclets.formats.html.ClassUseWriter;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.DeprecatedListWriter;
import jdk.javadoc.internal.doclets.formats.html.FrameOutputWriter;
import jdk.javadoc.internal.doclets.formats.html.HelpWriter;
import jdk.javadoc.internal.doclets.formats.html.PackageFrameWriter;
import jdk.javadoc.internal.doclets.formats.html.PackageIndexFrameWriter;
import jdk.javadoc.internal.doclets.formats.html.PackageIndexWriter;
import jdk.javadoc.internal.doclets.formats.html.PackageTreeWriter;
import jdk.javadoc.internal.doclets.formats.html.SingleIndexWriter;
import jdk.javadoc.internal.doclets.formats.html.SourceToHTMLConverter;
import jdk.javadoc.internal.doclets.formats.html.SplitIndexWriter;
import jdk.javadoc.internal.doclets.formats.html.TreeWriter;
import jdk.javadoc.internal.doclets.toolkit.AbstractDoclet;
import jdk.javadoc.internal.doclets.toolkit.Configuration;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import jdk.javadoc.internal.doclets.toolkit.util.ClassTree;
import jdk.javadoc.internal.doclets.toolkit.util.DocFile;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import jdk.javadoc.internal.doclets.toolkit.util.IndexBuilder;

public class HtmlDoclet
extends AbstractDoclet {
    public final ConfigurationImpl configuration = new ConfigurationImpl();
    private static final DocPath DOCLET_RESOURCES = DocPath.create("/jdk/javadoc/internal/doclets/formats/html/resources");

    public void init(Locale locale, Reporter reporter) {
        this.configuration.reporter = reporter;
        this.configuration.locale = locale;
    }

    public boolean run(DocletEnvironment root) {
        return this.startDoclet(root);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    protected void generateOtherFiles(DocletEnvironment root, ClassTree classtree) throws Exception {
        DocFile f;
        super.generateOtherFiles(root, classtree);
        if (this.configuration.linksource) {
            SourceToHTMLConverter.convertRoot(this.configuration, root, DocPaths.SOURCE_OUTPUT);
        }
        if (this.configuration.topFile.isEmpty()) {
            this.configuration.standardmessage.error("doclet.No_Non_Deprecated_Classes_To_Document", new Object[0]);
            return;
        }
        boolean nodeprecated = this.configuration.nodeprecated;
        this.performCopy(this.configuration.helpfile);
        this.performCopy(this.configuration.stylesheetfile);
        if (this.configuration.classuse) {
            ClassUseWriter.generate(this.configuration, classtree);
        }
        IndexBuilder indexbuilder = new IndexBuilder(this.configuration, nodeprecated);
        if (this.configuration.createtree) {
            TreeWriter.generate(this.configuration, classtree);
        }
        if (this.configuration.createindex) {
            this.configuration.buildSearchTagIndex();
            if (this.configuration.splitindex) {
                SplitIndexWriter.generate(this.configuration, indexbuilder);
            } else {
                SingleIndexWriter.generate(this.configuration, indexbuilder);
            }
        }
        if (!this.configuration.nodeprecatedlist && !nodeprecated) {
            DeprecatedListWriter.generate(this.configuration);
        }
        AllClassesFrameWriter.generate(this.configuration, new IndexBuilder(this.configuration, nodeprecated, true));
        FrameOutputWriter.generate(this.configuration);
        if (this.configuration.createoverview) {
            PackageIndexWriter.generate(this.configuration);
        }
        if (this.configuration.helpfile.length() == 0 && !this.configuration.nohelp) {
            HelpWriter.generate(this.configuration);
        }
        if (this.configuration.stylesheetfile.length() == 0) {
            f = DocFile.createFileForOutput(this.configuration, DocPaths.STYLESHEET);
            f.copyResource(DocPaths.RESOURCES.resolve(DocPaths.STYLESHEET), false, true);
        }
        f = DocFile.createFileForOutput(this.configuration, DocPaths.JAVASCRIPT);
        f.copyResource(DocPaths.RESOURCES.resolve(DocPaths.JAVASCRIPT), true, true);
        if (this.configuration.createindex) {
            f = DocFile.createFileForOutput(this.configuration, DocPaths.SEARCH_JS);
            f.copyResource(DOCLET_RESOURCES.resolve(DocPaths.SEARCH_JS), true, true);
            f = DocFile.createFileForOutput(this.configuration, DocPaths.RESOURCES.resolve(DocPaths.GLASS_IMG));
            f.copyResource(DOCLET_RESOURCES.resolve(DocPaths.GLASS_IMG), true, false);
            f = DocFile.createFileForOutput(this.configuration, DocPaths.RESOURCES.resolve(DocPaths.X_IMG));
            f.copyResource(DOCLET_RESOURCES.resolve(DocPaths.X_IMG), true, false);
            this.copyJqueryFiles();
        }
    }

    protected void copyJqueryFiles() {
        List<String> files = Arrays.asList("jquery-1.10.2.js", "jquery-ui.js", "jquery-ui.css", "jquery-ui.min.js", "jquery-ui.min.css", "jquery-ui.structure.min.css", "jquery-ui.structure.css", "external/jquery/jquery.js", "jszip/dist/jszip.js", "jszip/dist/jszip.min.js", "jszip-utils/dist/jszip-utils.js", "jszip-utils/dist/jszip-utils.min.js", "jszip-utils/dist/jszip-utils-ie.js", "jszip-utils/dist/jszip-utils-ie.min.js", "images/ui-bg_flat_0_aaaaaa_40x100.png", "images/ui-icons_454545_256x240.png", "images/ui-bg_glass_95_fef1ec_1x400.png", "images/ui-bg_glass_75_dadada_1x400.png", "images/ui-bg_highlight-soft_75_cccccc_1x100.png", "images/ui-icons_888888_256x240.png", "images/ui-icons_2e83ff_256x240.png", "images/ui-bg_glass_65_ffffff_1x400.png", "images/ui-icons_cd0a0a_256x240.png", "images/ui-bg_glass_55_fbf9ee_1x400.png", "images/ui-icons_222222_256x240.png", "images/ui-bg_glass_75_e6e6e6_1x400.png", "images/ui-bg_flat_75_ffffff_40x100.png");
        for (String file : files) {
            DocPath filePath = DocPaths.JQUERY_FILES.resolve(file);
            DocFile f = DocFile.createFileForOutput(this.configuration, filePath);
            f.copyResource(DOCLET_RESOURCES.resolve(filePath), true, false);
        }
    }

    @Override
    protected void generateClassFiles(SortedSet<TypeElement> arr, ClassTree classtree) {
        ArrayList<TypeElement> list = new ArrayList<TypeElement>(arr);
        ListIterator iterator = list.listIterator();
        TypeElement klass = null;
        while (iterator.hasNext()) {
            TypeElement next;
            TypeElement prev = iterator.hasPrevious() ? klass : null;
            klass = (TypeElement)iterator.next();
            TypeElement typeElement = next = iterator.nextIndex() == list.size() ? null : (TypeElement)list.get(iterator.nextIndex());
            if (!this.configuration.isGeneratedDoc(klass) || !this.utils.isIncluded(klass)) continue;
            try {
                if (this.utils.isAnnotationType(klass)) {
                    AbstractBuilder annotationTypeBuilder = this.configuration.getBuilderFactory().getAnnotationTypeBuilder(klass, prev == null ? null : prev.asType(), next == null ? null : next.asType());
                    annotationTypeBuilder.build();
                    continue;
                }
                AbstractBuilder classBuilder = this.configuration.getBuilderFactory().getClassBuilder(klass, prev, next, classtree);
                classBuilder.build();
            }
            catch (IOException e) {
                throw new DocletAbortException(e);
            }
            catch (DocletAbortException de) {
                throw de;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DocletAbortException(e);
            }
        }
    }

    @Override
    protected void generatePackageFiles(ClassTree classtree) throws Exception {
        SortedSet packages = this.configuration.packages;
        if (packages.size() > 1) {
            PackageIndexFrameWriter.generate(this.configuration);
        }
        ArrayList pList = new ArrayList(packages);
        PackageElement prev = null;
        for (int i = 0; i < pList.size(); ++i) {
            PackageElement pkg = (PackageElement)pList.get(i);
            if (this.configuration.nodeprecated && this.utils.isDeprecated(pkg)) continue;
            PackageFrameWriter.generate(this.configuration, pkg);
            int nexti = i + 1;
            PackageElement next = null;
            if (nexti < pList.size() && (next = (PackageElement)pList.get(nexti)).isUnnamed() && ++nexti < pList.size()) {
                next = (PackageElement)pList.get(nexti);
            }
            AbstractBuilder packageSummaryBuilder = this.configuration.getBuilderFactory().getPackageSummaryBuilder(pkg, prev, next);
            packageSummaryBuilder.build();
            if (this.configuration.createtree) {
                PackageTreeWriter.generate(this.configuration, pkg, prev, next, this.configuration.nodeprecated);
            }
            prev = pkg;
        }
    }

    public Set<Doclet.Option> getSupportedOptions() {
        return this.configuration.getSupportedOptions();
    }

    private void performCopy(String filename) {
        if (filename.isEmpty()) {
            return;
        }
        try {
            DocFile fromfile = DocFile.createFileForInput(this.configuration, filename);
            DocPath path = DocPath.create(fromfile.getName());
            DocFile toFile = DocFile.createFileForOutput(this.configuration, path);
            if (toFile.isSameFile(fromfile)) {
                return;
            }
            this.configuration.message.notice("doclet.Copying_File_0_To_File_1", fromfile.toString(), path.getPath());
            toFile.copyFile(fromfile);
        }
        catch (IOException exc) {
            this.configuration.message.error("doclet.perform_copy_exception_encountered", exc.toString());
            throw new DocletAbortException(exc);
        }
    }
}

