/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.doclint.DocLint;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.JavaFileObject;
import jdk.javadoc.internal.doclets.toolkit.Configuration;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import jdk.javadoc.internal.tool.DocEnv;
import jdk.javadoc.internal.tool.RootDocImpl;

public class WorkArounds {
    public final Configuration configuration;
    public final DocEnv env;
    public final Utils utils;
    private DocLint doclint;
    Map<CompilationUnitTree, Boolean> shouldCheck = new HashMap<CompilationUnitTree, Boolean>();
    private static final Map<TypeElement, NewSerializedForm> serializedForms = new HashMap<TypeElement, NewSerializedForm>();

    public WorkArounds(Configuration configuration) {
        this.configuration = configuration;
        this.utils = this.configuration.utils;
        this.env = ((RootDocImpl)this.configuration.root).env;
    }

    public void runDocLint(TreePath path) {
        CompilationUnitTree unit = path.getCompilationUnit();
        if (this.doclint != null) {
            if (this.shouldCheck.computeIfAbsent(unit, this.doclint::shouldCheck).booleanValue()) {
                this.doclint.scan(path);
            }
        }
    }

    public void initDocLint(Collection<String> opts, Collection<String> customTagNames, String htmlVersion) {
        ArrayList<String> doclintOpts = new ArrayList<String>();
        boolean msgOptionSeen = false;
        for (String opt : opts) {
            if (opt.startsWith("-Xmsgs")) {
                if (opt.equals("-Xmsgs:none")) {
                    return;
                }
                msgOptionSeen = true;
            }
            doclintOpts.add(opt);
        }
        if (!msgOptionSeen) {
            doclintOpts.add("-Xmsgs");
        }
        String sep = "";
        StringBuilder customTags = new StringBuilder();
        for (String customTag : customTagNames) {
            customTags.append(sep);
            customTags.append(customTag);
            sep = ",";
        }
        doclintOpts.add("-XcustomTags:" + customTags.toString());
        doclintOpts.add("-XhtmlVersion:" + htmlVersion);
        JavacTask t = BasicJavacTask.instance(this.env.context);
        this.doclint = new DocLint();
        doclintOpts.add("-XimplicitHeaders:2");
        this.doclint.init(t, doclintOpts.toArray(new String[doclintOpts.size()]), false);
    }

    public boolean haveDocLint() {
        return this.doclint == null;
    }

    public java.util.List<TypeMirror> interfaceTypesOf(TypeMirror type) {
        List<Type> interfaces = ((RootDocImpl)this.configuration.root).env.getTypes().interfaces((Type)type);
        if (interfaces.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeMirror> list = new ArrayList<TypeMirror>(interfaces.size());
        for (Type t : interfaces) {
            list.add(t);
        }
        return list;
    }

    public boolean isDeprecated0(Element e) {
        if (!this.utils.getDeprecatedTrees(e).isEmpty()) {
            return true;
        }
        JavacTypes jctypes = ((RootDocImpl)this.configuration.root).env.typeutils;
        TypeMirror deprecatedType = this.utils.getDeprecatedType();
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!jctypes.isSameType(annotationMirror.getAnnotationType().asElement().asType(), deprecatedType)) continue;
            return true;
        }
        return false;
    }

    public boolean isSynthesized(AnnotationMirror aDesc) {
        return ((Attribute)((Object)aDesc)).isSynthesized();
    }

    public boolean isVisible(TypeElement te) {
        return this.env.isVisible((Symbol.ClassSymbol)te);
    }

    public Object getConstValue(VariableElement ve) {
        return ((Symbol.VarSymbol)ve).getConstValue();
    }

    public Map<Element, TreePath> getElementToTreePath() {
        return this.env.elementToTreePath;
    }

    public TypeElement searchClass(TypeElement klass, String className) {
        TypeElement te = this.configuration.root.getElementUtils().getTypeElement(className);
        if (te != null) {
            return te;
        }
        for (TypeElement ite : this.utils.getClasses(klass)) {
            TypeElement innerClass = this.searchClass(ite, className);
            if (innerClass == null) continue;
            return innerClass;
        }
        te = this.utils.findClassInPackageElement(this.utils.containingPackage(klass), className);
        if (te != null) {
            return te;
        }
        Symbol.ClassSymbol tsym = (Symbol.ClassSymbol)klass;
        if (tsym.completer != null) {
            tsym.complete();
        }
        if (tsym.sourcefile != null) {
            Env<AttrContext> compenv = this.env.getEnv(tsym);
            if (compenv == null) {
                return null;
            }
            Names names = tsym.name.table.names;
            Scope.ImportScope s = compenv.toplevel.namedImportScope;
            for (Symbol sym : s.getSymbolsByName(names.fromString(className))) {
                if (sym.kind != Kinds.Kind.TYP) continue;
                return (TypeElement)((Object)sym);
            }
            s = compenv.toplevel.starImportScope;
            for (Symbol sym : s.getSymbolsByName(names.fromString(className))) {
                if (sym.kind != Kinds.Kind.TYP) continue;
                return (TypeElement)((Object)sym);
            }
        }
        return null;
    }

    public TypeMirror overriddenType(ExecutableElement method) {
        if (this.utils.isStatic(method)) {
            return null;
        }
        Symbol.MethodSymbol sym = (Symbol.MethodSymbol)method;
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)sym.owner;
        Type t = this.env.getTypes().supertype(origin.type);
        while (t.hasTag(TypeTag.CLASS)) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)t.tsym;
            for (Symbol sym2 : c.members().getSymbolsByName(sym.name)) {
                if (!sym.overrides(sym2, origin, this.env.getTypes(), true)) continue;
                return t;
            }
            t = this.env.getTypes().supertype(t);
        }
        return null;
    }

    public boolean shouldDocument(Element e) {
        return this.env.shouldDocument(e);
    }

    public SortedSet<VariableElement> getSerializableFields(Utils utils, TypeElement klass) {
        NewSerializedForm sf = serializedForms.get(klass);
        if (sf == null) {
            sf = new NewSerializedForm(utils, this.configuration.root.getElementUtils(), klass);
            serializedForms.put(klass, sf);
        }
        return sf.fields;
    }

    public SortedSet<ExecutableElement> getSerializationMethods(Utils utils, TypeElement klass) {
        NewSerializedForm sf = serializedForms.get(klass);
        if (sf == null) {
            sf = new NewSerializedForm(utils, this.configuration.root.getElementUtils(), klass);
            serializedForms.put(klass, sf);
        }
        return sf.methods;
    }

    public boolean definesSerializableFields(Utils utils, TypeElement klass) {
        if (!utils.isSerializable(klass) || utils.isExternalizable(klass)) {
            return false;
        }
        NewSerializedForm sf = serializedForms.get(klass);
        if (sf == null) {
            sf = new NewSerializedForm(utils, this.configuration.root.getElementUtils(), klass);
            serializedForms.put(klass, sf);
        }
        return sf.definesSerializableFields;
    }

    public JavaFileObject getJavaFileObject(PackageElement pe) {
        return this.env.pkgToJavaFOMap.get(pe);
    }

    static class NewSerializedForm {
        final Utils utils;
        final Elements elements;
        final SortedSet<ExecutableElement> methods;
        final SortedSet<VariableElement> fields;
        boolean definesSerializableFields = false;
        private static final String SERIALIZABLE_FIELDS = "serialPersistentFields";
        private static final String READOBJECT = "readObject";
        private static final String WRITEOBJECT = "writeObject";
        private static final String READRESOLVE = "readResolve";
        private static final String WRITEREPLACE = "writeReplace";
        private static final String READOBJECTNODATA = "readObjectNoData";

        NewSerializedForm(Utils utils, Elements elements, TypeElement te) {
            this.utils = utils;
            this.elements = elements;
            this.methods = new TreeSet<Element>(utils.makeGeneralPurposeComparator());
            this.fields = new TreeSet<Element>(utils.makeGeneralPurposeComparator());
            if (utils.isExternalizable(te)) {
                String[] readExternalParamArr = new String[]{"java.io.ObjectInput"};
                String[] writeExternalParamArr = new String[]{"java.io.ObjectOutput"};
                ExecutableElement md = this.findMethod(te, "readExternal", Arrays.asList(readExternalParamArr));
                if (md != null) {
                    this.methods.add(md);
                }
                if ((md = this.findMethod((Symbol.ClassSymbol)te, "writeExternal", Arrays.asList(writeExternalParamArr))) != null) {
                    this.methods.add(md);
                }
            } else if (utils.isSerializable(te)) {
                Symbol.VarSymbol dsf = this.getDefinedSerializableFields((Symbol.ClassSymbol)te);
                if (dsf != null) {
                    this.definesSerializableFields = true;
                    this.fields.add(dsf);
                } else {
                    this.computeDefaultSerializableFields((Symbol.ClassSymbol)te);
                }
                this.addMethodIfExist((Symbol.ClassSymbol)te, READOBJECT);
                this.addMethodIfExist((Symbol.ClassSymbol)te, WRITEOBJECT);
                this.addMethodIfExist((Symbol.ClassSymbol)te, READRESOLVE);
                this.addMethodIfExist((Symbol.ClassSymbol)te, WRITEREPLACE);
                this.addMethodIfExist((Symbol.ClassSymbol)te, READOBJECTNODATA);
            }
        }

        private Symbol.VarSymbol getDefinedSerializableFields(Symbol.ClassSymbol def) {
            Names names = def.name.table.names;
            for (Symbol sym : def.members().getSymbolsByName(names.fromString(SERIALIZABLE_FIELDS))) {
                Symbol.VarSymbol f;
                if (sym.kind != Kinds.Kind.VAR || ((f = (Symbol.VarSymbol)sym).flags() & 8L) == 0L || (f.flags() & 2L) == 0L) continue;
                return f;
            }
            return null;
        }

        private void addMethodIfExist(Symbol.ClassSymbol def, String methodName) {
            Names names = def.name.table.names;
            for (Symbol sym : def.members().getSymbolsByName(names.fromString(methodName))) {
                Symbol.MethodSymbol md;
                if (sym.kind != Kinds.Kind.MTH || ((md = (Symbol.MethodSymbol)sym).flags() & 8L) != 0L) continue;
                this.methods.add(md);
            }
        }

        private void computeDefaultSerializableFields(Symbol.ClassSymbol te) {
            for (Symbol sym : te.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                Symbol.VarSymbol f;
                if (sym == null || sym.kind != Kinds.Kind.VAR || ((f = (Symbol.VarSymbol)sym).flags() & 8L) != 0L || (f.flags() & 0x80L) != 0L) continue;
                this.fields.add(f);
            }
        }

        public ExecutableElement findMethod(TypeElement te, String methodName, java.util.List<String> paramTypes) {
            TypeElement encl;
            java.util.List<? extends Element> allMembers = this.elements.getAllMembers(te);
            block0: for (Element element : allMembers) {
                ExecutableElement ee;
                if (element.getKind() != ElementKind.METHOD || !(ee = (ExecutableElement)element).getSimpleName().contentEquals(methodName)) continue;
                java.util.List<? extends VariableElement> parameters = ee.getParameters();
                if (paramTypes.size() != parameters.size()) continue;
                for (int i = 0; i < parameters.size(); ++i) {
                    VariableElement ve = parameters.get(i);
                    if (!ve.asType().toString().equals(paramTypes.get(i))) break block0;
                }
                return ee;
            }
            if ((encl = this.utils.getEnclosingTypeElement(te)) == null) {
                return null;
            }
            return this.findMethod(encl, methodName, paramTypes);
        }
    }
}

