/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.util;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.ref.SoftReference;
import java.text.CollationKey;
import java.text.Collator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementKindVisitor9;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import javax.lang.model.util.TypeKindVisitor9;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import jdk.javadoc.internal.doclets.toolkit.CommentUtils;
import jdk.javadoc.internal.doclets.toolkit.Configuration;
import jdk.javadoc.internal.doclets.toolkit.WorkArounds;
import jdk.javadoc.internal.doclets.toolkit.util.CommentHelper;
import jdk.javadoc.internal.doclets.toolkit.util.DocFile;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import jdk.javadoc.internal.doclets.toolkit.util.DocletConstants;

public class Utils {
    public final Configuration configuration;
    public final DocTrees docTrees;
    public final Elements elementUtils;
    public final Types typeUtils;
    private HashMap<String, TypeMirror> symtab = new HashMap();
    private final Map<String, String> typeNameMap = new HashMap<String, String>();
    private DocCollator tertiaryCollator = null;
    private DocCollator secondaryCollator = null;
    private Set<TypeElement> specifiedClasses = null;
    private Set<PackageElement> specifiedPackages = null;
    private final HashMap<Element, SortedSet<TypeElement>> cachedClasses = new HashMap();
    EnumSet<ElementKind> nestedKinds = EnumSet.of(ElementKind.ANNOTATION_TYPE, ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE);
    private final Map<Element, String> nameCache = new LinkedHashMap<Element, String>();
    private SimpleElementVisitor9<String, Void> snvisitor = null;
    private ConstantValueExpression cve = null;
    private final WeakSoftHashMap wksMap = new WeakSoftHashMap(this);
    private final Map<Element, CommentUtils.DocCommentDuo> dcTreeCache = new LinkedHashMap<Element, CommentUtils.DocCommentDuo>();

    public Utils(Configuration c) {
        this.configuration = c;
        this.elementUtils = c.root.getElementUtils();
        this.typeUtils = c.root.getTypeUtils();
        this.docTrees = c.root.getDocTrees();
    }

    public TypeMirror getSymbol(String signature) {
        TypeMirror type = this.symtab.get(signature);
        if (type == null) {
            TypeElement typeElement = this.elementUtils.getTypeElement(signature);
            if (typeElement == null) {
                return null;
            }
            type = typeElement.asType();
            if (type == null) {
                return null;
            }
            this.symtab.put(signature, type);
        }
        return type;
    }

    public TypeMirror getObjectType() {
        return this.getSymbol("java.lang.Object");
    }

    public TypeMirror getExceptionType() {
        return this.getSymbol("java.lang.Exception");
    }

    public TypeMirror getErrorType() {
        return this.getSymbol("java.lang.Error");
    }

    public TypeMirror getSerializableType() {
        return this.getSymbol("java.io.Serializable");
    }

    public TypeMirror getExternalizableType() {
        return this.getSymbol("java.io.Externalizable");
    }

    public TypeMirror getIllegalArgumentExceptionType() {
        return this.getSymbol("java.lang.IllegalArgumentException");
    }

    public TypeMirror getNullPointerExceptionType() {
        return this.getSymbol("java.lang.NullPointerException");
    }

    public TypeMirror getDeprecatedType() {
        return this.getSymbol("java.lang.Deprecated");
    }

    public TypeMirror getFunctionalInterface() {
        return this.getSymbol("java.lang.FunctionalInterface");
    }

    public List<Element> excludeDeprecatedMembers(List<? extends Element> members) {
        List excludeList = members.stream().filter(member -> !this.isDeprecated((Element)member)).sorted(this.makeGeneralPurposeComparator()).collect(Collectors.toCollection(ArrayList::new));
        return excludeList;
    }

    public ExecutableElement findMethod(TypeElement te, ExecutableElement method) {
        for (Element element : this.getMethods(te)) {
            if (!this.executableMembersEqual(method, (ExecutableElement)element)) continue;
            return (ExecutableElement)element;
        }
        return null;
    }

    public boolean isSubclassOf(TypeElement t1, TypeElement t2) {
        return this.typeUtils.isSubtype(t1.asType(), t2.asType());
    }

    public boolean executableMembersEqual(ExecutableElement e1, ExecutableElement e2) {
        if (this.isStatic(e1) && this.isStatic(e2)) {
            List<? extends VariableElement> parameters1 = e1.getParameters();
            List<? extends VariableElement> parameters2 = e2.getParameters();
            if (e1.getSimpleName().equals(e2.getSimpleName()) && parameters1.size() == parameters2.size()) {
                int j;
                for (j = 0; j < parameters1.size(); ++j) {
                    String t2;
                    VariableElement v1 = parameters1.get(j);
                    VariableElement v2 = parameters2.get(j);
                    String t1 = this.getTypeName(v1.asType(), true);
                    if (!t1.equals(t2 = this.getTypeName(v2.asType(), true)) && !this.isTypeVariable(v1.asType()) && !this.isTypeVariable(v2.asType())) break;
                }
                if (j == parameters1.size()) {
                    return true;
                }
            }
            return false;
        }
        return this.elementUtils.overrides(e1, e2, this.getEnclosingTypeElement(e1)) || this.elementUtils.overrides(e2, e1, this.getEnclosingTypeElement(e2)) || e1.equals(e2);
    }

    public boolean isCoreClass(TypeElement e) {
        return this.getEnclosingTypeElement(e) == null || this.isStatic(e);
    }

    public boolean matches(Element e1, Element e2) {
        if (this.isExecutableElement(e1) && this.isExecutableElement(e1)) {
            return this.executableMembersEqual((ExecutableElement)e1, (ExecutableElement)e2);
        }
        return e1.getSimpleName().equals(e2.getSimpleName());
    }

    public void copyDocFiles(PackageElement pe) {
        this.copyDocFiles(DocPath.forPackage(pe).resolve(DocPaths.DOC_FILES));
    }

    public void copyDocFiles(DocPath dir) {
        try {
            boolean first = true;
            for (DocFile f : DocFile.list(this.configuration, StandardLocation.SOURCE_PATH, dir)) {
                DocFile destdir;
                DocFile srcdir;
                if (!f.isDirectory() || (srcdir = f).isSameFile(destdir = DocFile.createFileForOutput(this.configuration, dir))) continue;
                for (DocFile srcfile : srcdir.list()) {
                    DocFile destfile = destdir.resolve(srcfile.getName());
                    if (srcfile.isFile()) {
                        if (destfile.exists() && !first) {
                            this.configuration.message.warning("doclet.Copy_Overwrite_warning", srcfile.getPath(), destdir.getPath());
                            continue;
                        }
                        this.configuration.message.notice("doclet.Copying_File_0_To_Dir_1", srcfile.getPath(), destdir.getPath());
                        destfile.copyFile(srcfile);
                        continue;
                    }
                    if (!srcfile.isDirectory() || !this.configuration.copydocfilesubdirs || this.configuration.shouldExcludeDocFileDir(srcfile.getName())) continue;
                    this.copyDocFiles(dir.resolve(srcfile.getName()));
                }
                first = false;
            }
        }
        catch (IOException | SecurityException exc) {
            throw new DocletAbortException(exc);
        }
    }

    public boolean isAnnotated(TypeMirror e) {
        return !e.getAnnotationMirrors().isEmpty();
    }

    public boolean isAnnotated(Element e) {
        return !e.getAnnotationMirrors().isEmpty();
    }

    public boolean isAnnotationType(Element e) {
        return (Boolean)new SimpleElementVisitor9<Boolean, Void>(){

            @Override
            public Boolean visitExecutable(ExecutableElement e, Void p) {
                return (Boolean)this.visit(e.getEnclosingElement());
            }

            @Override
            public Boolean visitUnknown(Element e, Void p) {
                return false;
            }

            @Override
            protected Boolean defaultAction(Element e, Void p) {
                return e.getKind() == ElementKind.ANNOTATION_TYPE;
            }
        }.visit(e);
    }

    public boolean isClass(Element e) {
        return e.getKind().isClass();
    }

    public boolean isConstructor(Element e) {
        return e.getKind() == ElementKind.CONSTRUCTOR;
    }

    public boolean isEnum(Element e) {
        return e.getKind() == ElementKind.ENUM;
    }

    boolean isEnumConstant(Element e) {
        return e.getKind() == ElementKind.ENUM_CONSTANT;
    }

    public boolean isField(Element e) {
        return e.getKind() == ElementKind.FIELD;
    }

    public boolean isInterface(Element e) {
        return e.getKind() == ElementKind.INTERFACE;
    }

    public boolean isMethod(Element e) {
        return e.getKind() == ElementKind.METHOD;
    }

    public boolean isPackage(Element e) {
        return e.getKind() == ElementKind.PACKAGE;
    }

    public boolean isAbstract(Element e) {
        return e.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isDefault(Element e) {
        return e.getModifiers().contains((Object)Modifier.DEFAULT);
    }

    public boolean isPackagePrivate(Element e) {
        return !this.isPublic(e) && !this.isPrivate(e) && !this.isProtected(e);
    }

    public boolean isPrivate(Element e) {
        return e.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    public boolean isProtected(Element e) {
        return e.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    public boolean isPublic(Element e) {
        return e.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isProperty(String name) {
        return this.configuration.javafx && name.endsWith("Property");
    }

    public String getPropertyName(String name) {
        return this.isProperty(name) ? name.substring(0, name.length() - "Property".length()) : name;
    }

    public String getPropertyLabel(String name) {
        return name.substring(0, name.lastIndexOf("Property"));
    }

    public boolean isOverviewElement(Element e) {
        return e.getKind() == ElementKind.OTHER;
    }

    public boolean isStatic(Element e) {
        return e.getModifiers().contains((Object)Modifier.STATIC);
    }

    public boolean isSerializable(TypeElement e) {
        return this.typeUtils.isSubtype(e.asType(), this.getSerializableType());
    }

    public boolean isExternalizable(TypeElement e) {
        return this.typeUtils.isSubtype(e.asType(), this.getExternalizableType());
    }

    public SortedSet<VariableElement> serializableFields(TypeElement aclass) {
        return this.configuration.workArounds.getSerializableFields(this, aclass);
    }

    public SortedSet<ExecutableElement> serializationMethods(TypeElement aclass) {
        return this.configuration.workArounds.getSerializationMethods(this, aclass);
    }

    public boolean definesSerializableFields(TypeElement aclass) {
        return this.configuration.workArounds.definesSerializableFields(this, aclass);
    }

    public String modifiersToString(Element e, final boolean trailingSpace) {
        final TreeSet<Modifier> set = new TreeSet<Modifier>(e.getModifiers());
        set.remove((Object)Modifier.NATIVE);
        set.remove((Object)Modifier.STRICTFP);
        set.remove((Object)Modifier.SYNCHRONIZED);
        return (String)new ElementKindVisitor9<String, SortedSet<Modifier>>(){
            final StringBuilder sb = new StringBuilder();

            void addVisibilityModifier(Set<Modifier> modifiers) {
                if (modifiers.contains((Object)Modifier.PUBLIC)) {
                    this.sb.append("public").append(" ");
                } else if (modifiers.contains((Object)Modifier.PROTECTED)) {
                    this.sb.append("protected").append(" ");
                } else if (modifiers.contains((Object)Modifier.PRIVATE)) {
                    this.sb.append("private").append(" ");
                }
            }

            void addStatic(Set<Modifier> modifiers) {
                if (modifiers.contains((Object)Modifier.STATIC)) {
                    this.sb.append("static").append(" ");
                }
            }

            void addModifers(Set<Modifier> modifiers) {
                String s = set.stream().map(m -> m.toString()).collect(Collectors.joining(" "));
                this.sb.append(s);
                if (!s.isEmpty()) {
                    this.sb.append(" ");
                }
            }

            String finalString(String s) {
                this.sb.append(s);
                if (trailingSpace) {
                    if (this.sb.lastIndexOf(" ") == this.sb.length() - 1) {
                        return this.sb.toString();
                    }
                    return this.sb.append(" ").toString();
                }
                return this.sb.toString().trim();
            }

            @Override
            public String visitTypeAsInterface(TypeElement e, SortedSet<Modifier> p) {
                this.addVisibilityModifier(p);
                this.addStatic(p);
                return this.finalString("interface");
            }

            @Override
            public String visitTypeAsEnum(TypeElement e, SortedSet<Modifier> p) {
                this.addVisibilityModifier(p);
                this.addStatic(p);
                return this.finalString("enum");
            }

            @Override
            public String visitTypeAsAnnotationType(TypeElement e, SortedSet<Modifier> p) {
                this.addVisibilityModifier(p);
                this.addStatic(p);
                return this.finalString("@interface");
            }

            @Override
            public String visitTypeAsClass(TypeElement e, SortedSet<Modifier> p) {
                this.addModifers(p);
                return this.finalString("class");
            }

            @Override
            protected String defaultAction(Element e, SortedSet<Modifier> p) {
                this.addModifers(p);
                return this.sb.toString().trim();
            }
        }.visit(e, set);
    }

    public boolean isFunctionalInterface(AnnotationMirror amirror) {
        return amirror.getAnnotationType().equals(this.getFunctionalInterface()) && this.configuration.root.getSourceVersion().compareTo(SourceVersion.RELEASE_8) >= 0;
    }

    public boolean isNoType(TypeMirror t) {
        return t.getKind() == TypeKind.NONE;
    }

    public boolean isOrdinaryClass(TypeElement te) {
        if (this.isEnum(te) || this.isInterface(te) || this.isAnnotationType(te)) {
            return false;
        }
        return !this.isError(te) && !this.isException(te);
    }

    public boolean isError(TypeElement te) {
        if (this.isEnum(te) || this.isInterface(te) || this.isAnnotationType(te)) {
            return false;
        }
        return this.typeUtils.isSubtype(te.asType(), this.getErrorType());
    }

    public boolean isException(TypeElement te) {
        if (this.isEnum(te) || this.isInterface(te) || this.isAnnotationType(te)) {
            return false;
        }
        return this.typeUtils.isSubtype(te.asType(), this.getExceptionType());
    }

    public boolean isPrimitive(TypeMirror t) {
        return (Boolean)new SimpleTypeVisitor9<Boolean, Void>(){

            @Override
            public Boolean visitNoType(NoType t, Void p) {
                return t.getKind() == TypeKind.VOID;
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Void p) {
                return true;
            }

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return (Boolean)this.visit(t.getComponentType());
            }

            @Override
            protected Boolean defaultAction(TypeMirror e, Void p) {
                return false;
            }
        }.visit(t);
    }

    public boolean isExecutableElement(Element e) {
        ElementKind kind = e.getKind();
        switch (kind) {
            case CONSTRUCTOR: 
            case METHOD: 
            case INSTANCE_INIT: {
                return true;
            }
        }
        return false;
    }

    public boolean isVariableElement(Element e) {
        ElementKind kind = e.getKind();
        switch (kind) {
            case ENUM_CONSTANT: 
            case EXCEPTION_PARAMETER: 
            case FIELD: 
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case RESOURCE_VARIABLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isTypeElement(Element e) {
        switch (e.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                return true;
            }
        }
        return false;
    }

    public String signature(ExecutableElement e) {
        return this.makeSignature(e, true);
    }

    public String flatSignature(ExecutableElement e) {
        return this.makeSignature(e, false);
    }

    public String makeSignature(ExecutableElement e, boolean full) {
        return this.makeSignature(e, full, false);
    }

    public String makeSignature(ExecutableElement e, boolean full, boolean ignoreTypeParameters) {
        StringBuilder result = new StringBuilder();
        result.append("(");
        Iterator<? extends VariableElement> iterator = e.getParameters().iterator();
        while (iterator.hasNext()) {
            VariableElement next = iterator.next();
            TypeMirror type = next.asType();
            result.append(this.getTypeSignature(type, full, ignoreTypeParameters));
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        if (e.isVarArgs()) {
            int len = result.length();
            result.replace(len - 2, len, "...");
        }
        result.append(")");
        return result.toString();
    }

    private String getTypeSignature(TypeMirror t, final boolean qualifiedName, final boolean noTypeParameters) {
        return ((StringBuilder)new SimpleTypeVisitor9<StringBuilder, Void>(){
            final StringBuilder sb = new StringBuilder();

            @Override
            public StringBuilder visitArray(ArrayType t, Void p) {
                TypeMirror componentType = t.getComponentType();
                this.visit(componentType);
                this.sb.append("[]");
                return this.sb;
            }

            @Override
            public StringBuilder visitDeclared(DeclaredType t, Void p) {
                Element e = t.asElement();
                this.sb.append(qualifiedName ? Utils.this.getFullyQualifiedName(e) : Utils.this.getSimpleName(e));
                List<? extends TypeMirror> typeArguments = t.getTypeArguments();
                if (typeArguments.isEmpty() || noTypeParameters) {
                    return this.sb;
                }
                this.sb.append("<");
                Iterator<? extends TypeMirror> iterator = typeArguments.iterator();
                while (iterator.hasNext()) {
                    TypeMirror ta = iterator.next();
                    this.visit(ta);
                    if (!iterator.hasNext()) continue;
                    this.sb.append(", ");
                }
                this.sb.append(">");
                return this.sb;
            }

            @Override
            public StringBuilder visitTypeVariable(TypeVariable t, Void p) {
                Element e = t.asElement();
                this.sb.append(qualifiedName ? Utils.this.getFullyQualifiedName(e, false) : Utils.this.getSimpleName(e));
                return this.sb;
            }

            @Override
            public StringBuilder visitWildcard(WildcardType t, Void p) {
                TypeMirror superBound;
                this.sb.append("?");
                TypeMirror upperBound = t.getExtendsBound();
                if (upperBound != null) {
                    this.sb.append(" extends ");
                    this.visit(upperBound);
                }
                if ((superBound = t.getSuperBound()) != null) {
                    this.sb.append(" super ");
                    this.visit(superBound);
                }
                return this.sb;
            }

            @Override
            protected StringBuilder defaultAction(TypeMirror e, Void p) {
                return this.sb.append(e);
            }
        }.visit(t)).toString();
    }

    public boolean isArrayType(TypeMirror t) {
        return t.getKind() == TypeKind.ARRAY;
    }

    public boolean isDeclaredType(TypeMirror t) {
        return t.getKind() == TypeKind.DECLARED;
    }

    public boolean isErrorType(TypeMirror t) {
        return t.getKind() == TypeKind.ERROR;
    }

    public boolean isIntersectionType(TypeMirror t) {
        return t.getKind() == TypeKind.INTERSECTION;
    }

    public boolean isTypeParameterElement(Element e) {
        return e.getKind() == ElementKind.TYPE_PARAMETER;
    }

    public boolean isTypeVariable(TypeMirror t) {
        return t.getKind() == TypeKind.TYPEVAR;
    }

    public boolean isVoid(TypeMirror t) {
        return t.getKind() == TypeKind.VOID;
    }

    public boolean isWildCard(TypeMirror t) {
        return t.getKind() == TypeKind.WILDCARD;
    }

    public boolean ignoreBounds(TypeMirror bound) {
        return bound.equals(this.getObjectType()) && !this.isAnnotated(bound);
    }

    public List<? extends TypeMirror> getBounds(TypeParameterElement tpe) {
        TypeMirror upperBound;
        List<? extends TypeMirror> bounds = tpe.getBounds();
        if (!bounds.isEmpty() && this.ignoreBounds(upperBound = bounds.get(bounds.size() - 1))) {
            return Collections.emptyList();
        }
        return bounds;
    }

    public TypeMirror getReturnType(ExecutableElement ee) {
        return ee.getKind() == ElementKind.CONSTRUCTOR ? null : ee.getReturnType();
    }

    public TypeMirror overriddenType(ExecutableElement method) {
        return this.configuration.workArounds.overriddenType(method);
    }

    private TypeMirror getType(TypeMirror t) {
        return this.isNoType(t) ? this.getObjectType() : t;
    }

    public TypeMirror getSuperType(TypeElement te) {
        TypeMirror t = te.getSuperclass();
        return this.getType(t);
    }

    public TypeElement overriddenClass(ExecutableElement ee) {
        TypeMirror type = this.overriddenType(ee);
        return type != null ? this.asTypeElement(type) : null;
    }

    public ExecutableElement overriddenMethod(ExecutableElement method) {
        if (this.isStatic(method)) {
            return null;
        }
        TypeElement origin = this.getEnclosingTypeElement(method);
        TypeMirror t = this.getSuperType(origin);
        while (t.getKind() == TypeKind.DECLARED) {
            TypeElement te = this.asTypeElement(t);
            if (te == null) {
                return null;
            }
            List<? extends Element> methods = te.getEnclosedElements();
            for (ExecutableElement ee : ElementFilter.methodsIn(methods)) {
                if (!this.elementUtils.overrides(method, ee, origin)) continue;
                return ee;
            }
            if (t.equals(this.getObjectType())) {
                return null;
            }
            t = this.getSuperType(this.asTypeElement(t));
        }
        return null;
    }

    public SortedSet<TypeElement> getTypeElementsAsSortedSet(Iterable<TypeElement> typeElements) {
        TreeSet<Element> set = new TreeSet<Element>(this.makeGeneralPurposeComparator());
        for (TypeElement te : typeElements) {
            set.add(te);
        }
        return set;
    }

    public List<? extends DocTree> getSerialDataTrees(ExecutableElement member) {
        return this.getBlockTags((Element)member, DocTree.Kind.SERIAL_DATA);
    }

    public FileObject getFileObject(TypeElement te) {
        return this.docTrees.getPath(te).getCompilationUnit().getSourceFile();
    }

    public TypeMirror getDeclaredType(TypeElement enclosing, TypeMirror target) {
        return this.getDeclaredType(Collections.emptyList(), enclosing, target);
    }

    public TypeMirror getDeclaredType(Collection<TypeMirror> values, TypeElement enclosing, TypeMirror target) {
        TypeElement targetElement = this.asTypeElement(target);
        List<? extends TypeParameterElement> targetTypeArgs = targetElement.getTypeParameters();
        if (targetTypeArgs.isEmpty()) {
            return target;
        }
        List<? extends TypeParameterElement> enclosingTypeArgs = enclosing.getTypeParameters();
        ArrayList<TypeMirror> targetTypeArgTypes = new ArrayList<TypeMirror>(targetTypeArgs.size());
        if (enclosingTypeArgs.isEmpty()) {
            for (TypeMirror te : values) {
                List<? extends TypeMirror> typeArguments = ((DeclaredType)te).getTypeArguments();
                if (typeArguments.size() < targetTypeArgs.size()) continue;
                for (int i = 0; i < targetTypeArgs.size(); ++i) {
                    targetTypeArgTypes.add(typeArguments.get(i));
                }
            }
            if (targetTypeArgTypes.isEmpty()) {
                return target;
            }
        } else {
            if (targetTypeArgs.size() > enclosingTypeArgs.size()) {
                return target;
            }
            for (int i = 0; i < targetTypeArgs.size(); ++i) {
                TypeParameterElement tpe = enclosingTypeArgs.get(i);
                targetTypeArgTypes.add(tpe.asType());
            }
        }
        DeclaredType dt = this.typeUtils.getDeclaredType(targetElement, targetTypeArgTypes.toArray(new TypeMirror[targetTypeArgTypes.size()]));
        return dt;
    }

    public Set<TypeMirror> getAllInterfaces(TypeElement te) {
        LinkedHashSet<TypeMirror> results = new LinkedHashSet<TypeMirror>();
        List<? extends TypeMirror> interfaceTypes = te.getInterfaces();
        for (TypeMirror typeMirror : interfaceTypes) {
            TypeElement intfc = this.asTypeElement(typeMirror);
            if (!this.isPublic(intfc) && !this.isLinkable(intfc)) continue;
            results.add(typeMirror);
            TypeElement klass = this.asTypeElement(typeMirror);
            for (TypeMirror t : this.getAllInterfaces(klass)) {
                t = this.getDeclaredType(results, te, t);
                results.add(t);
            }
        }
        TypeMirror superType = this.getSuperType(te);
        if (superType == this.getObjectType()) {
            return results;
        }
        this.addAllInterfaceTypes(results, te, superType, this.configuration.workArounds.interfaceTypesOf(superType));
        return results;
    }

    private void findAllInterfaceTypes(Set<TypeMirror> results, TypeElement baseClass, TypeMirror p) {
        TypeMirror superType = this.getSuperType(this.asTypeElement(p));
        if (superType == p) {
            return;
        }
        this.addAllInterfaceTypes(results, baseClass, superType, this.configuration.workArounds.interfaceTypesOf(superType));
    }

    private void addAllInterfaceTypes(Set<TypeMirror> results, TypeElement baseClass, TypeMirror type, List<TypeMirror> interfaceTypes) {
        for (TypeMirror interfaceType : interfaceTypes) {
            TypeElement iElement = this.asTypeElement(interfaceType);
            if (!this.isPublic(iElement) || !this.isLinkable(iElement)) continue;
            interfaceType = this.getDeclaredType(results, baseClass, interfaceType);
            results.add(interfaceType);
            Set<TypeMirror> superInterfaces = this.getAllInterfaces(iElement);
            for (TypeMirror superInterface : superInterfaces) {
                superInterface = this.getDeclaredType(results, baseClass, superInterface);
                results.add(superInterface);
            }
        }
        this.findAllInterfaceTypes(results, baseClass, type);
    }

    public TypeElement findClassInPackageElement(PackageElement pkg, String className) {
        for (TypeElement c : this.getAllClasses(pkg)) {
            if (!this.getSimpleName(c).equals(className)) continue;
            return c;
        }
        return null;
    }

    public TypeElement findClass(Element element, String className) {
        TypeElement encl = this.getEnclosingTypeElement(element);
        TypeElement searchResult = this.configuration.workArounds.searchClass(encl, className);
        if (searchResult == null) {
            encl = this.getEnclosingTypeElement(encl);
            while (encl != null && this.getEnclosingTypeElement(encl) != null) {
                encl = this.getEnclosingTypeElement(encl);
            }
            searchResult = encl == null ? null : this.configuration.workArounds.searchClass(encl, className);
        }
        return searchResult;
    }

    public String quote(String filepath) {
        return "\"" + filepath + "\"";
    }

    public String parsePackageName(PackageElement p) {
        String pkgname = p.isUnnamed() ? "" : this.getPackageName(p);
        int index = -1;
        for (int j = 0; j < 2; ++j) {
            index = pkgname.indexOf(".", index + 1);
        }
        if (index != -1) {
            pkgname = pkgname.substring(0, index);
        }
        return pkgname;
    }

    public String replaceText(String originalStr, String oldStr, String newStr) {
        if (oldStr == null || newStr == null || oldStr.equals(newStr)) {
            return originalStr;
        }
        return originalStr.replace(oldStr, newStr);
    }

    public boolean isDocumentedAnnotation(TypeElement annotation) {
        for (AnnotationMirror annotationMirror : annotation.getAnnotationMirrors()) {
            if (!this.getFullyQualifiedName(annotationMirror.getAnnotationType().asElement()).equals(Documented.class.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isLinkable(TypeElement typeElem) {
        return typeElem != null && this.isIncluded(typeElem) && this.configuration.isGeneratedDoc(typeElem) || this.configuration.extern.isExternal(typeElem) && (this.isPublic(typeElem) || this.isProtected(typeElem));
    }

    List<TypeMirror> asErasureTypes(Collection<TypeElement> inList) {
        ArrayList<TypeMirror> out = new ArrayList<TypeMirror>(inList.size());
        inList.stream().forEach(te -> out.add(this.typeUtils.erasure(te.asType())));
        return out;
    }

    List<TypeMirror> asTypes(Collection<TypeElement> inList) {
        ArrayList<TypeMirror> out = new ArrayList<TypeMirror>(inList.size());
        inList.stream().forEach(te -> out.add(te.asType()));
        return out;
    }

    public TypeElement asTypeElement(TypeMirror t) {
        return (TypeElement)new SimpleTypeVisitor9<TypeElement, Void>(){

            @Override
            public TypeElement visitDeclared(DeclaredType t, Void p) {
                return (TypeElement)t.asElement();
            }

            @Override
            public TypeElement visitArray(ArrayType t, Void p) {
                return (TypeElement)this.visit(t.getComponentType());
            }

            @Override
            public TypeElement visitTypeVariable(TypeVariable t, Void p) {
                if (Utils.this.isAnnotated(t)) {
                    return (TypeElement)this.visit(Utils.this.typeUtils.asElement(t).asType());
                }
                return (TypeElement)this.visit(Utils.this.typeUtils.erasure(t));
            }

            @Override
            public TypeElement visitWildcard(WildcardType t, Void p) {
                return (TypeElement)this.visit(Utils.this.typeUtils.erasure(t));
            }

            @Override
            public TypeElement visitError(ErrorType t, Void p) {
                return (TypeElement)t.asElement();
            }

            @Override
            protected TypeElement defaultAction(TypeMirror e, Void p) {
                return (TypeElement)super.defaultAction(e, p);
            }
        }.visit(t);
    }

    public TypeMirror getComponentType(TypeMirror t) {
        while (this.isArrayType(t)) {
            t = ((ArrayType)t).getComponentType();
        }
        return t;
    }

    public String getDimension(TypeMirror t) {
        return (String)new SimpleTypeVisitor9<String, Void>(){
            StringBuilder dimension = new StringBuilder("");

            @Override
            public String visitArray(ArrayType t, Void p) {
                this.dimension.append("[]");
                return (String)this.visit(t.getComponentType());
            }

            @Override
            protected String defaultAction(TypeMirror e, Void p) {
                return this.dimension.toString();
            }
        }.visit(t);
    }

    public TypeElement getSuperClass(TypeElement te) {
        if (this.isInterface(te) || this.isAnnotationType(te) || te.asType().equals(this.getObjectType())) {
            return null;
        }
        TypeMirror superclass = te.getSuperclass();
        if (this.isNoType(superclass) && this.isClass(te)) {
            superclass = this.getObjectType();
        }
        return this.asTypeElement(superclass);
    }

    public TypeElement getFirstVisibleSuperClassAsTypeElement(TypeElement te) {
        if (this.isAnnotationType(te) || this.isInterface(te) || te.asType().equals(this.getObjectType())) {
            return null;
        }
        TypeMirror firstVisibleSuperClass = this.getFirstVisibleSuperClass(te);
        return firstVisibleSuperClass == null ? null : this.asTypeElement(firstVisibleSuperClass);
    }

    public TypeMirror getFirstVisibleSuperClass(TypeMirror type) {
        return this.getFirstVisibleSuperClass(this.asTypeElement(type));
    }

    public TypeMirror getFirstVisibleSuperClass(TypeElement te) {
        TypeMirror supersuperType;
        TypeElement supersuperClass;
        TypeMirror superType = te.getSuperclass();
        if (this.isNoType(superType)) {
            superType = this.getObjectType();
        }
        TypeElement superClass = this.asTypeElement(superType);
        while (!(superClass == null || this.isPublic(superClass) || this.isLinkable(superClass) || (supersuperClass = this.asTypeElement(supersuperType = superClass.getSuperclass())) == null || supersuperClass.getQualifiedName().equals(superClass.getQualifiedName()))) {
            superType = supersuperType;
            superClass = supersuperClass;
        }
        if (te.asType().equals(superType)) {
            return null;
        }
        return superType;
    }

    public String getTypeElementName(TypeElement te, boolean lowerCaseOnly) {
        String typeName = "";
        if (this.isInterface(te)) {
            typeName = "doclet.Interface";
        } else if (this.isException(te)) {
            typeName = "doclet.Exception";
        } else if (this.isError(te)) {
            typeName = "doclet.Error";
        } else if (this.isAnnotationType(te)) {
            typeName = "doclet.AnnotationType";
        } else if (this.isEnum(te)) {
            typeName = "doclet.Enum";
        } else if (this.isOrdinaryClass(te)) {
            typeName = "doclet.Class";
        }
        typeName = lowerCaseOnly ? Utils.toLowerCase(typeName) : typeName;
        return this.typeNameMap.computeIfAbsent(typeName, this.configuration::getText);
    }

    public String getTypeName(TypeMirror t, final boolean fullyQualified) {
        return (String)new SimpleTypeVisitor9<String, Void>(){

            @Override
            public String visitArray(ArrayType t, Void p) {
                return (String)this.visit(t.getComponentType());
            }

            @Override
            public String visitDeclared(DeclaredType t, Void p) {
                TypeElement te = Utils.this.asTypeElement(t);
                return fullyQualified ? te.getQualifiedName().toString() : Utils.this.getSimpleName(te);
            }

            @Override
            public String visitExecutable(ExecutableType t, Void p) {
                return t.toString();
            }

            @Override
            public String visitPrimitive(PrimitiveType t, Void p) {
                return t.toString();
            }

            @Override
            public String visitTypeVariable(TypeVariable t, Void p) {
                return Utils.this.getSimpleName(t.asElement());
            }

            @Override
            public String visitWildcard(WildcardType t, Void p) {
                return t.toString();
            }

            @Override
            protected String defaultAction(TypeMirror e, Void p) {
                return e.toString();
            }
        }.visit(t);
    }

    public String replaceTabs(String text) {
        if (!text.contains("\t")) {
            return text;
        }
        int tabLength = this.configuration.sourcetab;
        String whitespace = this.configuration.tabSpaces;
        int textLength = text.length();
        StringBuilder result = new StringBuilder(textLength);
        int pos = 0;
        int lineLength = 0;
        block4: for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    lineLength = 0;
                    continue block4;
                }
                case '\t': {
                    result.append(text, pos, i);
                    int spaceCount = tabLength - lineLength % tabLength;
                    result.append(whitespace, 0, spaceCount);
                    lineLength += spaceCount;
                    pos = i + 1;
                    continue block4;
                }
                default: {
                    ++lineLength;
                }
            }
        }
        result.append(text, pos, textLength);
        return result.toString();
    }

    public CharSequence normalizeNewlines(CharSequence text) {
        StringBuilder sb = new StringBuilder();
        int textLength = text.length();
        String NL = DocletConstants.NL;
        int pos = 0;
        block4: for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append(text, pos, i);
                    sb.append(NL);
                    pos = i + 1;
                    continue block4;
                }
                case '\r': {
                    sb.append(text, pos, i);
                    sb.append(NL);
                    if (i + 1 < textLength && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    pos = i + 1;
                }
            }
        }
        sb.append(text, pos, textLength);
        return sb;
    }

    public void setEnumDocumentation(TypeElement elem) {
        for (Element element : this.getMethods(elem)) {
            ExecutableElement ee = (ExecutableElement)element;
            if (!this.getBody(element).isEmpty()) continue;
            if (ee.getSimpleName().contentEquals("values") && ee.getParameters().isEmpty()) {
                this.configuration.cmtUtils.setEnumValuesTree(this.configuration, element);
            }
            if (!ee.getSimpleName().contentEquals("valueOf") || ee.getParameters().size() != 1) continue;
            this.configuration.cmtUtils.setEnumValueOfTree(this.configuration, element);
        }
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase(Locale.US);
    }

    public boolean isDeprecated(Element e) {
        if (this.isPackage(e)) {
            return this.configuration.workArounds.isDeprecated0(e);
        }
        return this.elementUtils.isDeprecated(e);
    }

    public String propertyName(ExecutableElement e) {
        String name = this.getSimpleName(e);
        String propertyName = null;
        if (name.startsWith("get") || name.startsWith("set")) {
            propertyName = name.substring(3);
        } else if (name.startsWith("is")) {
            propertyName = name.substring(2);
        }
        if (propertyName == null || propertyName.isEmpty()) {
            return "";
        }
        return propertyName.substring(0, 1).toLowerCase(this.configuration.getLocale()) + propertyName.substring(1);
    }

    public SortedSet<TypeElement> filterOutPrivateClasses(Iterable<TypeElement> classlist, boolean javafx) {
        TreeSet<Element> filteredOutClasses = new TreeSet<Element>(this.makeGeneralPurposeComparator());
        if (!javafx) {
            for (Element element : classlist) {
                filteredOutClasses.add((TypeElement)element);
            }
            return filteredOutClasses;
        }
        for (Element element : classlist) {
            List<? extends DocTree> aspTags;
            if (this.isPrivate(element) || this.isPackagePrivate(element) || (aspTags = this.getBlockTags(element, "treatAsPrivate")) != null && !aspTags.isEmpty()) continue;
            filteredOutClasses.add((TypeElement)element);
        }
        return filteredOutClasses;
    }

    public boolean elementsEqual(Element e1, Element e2) {
        String s2;
        if (e1.getKind() != e2.getKind()) {
            return false;
        }
        String s1 = this.getSimpleName(e1);
        if (this.compareStrings(s1, s2 = this.getSimpleName(e2)) == 0) {
            String f2;
            String f1 = this.getFullyQualifiedName(e1, true);
            return this.compareStrings(f1, f2 = this.getFullyQualifiedName(e2, true)) == 0;
        }
        return false;
    }

    public int compareStrings(String s1, String s2) {
        return this.compareStrings(true, s1, s2);
    }

    public int compareCaseCompare(String s1, String s2) {
        return this.compareStrings(false, s1, s2);
    }

    private int compareStrings(boolean caseSensitive, String s1, String s2) {
        if (caseSensitive) {
            if (this.tertiaryCollator == null) {
                this.tertiaryCollator = new DocCollator(this.configuration.locale, 2);
            }
            return this.tertiaryCollator.compare(s1, s2);
        }
        if (this.secondaryCollator == null) {
            this.secondaryCollator = new DocCollator(this.configuration.locale, 1);
        }
        return this.secondaryCollator.compare(s1, s2);
    }

    public Comparator<Element> makePackageComparator() {
        return new ElementComparator<Element>(){

            @Override
            public int compare(Element pkg1, Element pkg2) {
                return this.compareFullyQualifiedNames(pkg1, pkg2);
            }
        };
    }

    public Comparator<SerialFieldTree> makeSerialFieldTreeComparator() {
        return (o1, o2) -> {
            String s1 = o1.getName().toString();
            String s2 = o2.getName().toString();
            return s1.compareTo(s2);
        };
    }

    public Comparator<Element> makeGeneralPurposeComparator() {
        return this.makeClassUseComparator();
    }

    public Comparator<Element> makeOverrideUseComparator() {
        return new ElementComparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                int result = Utils.this.compareStrings(Utils.this.getSimpleName(o1), Utils.this.getSimpleName(o2));
                if (result != 0) {
                    return result;
                }
                if (!(Utils.this.isTypeElement(o1) || Utils.this.isTypeElement(o2) || Utils.this.isPackage(o1) || Utils.this.isPackage(o2))) {
                    TypeElement t1 = Utils.this.getEnclosingTypeElement(o1);
                    TypeElement t2 = Utils.this.getEnclosingTypeElement(o2);
                    result = Utils.this.compareStrings(Utils.this.getSimpleName(t1), Utils.this.getSimpleName(t2));
                    if (result != 0) {
                        return result;
                    }
                }
                if ((result = Utils.this.compareStrings(Utils.this.getFullyQualifiedName(o1), Utils.this.getFullyQualifiedName(o2))) != 0) {
                    return result;
                }
                return this.compareElementTypeKinds(o1, o2);
            }
        };
    }

    public Comparator<Element> makeIndexUseComparator() {
        return new ElementComparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                int result = this.compareElementTypeKinds(e1, e2);
                if (result != 0) {
                    return result;
                }
                if (Utils.this.isPackage(e1) && Utils.this.isPackage(e2)) {
                    return this.compareFullyQualifiedNames(e1, e2);
                }
                result = this.compareNames(e1, e2);
                if (result != 0) {
                    return result;
                }
                if (this.hasParameters(e1)) {
                    List<? extends VariableElement> parameters2;
                    List<? extends VariableElement> parameters1 = ((ExecutableElement)e1).getParameters();
                    result = this.compareParameters(false, parameters1, parameters2 = ((ExecutableElement)e2).getParameters());
                    if (result != 0) {
                        return result;
                    }
                    result = this.compareParameters(true, parameters1, parameters2);
                    if (result != 0) {
                        return result;
                    }
                }
                return this.compareFullyQualifiedNames(e1, e2);
            }
        };
    }

    public Comparator<TypeMirror> makeTypeMirrorClassUseComparator() {
        return (type1, type2) -> {
            String s1 = this.getQualifiedTypeName((TypeMirror)type1);
            String s2 = this.getQualifiedTypeName((TypeMirror)type2);
            return this.compareStrings(s1, s2);
        };
    }

    public Comparator<TypeMirror> makeTypeMirrorIndexUseComparator() {
        return (t1, t2) -> {
            int result = this.compareStrings(this.getTypeName((TypeMirror)t1, false), this.getTypeName((TypeMirror)t2, false));
            if (result != 0) {
                return result;
            }
            return this.compareStrings(this.getQualifiedTypeName((TypeMirror)t1), this.getQualifiedTypeName((TypeMirror)t2));
        };
    }

    public String getQualifiedTypeName(TypeMirror t) {
        return (String)new SimpleTypeVisitor9<String, Void>(){

            @Override
            public String visitDeclared(DeclaredType t, Void p) {
                return Utils.this.getFullyQualifiedName(t.asElement());
            }

            @Override
            public String visitArray(ArrayType t, Void p) {
                return (String)this.visit(t.getComponentType());
            }

            @Override
            public String visitPrimitive(PrimitiveType t, Void p) {
                return t.toString();
            }

            @Override
            public String visitTypeVariable(TypeVariable t, Void p) {
                return t.toString();
            }

            @Override
            protected String defaultAction(TypeMirror e, Void p) {
                throw new UnsupportedOperationException("should not happen");
            }
        }.visit(t);
    }

    public String getFullyQualifiedName(Element e) {
        return this.getFullyQualifiedName(e, true);
    }

    public String getFullyQualifiedName(Element e, final boolean outer) {
        return (String)new SimpleElementVisitor9<String, Void>(){

            @Override
            public String visitPackage(PackageElement e, Void p) {
                return e.getQualifiedName().toString();
            }

            @Override
            public String visitType(TypeElement e, Void p) {
                return e.getQualifiedName().toString();
            }

            @Override
            protected String defaultAction(Element e, Void p) {
                return outer ? (String)this.visit(e.getEnclosingElement()) : e.getSimpleName().toString();
            }
        }.visit(e);
    }

    public Comparator<Element> makeClassUseComparator() {
        return new ElementComparator<Element>(){

            @Override
            public int compare(Element e1, Element e2) {
                int result = this.compareNames(e1, e2);
                if (result != 0) {
                    return result;
                }
                result = this.compareFullyQualifiedNames(e1, e2);
                if (result != 0) {
                    return result;
                }
                if (this.hasParameters(e1) && this.hasParameters(e2)) {
                    List<? extends VariableElement> parameters2;
                    List<? extends VariableElement> parameters1 = ((ExecutableElement)e1).getParameters();
                    result = this.compareParameters(false, parameters1, parameters2 = ((ExecutableElement)e2).getParameters());
                    if (result != 0) {
                        return result;
                    }
                    result = this.compareParameters(true, parameters1, parameters2);
                }
                if (result != 0) {
                    return result;
                }
                return this.compareElementTypeKinds(e1, e2);
            }
        };
    }

    public Iterable<TypeElement> getEnclosedTypeElements(PackageElement pkg) {
        List<TypeElement> out = this.getInterfaces(pkg);
        out.addAll(this.getClasses(pkg));
        out.addAll(this.getEnums(pkg));
        out.addAll(this.getAnnotationTypes(pkg));
        return out;
    }

    public List<Element> getAnnotationMembers(TypeElement aClass) {
        List<Element> members = this.getAnnotationFields(aClass);
        members.addAll(this.getAnnotationMethods(aClass));
        return members;
    }

    public List<Element> getAnnotationFields(TypeElement aClass) {
        return this.getItems0((Element)aClass, true, ElementKind.FIELD);
    }

    List<Element> getAnnotationFieldsUnfiltered(TypeElement aClass) {
        return this.getItems0((Element)aClass, true, ElementKind.FIELD);
    }

    public List<Element> getAnnotationMethods(TypeElement aClass) {
        return this.getItems0((Element)aClass, true, ElementKind.METHOD);
    }

    public List<TypeElement> getAnnotationTypes(Element e) {
        return this.convertToTypeElement(this.getItems(e, true, ElementKind.ANNOTATION_TYPE));
    }

    public List<TypeElement> getAnnotationTypesUnfiltered(Element e) {
        return this.convertToTypeElement(this.getItems(e, false, ElementKind.ANNOTATION_TYPE));
    }

    public List<VariableElement> getFields(Element e) {
        return this.convertToVariableElement(this.getItems(e, true, ElementKind.FIELD));
    }

    public List<VariableElement> getFieldsUnfiltered(Element e) {
        return this.convertToVariableElement(this.getItems(e, false, ElementKind.FIELD));
    }

    public List<TypeElement> getClasses(Element e) {
        return this.convertToTypeElement(this.getItems(e, true, ElementKind.CLASS));
    }

    public List<TypeElement> getClassesUnfiltered(Element e) {
        return this.convertToTypeElement(this.getItems(e, false, ElementKind.CLASS));
    }

    public List<ExecutableElement> getConstructors(Element e) {
        return this.convertToExecutableElement(this.getItems(e, true, ElementKind.CONSTRUCTOR));
    }

    public List<ExecutableElement> getMethods(Element e) {
        return this.convertToExecutableElement(this.getItems(e, true, ElementKind.METHOD));
    }

    List<ExecutableElement> getMethodsUnfiltered(Element e) {
        return this.convertToExecutableElement(this.getItems(e, false, ElementKind.METHOD));
    }

    public long getLineNumber(Element e) {
        TreePath path = this.getTreePath(e);
        if (path == null) {
            TypeElement encl = this.getEnclosingTypeElement(e);
            path = this.getTreePath(encl);
        }
        CompilationUnitTree cu = path.getCompilationUnit();
        LineMap lineMap = cu.getLineMap();
        DocSourcePositions spos = this.docTrees.getSourcePositions();
        long pos = spos.getStartPosition(cu, path.getLeaf());
        return lineMap.getLineNumber(pos);
    }

    public List<ExecutableElement> convertToExecutableElement(List<Element> list) {
        ArrayList<ExecutableElement> out = new ArrayList<ExecutableElement>(list.size());
        for (Element e : list) {
            out.add((ExecutableElement)e);
        }
        return out;
    }

    public List<TypeElement> convertToTypeElement(List<Element> list) {
        ArrayList<TypeElement> out = new ArrayList<TypeElement>(list.size());
        for (Element e : list) {
            out.add((TypeElement)e);
        }
        return out;
    }

    public List<VariableElement> convertToVariableElement(List<Element> list) {
        ArrayList<VariableElement> out = new ArrayList<VariableElement>(list.size());
        for (Element e : list) {
            out.add((VariableElement)e);
        }
        return out;
    }

    public List<TypeElement> getInterfaces(Element e) {
        return this.convertToTypeElement(this.getItems(e, true, ElementKind.INTERFACE));
    }

    public List<TypeElement> getInterfacesUnfiltered(Element e) {
        return this.convertToTypeElement(this.getItems(e, false, ElementKind.INTERFACE));
    }

    List<Element> getNestedClasses(TypeElement e) {
        ArrayList<Element> result = new ArrayList<Element>();
        this.recursiveGetItems(result, e, true, ElementKind.CLASS);
        return result;
    }

    List<Element> getNestedClassesUnfiltered(TypeElement e) {
        ArrayList<Element> result = new ArrayList<Element>();
        this.recursiveGetItems(result, e, false, ElementKind.CLASS);
        return result;
    }

    public List<Element> getEnumConstants(Element e) {
        return this.getItems(e, true, ElementKind.ENUM_CONSTANT);
    }

    public List<TypeElement> getEnums(Element e) {
        return this.convertToTypeElement(this.getItems(e, true, ElementKind.ENUM));
    }

    public List<TypeElement> getEnumsUnfiltered(Element e) {
        return this.convertToTypeElement(this.getItems(e, false, ElementKind.ENUM));
    }

    public SortedSet<TypeElement> getAllClassesUnfiltered(Element e) {
        List<TypeElement> clist = this.getClassesUnfiltered(e);
        clist.addAll(this.getInterfacesUnfiltered(e));
        clist.addAll(this.getAnnotationTypesUnfiltered(e));
        TreeSet<Element> oset = new TreeSet<Element>(this.makeGeneralPurposeComparator());
        oset.addAll(clist);
        return oset;
    }

    private void initSpecifiedElements() {
        this.specifiedClasses = new LinkedHashSet<TypeElement>(ElementFilter.typesIn(this.configuration.root.getSpecifiedElements()));
        this.specifiedPackages = new LinkedHashSet<PackageElement>(ElementFilter.packagesIn(this.configuration.root.getSpecifiedElements()));
    }

    public Set<TypeElement> getSpecifiedClasses() {
        if (this.specifiedClasses == null || this.specifiedPackages == null) {
            this.initSpecifiedElements();
        }
        return this.specifiedClasses;
    }

    public Set<PackageElement> getSpecifiedPackages() {
        if (this.specifiedClasses == null || this.specifiedPackages == null) {
            this.initSpecifiedElements();
        }
        return this.specifiedPackages;
    }

    public SortedSet<TypeElement> getAllClasses(Element e) {
        SortedSet<TypeElement> oset = this.cachedClasses.get(e);
        if (oset != null) {
            return oset;
        }
        List<TypeElement> clist = this.getClasses(e);
        clist.addAll(this.getInterfaces(e));
        clist.addAll(this.getAnnotationTypes(e));
        clist.addAll(this.getEnums(e));
        oset = new TreeSet<Element>(this.makeGeneralPurposeComparator());
        oset.addAll(clist);
        this.cachedClasses.put(e, oset);
        return oset;
    }

    private List<TypeElement> getInnerClasses(Element e, boolean filter) {
        ArrayList<TypeElement> olist = new ArrayList<TypeElement>();
        for (TypeElement te : this.getClassesUnfiltered(e)) {
            if (filter && !this.configuration.workArounds.isVisible(te)) continue;
            olist.add(te);
        }
        for (TypeElement te : this.getInterfacesUnfiltered(e)) {
            if (filter && !this.configuration.workArounds.isVisible(te)) continue;
            olist.add(te);
        }
        for (TypeElement te : this.getAnnotationTypesUnfiltered(e)) {
            if (filter && !this.configuration.workArounds.isVisible(te)) continue;
            olist.add(te);
        }
        for (TypeElement te : this.getEnumsUnfiltered(e)) {
            if (filter && !this.configuration.workArounds.isVisible(te)) continue;
            olist.add(te);
        }
        return olist;
    }

    public List<TypeElement> getInnerClasses(Element e) {
        return this.getInnerClasses(e, true);
    }

    public List<TypeElement> getInnerClassesUnfiltered(Element e) {
        return this.getInnerClasses(e, false);
    }

    public List<TypeElement> getOrdinaryClasses(Element e) {
        return this.getClasses(e).stream().filter(te -> !this.isException((TypeElement)te) && !this.isError((TypeElement)te)).collect(Collectors.toList());
    }

    public List<TypeElement> getErrors(Element e) {
        return this.getClasses(e).stream().filter(this::isError).collect(Collectors.toList());
    }

    public List<TypeElement> getExceptions(Element e) {
        return this.getClasses(e).stream().filter(this::isException).collect(Collectors.toList());
    }

    List<Element> getItems(Element e, final boolean filter, final ElementKind select) {
        final ArrayList<Element> elements = new ArrayList<Element>();
        if (this.configuration.backwardCompatibility && e.getKind() == ElementKind.ANNOTATION_TYPE) {
            return elements;
        }
        return (List)new SimpleElementVisitor9<List<Element>, Void>(){

            @Override
            public List<Element> visitPackage(PackageElement e, Void p) {
                Utils.this.recursiveGetItems(elements, e, filter, select);
                return elements;
            }

            @Override
            protected List<Element> defaultAction(Element e0, Void p) {
                return Utils.this.getItems0(e0, filter, new ElementKind[]{select});
            }
        }.visit(e);
    }

    void recursiveGetItems(Collection<Element> list, Element e, boolean filter, ElementKind ... select) {
        list.addAll(this.getItems0(e, filter, select));
        List<Element> classes = this.getItems0(e, filter, this.nestedKinds);
        for (Element c : classes) {
            list.addAll(this.getItems0(c, filter, select));
            if (!this.isTypeElement(c)) continue;
            this.recursiveGetItems(list, c, filter, select);
        }
    }

    private List<Element> getItems0(Element te, boolean filter, ElementKind ... select) {
        EnumSet<ElementKind> kinds = EnumSet.copyOf(Arrays.asList(select));
        return this.getItems0(te, filter, kinds);
    }

    private List<Element> getItems0(Element te, boolean filter, Set<ElementKind> kinds) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element element : te.getEnclosedElements()) {
            if (!kinds.contains((Object)element.getKind()) || filter && !this.configuration.workArounds.shouldDocument(element)) continue;
            elements.add(element);
        }
        return elements;
    }

    public String getSimpleName(Element e) {
        return this.nameCache.computeIfAbsent(e, this::getSimpleName0);
    }

    private String getSimpleName0(Element e) {
        if (this.snvisitor == null) {
            this.snvisitor = new SimpleElementVisitor9<String, Void>(){

                @Override
                public String visitType(TypeElement e, Void p) {
                    StringBuilder sb = new StringBuilder(e.getSimpleName());
                    for (Element enclosed = e.getEnclosingElement(); enclosed != null && (enclosed.getKind().isClass() || enclosed.getKind().isInterface()); enclosed = enclosed.getEnclosingElement()) {
                        sb.insert(0, enclosed.getSimpleName() + ".");
                    }
                    return sb.toString();
                }

                @Override
                public String visitExecutable(ExecutableElement e, Void p) {
                    if (e.getKind() == ElementKind.CONSTRUCTOR || e.getKind() == ElementKind.STATIC_INIT) {
                        return e.getEnclosingElement().getSimpleName().toString();
                    }
                    return e.getSimpleName().toString();
                }

                @Override
                protected String defaultAction(Element e, Void p) {
                    return e.getSimpleName().toString();
                }
            };
        }
        return (String)this.snvisitor.visit(e);
    }

    public TypeElement getEnclosingTypeElement(Element e) {
        if (e.getKind() == ElementKind.PACKAGE) {
            return null;
        }
        Element encl = e.getEnclosingElement();
        ElementKind kind = encl.getKind();
        if (kind == ElementKind.PACKAGE) {
            return null;
        }
        while (!kind.isClass() && !kind.isInterface()) {
            encl = encl.getEnclosingElement();
        }
        return (TypeElement)encl;
    }

    public String constantValueExpresion(VariableElement ve) {
        if (this.cve == null) {
            this.cve = new ConstantValueExpression();
        }
        return this.cve.constantValueExpression(this.configuration.workArounds, ve);
    }

    public boolean isEnclosingPackageIncluded(TypeElement te) {
        return this.isIncluded(this.containingPackage(te));
    }

    public boolean isIncluded(Element e) {
        return this.configuration.root.isIncluded(e);
    }

    public String getPackageName(PackageElement pkg) {
        if (pkg == null || pkg.isUnnamed()) {
            return "<Unnamed>";
        }
        return pkg.getQualifiedName().toString();
    }

    public boolean isAttribute(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.ATTRIBUTE);
    }

    public boolean isAuthor(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.AUTHOR);
    }

    public boolean isComment(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.COMMENT);
    }

    public boolean isDeprecated(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.DEPRECATED);
    }

    public boolean isDocComment(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.DOC_COMMENT);
    }

    public boolean isDocRoot(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.DOC_ROOT);
    }

    public boolean isEndElement(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.END_ELEMENT);
    }

    public boolean isEntity(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.ENTITY);
    }

    public boolean isErroneous(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.ERRONEOUS);
    }

    public boolean isException(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.EXCEPTION);
    }

    public boolean isIdentifier(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.IDENTIFIER);
    }

    public boolean isInheritDoc(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.INHERIT_DOC);
    }

    public boolean isLink(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.LINK);
    }

    public boolean isLinkPlain(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.LINK_PLAIN);
    }

    public boolean isLiteral(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.LITERAL);
    }

    public boolean isOther(DocTree doctree) {
        return doctree.getKind() == DocTree.Kind.OTHER;
    }

    public boolean isParam(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.PARAM);
    }

    public boolean isReference(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.REFERENCE);
    }

    public boolean isReturn(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.RETURN);
    }

    public boolean isSee(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.SEE);
    }

    public boolean isSerial(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.SERIAL);
    }

    public boolean isSerialData(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.SERIAL_DATA);
    }

    public boolean isSerialField(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.SERIAL_FIELD);
    }

    public boolean isSince(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.SINCE);
    }

    public boolean isStartElement(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.START_ELEMENT);
    }

    public boolean isText(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.TEXT);
    }

    public boolean isThrows(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.THROWS);
    }

    public boolean isUnknownBlockTag(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.UNKNOWN_BLOCK_TAG);
    }

    public boolean isUnknownInlineTag(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.UNKNOWN_INLINE_TAG);
    }

    public boolean isValue(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.VALUE);
    }

    public boolean isVersion(DocTree doctree) {
        return this.isKind(doctree, DocTree.Kind.VERSION);
    }

    private boolean isKind(DocTree doctree, DocTree.Kind match) {
        return doctree.getKind() == match;
    }

    public CommentHelper getCommentHelper(Element element) {
        return this.wksMap.computeIfAbsent(element);
    }

    public void removeCommentHelper(Element element) {
        this.wksMap.remove(element);
    }

    public List<? extends DocTree> filteredList(List<? extends DocTree> dlist, DocTree.Kind ... select) {
        ArrayList<DocTree> list = new ArrayList<DocTree>(dlist.size());
        if (select == null) {
            return dlist;
        }
        for (DocTree docTree : dlist) {
            if (docTree.getKind() == DocTree.Kind.ERRONEOUS) continue;
            for (DocTree.Kind kind : select) {
                if (docTree.getKind() != kind) continue;
                list.add(docTree);
            }
        }
        return list;
    }

    private List<? extends DocTree> getBlockTags0(Element element, DocTree.Kind ... kinds) {
        DocCommentTree dcTree = this.getDocCommentTree(element);
        if (dcTree == null) {
            return Collections.emptyList();
        }
        return this.filteredList(dcTree.getBlockTags(), kinds);
    }

    public List<? extends DocTree> getBlockTags(Element element) {
        return this.getBlockTags0(element, null);
    }

    public List<? extends DocTree> getBlockTags(Element element, DocTree.Kind ... kinds) {
        return this.getBlockTags0(element, kinds);
    }

    public List<? extends DocTree> getBlockTags(Element element, String tagName) {
        DocTree.Kind kind = null;
        switch (tagName) {
            case "author": 
            case "deprecated": 
            case "param": 
            case "return": 
            case "see": 
            case "serial": 
            case "since": 
            case "throws": 
            case "exception": 
            case "version": {
                kind = DocTree.Kind.valueOf(tagName.toUpperCase());
                return this.getBlockTags(element, kind);
            }
            case "serialData": {
                kind = DocTree.Kind.SERIAL_DATA;
                return this.getBlockTags(element, kind);
            }
            case "serialField": {
                kind = DocTree.Kind.SERIAL_FIELD;
                return this.getBlockTags(element, kind);
            }
        }
        kind = DocTree.Kind.UNKNOWN_BLOCK_TAG;
        List<? extends DocTree> blockTags = this.getBlockTags(element, kind);
        ArrayList<DocTree> out = new ArrayList<DocTree>();
        String tname = tagName.startsWith("@") ? tagName.substring(1) : tagName;
        CommentHelper ch = this.wksMap.get(element);
        for (DocTree docTree : blockTags) {
            if (!ch.getTagName(docTree).equals(tname)) continue;
            out.add(docTree);
        }
        return out;
    }

    public TreePath getTreePath(Element e) {
        CommentUtils.DocCommentDuo duo = this.dcTreeCache.get(e);
        if (this.isValidDuo(duo) && duo.treePath != null) {
            return duo.treePath;
        }
        duo = this.configuration.cmtUtils.getSyntheticCommentDuo(e);
        if (this.isValidDuo(duo) && duo.treePath != null) {
            return duo.treePath;
        }
        Map<Element, TreePath> elementToTreePath = this.configuration.workArounds.getElementToTreePath();
        TreePath path = elementToTreePath.get(e);
        if (path != null || elementToTreePath.containsKey(e)) {
            return path;
        }
        return elementToTreePath.computeIfAbsent(e, this.docTrees::getPath);
    }

    public DocCommentTree getDocCommentTree0(Element element) {
        TreePath path;
        CommentUtils.DocCommentDuo duo = null;
        ElementKind kind = element.getKind();
        if (kind == ElementKind.PACKAGE || kind == ElementKind.OTHER) {
            duo = this.dcTreeCache.get(element);
            if (!this.isValidDuo(duo) && kind == ElementKind.PACKAGE) {
                duo = this.getDocCommentTuple(element);
            }
            if (!this.isValidDuo(duo)) {
                duo = this.configuration.cmtUtils.getHtmlCommentDuo(element);
            }
        } else {
            duo = this.configuration.cmtUtils.getSyntheticCommentDuo(element);
            if (!this.isValidDuo(duo)) {
                duo = this.dcTreeCache.get(element);
            }
            if (!this.isValidDuo(duo)) {
                duo = this.getDocCommentTuple(element);
            }
        }
        DocCommentTree docCommentTree = this.isValidDuo(duo) ? duo.dcTree : null;
        TreePath treePath = path = this.isValidDuo(duo) ? duo.treePath : null;
        if (!this.dcTreeCache.containsKey(element)) {
            if (docCommentTree != null && path != null) {
                this.configuration.workArounds.runDocLint(path);
            }
            this.dcTreeCache.put(element, duo);
        }
        return docCommentTree;
    }

    private CommentUtils.DocCommentDuo getDocCommentTuple(Element element) {
        TreePath path;
        if (element.getKind() != ElementKind.OTHER && (path = this.getTreePath(element)) != null) {
            DocCommentTree docCommentTree = this.docTrees.getDocCommentTree(path);
            return new CommentUtils.DocCommentDuo(path, docCommentTree);
        }
        return null;
    }

    boolean isValidDuo(CommentUtils.DocCommentDuo duo) {
        return duo != null && duo.dcTree != null;
    }

    public DocCommentTree getDocCommentTree(Element element) {
        CommentHelper ch = this.wksMap.get(element);
        if (ch != null) {
            return ch.dctree;
        }
        DocCommentTree dcTree = this.getDocCommentTree0(element);
        if (dcTree != null) {
            this.wksMap.put(element, new CommentHelper(this.configuration, element, this.getTreePath(element), dcTree));
        }
        return dcTree;
    }

    public List<? extends DocTree> getBody(Element element) {
        DocCommentTree docCommentTree = this.getDocCommentTree(element);
        if (docCommentTree == null) {
            return Collections.emptyList();
        }
        return docCommentTree.getFullBody();
    }

    public List<? extends DocTree> getDeprecatedTrees(Element element) {
        return this.getBlockTags(element, DocTree.Kind.DEPRECATED);
    }

    public List<? extends DocTree> getSeeTrees(Element element) {
        return this.getBlockTags(element, DocTree.Kind.SEE);
    }

    public List<? extends DocTree> getSerialTrees(Element element) {
        return this.getBlockTags(element, DocTree.Kind.SERIAL);
    }

    public List<? extends DocTree> getSerialFieldTrees(VariableElement field) {
        return this.getBlockTags((Element)field, DocTree.Kind.SERIAL_FIELD);
    }

    public List<? extends DocTree> getThrowsTrees(Element element) {
        return this.getBlockTags(element, DocTree.Kind.EXCEPTION, DocTree.Kind.THROWS);
    }

    public List<? extends DocTree> getTypeParamTrees(Element element) {
        return this.getParamTrees(element, true);
    }

    public List<? extends DocTree> getParamTrees(Element element) {
        return this.getParamTrees(element, false);
    }

    private List<? extends DocTree> getParamTrees(Element element, boolean isTypeParameters) {
        ArrayList<DocTree> out = new ArrayList<DocTree>();
        for (DocTree docTree : this.getBlockTags(element, DocTree.Kind.PARAM)) {
            ParamTree pt = (ParamTree)docTree;
            if (pt.isTypeParameter() != isTypeParameters) continue;
            out.add(docTree);
        }
        return out;
    }

    public List<? extends DocTree> getReturnTrees(Element element) {
        ArrayList<DocTree> out = new ArrayList<DocTree>();
        for (DocTree docTree : this.getBlockTags(element, DocTree.Kind.RETURN)) {
            out.add(docTree);
        }
        return out;
    }

    public List<? extends DocTree> getFirstSentenceTrees(Element element) {
        DocCommentTree dcTree = this.getDocCommentTree(element);
        if (dcTree == null) {
            return Collections.emptyList();
        }
        ArrayList<DocTree> out = new ArrayList<DocTree>();
        for (DocTree docTree : dcTree.getFirstSentence()) {
            out.add(docTree);
        }
        return out;
    }

    public PackageElement containingPackage(Element e) {
        return this.elementUtils.getPackageOf(e);
    }

    public TypeElement getTopMostContainingTypeElement(Element e) {
        if (this.isPackage(e)) {
            return null;
        }
        TypeElement outer = this.getEnclosingTypeElement(e);
        if (outer == null) {
            return (TypeElement)e;
        }
        while (outer != null && outer.getNestingKind().isNested()) {
            outer = this.getEnclosingTypeElement(outer);
        }
        return outer;
    }

    static class WeakSoftHashMap
    implements Map<Element, CommentHelper> {
        private final WeakHashMap<Element, SoftReference<CommentHelper>> wkMap = new WeakHashMap();
        private final Utils utils;

        public WeakSoftHashMap(Utils utils) {
            this.utils = utils;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.wkMap.containsKey(key);
        }

        @Override
        public Collection<CommentHelper> values() {
            LinkedHashSet<CommentHelper> out = new LinkedHashSet<CommentHelper>();
            for (SoftReference<CommentHelper> v : this.wkMap.values()) {
                out.add(v.get());
            }
            return out;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.wkMap.containsValue(new SoftReference<CommentHelper>((CommentHelper)value));
        }

        @Override
        public CommentHelper remove(Object key) {
            SoftReference<CommentHelper> value = this.wkMap.remove(key);
            return value == null ? null : value.get();
        }

        @Override
        public CommentHelper put(Element key, CommentHelper value) {
            SoftReference<CommentHelper> nvalue = this.wkMap.put(key, new SoftReference<CommentHelper>(value));
            return nvalue == null ? null : nvalue.get();
        }

        @Override
        public CommentHelper get(Object key) {
            SoftReference<CommentHelper> value = this.wkMap.get(key);
            return value == null ? null : value.get();
        }

        @Override
        public int size() {
            return this.wkMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.wkMap.isEmpty();
        }

        @Override
        public void clear() {
            this.wkMap.clear();
        }

        public CommentHelper computeIfAbsent(Element key) {
            CommentHelper cvalue;
            SoftReference<CommentHelper> value;
            if (this.wkMap.containsKey(key) && (value = this.wkMap.get(key)) != null && (cvalue = value.get()) != null) {
                return cvalue;
            }
            CommentHelper newValue = new CommentHelper(this.utils.configuration, key, this.utils.getTreePath(key), this.utils.getDocCommentTree(key));
            this.wkMap.put(key, new SoftReference<CommentHelper>(newValue));
            return newValue;
        }

        @Override
        public void putAll(Map<? extends Element, ? extends CommentHelper> map) {
            for (Map.Entry<? extends Element, ? extends CommentHelper> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<Element> keySet() {
            return this.wkMap.keySet();
        }

        @Override
        public Set<Map.Entry<Element, CommentHelper>> entrySet() {
            LinkedHashSet<Map.Entry<Element, CommentHelper>> out = new LinkedHashSet<Map.Entry<Element, CommentHelper>>();
            for (Element e : this.wkMap.keySet()) {
                AbstractMap.SimpleEntry<Element, CommentHelper> n = new AbstractMap.SimpleEntry<Element, CommentHelper>(e, this.get(e));
                out.add(n);
            }
            return out;
        }
    }

    private static class ConstantValueExpression {
        private ConstantValueExpression() {
        }

        public String constantValueExpression(WorkArounds workArounds, VariableElement ve) {
            return (String)new TypeKindVisitor9<String, Object>(){

                @Override
                public String visitPrimitiveAsBoolean(PrimitiveType t, Object val) {
                    return (Integer)val == 0 ? "false" : "true";
                }

                @Override
                public String visitPrimitiveAsDouble(PrimitiveType t, Object val) {
                    return this.sourceForm((Double)val, 'd');
                }

                @Override
                public String visitPrimitiveAsFloat(PrimitiveType t, Object val) {
                    return this.sourceForm(((Float)val).doubleValue(), 'f');
                }

                @Override
                public String visitPrimitiveAsLong(PrimitiveType t, Object val) {
                    return val + "L";
                }

                @Override
                protected String defaultAction(TypeMirror e, Object val) {
                    if (val == null) {
                        return null;
                    }
                    if (val instanceof Character) {
                        return this.sourceForm(((Character)val).charValue());
                    }
                    if (val instanceof Byte) {
                        return this.sourceForm((Byte)val);
                    }
                    if (val instanceof String) {
                        return this.sourceForm((String)val);
                    }
                    return val.toString();
                }
            }.visit(ve.asType(), workArounds.getConstValue(ve));
        }

        private String sourceForm(double v, char suffix) {
            if (Double.isNaN(v)) {
                return "0" + suffix + "/0" + suffix;
            }
            if (v == Double.POSITIVE_INFINITY) {
                return "1" + suffix + "/0" + suffix;
            }
            if (v == Double.NEGATIVE_INFINITY) {
                return "-1" + suffix + "/0" + suffix;
            }
            return v + (suffix == 'f' || suffix == 'F' ? "" + suffix : "");
        }

        private String sourceForm(char c) {
            StringBuilder buf = new StringBuilder(8);
            buf.append('\'');
            this.sourceChar(c, buf);
            buf.append('\'');
            return buf.toString();
        }

        private String sourceForm(byte c) {
            return "0x" + Integer.toString(c & 0xFF, 16);
        }

        private String sourceForm(String s) {
            StringBuilder buf = new StringBuilder(s.length() + 5);
            buf.append('\"');
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                this.sourceChar(c, buf);
            }
            buf.append('\"');
            return buf.toString();
        }

        private void sourceChar(char c, StringBuilder buf) {
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    return;
                }
                case '\t': {
                    buf.append("\\t");
                    return;
                }
                case '\n': {
                    buf.append("\\n");
                    return;
                }
                case '\f': {
                    buf.append("\\f");
                    return;
                }
                case '\r': {
                    buf.append("\\r");
                    return;
                }
                case '\"': {
                    buf.append("\\\"");
                    return;
                }
                case '\'': {
                    buf.append("\\'");
                    return;
                }
                case '\\': {
                    buf.append("\\\\");
                    return;
                }
            }
            if (this.isPrintableAscii(c)) {
                buf.append(c);
                return;
            }
            this.unicodeEscape(c, buf);
        }

        private void unicodeEscape(char c, StringBuilder buf) {
            String chars = "0123456789abcdef";
            buf.append("\\u");
            buf.append("0123456789abcdef".charAt(0xF & c >> 12));
            buf.append("0123456789abcdef".charAt(0xF & c >> 8));
            buf.append("0123456789abcdef".charAt(0xF & c >> 4));
            buf.append("0123456789abcdef".charAt(0xF & c >> 0));
        }

        private boolean isPrintableAscii(char c) {
            return c >= ' ' && c <= '~';
        }
    }

    private abstract class ElementComparator<T extends Element>
    implements Comparator<Element> {
        final EnumMap<ElementKind, Integer> elementKindOrder = new EnumMap(ElementKind.class);

        public ElementComparator() {
            this.elementKindOrder.put(ElementKind.PACKAGE, 0);
            this.elementKindOrder.put(ElementKind.CLASS, 1);
            this.elementKindOrder.put(ElementKind.ENUM, 2);
            this.elementKindOrder.put(ElementKind.ENUM_CONSTANT, 3);
            this.elementKindOrder.put(ElementKind.INTERFACE, 4);
            this.elementKindOrder.put(ElementKind.ANNOTATION_TYPE, 5);
            this.elementKindOrder.put(ElementKind.FIELD, 6);
            this.elementKindOrder.put(ElementKind.CONSTRUCTOR, 7);
            this.elementKindOrder.put(ElementKind.METHOD, 8);
        }

        protected int compareParameters(boolean caseSensitive, List<? extends VariableElement> params1, List<? extends VariableElement> params2) {
            return Utils.this.compareStrings(caseSensitive, this.getParametersAsString(params1), this.getParametersAsString(params2));
        }

        String getParametersAsString(List<? extends VariableElement> params) {
            StringBuilder sb = new StringBuilder();
            for (VariableElement variableElement : params) {
                TypeMirror t = variableElement.asType();
                sb.append(this.getTypeCode(t)).append("-").append(t).append("-");
            }
            return sb.toString();
        }

        private String getTypeCode(TypeMirror t) {
            return (String)new SimpleTypeVisitor9<String, Void>(){

                @Override
                public String visitPrimitive(PrimitiveType t, Void p) {
                    return "P";
                }

                @Override
                public String visitArray(ArrayType t, Void p) {
                    return (String)this.visit(t.getComponentType());
                }

                @Override
                protected String defaultAction(TypeMirror e, Void p) {
                    return "R";
                }
            }.visit(t);
        }

        protected int compareNames(Element e1, Element e2) {
            return Utils.this.compareStrings(Utils.this.getSimpleName(e1), Utils.this.getSimpleName(e2));
        }

        protected int compareFullyQualifiedNames(Element e1, Element e2) {
            String thisElement = this.getFullyQualifiedName(e1);
            String thatElement = this.getFullyQualifiedName(e2);
            return Utils.this.compareStrings(thisElement, thatElement);
        }

        protected int compareElementTypeKinds(Element e1, Element e2) {
            return Integer.compare(this.elementKindOrder.get((Object)e1.getKind()), this.elementKindOrder.get((Object)e2.getKind()));
        }

        boolean hasParameters(Element e) {
            return (Boolean)new SimpleElementVisitor9<Boolean, Void>(){

                @Override
                public Boolean visitExecutable(ExecutableElement e, Void p) {
                    return true;
                }

                @Override
                protected Boolean defaultAction(Element e, Void p) {
                    return false;
                }
            }.visit(e);
        }

        private String getFullyQualifiedName(Element e) {
            return (String)new SimpleElementVisitor9<String, Void>(){

                @Override
                public String visitPackage(PackageElement e, Void p) {
                    return e.getQualifiedName().toString();
                }

                @Override
                public String visitExecutable(ExecutableElement e, Void p) {
                    return ElementComparator.this.getFullyQualifiedName(e.getEnclosingElement()) + "." + e.getSimpleName().toString();
                }

                @Override
                public String visitType(TypeElement e, Void p) {
                    return e.getQualifiedName().toString();
                }

                @Override
                protected String defaultAction(Element e, Void p) {
                    return Utils.this.getEnclosingTypeElement(e).getQualifiedName().toString() + "." + e.getSimpleName().toString();
                }
            }.visit(e);
        }
    }

    private static class DocCollator {
        private final Map<String, CollationKey> keys;
        private final Collator instance;
        private final int MAX_SIZE = 1000;

        private DocCollator(Locale locale, int strength) {
            this.instance = Collator.getInstance(locale);
            this.instance.setStrength(strength);
            this.keys = new LinkedHashMap<String, CollationKey>(1001, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, CollationKey> eldest) {
                    return this.size() > 1000;
                }
            };
        }

        CollationKey getKey(String s) {
            return this.keys.computeIfAbsent(s, this.instance::getCollationKey);
        }

        public int compare(String s1, String s2) {
            return this.getKey(s1).compareTo(this.getKey(s2));
        }
    }
}

