/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import jdk.jshell.JShell;
import jdk.jshell.Snippet;

abstract class Key {
    private final int index;
    private final JShell state;

    Key(JShell state) {
        this.index = state.nextKeyIndex();
        this.state = state;
    }

    int index() {
        return this.index;
    }

    abstract Snippet.Kind kind();

    JShell state() {
        return this.state;
    }

    static class ErroneousKey
    extends UniqueKey {
        ErroneousKey(JShell state) {
            super(state);
        }

        @Override
        Snippet.Kind kind() {
            return Snippet.Kind.ERRONEOUS;
        }

        public String toString() {
            return "ErroneousKey#" + this.index();
        }
    }

    static class ExpressionKey
    extends UniqueKey {
        private final String name;
        private final String typeName;

        ExpressionKey(JShell state, String name, String typeName) {
            super(state);
            this.name = name;
            this.typeName = typeName;
        }

        @Override
        public Snippet.Kind kind() {
            return Snippet.Kind.EXPRESSION;
        }

        String name() {
            return this.name;
        }

        String typeName() {
            return this.typeName;
        }

        public String toString() {
            return "ExpressionKey(" + this.name() + ")#" + this.index();
        }
    }

    static class StatementKey
    extends UniqueKey {
        StatementKey(JShell state) {
            super(state);
        }

        @Override
        public Snippet.Kind kind() {
            return Snippet.Kind.STATEMENT;
        }

        public String toString() {
            return "StatementKey#" + this.index();
        }
    }

    static abstract class UniqueKey
    extends Key {
        UniqueKey(JShell state) {
            super(state);
        }
    }

    static class ImportKey
    extends PersistentKey {
        private final Snippet.SubKind snippetKind;

        ImportKey(JShell state, String name, Snippet.SubKind snippetKind) {
            super(state, name);
            this.snippetKind = snippetKind;
        }

        @Override
        public Snippet.Kind kind() {
            return Snippet.Kind.IMPORT;
        }

        Snippet.SubKind snippetKind() {
            return this.snippetKind;
        }

        public String toString() {
            return "ImportKey(" + this.name() + "," + (Object)((Object)this.snippetKind) + ")#" + this.index();
        }
    }

    static class VarKey
    extends DeclarationKey {
        VarKey(JShell state, String name) {
            super(state, name);
        }

        @Override
        public Snippet.Kind kind() {
            return Snippet.Kind.VAR;
        }

        public String toString() {
            return "VariableKey(" + this.name() + ")#" + this.index();
        }
    }

    static class MethodKey
    extends DeclarationKey {
        private final String parameterTypes;

        MethodKey(JShell state, String name, String parameterTypes) {
            super(state, name);
            this.parameterTypes = parameterTypes;
        }

        @Override
        Snippet.Kind kind() {
            return Snippet.Kind.METHOD;
        }

        String parameterTypes() {
            return this.parameterTypes;
        }

        public String toString() {
            return "MethodKey(" + this.name() + "(" + this.parameterTypes() + "))#" + this.index();
        }
    }

    static class TypeDeclKey
    extends DeclarationKey {
        TypeDeclKey(JShell state, String name) {
            super(state, name);
        }

        @Override
        Snippet.Kind kind() {
            return Snippet.Kind.TYPE_DECL;
        }

        public String toString() {
            return "ClassKey(" + this.name() + ")#" + this.index();
        }
    }

    static abstract class DeclarationKey
    extends PersistentKey {
        DeclarationKey(JShell state, String name) {
            super(state, name);
        }
    }

    static abstract class PersistentKey
    extends Key {
        private final String name;

        PersistentKey(JShell state, String name) {
            super(state);
            this.name = name;
        }

        String name() {
            return this.name;
        }
    }
}

