/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.jshell.remote.RemoteCodes;
import jdk.jshell.ImportSnippet;
import jdk.jshell.JShell;
import jdk.jshell.Key;
import jdk.jshell.Snippet;

final class SnippetMaps {
    private String packageName;
    private final List<Snippet> keyIndexToSnippet = new ArrayList<Snippet>();
    private final Set<Snippet> snippets = new LinkedHashSet<Snippet>();
    private final Map<String, Set<Integer>> dependencies = new HashMap<String, Set<Integer>>();
    private final JShell state;

    SnippetMaps(JShell proc) {
        this.state = proc;
    }

    void installSnippet(Snippet sn) {
        if (sn != null && this.snippets.add(sn) && sn.key() != null) {
            sn.setId(this.state.idGenerator != null ? this.state.idGenerator.apply(sn, sn.key().index()) : "" + sn.key().index());
            this.setSnippet(sn.key().index(), sn);
        }
    }

    private void setSnippet(int ki, Snippet snip) {
        while (ki >= this.keyIndexToSnippet.size()) {
            this.keyIndexToSnippet.add(null);
        }
        this.keyIndexToSnippet.set(ki, snip);
    }

    Snippet getSnippet(Key key) {
        return this.getSnippet(key.index());
    }

    Snippet getSnippet(int ki) {
        if (ki >= this.keyIndexToSnippet.size()) {
            return null;
        }
        return this.keyIndexToSnippet.get(ki);
    }

    List<Snippet> snippetList() {
        return new ArrayList<Snippet>(this.snippets);
    }

    void setPackageName(String n) {
        this.packageName = n;
    }

    String packageName() {
        return this.packageName;
    }

    String classFullName(Snippet sn) {
        return this.packageName + "." + sn.className();
    }

    String packageAndImportsExcept(Set<Key> except, Collection<Snippet> plus) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(this.packageName()).append(";\n");
        for (Snippet si : this.keyIndexToSnippet) {
            if (si == null || !si.status().isDefined || except != null && except.contains(si.key())) continue;
            sb.append(si.importLine(this.state));
        }
        if (plus != null) {
            plus.stream().forEach(psi -> sb.append(psi.importLine(this.state)));
        }
        return sb.toString();
    }

    List<Snippet> getDependents(Snippet snip) {
        Set<Object> depset;
        if (!snip.kind().isPersistent) {
            return Collections.emptyList();
        }
        if (snip.unitName.equals("*")) {
            depset = new HashSet();
            for (Set<Integer> as : this.dependencies.values()) {
                depset.addAll(as);
            }
        } else {
            depset = this.dependencies.get(snip.name());
        }
        if (depset == null) {
            return Collections.emptyList();
        }
        ArrayList<Snippet> deps = new ArrayList<Snippet>();
        for (Integer n : depset) {
            Snippet dep = this.getSnippet(n);
            if (dep == null) continue;
            deps.add(dep);
            this.state.debug(8, "Found dependency %s -> %s\n", snip.name(), dep.name());
        }
        return deps;
    }

    void mapDependencies(Snippet snip) {
        this.addDependencies(snip.declareReferences(), snip);
        this.addDependencies(snip.bodyReferences(), snip);
    }

    private void addDependencies(Collection<String> refs, Snippet snip) {
        if (refs == null) {
            return;
        }
        for (String ref : refs) {
            this.dependencies.computeIfAbsent(ref, k -> new HashSet()).add(snip.key().index());
            this.state.debug(8, "Added dependency %s -> %s\n", ref, snip.name());
        }
    }

    String fullClassNameAndPackageToClass(String full, String pkg) {
        Matcher mat = RemoteCodes.prefixPattern.matcher(full);
        if (mat.lookingAt()) {
            return full.substring(mat.end());
        }
        this.state.debug(8, "SM %s %s\n", full, pkg);
        List klasses = this.importSnippets().filter(isi -> !isi.isStar).map(isi -> isi.fullname).collect(Collectors.toList());
        for (String k : klasses) {
            if (!k.equals(full)) continue;
            return full.substring(full.lastIndexOf(".") + 1, full.length());
        }
        List pkgs = this.importSnippets().filter(isi -> isi.isStar).map(isi -> isi.fullname.substring(0, isi.fullname.lastIndexOf("."))).collect(Collectors.toList());
        pkgs.add(0, "java.lang");
        for (String ipkg : pkgs) {
            if (ipkg.isEmpty() || !ipkg.equals(pkg)) continue;
            return full.substring(pkg.length() + 1);
        }
        return full;
    }

    private Stream<ImportSnippet> importSnippets() {
        return this.state.keyMap.importKeys().map(key -> (ImportSnippet)this.getSnippet((Key)key)).filter(sn -> this.state.status((Snippet)sn).isDefined);
    }
}

