/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashSet;
import java.util.function.BiConsumer;
import javax.tools.JavaFileObject;

public class TypeEnter
implements Symbol.Completer {
    protected static final Context.Key<TypeEnter> typeEnterKey = new Context.Key();
    static final boolean checkClash = true;
    private final Names names;
    private final Enter enter;
    private final MemberEnter memberEnter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final TreeMaker make;
    private final Todo todo;
    private final Annotate annotate;
    private final TypeAnnotations typeAnnotations;
    private final Types types;
    private final JCDiagnostic.Factory diags;
    private final Source source;
    private final DeferredLintHandler deferredLintHandler;
    private final Lint lint;
    private final TypeEnvs typeEnvs;
    private final Dependencies dependencies;
    boolean allowTypeAnnos;
    boolean allowDeprecationOnImport;
    boolean completionEnabled = true;
    private final ImportsPhase completeClass = new ImportsPhase();
    private Phase topLevelPhase;

    public static TypeEnter instance(Context context) {
        TypeEnter instance = context.get(typeEnterKey);
        if (instance == null) {
            instance = new TypeEnter(context);
        }
        return instance;
    }

    protected TypeEnter(Context context) {
        context.put(typeEnterKey, this);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.todo = Todo.instance(context);
        this.annotate = Annotate.instance(context);
        this.typeAnnotations = TypeAnnotations.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.source = Source.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.lint = Lint.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.dependencies = Dependencies.instance(context);
        Source source = Source.instance(context);
        this.allowTypeAnnos = source.allowTypeAnnotations();
        this.allowDeprecationOnImport = source.allowDeprecationOnImport();
    }

    protected void ensureImportsChecked(List<JCTree.JCCompilationUnit> trees) {
        for (JCTree.JCCompilationUnit tree : trees) {
            if (tree.starImportScope.isFilled()) continue;
            Env<AttrContext> topEnv = this.enter.topLevelEnv(tree);
            this.finishImports(tree, () -> this.completeClass.resolveImports(tree, topEnv));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (!this.completionEnabled) {
            Assert.check((sym.flags() & 0x1000000L) == 0L);
            sym.completer = this;
            return;
        }
        try {
            List<Env<AttrContext>> queue;
            this.annotate.blockAnnotations();
            sym.flags_field |= 0x10000000L;
            this.dependencies.push((Symbol.ClassSymbol)sym, Dependencies.CompletionCause.MEMBER_ENTER);
            try {
                queue = this.completeClass.completeEnvs(List.of(this.typeEnvs.get((Symbol.ClassSymbol)sym)));
            }
            finally {
                this.dependencies.pop();
            }
            if (!queue.isEmpty()) {
                HashSet<JCTree.JCCompilationUnit> seen = new HashSet<JCTree.JCCompilationUnit>();
                for (Env<AttrContext> env : queue) {
                    if (!env.toplevel.defs.contains(env.enclClass) || !seen.add(env.toplevel)) continue;
                    this.finishImports(env.toplevel, () -> {});
                }
            }
        }
        finally {
            this.annotate.unblockAnnotations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishImports(JCTree.JCCompilationUnit toplevel, Runnable resolve) {
        JavaFileObject prev = this.log.useSource(toplevel.sourcefile);
        try {
            resolve.run();
            this.chk.checkImportsUnique(toplevel);
            this.chk.checkImportsResolvable(toplevel);
            this.chk.checkImportedPackagesObservable(toplevel);
            toplevel.namedImportScope.finalizeScope();
            toplevel.starImportScope.finalizeScope();
        }
        finally {
            this.log.useSource(prev);
        }
    }

    JCTree DefaultConstructor(TreeMaker make, Symbol.ClassSymbol c, Symbol.MethodSymbol baseInit, List<Type> typarams, List<Type> argtypes, List<Type> thrown, long flags, boolean based) {
        flags = (c.flags() & 0x4000L) != 0L && this.types.supertype((Type)c.type).tsym == this.syms.enumSym ? flags & 0xFFFFFFFFFFFFFFF8L | 2L | 0x1000000000L : (flags |= c.flags() & 7L | 0x1000000000L);
        if (c.name.isEmpty()) {
            flags |= 0x20000000L;
        }
        Type.MethodType mType = new Type.MethodType(argtypes, null, thrown, c);
        Type initType = typarams.nonEmpty() ? new Type.ForAll(typarams, (Type)mType) : mType;
        Symbol.MethodSymbol init = new Symbol.MethodSymbol(flags, this.names.init, initType, c);
        init.params = this.createDefaultConstructorParams(make, baseInit, init, argtypes, based);
        List<JCTree.JCVariableDecl> params = make.Params(argtypes, init);
        List<JCTree.JCStatement> stats = List.nil();
        if (c.type != this.syms.objectType) {
            stats = stats.prepend(this.SuperCall(make, typarams, params, based));
        }
        JCTree.JCMethodDecl result = make.MethodDef(init, make.Block(0L, stats));
        return result;
    }

    private List<Symbol.VarSymbol> createDefaultConstructorParams(TreeMaker make, Symbol.MethodSymbol baseInit, Symbol.MethodSymbol init, List<Type> argtypes, boolean based) {
        List<Symbol.VarSymbol> initParams = null;
        List<Type> argTypesList = argtypes;
        if (based) {
            initParams = List.nil();
            Symbol.VarSymbol param = new Symbol.VarSymbol(0x200000000L, make.paramName(0), (Type)argtypes.head, init);
            initParams = initParams.append(param);
            argTypesList = argTypesList.tail;
        }
        if (baseInit != null && baseInit.params != null && baseInit.params.nonEmpty() && argTypesList.nonEmpty()) {
            initParams = initParams == null ? List.nil() : initParams;
            List<Symbol.VarSymbol> baseInitParams = baseInit.params;
            while (baseInitParams.nonEmpty() && argTypesList.nonEmpty()) {
                Symbol.VarSymbol param = new Symbol.VarSymbol(((Symbol.VarSymbol)baseInitParams.head).flags() | 0x200000000L, ((Symbol.VarSymbol)baseInitParams.head).name, (Type)argTypesList.head, init);
                initParams = initParams.append(param);
                baseInitParams = baseInitParams.tail;
                argTypesList = argTypesList.tail;
            }
        }
        return initParams;
    }

    JCTree.JCExpressionStatement SuperCall(TreeMaker make, List<Type> typarams, List<JCTree.JCVariableDecl> params, boolean based) {
        JCTree.JCExpression meth;
        if (based) {
            meth = make.Select(make.Ident((JCTree.JCVariableDecl)params.head), this.names._super);
            params = params.tail;
        } else {
            meth = make.Ident(this.names._super);
        }
        List<JCTree.JCExpression> typeargs = typarams.nonEmpty() ? make.Types(typarams) : null;
        return make.Exec(make.Apply(typeargs, meth, make.Idents(params)));
    }

    private final class MembersPhase
    extends Phase {
        public MembersPhase() {
            super(Dependencies.CompletionCause.MEMBERS_PHASE, null);
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            Type.ClassType ct2 = (Type.ClassType)sym.type;
            if ((sym.flags() & 0x200L) == 0L && !TreeInfo.hasConstructors(tree.defs)) {
                List<Type> argtypes = List.nil();
                List<Type> typarams = List.nil();
                List<Type> thrown = List.nil();
                long ctorFlags = 0L;
                boolean based = false;
                boolean addConstructor = true;
                JCTree.JCNewClass nc = null;
                if (sym.name.isEmpty()) {
                    nc = (JCTree.JCNewClass)env.next.tree;
                    if (nc.constructor != null) {
                        addConstructor = nc.constructor.kind != Kinds.Kind.ERR;
                        Type superConstrType = TypeEnter.this.types.memberType(sym.type, nc.constructor);
                        argtypes = superConstrType.getParameterTypes();
                        typarams = superConstrType.getTypeArguments();
                        ctorFlags = nc.constructor.flags() & 0x400000000L;
                        if (nc.encl != null) {
                            argtypes = argtypes.prepend(nc.encl.type);
                            based = true;
                        }
                        thrown = superConstrType.getThrownTypes();
                    }
                }
                if (addConstructor) {
                    Symbol.MethodSymbol basedConstructor = nc != null ? (Symbol.MethodSymbol)nc.constructor : null;
                    JCTree constrDef = TypeEnter.this.DefaultConstructor(TypeEnter.this.make.at(tree.pos), sym, basedConstructor, typarams, argtypes, thrown, ctorFlags, based);
                    tree.defs = tree.defs.prepend(constrDef);
                }
            }
            Symbol.VarSymbol thisSym = new Symbol.VarSymbol(262160L, ((TypeEnter)TypeEnter.this).names._this, sym.type, sym);
            thisSym.pos = 0;
            ((AttrContext)env.info).scope.enter(thisSym);
            if ((sym.flags_field & 0x200L) == 0L && ct2.supertype_field.hasTag(TypeTag.CLASS)) {
                Symbol.VarSymbol superSym = new Symbol.VarSymbol(262160L, ((TypeEnter)TypeEnter.this).names._super, ct2.supertype_field, sym);
                superSym.pos = 0;
                ((AttrContext)env.info).scope.enter(superSym);
            }
            this.finishClass(tree, env);
            if (TypeEnter.this.allowTypeAnnos) {
                TypeEnter.this.typeAnnotations.organizeTypeAnnotationsSignatures(env, (JCTree.JCClassDecl)env.tree);
                TypeEnter.this.typeAnnotations.validateTypeAnnotationsSignatures(env, (JCTree.JCClassDecl)env.tree);
            }
        }

        void finishClass(JCTree.JCClassDecl tree, Env<AttrContext> env) {
            if ((tree.mods.flags & 0x4000L) != 0L && !tree.sym.type.hasTag(TypeTag.ERROR) && (((TypeEnter)TypeEnter.this).types.supertype((Type)tree.sym.type).tsym.flags() & 0x4000L) == 0L) {
                this.addEnumMembers(tree, env);
            }
            TypeEnter.this.memberEnter.memberEnter(tree.defs, env);
            if (tree.sym.isAnnotationType()) {
                Assert.check(tree.sym.isCompleted());
                tree.sym.setAnnotationTypeMetadata(new Annotate.AnnotationTypeMetadata(tree.sym, TypeEnter.this.annotate.annotationTypeSourceCompleter()));
            }
        }

        private void addEnumMembers(JCTree.JCClassDecl tree, Env<AttrContext> env) {
            JCTree.JCExpression valuesType = TypeEnter.this.make.Type(new Type.ArrayType(tree.sym.type, ((TypeEnter)TypeEnter.this).syms.arrayClass));
            JCTree.JCMethodDecl values = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(9L), ((TypeEnter)TypeEnter.this).names.values, valuesType, List.nil(), List.nil(), List.nil(), null, null);
            TypeEnter.this.memberEnter.memberEnter(values, env);
            JCTree.JCMethodDecl valueOf = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(9L), ((TypeEnter)TypeEnter.this).names.valueOf, TypeEnter.this.make.Type(tree.sym.type), List.nil(), List.of(TypeEnter.this.make.VarDef(TypeEnter.this.make.Modifiers(0x200008000L), TypeEnter.this.names.fromString("name"), TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.stringType), null)), List.nil(), null, null);
            TypeEnter.this.memberEnter.memberEnter(valueOf, env);
        }
    }

    private final class HeaderPhase
    extends AbstractHeaderPhase {
        public HeaderPhase() {
            super(Dependencies.CompletionCause.HEADER_PHASE, new MembersPhase());
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            Type.ClassType ct2 = (Type.ClassType)sym.type;
            Env<AttrContext> baseEnv = this.baseEnv(tree, env);
            if (tree.extending != null) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(tree.extending, baseEnv, sym, tree.pos());
            }
            for (JCTree.JCExpression impl : tree.implementing) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(impl, baseEnv, sym, tree.pos());
            }
            TypeEnter.this.annotate.flush();
            this.attribSuperTypes(env, baseEnv);
            HashSet<Type> interfaceSet = new HashSet<Type>();
            for (JCTree.JCExpression iface : tree.implementing) {
                Type it = iface.type;
                if (!it.hasTag(TypeTag.CLASS)) continue;
                TypeEnter.this.chk.checkNotRepeated(iface.pos(), TypeEnter.this.types.erasure(it), interfaceSet);
            }
            TypeEnter.this.annotate.annotateLater(tree.mods.annotations, baseEnv, sym, tree.pos());
            TypeEnter.this.attr.attribTypeVariables(tree.typarams, baseEnv);
            for (JCTree.JCTypeParameter tp : tree.typarams) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(tp, baseEnv, sym, tree.pos());
            }
            if (sym.owner.kind == Kinds.Kind.PCK && sym.owner != ((TypeEnter)TypeEnter.this).syms.unnamedPackage && TypeEnter.this.syms.packageExists(sym.fullname)) {
                TypeEnter.this.log.error(tree.pos, "clash.with.pkg.of.same.name", Kinds.kindName(sym), sym);
            }
            if (sym.owner.kind == Kinds.Kind.PCK && (sym.flags_field & 1L) == 0L && !env.toplevel.sourcefile.isNameCompatible(sym.name.toString(), JavaFileObject.Kind.SOURCE)) {
                sym.flags_field |= 0x100000000000L;
            }
        }
    }

    private final class HierarchyPhase
    extends AbstractHeaderPhase
    implements Symbol.Completer {
        public HierarchyPhase() {
            super(Dependencies.CompletionCause.HIERARCHY_PHASE, new HeaderPhase());
        }

        @Override
        protected void doCompleteEnvs(List<Env<AttrContext>> envs) {
            for (Env<AttrContext> env : envs) {
                env.enclClass.sym.completer = this;
            }
            for (Env<AttrContext> env : envs) {
                env.enclClass.sym.complete();
            }
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            Type.ClassType ct2 = (Type.ClassType)sym.type;
            Env<AttrContext> baseEnv = this.baseEnv(tree, env);
            this.attribSuperTypes(env, baseEnv);
            if (sym.fullname == ((TypeEnter)TypeEnter.this).names.java_lang_Object) {
                if (tree.extending != null) {
                    TypeEnter.this.chk.checkNonCyclic(tree.extending.pos(), ct2.supertype_field);
                    ct2.supertype_field = Type.noType;
                } else if (tree.implementing.nonEmpty()) {
                    TypeEnter.this.chk.checkNonCyclic(((JCTree.JCExpression)tree.implementing.head).pos(), (Type)ct2.interfaces_field.head);
                    ct2.interfaces_field = List.nil();
                }
            }
            TypeEnter.this.attr.attribAnnotationTypes(tree.mods.annotations, baseEnv);
            if (this.hasDeprecatedAnnotation(tree.mods.annotations)) {
                sym.flags_field |= 0x20000L;
            }
            TypeEnter.this.chk.checkNonCyclicDecl(tree);
        }

        @Override
        protected JCTree.JCExpression clearTypeParams(JCTree.JCExpression superType) {
            switch (superType.getTag()) {
                case TYPEAPPLY: {
                    return ((JCTree.JCTypeApply)superType).clazz;
                }
            }
            return superType;
        }

        private boolean hasDeprecatedAnnotation(List<JCTree.JCAnnotation> annotations) {
            List<JCTree.JCAnnotation> al = annotations;
            while (!al.isEmpty()) {
                JCTree.JCAnnotation a = (JCTree.JCAnnotation)al.head;
                if (a.annotationType.type == ((TypeEnter)TypeEnter.this).syms.deprecatedType && a.args.isEmpty()) {
                    return true;
                }
                al = al.tail;
            }
            return false;
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            Assert.check(TypeEnter.this.topLevelPhase instanceof ImportsPhase || TypeEnter.this.topLevelPhase == this);
            if (TypeEnter.this.topLevelPhase != this) {
                sym.completer = this;
                return;
            }
            Env<AttrContext> env = TypeEnter.this.typeEnvs.get((Symbol.ClassSymbol)sym);
            super.doCompleteEnvs(List.of(env));
        }
    }

    private abstract class AbstractHeaderPhase
    extends Phase {
        public AbstractHeaderPhase(Dependencies.CompletionCause phaseName, Phase next) {
            super(phaseName, next);
        }

        protected Env<AttrContext> baseEnv(JCTree.JCClassDecl tree, Env<AttrContext> env) {
            Scope.WriteableScope baseScope = Scope.WriteableScope.create(tree.sym);
            for (Symbol sym : ((AttrContext)env.outer.info).scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (!sym.isLocal()) continue;
                baseScope.enter(sym);
            }
            if (tree.typarams != null) {
                List<JCTree.JCTypeParameter> typarams = tree.typarams;
                while (typarams.nonEmpty()) {
                    baseScope.enter(((JCTree.JCTypeParameter)typarams.head).type.tsym);
                    typarams = typarams.tail;
                }
            }
            Env<AttrContext> outer = env.outer;
            Env<AttrContext> localEnv = outer.dup(tree, ((AttrContext)outer.info).dup(baseScope));
            localEnv.baseClause = true;
            localEnv.outer = outer;
            ((AttrContext)localEnv.info).isSelfCall = false;
            return localEnv;
        }

        protected JCTree.JCExpression enumBase(int pos, Symbol.ClassSymbol c) {
            JCTree.JCTypeApply result = TypeEnter.this.make.at(pos).TypeApply(TypeEnter.this.make.QualIdent(((TypeEnter)TypeEnter.this).syms.enumSym), List.of(TypeEnter.this.make.Type(c.type)));
            return result;
        }

        protected Type modelMissingTypes(Type t, final JCTree.JCExpression tree, final boolean interfaceExpected) {
            if (!t.hasTag(TypeTag.ERROR)) {
                return t;
            }
            return new Type.ErrorType(t.getOriginalType(), t.tsym){
                private Type modelType;

                @Override
                public Type getModelType() {
                    if (this.modelType == null) {
                        this.modelType = new Synthesizer(this.getOriginalType(), interfaceExpected).visit(tree);
                    }
                    return this.modelType;
                }
            };
        }

        protected void attribSuperTypes(Env<AttrContext> env, Env<AttrContext> baseEnv) {
            Type supertype;
            JCTree.JCExpression extending;
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            Type.ClassType ct2 = (Type.ClassType)sym.type;
            if (tree.extending != null) {
                extending = this.clearTypeParams(tree.extending);
                supertype = TypeEnter.this.attr.attribBase(extending, baseEnv, true, false, true);
            } else {
                extending = null;
                supertype = (tree.mods.flags & 0x4000L) != 0L ? TypeEnter.this.attr.attribBase(this.enumBase(tree.pos, sym), baseEnv, true, false, false) : (sym.fullname == ((TypeEnter)TypeEnter.this).names.java_lang_Object ? Type.noType : ((TypeEnter)TypeEnter.this).syms.objectType);
            }
            ct2.supertype_field = this.modelMissingTypes(supertype, extending, false);
            ListBuffer<Type> interfaces = new ListBuffer<Type>();
            ListBuffer<Type> all_interfaces = null;
            List<JCTree.JCExpression> interfaceTrees = tree.implementing;
            for (JCTree.JCExpression iface : interfaceTrees) {
                iface = this.clearTypeParams(iface);
                Type it = TypeEnter.this.attr.attribBase(iface, baseEnv, false, true, true);
                if (it.hasTag(TypeTag.CLASS)) {
                    interfaces.append(it);
                    if (all_interfaces == null) continue;
                    all_interfaces.append(it);
                    continue;
                }
                if (all_interfaces == null) {
                    all_interfaces = new ListBuffer<Type>().appendList(interfaces);
                }
                all_interfaces.append(this.modelMissingTypes(it, iface, true));
            }
            if ((sym.flags_field & 0x2000L) != 0L) {
                ct2.interfaces_field = List.of(((TypeEnter)TypeEnter.this).syms.annotationType);
                ct2.all_interfaces_field = ct2.interfaces_field;
            } else {
                ct2.interfaces_field = interfaces.toList();
                ct2.all_interfaces_field = all_interfaces == null ? ct2.interfaces_field : all_interfaces.toList();
            }
        }

        protected JCTree.JCExpression clearTypeParams(JCTree.JCExpression superType) {
            return superType;
        }

        private class Synthesizer
        extends JCTree.Visitor {
            Type originalType;
            boolean interfaceExpected;
            List<Symbol.ClassSymbol> synthesizedSymbols = List.nil();
            Type result;

            Synthesizer(Type originalType, boolean interfaceExpected) {
                this.originalType = originalType;
                this.interfaceExpected = interfaceExpected;
            }

            Type visit(JCTree tree) {
                tree.accept(this);
                return this.result;
            }

            List<Type> visit(List<? extends JCTree> trees) {
                ListBuffer<Type> lb = new ListBuffer<Type>();
                for (JCTree jCTree : trees) {
                    lb.append(this.visit(jCTree));
                }
                return lb.toList();
            }

            @Override
            public void visitTree(JCTree tree) {
                this.result = ((TypeEnter)TypeEnter.this).syms.errType;
            }

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                this.result = !tree.type.hasTag(TypeTag.ERROR) ? tree.type : this.synthesizeClass((Name)tree.name, (Symbol)((TypeEnter)TypeEnter.this).syms.unnamedPackage).type;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitSelect(JCTree.JCFieldAccess tree) {
                if (!tree.type.hasTag(TypeTag.ERROR)) {
                    this.result = tree.type;
                } else {
                    Type selectedType;
                    boolean prev = this.interfaceExpected;
                    try {
                        this.interfaceExpected = false;
                        selectedType = this.visit(tree.selected);
                    }
                    finally {
                        this.interfaceExpected = prev;
                    }
                    Symbol.ClassSymbol c = this.synthesizeClass(tree.name, selectedType.tsym);
                    this.result = c.type;
                }
            }

            @Override
            public void visitTypeApply(JCTree.JCTypeApply tree) {
                if (!tree.type.hasTag(TypeTag.ERROR)) {
                    this.result = tree.type;
                } else {
                    Type.ClassType clazzType = (Type.ClassType)this.visit(tree.clazz);
                    if (this.synthesizedSymbols.contains(clazzType.tsym)) {
                        this.synthesizeTyparams((Symbol.ClassSymbol)clazzType.tsym, tree.arguments.size());
                    }
                    final List<Type> actuals = this.visit(tree.arguments);
                    this.result = new Type.ErrorType(tree.type, clazzType.tsym){

                        @Override
                        public List<Type> getTypeArguments() {
                            return actuals;
                        }
                    };
                }
            }

            Symbol.ClassSymbol synthesizeClass(Name name, Symbol owner) {
                int flags = this.interfaceExpected ? 512 : 0;
                Symbol.ClassSymbol c = new Symbol.ClassSymbol(flags, name, owner);
                c.members_field = new Scope.ErrorScope(c);
                c.type = new Type.ErrorType(this.originalType, (Symbol.TypeSymbol)c){

                    @Override
                    public List<Type> getTypeArguments() {
                        return this.typarams_field;
                    }
                };
                this.synthesizedSymbols = this.synthesizedSymbols.prepend(c);
                return c;
            }

            void synthesizeTyparams(Symbol.ClassSymbol sym, int n) {
                Type.ClassType ct2 = (Type.ClassType)sym.type;
                Assert.check(ct2.typarams_field.isEmpty());
                if (n == 1) {
                    Type.TypeVar v = new Type.TypeVar(TypeEnter.this.names.fromString("T"), sym, ((TypeEnter)TypeEnter.this).syms.botType);
                    ct2.typarams_field = ct2.typarams_field.prepend(v);
                } else {
                    for (int i = n; i > 0; --i) {
                        Type.TypeVar v = new Type.TypeVar(TypeEnter.this.names.fromString("T" + i), sym, ((TypeEnter)TypeEnter.this).syms.botType);
                        ct2.typarams_field = ct2.typarams_field.prepend(v);
                    }
                }
            }
        }
    }

    private final class ImportsPhase
    extends Phase {
        Env<AttrContext> env;
        Scope.ImportFilter staticImportFilter;
        Scope.ImportFilter typeImportFilter;
        BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler;

        public ImportsPhase() {
            super(Dependencies.CompletionCause.IMPORTS_PHASE, new HierarchyPhase());
            this.cfHandler = (imp, cf) -> TypeEnter.this.chk.completionError(imp.pos(), (Symbol.CompletionFailure)cf);
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl tree = env.enclClass;
            Symbol.ClassSymbol sym = tree.sym;
            if (sym.owner.kind == Kinds.Kind.PCK) {
                this.resolveImports(env.toplevel, env.enclosing(JCTree.Tag.TOPLEVEL));
                TypeEnter.this.todo.append(env);
            }
            if (sym.owner.kind == Kinds.Kind.TYP) {
                sym.owner.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveImports(JCTree.JCCompilationUnit tree, Env<AttrContext> env) {
            if (tree.starImportScope.isFilled()) {
                return;
            }
            Scope.ImportFilter prevStaticImportFilter = this.staticImportFilter;
            Scope.ImportFilter prevTypeImportFilter = this.typeImportFilter;
            JCDiagnostic.DiagnosticPosition prevLintPos = TypeEnter.this.deferredLintHandler.immediate();
            Lint prevLint = TypeEnter.this.chk.setLint(TypeEnter.this.lint);
            Env<AttrContext> prevEnv = this.env;
            try {
                this.env = env;
                Symbol.PackageSymbol packge = env.toplevel.packge;
                this.staticImportFilter = (origin, sym) -> sym.isStatic() && TypeEnter.this.chk.importAccessible(sym, packge) && sym.isMemberOf((Symbol.TypeSymbol)origin.owner, TypeEnter.this.types);
                this.typeImportFilter = (origin, sym) -> sym.kind == Kinds.Kind.TYP && TypeEnter.this.chk.importAccessible(sym, packge);
                Symbol.PackageSymbol javaLang = TypeEnter.this.syms.enterPackage(((TypeEnter)TypeEnter.this).names.java_lang);
                if (javaLang.members().isEmpty() && !javaLang.exists()) {
                    throw new FatalError(TypeEnter.this.diags.fragment("fatal.err.no.java.lang", new Object[0]));
                }
                this.importAll(TypeEnter.this.make.at(tree.pos()).Import(TypeEnter.this.make.QualIdent(javaLang), false), javaLang, env);
                if (tree.getPackage() != null) {
                    this.checkClassPackageClash(tree.getPackage());
                }
                for (JCTree.JCImport imp : tree.getImports()) {
                    this.doImport(imp);
                }
            }
            finally {
                this.env = prevEnv;
                TypeEnter.this.chk.setLint(prevLint);
                TypeEnter.this.deferredLintHandler.setPos(prevLintPos);
                this.staticImportFilter = prevStaticImportFilter;
                this.typeImportFilter = prevTypeImportFilter;
            }
        }

        private void checkClassPackageClash(JCTree.JCPackageDecl tree) {
            if (tree.pid != null) {
                Symbol p = this.env.toplevel.packge;
                while (p.owner != ((TypeEnter)TypeEnter.this).syms.rootPackage) {
                    p.owner.complete();
                    if (((TypeEnter)TypeEnter.this).syms.classes.get(((Symbol)p).getQualifiedName()) != null) {
                        TypeEnter.this.log.error(tree.pos, "pkg.clashes.with.class.of.same.name", p);
                    }
                    p = p.owner;
                }
            }
            TypeEnter.this.annotate.annotateLater(tree.annotations, this.env, this.env.toplevel.packge, null);
        }

        private void doImport(JCTree.JCImport tree) {
            JCTree.JCFieldAccess imp = (JCTree.JCFieldAccess)tree.qualid;
            Name name = TreeInfo.name(imp);
            Env<AttrContext> localEnv = this.env.dup(tree);
            Symbol.TypeSymbol p = ((TypeEnter)TypeEnter.this).attr.attribImportQualifier((JCTree.JCImport)tree, localEnv).tsym;
            if (name == ((TypeEnter)TypeEnter.this).names.asterisk) {
                TypeEnter.this.chk.checkCanonical(imp.selected);
                if (tree.staticImport) {
                    this.importStaticAll(tree, p, this.env);
                } else {
                    this.importAll(tree, p, this.env);
                }
            } else if (tree.staticImport) {
                this.importNamedStatic(tree, p, name, localEnv);
                TypeEnter.this.chk.checkCanonical(imp.selected);
            } else {
                Symbol.TypeSymbol c = this.attribImportType((JCTree)imp, localEnv).tsym;
                TypeEnter.this.chk.checkCanonical(imp);
                this.importNamed(tree.pos(), c, this.env, tree);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type attribImportType(JCTree tree, Env<AttrContext> env) {
            Assert.check(TypeEnter.this.completionEnabled);
            Lint prevLint = TypeEnter.this.chk.setLint(TypeEnter.this.allowDeprecationOnImport ? TypeEnter.this.lint : TypeEnter.this.lint.suppress(Lint.LintCategory.DEPRECATION));
            try {
                TypeEnter.this.completionEnabled = false;
                Type type = TypeEnter.this.attr.attribType(tree, env);
                return type;
            }
            finally {
                TypeEnter.this.completionEnabled = true;
                TypeEnter.this.chk.setLint(prevLint);
            }
        }

        private void importAll(JCTree.JCImport imp, Symbol.TypeSymbol tsym, Env<AttrContext> env) {
            env.toplevel.starImportScope.importAll(TypeEnter.this.types, tsym.members(), this.typeImportFilter, imp, this.cfHandler);
        }

        private void importStaticAll(JCTree.JCImport imp, Symbol.TypeSymbol tsym, Env<AttrContext> env) {
            Scope.StarImportScope toScope = env.toplevel.starImportScope;
            Symbol.TypeSymbol origin = tsym;
            toScope.importAll(TypeEnter.this.types, origin.members(), this.staticImportFilter, imp, this.cfHandler);
        }

        private void importNamedStatic(JCTree.JCImport imp, Symbol.TypeSymbol tsym, Name name, Env<AttrContext> env) {
            if (tsym.kind != Kinds.Kind.TYP) {
                TypeEnter.this.log.error(JCDiagnostic.DiagnosticFlag.RECOVERABLE, imp.pos(), "static.imp.only.classes.and.interfaces", new Object[0]);
                return;
            }
            Scope.NamedImportScope toScope = env.toplevel.namedImportScope;
            Scope.WriteableScope originMembers = tsym.members();
            imp.importScope = toScope.importByName(TypeEnter.this.types, originMembers, name, this.staticImportFilter, imp, this.cfHandler);
        }

        private void importNamed(JCDiagnostic.DiagnosticPosition pos, Symbol tsym, Env<AttrContext> env, JCTree.JCImport imp) {
            if (tsym.kind == Kinds.Kind.TYP) {
                imp.importScope = env.toplevel.namedImportScope.importType(tsym.owner.members(), tsym.owner.members(), tsym);
            }
        }
    }

    abstract class Phase {
        private final ListBuffer<Env<AttrContext>> queue = new ListBuffer();
        private final Phase next;
        private final Dependencies.CompletionCause phaseName;

        Phase(Dependencies.CompletionCause phaseName, Phase next) {
            this.phaseName = phaseName;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final List<Env<AttrContext>> completeEnvs(List<Env<AttrContext>> envs) {
            boolean firstToComplete = this.queue.isEmpty();
            Phase prevTopLevelPhase = TypeEnter.this.topLevelPhase;
            try {
                TypeEnter.this.topLevelPhase = this;
                this.doCompleteEnvs(envs);
            }
            finally {
                TypeEnter.this.topLevelPhase = prevTopLevelPhase;
            }
            if (firstToComplete) {
                List<Env<AttrContext>> out = this.queue.toList();
                this.queue.clear();
                return this.next != null ? this.next.completeEnvs(out) : out;
            }
            return List.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doCompleteEnvs(List<Env<AttrContext>> envs) {
            for (Env<AttrContext> env : envs) {
                JCTree.JCClassDecl tree = (JCTree.JCClassDecl)env.tree;
                this.queue.add(env);
                JavaFileObject prev = TypeEnter.this.log.useSource(env.toplevel.sourcefile);
                JCDiagnostic.DiagnosticPosition prevLintPos = TypeEnter.this.deferredLintHandler.setPos(tree.pos());
                try {
                    TypeEnter.this.dependencies.push(env.enclClass.sym, this.phaseName);
                    this.runPhase(env);
                }
                catch (Symbol.CompletionFailure ex) {
                    TypeEnter.this.chk.completionError(tree.pos(), ex);
                }
                finally {
                    TypeEnter.this.dependencies.pop();
                    TypeEnter.this.deferredLintHandler.setPos(prevLintPos);
                    TypeEnter.this.log.useSource(prev);
                }
            }
        }

        protected abstract void runPhase(Env<AttrContext> var1);
    }
}

