/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jline;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import jdk.internal.jline.TerminalSupport;
import jdk.internal.jline.internal.Configuration;
import jdk.internal.jline.internal.Log;

public class WindowsTerminal
extends TerminalSupport {
    public static final String DIRECT_CONSOLE = WindowsTerminal.class.getName() + ".directConsole";
    public static final String ANSI = WindowsTerminal.class.getName() + ".ansi";
    private boolean directConsole;
    private int originalMode;

    public WindowsTerminal() throws Exception {
        super(true);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.setAnsiSupported(false);
        this.setDirectConsole(Configuration.getBoolean(DIRECT_CONSOLE, true));
        this.originalMode = this.getConsoleMode();
        this.setConsoleMode(this.originalMode & ~ConsoleMode.ENABLE_ECHO_INPUT.code);
        this.setEchoEnabled(false);
    }

    @Override
    public void restore() throws Exception {
        this.setConsoleMode(this.originalMode);
        super.restore();
    }

    @Override
    public int getWidth() {
        int w = this.getWindowsTerminalWidth();
        return w < 1 ? 80 : w;
    }

    @Override
    public int getHeight() {
        int h = this.getWindowsTerminalHeight();
        return h < 1 ? 24 : h;
    }

    @Override
    public void setEchoEnabled(boolean enabled) {
        if (enabled) {
            this.setConsoleMode(this.getConsoleMode() | ConsoleMode.ENABLE_ECHO_INPUT.code | ConsoleMode.ENABLE_LINE_INPUT.code | ConsoleMode.ENABLE_PROCESSED_INPUT.code | ConsoleMode.ENABLE_WINDOW_INPUT.code);
        } else {
            this.setConsoleMode(this.getConsoleMode() & ~(ConsoleMode.ENABLE_LINE_INPUT.code | ConsoleMode.ENABLE_ECHO_INPUT.code | ConsoleMode.ENABLE_PROCESSED_INPUT.code | ConsoleMode.ENABLE_WINDOW_INPUT.code));
        }
        super.setEchoEnabled(enabled);
    }

    public void setDirectConsole(boolean flag) {
        this.directConsole = flag;
        Log.debug("Direct console: ", flag);
    }

    public Boolean getDirectConsole() {
        return this.directConsole;
    }

    @Override
    public InputStream wrapInIfNeeded(InputStream in) throws IOException {
        if (this.directConsole && this.isSystemIn(in)) {
            return new InputStream(){
                private byte[] buf = null;
                int bufIdx = 0;

                @Override
                public int read() throws IOException {
                    while (this.buf == null || this.bufIdx == this.buf.length) {
                        this.buf = WindowsTerminal.this.readConsoleInput();
                        this.bufIdx = 0;
                    }
                    int c = this.buf[this.bufIdx] & 0xFF;
                    ++this.bufIdx;
                    return c;
                }
            };
        }
        return super.wrapInIfNeeded(in);
    }

    protected boolean isSystemIn(InputStream in) throws IOException {
        if (in == null) {
            return false;
        }
        if (in == System.in) {
            return true;
        }
        return in instanceof FileInputStream && ((FileInputStream)in).getFD() == FileDescriptor.in;
    }

    @Override
    public String getOutputEncoding() {
        int codepage = this.getConsoleOutputCodepage();
        String charsetMS = "ms" + codepage;
        if (Charset.isSupported(charsetMS)) {
            return charsetMS;
        }
        String charsetCP = "cp" + codepage;
        if (Charset.isSupported(charsetCP)) {
            return charsetCP;
        }
        Log.debug("can't figure out the Java Charset of this code page (" + codepage + ")...");
        return super.getOutputEncoding();
    }

    private static native void initIDs();

    protected native int getConsoleMode();

    protected native void setConsoleMode(int var1);

    private byte[] readConsoleInput() {
        KEY_EVENT_RECORD keyEvent = this.readKeyEvent();
        return WindowsTerminal.convertKeys(keyEvent).getBytes();
    }

    public static String convertKeys(KEY_EVENT_RECORD keyEvent) {
        if (keyEvent == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (keyEvent.keyDown) {
            if (keyEvent.uchar > '\u0000') {
                int altState = 3;
                int ctrlState = 12;
                boolean handled = false;
                if ((keyEvent.controlKeyState & 0xC) != 0) {
                    switch (keyEvent.keyCode) {
                        case 67: {
                            sb.append("\u0003");
                            handled = true;
                        }
                    }
                }
                if ((keyEvent.controlKeyState & 0x10) != 0) {
                    switch (keyEvent.keyCode) {
                        case 9: {
                            sb.append("\u001b[Z");
                            handled = true;
                        }
                    }
                }
                if (!handled) {
                    if ((keyEvent.uchar >= '@' && keyEvent.uchar <= '_' || keyEvent.uchar >= 'a' && keyEvent.uchar <= 'z') && (keyEvent.controlKeyState & 3) != 0 && (keyEvent.controlKeyState & 0xC) == 0) {
                        sb.append('\u001b');
                    }
                    sb.append(keyEvent.uchar);
                }
            } else {
                String escapeSequence = null;
                switch (keyEvent.keyCode) {
                    case 33: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[5~", "\u001b[5;%d~");
                        break;
                    }
                    case 34: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[6~", "\u001b[6;%d~");
                        break;
                    }
                    case 35: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[4~", "\u001b[4;%d~");
                        break;
                    }
                    case 36: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[1~", "\u001b[1;%d~");
                        break;
                    }
                    case 37: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[D", "\u001b[1;%dD");
                        break;
                    }
                    case 38: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[A", "\u001b[1;%dA");
                        break;
                    }
                    case 39: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[C", "\u001b[1;%dC");
                        break;
                    }
                    case 40: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[B", "\u001b[1;%dB");
                        break;
                    }
                    case 45: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[2~", "\u001b[2;%d~");
                        break;
                    }
                    case 46: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[3~", "\u001b[3;%d~");
                        break;
                    }
                    case 112: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001bOP", "\u001bO%dP");
                        break;
                    }
                    case 113: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001bOQ", "\u001bO%dQ");
                        break;
                    }
                    case 114: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001bOR", "\u001bO%dR");
                        break;
                    }
                    case 115: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001bOS", "\u001bO%dS");
                        break;
                    }
                    case 116: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[15~", "\u001b[15;%d~");
                        break;
                    }
                    case 117: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[17~", "\u001b[17;%d~");
                        break;
                    }
                    case 118: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[18~", "\u001b[18;%d~");
                        break;
                    }
                    case 119: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[19~", "\u001b[19;%d~");
                        break;
                    }
                    case 120: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[20~", "\u001b[20;%d~");
                        break;
                    }
                    case 121: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[21~", "\u001b[21;%d~");
                        break;
                    }
                    case 122: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[23~", "\u001b[23;%d~");
                        break;
                    }
                    case 123: {
                        escapeSequence = WindowsTerminal.escapeSequence(keyEvent.controlKeyState, "\u001b[24~", "\u001b[24;%d~");
                        break;
                    }
                }
                if (escapeSequence != null) {
                    for (int k = 0; k < keyEvent.repeatCount; ++k) {
                        sb.append(escapeSequence);
                    }
                }
            }
        } else if (keyEvent.keyCode == 18 && keyEvent.uchar > '\u0000') {
            sb.append(keyEvent.uchar);
        }
        return sb.toString();
    }

    private static String escapeSequence(int controlKeyState, String noControlSequence, String withControlSequence) {
        int controlNum = 1;
        if ((controlKeyState & 0x10) != 0) {
            ++controlNum;
        }
        if ((controlKeyState & 3) != 0) {
            controlNum += 2;
        }
        if ((controlKeyState & 0xC) != 0) {
            controlNum += 4;
        }
        if (controlNum > 1) {
            return String.format(withControlSequence, controlNum);
        }
        return noControlSequence;
    }

    private native KEY_EVENT_RECORD readKeyEvent();

    private native int getConsoleOutputCodepage();

    private native int getWindowsTerminalWidth();

    private native int getWindowsTerminalHeight();

    static {
        System.loadLibrary("le");
        WindowsTerminal.initIDs();
    }

    public static enum ConsoleMode {
        ENABLE_LINE_INPUT(2),
        ENABLE_ECHO_INPUT(4),
        ENABLE_PROCESSED_INPUT(1),
        ENABLE_WINDOW_INPUT(8),
        ENABLE_MOUSE_INPUT(16),
        ENABLE_PROCESSED_OUTPUT(1),
        ENABLE_WRAP_AT_EOL_OUTPUT(2);

        public final int code;

        private ConsoleMode(int code) {
            this.code = code;
        }
    }

    public static class KEY_EVENT_RECORD {
        public static final int ALT_PRESSED = 3;
        public static final int CTRL_PRESSED = 12;
        public static final int SHIFT_PRESSED = 16;
        public final boolean keyDown;
        public final char uchar;
        public final int controlKeyState;
        public final int keyCode;
        public final int repeatCount;

        public KEY_EVENT_RECORD(boolean keyDown, char uchar, int controlKeyState, int keyCode, int repeatCount) {
            this.keyDown = keyDown;
            this.uchar = uchar;
            this.controlKeyState = controlKeyState;
            this.keyCode = keyCode;
            this.repeatCount = repeatCount;
        }
    }
}

