/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.tool;

import com.sun.source.util.DocTrees;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileManager;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.internal.tool.DocEnv;

public class RootDocImpl
implements DocletEnvironment {
    private Set<TypeElement> cmdLineClasses;
    private Set<PackageElement> cmdLinePackages;
    public final DocEnv env;
    private Set<TypeElement> classesToDocument = null;

    public RootDocImpl(DocEnv env, List<JCTree.JCClassDecl> classes, List<String> packages) {
        this.env = env;
        this.setPackages(env, packages);
        this.setClasses(env, classes);
    }

    public RootDocImpl(DocEnv env, List<String> classes) {
        this.env = env;
        LinkedHashSet<TypeElement> classList = new LinkedHashSet<TypeElement>();
        for (String className : classes) {
            TypeElement c = env.loadClass(className);
            if (c == null) {
                env.error(null, "javadoc.class_not_found", className);
                continue;
            }
            classList.add(c);
        }
        this.cmdLineClasses = classList;
    }

    private void setClasses(DocEnv env, List<JCTree.JCClassDecl> classes) {
        LinkedHashSet result = new LinkedHashSet();
        classes.stream().filter(def -> env.shouldDocument(def.sym)).forEach(def -> {
            Symbol.ClassSymbol te = def.sym;
            if (te != null) {
                env.setIncluded(def.sym);
                result.add(te);
            }
        });
        this.cmdLineClasses = Collections.unmodifiableSet(result);
    }

    private void setPackages(DocEnv env, List<String> packages) {
        LinkedHashSet packlist = new LinkedHashSet();
        packages.stream().forEach(name -> {
            PackageElement pkg = this.getElementUtils().getPackageElement((CharSequence)name);
            if (pkg != null) {
                env.setIncluded(pkg);
                packlist.add(pkg);
            } else {
                env.warning("main.no_source_files_for_package", (String)name);
            }
        });
        this.cmdLinePackages = Collections.unmodifiableSet(packlist);
    }

    public Set<PackageElement> specifiedPackages() {
        return this.cmdLinePackages;
    }

    public Set<TypeElement> specifiedClasses() {
        LinkedHashSet<TypeElement> out = new LinkedHashSet<TypeElement>();
        this.cmdLineClasses.stream().forEach(te -> this.env.addAllClasses((Collection<TypeElement>)out, (TypeElement)te, true));
        return out;
    }

    @Override
    public Set<TypeElement> getIncludedClasses() {
        if (this.classesToDocument == null) {
            LinkedHashSet classes = new LinkedHashSet();
            this.cmdLineClasses.stream().forEach(te -> this.env.addAllClasses(classes, (TypeElement)te, true));
            this.cmdLinePackages.stream().forEach(pkg -> this.env.addAllClasses(classes, (PackageElement)pkg));
            this.classesToDocument = Collections.unmodifiableSet(classes);
        }
        return this.classesToDocument;
    }

    public String name() {
        return "*RootDocImpl*";
    }

    public String qualifiedName() {
        return "*RootDocImpl*";
    }

    @Override
    public boolean isIncluded(Element e) {
        return this.env.isIncluded(e);
    }

    public JavaFileManager getFileManager() {
        return this.env.fileManager;
    }

    @Override
    public DocTrees getDocTrees() {
        return this.env.docTrees;
    }

    @Override
    public Elements getElementUtils() {
        return this.env.elements;
    }

    @Override
    public List<Element> getSelectedElements(List<? extends Element> elements) {
        return elements.stream().filter(e -> this.isIncluded((Element)e)).collect(Collectors.toList());
    }

    @Override
    public Set<Element> getSpecifiedElements() {
        LinkedHashSet<Element> out = new LinkedHashSet<Element>();
        this.specifiedPackages().stream().forEach(pe -> out.add((Element)pe));
        this.specifiedClasses().stream().forEach(e -> out.add((Element)e));
        return out;
    }

    @Override
    public Types getTypeUtils() {
        return this.env.typeutils;
    }

    @Override
    public JavaFileManager getJavaFileManager() {
        return this.env.fileManager;
    }

    @Override
    public SourceVersion getSourceVersion() {
        return Source.toSourceVersion(this.env.source);
    }
}

