/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JRTIndex;
import com.sun.tools.javac.file.Locations;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JavacFileManager
extends BaseFileManager
implements StandardJavaFileManager {
    private FSInfo fsInfo;
    private final Set<JavaFileObject.Kind> sourceOrClass = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    protected boolean symbolFileEnabled;
    protected SortFiles sortFiles;
    private final Map<Path, Container> containers = new HashMap<Path, Container>();
    private static final Container MISSING_CONTAINER = new Container(){

        @Override
        public void list(Path userPath, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) throws IOException {
        }

        @Override
        public JavaFileObject getFileObject(Path userPath, RelativePath.RelativeFile name) throws IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    };
    private JRTIndex jrtIndex;
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';

    public static char[] toArray(CharBuffer buffer) {
        if (buffer.hasArray()) {
            return ((CharBuffer)buffer.compact().flip()).array();
        }
        return buffer.toString().toCharArray();
    }

    public static void preRegister(Context context) {
        context.put(JavaFileManager.class, new Context.Factory<JavaFileManager>(){

            @Override
            public JavaFileManager make(Context c) {
                return new JavacFileManager(c, true, null);
            }
        });
    }

    public JavacFileManager(Context context, boolean register, Charset charset) {
        super(charset);
        if (register) {
            context.put(JavaFileManager.class, this);
        }
        this.setContext(context);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.fsInfo = FSInfo.instance(context);
        this.symbolFileEnabled = !this.options.isSet("ignore.symbol.file");
        String sf = this.options.get("sortFiles");
        if (sf != null) {
            this.sortFiles = sf.equals("reverse") ? SortFiles.REVERSE : SortFiles.FORWARD;
        }
    }

    public void setSymbolFileEnabled(boolean b) {
        this.symbolFileEnabled = b;
    }

    public boolean isSymbolFileEnabled() {
        return this.symbolFileEnabled;
    }

    public JavaFileObject getJavaFileObject(String name) {
        return this.getJavaFileObjects(name).iterator().next();
    }

    public JavaFileObject getJavaFileObject(Path file) {
        return this.getJavaFileObjects(file).iterator().next();
    }

    public JavaFileObject getFileForOutput(String classname, JavaFileObject.Kind kind, JavaFileObject sibling) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, classname, kind, sibling);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        ListBuffer<Path> paths = new ListBuffer<Path>();
        for (String name : names) {
            paths.append(Paths.get(JavacFileManager.nullCheck(name), new String[0]));
        }
        return this.getJavaFileObjectsFromPaths(paths.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList((Object[])JavacFileManager.nullCheck(names)));
    }

    private static boolean isValidName(String name) {
        for (String s : name.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String className) {
        if (!JavacFileManager.isValidName(className)) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
    }

    private static void validatePackageName(String packageName) {
        if (packageName.length() > 0 && !JavacFileManager.isValidName(packageName)) {
            throw new IllegalArgumentException("Invalid packageName name: " + packageName);
        }
    }

    public static void testName(String name, boolean isValidPackageName, boolean isValidClassName) {
        try {
            JavacFileManager.validatePackageName(name);
            if (!isValidPackageName) {
                throw new AssertionError((Object)("Invalid package name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidPackageName) {
                throw new AssertionError((Object)("Valid package name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", name);
        }
        try {
            JavacFileManager.validateClassName(name);
            if (!isValidClassName) {
                throw new AssertionError((Object)("Invalid class name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidClassName) {
                throw new AssertionError((Object)("Valid class name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", name);
        }
    }

    private static void printAscii(String format, Object ... args) {
        String message;
        try {
            String ascii = "US-ASCII";
            message = new String(String.format(null, format, args).getBytes("US-ASCII"), "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
        System.out.println(message);
    }

    synchronized Container getContainer(Path path) throws IOException {
        Container fs = this.containers.get(path);
        if (fs != null) {
            return fs;
        }
        if (path.endsWith("bootmodules.jimage")) {
            System.err.println("Warning: reference to bootmodules.jimage replaced by jrt:");
            path = Locations.JRT_MARKER_FILE;
        } else if (path.getNameCount() > 0 && path.getFileName().toString().endsWith(".jimage")) {
            System.err.println("Warning: reference to " + path + " ignored");
            return MISSING_CONTAINER;
        }
        if (path == Locations.JRT_MARKER_FILE) {
            fs = new JRTImageContainer();
            this.containers.put(path, fs);
            return fs;
        }
        Path realPath = this.fsInfo.getCanonicalFile(path);
        fs = this.containers.get(realPath);
        if (fs != null) {
            this.containers.put(path, fs);
            return fs;
        }
        BasicFileAttributes attr = null;
        try {
            attr = Files.readAttributes(realPath, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException ex) {
            fs = MISSING_CONTAINER;
        }
        if (attr != null) {
            if (attr.isDirectory()) {
                fs = new DirectoryContainer(path);
            } else {
                try {
                    fs = new ArchiveContainer(path);
                }
                catch (SecurityException | ProviderNotFoundException ex) {
                    throw new IOException(ex);
                }
            }
        }
        this.containers.put(realPath, fs);
        this.containers.put(path, fs);
        return fs;
    }

    private synchronized JRTIndex getJRTIndex() {
        if (this.jrtIndex == null) {
            this.jrtIndex = JRTIndex.getSharedInstance();
        }
        return this.jrtIndex;
    }

    private boolean isValidFile(String s, Set<JavaFileObject.Kind> fileKinds) {
        JavaFileObject.Kind kind = JavacFileManager.getKind(s);
        return fileKinds.contains((Object)kind);
    }

    private boolean caseMapCheck(Path f, RelativePath name) {
        char sep;
        String path;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            path = f.toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
            sep = f.getFileSystem().getSeparator().charAt(0);
        }
        catch (IOException ex) {
            return false;
        }
        char[] pcs = path.toCharArray();
        char[] ncs = name.path.toCharArray();
        int i = pcs.length - 1;
        int j = ncs.length - 1;
        while (i >= 0 && j >= 0) {
            while (i >= 0 && pcs[i] == sep) {
                --i;
            }
            while (j >= 0 && ncs[j] == '/') {
                --j;
            }
            if (i < 0 || j < 0) continue;
            if (pcs[i] != ncs[j]) {
                return false;
            }
            --i;
            --j;
        }
        return j < 0;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.deferredCloseTimeout > 0L) {
            this.deferredClose();
            return;
        }
        for (Container container : this.containers.values()) {
            container.close();
        }
        this.containers.clear();
        this.contentCache.clear();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        ListBuffer<URL> lb = new ListBuffer<URL>();
        for (File file : path) {
            try {
                lb.append(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.getClassLoader(lb.toArray(new URL[lb.size()]));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        JavacFileManager.nullCheck(packageName);
        JavacFileManager.nullCheck(kinds);
        Iterable<? extends Path> path = this.getLocationAsPaths(location);
        if (path == null) {
            return List.nil();
        }
        RelativePath.RelativeDirectory subdirectory = RelativePath.RelativeDirectory.forPackage(packageName);
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (Path path2 : path) {
            Container container = this.getContainer(path2);
            container.list(path2, subdirectory, kinds, recurse, results);
        }
        return results.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        Objects.requireNonNull(file);
        Objects.requireNonNull(location);
        Iterable<? extends Path> path = this.getLocationAsPaths(location);
        if (path == null) {
            return null;
        }
        if (file instanceof PathFileObject) {
            return ((PathFileObject)file).inferBinaryName(path);
        }
        throw new IllegalArgumentException(file.getClass().getName());
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        JavacFileManager.nullCheck(a);
        JavacFileManager.nullCheck(b);
        if (a instanceof PathFileObject && b instanceof PathFileObject) {
            return ((PathFileObject)a).isSameFile((PathFileObject)b);
        }
        return a.equals(b);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.getLocation(location) != null;
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, RelativePath.RelativeFile.forClass(className, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(relativeName)) {
            throw new IllegalArgumentException("Invalid relative name: " + relativeName);
        }
        RelativePath.RelativeFile name = packageName.length() == 0 ? new RelativePath.RelativeFile(relativeName) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(packageName), relativeName);
        return this.getFileForInput(location, name);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, RelativePath.RelativeFile name) throws IOException {
        Iterable<? extends Path> path = this.getLocationAsPaths(location);
        if (path == null) {
            return null;
        }
        for (Path path2 : path) {
            JavaFileObject fo = this.getContainer(path2).getFileObject(path2, name);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!this.sourceOrClass.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, RelativePath.RelativeFile.forClass(className, kind), sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(relativeName)) {
            throw new IllegalArgumentException("Invalid relative name: " + relativeName);
        }
        RelativePath.RelativeFile name = packageName.length() == 0 ? new RelativePath.RelativeFile(relativeName) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(packageName), relativeName);
        return this.getFileForOutput(location, name, sibling);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile fileName, FileObject sibling) throws IOException {
        Path dir;
        block10: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    dir = this.getClassOutDir();
                    break block10;
                } else {
                    String string = fileName.basename();
                    if (sibling != null && sibling instanceof PathFileObject) {
                        return ((PathFileObject)sibling).getSibling(string);
                    }
                    Path p = Paths.get(string, new String[0]);
                    Path real = this.fsInfo.getCanonicalFile(p);
                    return PathFileObject.forSimplePath(this, real, p);
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                dir = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                Collection<Path> collection = this.locations.getLocation(location);
                dir = null;
                Iterator iterator = collection.iterator();
                if (iterator.hasNext()) {
                    Path f;
                    dir = f = (Path)iterator.next();
                }
            }
        }
        try {
            if (dir == null) {
                dir = Paths.get(System.getProperty("user.dir"), new String[0]);
            }
            Path path = fileName.resolveAgainst(this.fsInfo.getCanonicalFile(dir));
            return PathFileObject.forDirectoryPath(this, path, dir, fileName);
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("bad filename " + fileName, invalidPathException);
        }
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<PathFileObject> result = files instanceof Collection ? new ArrayList(((Collection)files).size()) : new ArrayList<PathFileObject>();
        for (File file : files) {
            Objects.requireNonNull(file);
            Path p = file.toPath();
            result.add(PathFileObject.forSimplePath(this, this.fsInfo.getCanonicalFile(p), p));
        }
        return result;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> paths) {
        ArrayList<PathFileObject> result = paths instanceof Collection ? new ArrayList(((Collection)paths).size()) : new ArrayList<PathFileObject>();
        for (Path path : paths) {
            result.add(PathFileObject.forSimplePath(this, this.fsInfo.getCanonicalFile(path), path));
        }
        return result;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList((Object[])JavacFileManager.nullCheck(files)));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... paths) {
        return this.getJavaFileObjectsFromPaths(Arrays.asList((Object[])JavacFileManager.nullCheck(paths)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> searchpath) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, JavacFileManager.asPaths(searchpath));
    }

    @Override
    public void setLocationFromPaths(JavaFileManager.Location location, Iterable<? extends Path> searchpath) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, JavacFileManager.nullCheck(searchpath));
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return JavacFileManager.asFiles(this.locations.getLocation(location));
    }

    @Override
    public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.getLocation(location);
    }

    private Path getClassOutDir() {
        return this.locations.getOutputLocation(StandardLocation.CLASS_OUTPUT);
    }

    private Path getSourceOutDir() {
        return this.locations.getOutputLocation(StandardLocation.SOURCE_OUTPUT);
    }

    @Override
    public Path asPath(FileObject file) {
        if (file instanceof PathFileObject) {
            return ((PathFileObject)file).path;
        }
        throw new IllegalArgumentException(file.getName());
    }

    protected static boolean isRelativeUri(URI uri) {
        if (uri.isAbsolute()) {
            return false;
        }
        String path = uri.normalize().getPath();
        if (path.length() == 0) {
            return false;
        }
        if (!path.equals(uri.getPath())) {
            return false;
        }
        return !path.startsWith("/") && !path.startsWith("./") && !path.startsWith("../");
    }

    protected static boolean isRelativeUri(String u) {
        try {
            return JavacFileManager.isRelativeUri(new URI(u));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static String getRelativeName(File file) {
        String result;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(result = file.getPath().replace(File.separatorChar, '/'))) {
            return result;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    public static String getMessage(IOException e) {
        String s = e.getLocalizedMessage();
        if (s != null) {
            return s;
        }
        s = e.getMessage();
        if (s != null) {
            return s;
        }
        return e.toString();
    }

    private static Iterable<Path> asPaths(final Iterable<? extends File> files) {
        if (files == null) {
            return null;
        }
        return () -> new Iterator<Path>(){
            Iterator iter;
            {
                this.iter = files.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return ((File)this.iter.next()).toPath();
            }
        };
    }

    private static Iterable<File> asFiles(final Iterable<? extends Path> paths) {
        if (paths == null) {
            return null;
        }
        return () -> new Iterator<File>(){
            Iterator iter;
            {
                this.iter = paths.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                try {
                    return ((Path)this.iter.next()).toFile();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    private final class ArchiveContainer
    implements Container {
        private final Path archivePath;
        private final FileSystem fileSystem;
        private final Map<RelativePath, Path> packages;

        public ArchiveContainer(Path archivePath) throws IOException, ProviderNotFoundException, SecurityException {
            this.archivePath = archivePath;
            this.fileSystem = FileSystems.newFileSystem(archivePath, null);
            this.packages = new HashMap<RelativePath, Path>();
            for (final Path root : this.fileSystem.getRootDirectories()) {
                Files.walkFileTree(root, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        if (ArchiveContainer.this.isValid(dir.getFileName())) {
                            ArchiveContainer.this.packages.put(new RelativePath.RelativeDirectory(root.relativize(dir).toString()), dir);
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                });
            }
        }

        @Override
        public void list(Path userPath, RelativePath.RelativeDirectory subdirectory, final Set<JavaFileObject.Kind> fileKinds, boolean recurse, final ListBuffer<JavaFileObject> resultList) throws IOException {
            Path resolvedSubdirectory = this.packages.get(subdirectory);
            if (resolvedSubdirectory == null) {
                return;
            }
            int maxDepth = recurse ? Integer.MAX_VALUE : 1;
            EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            Files.walkFileTree(resolvedSubdirectory, opts, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (ArchiveContainer.this.isValid(dir.getFileName())) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (attrs.isRegularFile() && fileKinds.contains((Object)BaseFileManager.getKind(file.getFileName().toString()))) {
                        PathFileObject fe = PathFileObject.forJarPath(JavacFileManager.this, file, ArchiveContainer.this.archivePath);
                        resultList.append(fe);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        boolean isValid(Path fileName) {
            if (fileName == null) {
                return true;
            }
            String name = fileName.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return SourceVersion.isIdentifier(name);
        }

        @Override
        public JavaFileObject getFileObject(Path userPath, RelativePath.RelativeFile name) throws IOException {
            Path relpath;
            RelativePath.RelativeDirectory root = name.dirname();
            Path packagepath = this.packages.get(root);
            if (packagepath != null && Files.exists(relpath = packagepath.resolve(name.basename()), new LinkOption[0])) {
                return PathFileObject.forJarPath(JavacFileManager.this, relpath, userPath);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.fileSystem.close();
        }
    }

    private final class DirectoryContainer
    implements Container {
        private final Path directory;

        public DirectoryContainer(Path directory) {
            this.directory = directory;
        }

        @Override
        public void list(Path userPath, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) throws IOException {
            java.util.List files;
            Path d;
            try {
                d = subdirectory.resolveAgainst(userPath);
            }
            catch (InvalidPathException ignore) {
                return;
            }
            if (!Files.exists(d, new LinkOption[0])) {
                return;
            }
            if (!JavacFileManager.this.caseMapCheck(d, subdirectory)) {
                return;
            }
            try (Stream<Path> s = Files.list(d);){
                files = (JavacFileManager.this.sortFiles == null ? s : s.sorted(JavacFileManager.this.sortFiles)).collect(Collectors.toList());
            }
            catch (IOException ignore) {
                return;
            }
            for (Path f : files) {
                String fname = f.getFileName().toString();
                if (fname.endsWith("/")) {
                    fname = fname.substring(0, fname.length() - 1);
                }
                if (Files.isDirectory(f, new LinkOption[0])) {
                    if (!recurse || !SourceVersion.isIdentifier(fname)) continue;
                    this.list(userPath, new RelativePath.RelativeDirectory(subdirectory, fname), fileKinds, recurse, resultList);
                    continue;
                }
                if (!JavacFileManager.this.isValidFile(fname, fileKinds)) continue;
                RelativePath.RelativeFile file = new RelativePath.RelativeFile(subdirectory, fname);
                PathFileObject fe = PathFileObject.forDirectoryPath(JavacFileManager.this, file.resolveAgainst(this.directory), userPath, file);
                resultList.append(fe);
            }
        }

        @Override
        public JavaFileObject getFileObject(Path userPath, RelativePath.RelativeFile name) throws IOException {
            try {
                Path f = name.resolveAgainst(userPath);
                if (Files.exists(f, new LinkOption[0])) {
                    return PathFileObject.forSimplePath(JavacFileManager.this, JavacFileManager.this.fsInfo.getCanonicalFile(f), f);
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private final class JRTImageContainer
    implements Container {
        private JRTImageContainer() {
        }

        @Override
        public void list(Path userPath, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) throws IOException {
            try {
                JRTIndex.Entry e = JavacFileManager.this.getJRTIndex().getEntry(subdirectory);
                if (JavacFileManager.this.symbolFileEnabled && e.ctSym.hidden) {
                    return;
                }
                for (Path file : e.files.values()) {
                    if (!fileKinds.contains((Object)BaseFileManager.getKind(file))) continue;
                    PathFileObject fe = PathFileObject.forJRTPath(JavacFileManager.this, file);
                    resultList.append(fe);
                }
                if (recurse) {
                    for (RelativePath.RelativeDirectory rd : e.subdirs) {
                        this.list(userPath, rd, fileKinds, recurse, resultList);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                JavacFileManager.this.log.error("error.reading.file", userPath, JavacFileManager.getMessage(ex));
            }
        }

        @Override
        public JavaFileObject getFileObject(Path userPath, RelativePath.RelativeFile name) throws IOException {
            JRTIndex.Entry e = JavacFileManager.this.getJRTIndex().getEntry(name.dirname());
            if (JavacFileManager.this.symbolFileEnabled && e.ctSym.hidden) {
                return null;
            }
            Path p = e.files.get(name.basename());
            if (p != null) {
                return PathFileObject.forJRTPath(JavacFileManager.this, p);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static interface Container {
        public void list(Path var1, RelativePath.RelativeDirectory var2, Set<JavaFileObject.Kind> var3, boolean var4, ListBuffer<JavaFileObject> var5) throws IOException;

        public JavaFileObject getFileObject(Path var1, RelativePath.RelativeFile var2) throws IOException;

        public void close() throws IOException;
    }

    protected static enum SortFiles implements Comparator<Path>
    {
        FORWARD{

            @Override
            public int compare(Path f1, Path f2) {
                return f1.getFileName().compareTo(f2.getFileName());
            }
        }
        ,
        REVERSE{

            @Override
            public int compare(Path f1, Path f2) {
                return -f1.getFileName().compareTo(f2.getFileName());
            }
        };

    }
}

