/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jshell.tool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.internal.jline.console.history.History;
import jdk.internal.jline.console.history.MemoryHistory;
import jdk.jshell.SourceCodeAnalysis;

public abstract class EditingHistory
implements History {
    private final Preferences prefs;
    private final History fullHistory;
    private History currentDelegate;
    private static final String HISTORY_LINE_PREFIX = "HISTORY_LINE_";
    private static final String HISTORY_SNIPPET_START = "HISTORY_SNIPPET";

    protected EditingHistory(Preferences prefs) {
        this.prefs = prefs;
        this.currentDelegate = this.fullHistory = new MemoryHistory();
        this.load();
    }

    public int size() {
        return this.currentDelegate.size();
    }

    public boolean isEmpty() {
        return this.currentDelegate.isEmpty();
    }

    public int index() {
        return this.currentDelegate.index();
    }

    public void clear() {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        this.currentDelegate.clear();
    }

    public CharSequence get(int index) {
        return this.currentDelegate.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CharSequence line) {
        int fullSize;
        NarrowingHistoryLine currentLine = null;
        int origIndex = this.fullHistory.index();
        try {
            this.fullHistory.moveToEnd();
            fullSize = this.fullHistory.index();
            if (this.currentDelegate == this.fullHistory && origIndex < this.fullHistory.index()) {
                for (History.Entry entry : this.fullHistory) {
                    int[] cluster;
                    if (!(entry.value() instanceof NarrowingHistoryLine) || (cluster = ((NarrowingHistoryLine)entry.value()).span)[0] != origIndex || cluster[1] <= cluster[0]) continue;
                    this.currentDelegate = new MemoryHistory();
                    for (int i = cluster[0]; i <= cluster[1]; ++i) {
                        this.currentDelegate.add(this.fullHistory.get(i));
                    }
                }
            }
            this.fullHistory.moveToEnd();
            while (this.fullHistory.previous()) {
                CharSequence c = this.fullHistory.current();
                if (!(c instanceof NarrowingHistoryLine)) continue;
                currentLine = (NarrowingHistoryLine)c;
                break;
            }
        }
        finally {
            this.fullHistory.moveTo(origIndex);
        }
        if (currentLine == null || currentLine.span[1] != -1) {
            currentLine = new NarrowingHistoryLine(line, fullSize);
            line = currentLine;
        }
        StringBuilder complete = new StringBuilder();
        for (int i = currentLine.span[0]; i < fullSize; ++i) {
            complete.append(this.fullHistory.get(i));
        }
        complete.append(line);
        if (this.analyzeCompletion((String)complete.toString()).completeness.isComplete) {
            ((NarrowingHistoryLine)currentLine).span[1] = fullSize;
            this.currentDelegate = this.fullHistory;
        }
        this.fullHistory.add(line);
    }

    protected abstract SourceCodeAnalysis.CompletionInfo analyzeCompletion(String var1);

    public void set(int index, CharSequence item) {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        this.currentDelegate.set(index, item);
    }

    public CharSequence remove(int i) {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        return this.currentDelegate.remove(i);
    }

    public CharSequence removeFirst() {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        return this.currentDelegate.removeFirst();
    }

    public CharSequence removeLast() {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        return this.currentDelegate.removeLast();
    }

    public void replace(CharSequence item) {
        if (this.currentDelegate != this.fullHistory) {
            throw new IllegalStateException("narrowed");
        }
        this.currentDelegate.replace(item);
    }

    public ListIterator<History.Entry> entries(int index) {
        return this.currentDelegate.entries(index);
    }

    public ListIterator<History.Entry> entries() {
        return this.currentDelegate.entries();
    }

    public Iterator<History.Entry> iterator() {
        return this.currentDelegate.iterator();
    }

    public CharSequence current() {
        return this.currentDelegate.current();
    }

    public boolean previous() {
        return this.currentDelegate.previous();
    }

    public boolean next() {
        return this.currentDelegate.next();
    }

    public boolean moveToFirst() {
        return this.currentDelegate.moveToFirst();
    }

    public boolean moveToLast() {
        return this.currentDelegate.moveToLast();
    }

    public boolean moveTo(int index) {
        return this.currentDelegate.moveTo(index);
    }

    public void moveToEnd() {
        this.currentDelegate.moveToEnd();
    }

    public boolean previousSnippet() {
        for (int i = this.index() - 1; i >= 0; --i) {
            if (!(this.get(i) instanceof NarrowingHistoryLine)) continue;
            this.moveTo(i);
            return true;
        }
        return false;
    }

    public boolean nextSnippet() {
        for (int i = this.index() + 1; i < this.size(); ++i) {
            if (!(this.get(i) instanceof NarrowingHistoryLine)) continue;
            this.moveTo(i);
            return true;
        }
        if (this.index() < this.size()) {
            this.moveToEnd();
            return true;
        }
        return false;
    }

    public final void load() {
        try {
            HashSet<Integer> snippetsStart = new HashSet<Integer>();
            for (String start : this.prefs.get(HISTORY_SNIPPET_START, "").split(";")) {
                if (start.isEmpty()) continue;
                snippetsStart.add(Integer.parseInt(start));
            }
            List keys = Stream.of(this.prefs.keys()).sorted().collect(Collectors.toList());
            class PersistentNarrowingHistoryLine
            extends NarrowingHistoryLine
            implements PersistentEntryMarker {
                public PersistentNarrowingHistoryLine(CharSequence delegate, int start) {
                    super(delegate, start);
                }
            }
            PersistentNarrowingHistoryLine currentHistoryLine = null;
            int currentLine = 0;
            for (String key : keys) {
                if (!key.startsWith(HISTORY_LINE_PREFIX)) continue;
                CharSequence line = this.prefs.get(key, "");
                if (snippetsStart.contains(currentLine)) {
                    currentHistoryLine = new PersistentNarrowingHistoryLine(line, currentLine);
                    line = currentHistoryLine;
                } else {
                    class PersistentLine
                    implements CharSequence,
                    PersistentEntryMarker {
                        private final CharSequence delegate;

                        public PersistentLine(CharSequence delegate) {
                            this.delegate = delegate;
                        }

                        @Override
                        public int length() {
                            return this.delegate.length();
                        }

                        @Override
                        public char charAt(int index) {
                            return this.delegate.charAt(index);
                        }

                        @Override
                        public CharSequence subSequence(int start, int end) {
                            return this.delegate.subSequence(start, end);
                        }

                        @Override
                        public String toString() {
                            return this.delegate.toString();
                        }
                    }
                    line = new PersistentLine(line);
                }
                if (currentHistoryLine != null) {
                    ((NarrowingHistoryLine)currentHistoryLine).span[1] = currentLine;
                }
                ++currentLine;
                this.fullHistory.add(line);
            }
            currentLine = 0;
        }
        catch (BackingStoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void save() {
        try {
            for (String key : this.prefs.keys()) {
                if (!key.startsWith(HISTORY_LINE_PREFIX)) continue;
                this.prefs.remove(key);
            }
            Iterator entries = this.fullHistory.iterator();
            if (entries.hasNext()) {
                int len = (int)Math.ceil(Math.log10(this.fullHistory.size() + 1));
                String format = "HISTORY_LINE_%0" + len + "d";
                StringBuilder snippetStarts = new StringBuilder();
                String snippetStartDelimiter = "";
                while (entries.hasNext()) {
                    History.Entry entry = (History.Entry)entries.next();
                    this.prefs.put(String.format(format, entry.index()), entry.value().toString());
                    if (!(entry.value() instanceof NarrowingHistoryLine)) continue;
                    snippetStarts.append(snippetStartDelimiter);
                    snippetStarts.append(entry.index());
                    snippetStartDelimiter = ";";
                }
                this.prefs.put(HISTORY_SNIPPET_START, snippetStarts.toString());
            }
        }
        catch (BackingStoreException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public List<String> currentSessionEntries() {
        ArrayList<String> result = new ArrayList<String>();
        for (History.Entry e : this.fullHistory) {
            if (e.value() instanceof PersistentEntryMarker) continue;
            result.add(e.value().toString());
        }
        return result;
    }

    void fullHistoryReplace(String source) {
        this.fullHistory.replace((CharSequence)source);
    }

    private static interface PersistentEntryMarker {
    }

    private class NarrowingHistoryLine
    implements CharSequence {
        private final CharSequence delegate;
        private final int[] span;

        public NarrowingHistoryLine(CharSequence delegate, int start) {
            this.delegate = delegate;
            this.span = new int[]{start, -1};
        }

        @Override
        public int length() {
            return this.delegate.length();
        }

        @Override
        public char charAt(int index) {
            return this.delegate.charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.delegate.subSequence(start, end);
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

