/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.builders;

import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.PropertyWriter;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractMemberBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.XMLNode;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class PropertyBuilder
extends AbstractMemberBuilder {
    private final TypeElement typeElement;
    private final VisibleMemberMap visibleMemberMap;
    private final PropertyWriter writer;
    private final SortedSet<Element> properties;
    private ExecutableElement currentProperty;

    private PropertyBuilder(AbstractBuilder.Context context, TypeElement typeElement, PropertyWriter writer) {
        super(context);
        this.typeElement = typeElement;
        this.writer = writer;
        this.visibleMemberMap = new VisibleMemberMap(typeElement, VisibleMemberMap.Kind.PROPERTIES, this.configuration);
        this.properties = this.visibleMemberMap.getMembersFor(typeElement);
    }

    public static PropertyBuilder getInstance(AbstractBuilder.Context context, TypeElement typeElement, PropertyWriter writer) {
        return new PropertyBuilder(context, typeElement, writer);
    }

    @Override
    public String getName() {
        return "PropertyDetails";
    }

    public SortedSet<Element> members(TypeElement typeElement) {
        return this.visibleMemberMap.getMembersFor(typeElement);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return !this.properties.isEmpty();
    }

    public void buildPropertyDoc(XMLNode node, Content memberDetailsTree) {
        if (this.writer == null) {
            return;
        }
        int size = this.properties.size();
        if (size > 0) {
            Content propertyDetailsTree = this.writer.getPropertyDetailsTreeHeader(this.typeElement, memberDetailsTree);
            for (Element e : this.properties) {
                this.currentProperty = (ExecutableElement)e;
                Content propertyDocTree = this.writer.getPropertyDocTreeHeader(this.currentProperty, propertyDetailsTree);
                this.buildChildren(node, propertyDocTree);
                propertyDetailsTree.addContent(this.writer.getPropertyDoc(propertyDocTree, this.currentProperty == this.properties.last()));
            }
            memberDetailsTree.addContent(this.writer.getPropertyDetails(propertyDetailsTree));
        }
    }

    public void buildSignature(XMLNode node, Content propertyDocTree) {
        propertyDocTree.addContent(this.writer.getSignature(this.currentProperty));
    }

    public void buildDeprecationInfo(XMLNode node, Content propertyDocTree) {
        this.writer.addDeprecated(this.currentProperty, propertyDocTree);
    }

    public void buildPropertyComments(XMLNode node, Content propertyDocTree) {
        if (!this.configuration.nocomment) {
            this.writer.addComments(this.currentProperty, propertyDocTree);
        }
    }

    public void buildTagInfo(XMLNode node, Content propertyDocTree) {
        this.writer.addTags(this.currentProperty, propertyDocTree);
    }

    public PropertyWriter getWriter() {
        return this.writer;
    }
}

