/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.toolkit.builders;

import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.SerialFieldTree;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.SerializedFormWriter;
import jdk.javadoc.internal.doclets.toolkit.builders.AbstractBuilder;
import jdk.javadoc.internal.doclets.toolkit.builders.XMLNode;
import jdk.javadoc.internal.doclets.toolkit.util.CommentHelper;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;

public class SerializedFormBuilder
extends AbstractBuilder {
    public static final String NAME = "SerializedForm";
    private SerializedFormWriter writer;
    private SerializedFormWriter.SerialFieldWriter fieldWriter;
    private SerializedFormWriter.SerialMethodWriter methodWriter;
    private static final String SERIAL_VERSION_UID = "serialVersionUID";
    private static final String SERIAL_VERSION_UID_HEADER = "serialVersionUID:";
    private PackageElement currentPackage;
    private TypeElement currentTypeElement;
    protected Element currentMember;
    private Content contentTree;

    private SerializedFormBuilder(AbstractBuilder.Context context) {
        super(context);
    }

    public static SerializedFormBuilder getInstance(AbstractBuilder.Context context) {
        return new SerializedFormBuilder(context);
    }

    @Override
    public void build() throws IOException {
        TreeSet<Element> rootclasses = new TreeSet<Element>(this.utils.makeGeneralPurposeComparator());
        rootclasses.addAll(this.configuration.root.getIncludedClasses());
        if (!this.serialClassFoundToDocument(rootclasses)) {
            return;
        }
        try {
            this.writer = this.configuration.getWriterFactory().getSerializedFormWriter();
            if (this.writer == null) {
                return;
            }
        }
        catch (Exception e) {
            throw new DocletAbortException(e);
        }
        this.build(this.layoutParser.parseXML(NAME), this.contentTree);
        this.writer.close();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void buildSerializedForm(XMLNode node, Content serializedTree) throws Exception {
        serializedTree = this.writer.getHeader(this.configuration.getText("doclet.Serialized_Form"));
        this.buildChildren(node, serializedTree);
        this.writer.addFooter(serializedTree);
        this.writer.printDocument(serializedTree);
        this.writer.close();
    }

    public void buildSerializedFormSummaries(XMLNode node, Content serializedTree) {
        Content serializedSummariesTree = this.writer.getSerializedSummariesHeader();
        Iterator iterator = this.configuration.packages.iterator();
        while (iterator.hasNext()) {
            PackageElement pkg;
            this.currentPackage = pkg = (PackageElement)iterator.next();
            this.buildChildren(node, serializedSummariesTree);
        }
        serializedTree.addContent(this.writer.getSerializedContent(serializedSummariesTree));
    }

    public void buildPackageSerializedForm(XMLNode node, Content serializedSummariesTree) {
        Content packageSerializedTree = this.writer.getPackageSerializedHeader();
        SortedSet<TypeElement> classes = this.utils.getAllClassesUnfiltered(this.currentPackage);
        if (classes.isEmpty()) {
            return;
        }
        if (!SerializedFormBuilder.serialInclude(this.utils, this.currentPackage)) {
            return;
        }
        if (!this.serialClassFoundToDocument(classes)) {
            return;
        }
        this.buildChildren(node, packageSerializedTree);
        this.writer.addPackageSerializedTree(serializedSummariesTree, packageSerializedTree);
    }

    public void buildPackageHeader(XMLNode node, Content packageSerializedTree) {
        packageSerializedTree.addContent(this.writer.getPackageHeader(this.utils.getPackageName(this.currentPackage)));
    }

    public void buildClassSerializedForm(XMLNode node, Content packageSerializedTree) {
        Content classSerializedTree = this.writer.getClassSerializedHeader();
        SortedSet<TypeElement> typeElements = this.utils.getAllClassesUnfiltered(this.currentPackage);
        Iterator iterator = typeElements.iterator();
        while (iterator.hasNext()) {
            TypeElement typeElement;
            this.currentTypeElement = typeElement = (TypeElement)iterator.next();
            this.fieldWriter = this.writer.getSerialFieldWriter(this.currentTypeElement);
            this.methodWriter = this.writer.getSerialMethodWriter(this.currentTypeElement);
            if (!this.utils.isClass(this.currentTypeElement) || !this.utils.isSerializable(this.currentTypeElement) || !SerializedFormBuilder.serialClassInclude(this.utils, this.currentTypeElement)) continue;
            Content classTree = this.writer.getClassHeader(this.currentTypeElement);
            this.buildChildren(node, classTree);
            classSerializedTree.addContent(classTree);
        }
        packageSerializedTree.addContent(classSerializedTree);
    }

    public void buildSerialUIDInfo(XMLNode node, Content classTree) {
        Content serialUidTree = this.writer.getSerialUIDInfoHeader();
        for (Element element : this.utils.getFieldsUnfiltered(this.currentTypeElement)) {
            VariableElement field = (VariableElement)element;
            if (field.getSimpleName().toString().compareTo(SERIAL_VERSION_UID) != 0 || field.getConstantValue() == null) continue;
            this.writer.addSerialUIDInfo(SERIAL_VERSION_UID_HEADER, this.utils.constantValueExpresion(field), serialUidTree);
            break;
        }
        classTree.addContent(serialUidTree);
    }

    public void buildClassContent(XMLNode node, Content classTree) {
        Content classContentTree = this.writer.getClassContentHeader();
        this.buildChildren(node, classContentTree);
        classTree.addContent(classContentTree);
    }

    public void buildSerializableMethods(XMLNode node, Content classContentTree) {
        Content serializableMethodTree = this.methodWriter.getSerializableMethodsHeader();
        SortedSet<ExecutableElement> members = this.utils.serializationMethods(this.currentTypeElement);
        if (!members.isEmpty()) {
            for (ExecutableElement member : members) {
                this.currentMember = member;
                Content methodsContentTree = this.methodWriter.getMethodsContentHeader(this.currentMember == members.last());
                this.buildChildren(node, methodsContentTree);
                serializableMethodTree.addContent(methodsContentTree);
            }
        }
        if (!this.utils.serializationMethods(this.currentTypeElement).isEmpty()) {
            classContentTree.addContent(this.methodWriter.getSerializableMethods(this.configuration.getText("doclet.Serialized_Form_methods"), serializableMethodTree));
            if (this.utils.isSerializable(this.currentTypeElement) && !this.utils.isExternalizable(this.currentTypeElement) && this.utils.serializationMethods(this.currentTypeElement).isEmpty()) {
                Content noCustomizationMsg = this.methodWriter.getNoCustomizationMsg(this.configuration.getText("doclet.Serializable_no_customization"));
                classContentTree.addContent(this.methodWriter.getSerializableMethods(this.configuration.getText("doclet.Serialized_Form_methods"), noCustomizationMsg));
            }
        }
    }

    public void buildMethodSubHeader(XMLNode node, Content methodsContentTree) {
        this.methodWriter.addMemberHeader((ExecutableElement)this.currentMember, methodsContentTree);
    }

    public void buildDeprecatedMethodInfo(XMLNode node, Content methodsContentTree) {
        this.methodWriter.addDeprecatedMemberInfo((ExecutableElement)this.currentMember, methodsContentTree);
    }

    public void buildMethodInfo(XMLNode node, Content methodsContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        this.buildChildren(node, methodsContentTree);
    }

    public void buildMethodDescription(XMLNode node, Content methodsContentTree) {
        this.methodWriter.addMemberDescription((ExecutableElement)this.currentMember, methodsContentTree);
    }

    public void buildMethodTags(XMLNode node, Content methodsContentTree) {
        this.methodWriter.addMemberTags((ExecutableElement)this.currentMember, methodsContentTree);
        ExecutableElement method = (ExecutableElement)this.currentMember;
        if (method.getSimpleName().toString().compareTo("writeExternal") == 0 && this.utils.getSerialDataTrees(method).isEmpty() && this.configuration.serialwarn) {
            TypeElement encl = (TypeElement)method.getEnclosingElement();
            this.configuration.getDocletSpecificMsg().warning(this.currentMember, "doclet.MissingSerialDataTag", encl.getQualifiedName().toString(), method.getSimpleName().toString());
        }
    }

    public void buildFieldHeader(XMLNode node, Content classContentTree) {
        if (!this.utils.serializableFields(this.currentTypeElement).isEmpty()) {
            this.buildFieldSerializationOverview(this.currentTypeElement, classContentTree);
        }
    }

    public void buildFieldSerializationOverview(TypeElement typeElement, Content classContentTree) {
        VariableElement ve;
        if (this.utils.definesSerializableFields(typeElement) && this.fieldWriter.shouldPrintOverview(ve = this.utils.serializableFields(typeElement).first())) {
            Content serializableFieldsTree = this.fieldWriter.getSerializableFieldsHeader();
            Content fieldsOverviewContentTree = this.fieldWriter.getFieldsContentHeader(true);
            this.fieldWriter.addMemberDeprecatedInfo(ve, fieldsOverviewContentTree);
            if (!this.configuration.nocomment) {
                this.fieldWriter.addMemberDescription(ve, fieldsOverviewContentTree);
                this.fieldWriter.addMemberTags(ve, fieldsOverviewContentTree);
            }
            serializableFieldsTree.addContent(fieldsOverviewContentTree);
            classContentTree.addContent(this.fieldWriter.getSerializableFields(this.configuration.getText("doclet.Serialized_Form_class"), serializableFieldsTree));
        }
    }

    public void buildSerializableFields(XMLNode node, Content classContentTree) {
        SortedSet<VariableElement> members = this.utils.serializableFields(this.currentTypeElement);
        if (!members.isEmpty()) {
            Content serializableFieldsTree = this.fieldWriter.getSerializableFieldsHeader();
            for (VariableElement ve : members) {
                this.currentMember = ve;
                if (!this.utils.definesSerializableFields(this.currentTypeElement)) {
                    Content fieldsContentTree = this.fieldWriter.getFieldsContentHeader(this.currentMember == members.last());
                    this.buildChildren(node, fieldsContentTree);
                    serializableFieldsTree.addContent(fieldsContentTree);
                    continue;
                }
                this.buildSerialFieldTagsInfo(serializableFieldsTree);
            }
            classContentTree.addContent(this.fieldWriter.getSerializableFields(this.configuration.getText("doclet.Serialized_Form_fields"), serializableFieldsTree));
        }
    }

    public void buildFieldSubHeader(XMLNode node, Content fieldsContentTree) {
        if (!this.utils.definesSerializableFields(this.currentTypeElement)) {
            VariableElement field = (VariableElement)this.currentMember;
            this.fieldWriter.addMemberHeader(this.utils.asTypeElement(field.asType()), this.utils.getTypeName(field.asType(), false), this.utils.getDimension(field.asType()), this.utils.getSimpleName(field), fieldsContentTree);
        }
    }

    public void buildFieldDeprecationInfo(XMLNode node, Content fieldsContentTree) {
        if (!this.utils.definesSerializableFields(this.currentTypeElement)) {
            this.fieldWriter.addMemberDeprecatedInfo((VariableElement)this.currentMember, fieldsContentTree);
        }
    }

    public void buildSerialFieldTagsInfo(Content serializableFieldsTree) {
        if (this.configuration.nocomment) {
            return;
        }
        VariableElement field = (VariableElement)this.currentMember;
        TreeSet<SerialFieldTree> tags = new TreeSet<SerialFieldTree>(this.utils.makeSerialFieldTreeComparator());
        for (DocTree docTree : this.utils.getSerialFieldTrees(field)) {
            SerialFieldTree st = (SerialFieldTree)docTree;
            tags.add(st);
        }
        CommentHelper ch = this.utils.getCommentHelper(field);
        for (SerialFieldTree tag : tags) {
            String refSignature;
            if (tag.getName() == null || tag.getType() == null) continue;
            Content fieldsContentTree = this.fieldWriter.getFieldsContentHeader(tag.equals(tags.last()));
            TypeElement te = ch.getReferencedClass(this.configuration, tag);
            String fieldType = ch.getReferencedMemberName(tag);
            if (te != null && this.utils.isPrimitive(te.asType())) {
                fieldType = this.utils.getTypeName(te.asType(), false);
                te = null;
            }
            if ((refSignature = ch.getReferencedSignature(tag)).endsWith("[]")) {
                te = null;
                fieldType = refSignature;
            }
            this.fieldWriter.addMemberHeader(te, fieldType, "", tag.getName().getName().toString(), fieldsContentTree);
            this.fieldWriter.addMemberDescription(field, tag, fieldsContentTree);
            serializableFieldsTree.addContent(fieldsContentTree);
        }
    }

    public void buildFieldInfo(XMLNode node, Content fieldsContentTree) {
        if (this.configuration.nocomment) {
            return;
        }
        VariableElement field = (VariableElement)this.currentMember;
        TypeElement te = this.utils.getEnclosingTypeElement(this.currentMember);
        if (this.utils.getSerialTrees(field).isEmpty() && this.configuration.serialwarn) {
            this.configuration.message.warning(field, "doclet.MissingSerialTag", this.utils.getFullyQualifiedName(te), this.utils.getSimpleName(field));
        }
        this.fieldWriter.addMemberDescription(field, fieldsContentTree);
        this.fieldWriter.addMemberTags(field, fieldsContentTree);
    }

    public static boolean serialInclude(Utils utils, Element element) {
        if (element == null) {
            return false;
        }
        return utils.isClass(element) ? SerializedFormBuilder.serialClassInclude(utils, (TypeElement)element) : SerializedFormBuilder.serialDocInclude(utils, element);
    }

    private static boolean serialClassInclude(Utils utils, TypeElement te) {
        if (utils.isEnum(te)) {
            return false;
        }
        if (utils.isSerializable(te)) {
            if (!utils.getSerialTrees(te).isEmpty()) {
                return SerializedFormBuilder.serialDocInclude(utils, te);
            }
            return utils.isPublic(te) || utils.isProtected(te);
        }
        return false;
    }

    private static boolean serialDocInclude(Utils utils, Element element) {
        if (utils.isEnum(element)) {
            return false;
        }
        List<? extends DocTree> serial = utils.getSerialTrees(element);
        if (!serial.isEmpty()) {
            CommentHelper ch = utils.getCommentHelper(element);
            String serialtext = Utils.toLowerCase(ch.getText(serial.get(0)));
            if (serialtext.contains("exclude")) {
                return false;
            }
            if (serialtext.contains("include")) {
                return true;
            }
        }
        return true;
    }

    private boolean serialClassFoundToDocument(SortedSet<TypeElement> classes) {
        for (TypeElement aClass : classes) {
            if (!SerializedFormBuilder.serialClassInclude(this.utils, aClass)) continue;
            return true;
        }
        return false;
    }
}

