/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.snapshot.LeafNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.utilities.Utilities;

public class StringNode
extends LeafNode<StringNode> {
    private final String value;

    public StringNode(String value, Node priority) {
        super(priority);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getHashRepresentation(Node.HashVersion version) {
        switch (version) {
            case V1: {
                String string = String.valueOf(this.getPriorityHash(version));
                String string2 = this.value;
                return new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("string:").append(string2).toString();
            }
            case V2: {
                String string = String.valueOf(this.getPriorityHash(version));
                String string3 = String.valueOf(Utilities.stringHashV2Representation(this.value));
                return new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string3).length()).append(string).append("string:").append(string3).toString();
            }
        }
        String string = String.valueOf((Object)version);
        throw new IllegalArgumentException(new StringBuilder(38 + String.valueOf(string).length()).append("Invalid hash version for string node: ").append(string).toString());
    }

    @Override
    public StringNode updatePriority(Node priority) {
        return new StringNode(this.value, priority);
    }

    @Override
    protected LeafNode.LeafType getLeafType() {
        return LeafNode.LeafType.String;
    }

    @Override
    protected int compareLeafValues(StringNode other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof StringNode)) {
            return false;
        }
        StringNode otherStringNode = (StringNode)other;
        return this.value.equals(otherStringNode.value) && this.priority.equals(otherStringNode.priority);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode() + this.priority.hashCode();
    }
}

