/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.util.GAuthToken;
import com.google.firebase.internal.GetTokenResult;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.OnCompleteListener;
import com.google.firebase.tasks.Task;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class JvmAuthTokenProvider
implements AuthTokenProvider {
    private final ScheduledExecutorService executorService;
    private final FirebaseApp firebaseApp;

    public JvmAuthTokenProvider(FirebaseApp firebaseApp, ScheduledExecutorService executorService) {
        this.executorService = executorService;
        this.firebaseApp = firebaseApp;
    }

    @Override
    public void getToken(boolean forceRefresh, final AuthTokenProvider.GetTokenCompletionListener listener) {
        ImplFirebaseTrampolines.getToken(this.firebaseApp, forceRefresh).addOnCompleteListener(this.executorService, new OnCompleteListener<GetTokenResult>(){

            @Override
            public void onComplete(@NonNull Task<GetTokenResult> task) {
                if (task.isSuccessful()) {
                    String oauthToken = task.getResult().getToken();
                    if (oauthToken == null) {
                        listener.onSuccess(null);
                    } else {
                        Map<String, Object> authVariable = JvmAuthTokenProvider.this.firebaseApp.getOptions().getDatabaseAuthVariableOverride();
                        GAuthToken gAuthToken = new GAuthToken(oauthToken, authVariable);
                        listener.onSuccess(gAuthToken.serializeToString());
                    }
                } else {
                    listener.onError(task.getException().toString());
                }
            }
        });
    }

    @Override
    public void addTokenChangeListener(AuthTokenProvider.TokenChangeListener listener) {
    }

    @Override
    public void removeTokenChangeListener(AuthTokenProvider.TokenChangeListener listener) {
    }
}

