/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.FirebaseCredentials;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Objects;
import com.google.firebase.internal.Preconditions;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class FirebaseOptions {
    private final String mDatabaseUrl;
    private final FirebaseCredential mFirebaseCredential;
    private final Map<String, Object> mDatabaseAuthVariableOverride;

    private FirebaseOptions(@Nullable String databaseUrl, @NonNull FirebaseCredential firebaseCredential, @Nullable Map<String, Object> databaseAuthVariableOverride) {
        Preconditions.checkArgument(firebaseCredential != null, "Service Account must be provided.");
        this.mDatabaseUrl = databaseUrl;
        this.mFirebaseCredential = firebaseCredential;
        this.mDatabaseAuthVariableOverride = databaseAuthVariableOverride;
    }

    public String getDatabaseUrl() {
        return this.mDatabaseUrl;
    }

    FirebaseCredential getCredential() {
        return this.mFirebaseCredential;
    }

    public Map<String, Object> getDatabaseAuthVariableOverride() {
        return this.mDatabaseAuthVariableOverride;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions other = (FirebaseOptions)o;
        return Objects.equal(this.mDatabaseUrl, other.mDatabaseUrl) && Objects.equal(this.mFirebaseCredential, other.mFirebaseCredential) && Objects.equal(this.mDatabaseAuthVariableOverride, other.mDatabaseAuthVariableOverride);
    }

    public int hashCode() {
        return Objects.hashCode(this.mDatabaseUrl, this.mFirebaseCredential, this.mDatabaseAuthVariableOverride);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("databaseUrl", this.mDatabaseUrl).add("credential", this.mFirebaseCredential).add("databaseAuthVariableOverride", this.mDatabaseAuthVariableOverride).toString();
    }

    public static final class Builder {
        private String mDatabaseUrl;
        private FirebaseCredential mFirebaseCredential;
        private FirebaseCredential mServiceAccountCredential;
        private Map<String, Object> mDatabaseAuthVariableOverride = new HashMap<String, Object>();

        public Builder() {
        }

        public Builder(FirebaseOptions options) {
            this.mDatabaseUrl = options.mDatabaseUrl;
            this.mFirebaseCredential = options.mFirebaseCredential;
            this.mDatabaseAuthVariableOverride = options.mDatabaseAuthVariableOverride;
        }

        public Builder setDatabaseUrl(@Nullable String databaseUrl) {
            this.mDatabaseUrl = databaseUrl;
            return this;
        }

        @Deprecated
        public Builder setServiceAccount(@NonNull InputStream stream) {
            this.mServiceAccountCredential = FirebaseCredentials.fromCertificate(stream);
            return this;
        }

        public Builder setCredential(@NonNull FirebaseCredential credential) {
            Preconditions.checkArgument(credential != null);
            this.mFirebaseCredential = credential;
            return this;
        }

        public Builder setDatabaseAuthVariableOverride(@Nullable Map<String, Object> databaseAuthVariableOverride) {
            this.mDatabaseAuthVariableOverride = databaseAuthVariableOverride;
            return this;
        }

        public FirebaseOptions build() {
            if (this.mServiceAccountCredential == null && this.mFirebaseCredential == null) {
                throw new IllegalStateException("FirebaseOptions must be initialized with setCredential().");
            }
            if (this.mServiceAccountCredential != null && this.mFirebaseCredential != null) {
                throw new IllegalStateException("FirebaseOptions cannot be initialized with both setCredential() and setServiceAccount().");
            }
            FirebaseCredential firebaseCredential = this.mFirebaseCredential != null ? this.mFirebaseCredential : this.mServiceAccountCredential;
            return new FirebaseOptions(this.mDatabaseUrl, firebaseCredential, this.mDatabaseAuthVariableOverride);
        }
    }
}

