/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.FirebaseAppStore;
import com.google.firebase.internal.Joiner;
import com.google.firebase.internal.NonNull;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SharedPrefsFirebaseAppStore
extends FirebaseAppStore {
    private static final int DATA_FORMAT_VERSION = 1;
    private static final String KEY_DATA_FORMAT_VERSION_VERSION = "version";
    private static final String KEY_FIREBASE_APP_NAMES = "firebase-app-names";
    private static final String KEY_PREFIX_API_KEY = "apiKey-";
    private static final String KEY_PREFIX_APP_ID = "appId-";
    private static final String KEY_PREFIX_DATABASE_URL = "dbUrl-";
    private static final String KEY_PREFIX_GA_TRACKING_ID = "gaTrackingId-";
    private static final String KEY_PREFIX_GCM_SENDER_ID = "gcmSenderId-";
    private static final String KEY_PREFIX_STORAGE_BUCKET = "storageBucket-";
    private static final String VALUE_SEPARATOR = ",";
    private final Object lock = new Object();
    private Preferences preferences;

    SharedPrefsFirebaseAppStore() {
    }

    private static String encodeValue(String value) {
        if (value == null) {
            value = "";
        }
        return BaseEncoding.base64Url().omitPadding().encode(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String decodeValue(String encodedValue) {
        String decodedValue = new String(BaseEncoding.base64Url().omitPadding().decode((CharSequence)encodedValue), StandardCharsets.UTF_8);
        if (Strings.isNullOrEmpty((String)decodedValue)) {
            return null;
        }
        return decodedValue;
    }

    private static void writeValue(Preferences prefs, String key, String value) {
        if (value != null) {
            prefs.put(key, SharedPrefsFirebaseAppStore.encodeValue(value));
        }
    }

    private static String readValue(Preferences prefs, String key) {
        String encodedValue = prefs.get(key, null);
        if (encodedValue != null) {
            return SharedPrefsFirebaseAppStore.decodeValue(encodedValue);
        }
        return null;
    }

    @Override
    public Set<String> getAllPersistedAppNames() {
        this.ensurePrefsInitialized();
        List<String> encodedAppNames = this.getEncodedAppNames();
        HashSet<String> persistedAppNames = new HashSet<String>();
        for (String encodedAppName : encodedAppNames) {
            persistedAppNames.add(SharedPrefsFirebaseAppStore.decodeValue(encodedAppName));
        }
        return persistedAppNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistApp(@NonNull FirebaseApp app) {
        Object object = this.lock;
        synchronized (object) {
            Preferences prefs = this.ensurePrefsInitialized();
            String encodedAppName = SharedPrefsFirebaseAppStore.encodeValue(app.getName());
            String encodedAppNamesValue = prefs.get(KEY_FIREBASE_APP_NAMES, "");
            List<String> encodedAppNames = Arrays.asList(encodedAppNamesValue.split(VALUE_SEPARATOR));
            if (!ImplFirebaseTrampolines.isDefaultApp(app) && encodedAppNames.contains(encodedAppName)) {
                this.checkPersistedAppCompatible(app);
                return;
            }
            FirebaseOptions options = app.getOptions();
            prefs.put(KEY_FIREBASE_APP_NAMES, encodedAppNamesValue + VALUE_SEPARATOR + encodedAppName);
            SharedPrefsFirebaseAppStore.writeValue(prefs, KEY_PREFIX_DATABASE_URL + encodedAppName, options.getDatabaseUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApp(@NonNull String name) {
        Object object = this.lock;
        synchronized (object) {
            Preferences prefs = this.ensurePrefsInitialized();
            String encodedAppName = SharedPrefsFirebaseAppStore.encodeValue(name);
            String encodedAppNamesValue = prefs.get(KEY_FIREBASE_APP_NAMES, "");
            List<String> encodedAppNames = Arrays.asList(encodedAppNamesValue.split(VALUE_SEPARATOR));
            ArrayList<String> updatedEncodedAppNames = new ArrayList<String>(encodedAppNames);
            updatedEncodedAppNames.remove(encodedAppName);
            prefs.put(KEY_FIREBASE_APP_NAMES, Joiner.on(VALUE_SEPARATOR).join(updatedEncodedAppNames));
            prefs.remove(KEY_PREFIX_API_KEY + encodedAppName);
            prefs.remove(KEY_PREFIX_APP_ID + encodedAppName);
            prefs.remove(KEY_PREFIX_DATABASE_URL + encodedAppName);
            prefs.remove(KEY_PREFIX_GA_TRACKING_ID + encodedAppName);
            prefs.remove(KEY_PREFIX_GCM_SENDER_ID + encodedAppName);
            prefs.remove(KEY_PREFIX_STORAGE_BUCKET + encodedAppName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirebaseOptions restoreAppOptions(@NonNull String name) {
        Object object = this.lock;
        synchronized (object) {
            Preferences prefs = this.ensurePrefsInitialized();
            String encodedName = SharedPrefsFirebaseAppStore.encodeValue(name);
            String applicationId = prefs.get(KEY_PREFIX_APP_ID + encodedName, null);
            if (applicationId == null) {
                return null;
            }
            return new FirebaseOptions.Builder().setDatabaseUrl(SharedPrefsFirebaseAppStore.readValue(prefs, KEY_PREFIX_DATABASE_URL + encodedName)).build();
        }
    }

    private void checkPersistedAppCompatible(FirebaseApp app) {
        String name = app.getName();
        FirebaseOptions options = this.restoreAppOptions(name);
        Preconditions.checkState((boolean)options.equals(app.getOptions()), (String)"FirebaseApp %s incompatible with persisted version! Persisted options: %s, Newly initialized app options: %s", (Object)app.getName(), (Object)options, (Object)app.getOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences ensurePrefsInitialized() {
        Object object = this.lock;
        synchronized (object) {
            if (this.preferences == null) {
                this.preferences = Preferences.userNodeForPackage(FirebaseApp.class);
                int readDataVersion = this.preferences.getInt(KEY_DATA_FORMAT_VERSION_VERSION, -1);
                if (readDataVersion == -1) {
                    this.resetStore();
                } else if (readDataVersion != 1) {
                    throw new IllegalStateException(String.format("Unexpected data format version. Was %d, but expected %d.", readDataVersion, 1));
                }
            }
        }
        return this.preferences;
    }

    private List<String> getEncodedAppNames() {
        String encodedAppNamesValue = this.preferences.get(KEY_FIREBASE_APP_NAMES, "");
        ArrayList<String> encodedAppNames = new ArrayList<String>();
        for (String encodedAppName : encodedAppNamesValue.split(VALUE_SEPARATOR)) {
            if (encodedAppName == null || encodedAppName.equals("")) continue;
            encodedAppNames.add(encodedAppName);
        }
        return encodedAppNames;
    }

    @Override
    protected void resetStore() {
        try {
            this.preferences.clear();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Could not clear Preferences", e);
        }
        this.preferences.putInt(KEY_DATA_FORMAT_VERSION_VERSION, 1);
    }
}

