/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.cloud;

import com.google.auth.Credentials;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.FirebaseService;

public class StorageClient {
    private final FirebaseApp app;
    private final Storage storage;
    private static final String SERVICE_ID = StorageClient.class.getName();

    private StorageClient(FirebaseApp app) {
        this.app = (FirebaseApp)Preconditions.checkNotNull((Object)app, (Object)"FirebaseApp must not be null");
        this.storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ImplFirebaseTrampolines.getCredentials(app))).build().getService();
    }

    public static StorageClient getInstance() {
        return StorageClient.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized StorageClient getInstance(FirebaseApp app) {
        StorageClientService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, StorageClientService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new StorageClientService(app));
        }
        return (StorageClient)service.getInstance();
    }

    public Bucket bucket() {
        return this.bucket(this.app.getOptions().getStorageBucket());
    }

    public Bucket bucket(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Bucket name not specified. Specify the bucket name via the storageBucket option when initializing the app, or specify the bucket name explicitly when calling the getBucket() method.");
        Bucket bucket = this.storage.get(name, new Storage.BucketGetOption[0]);
        Preconditions.checkArgument((bucket != null ? 1 : 0) != 0, (Object)("Bucket " + name + " does not exist."));
        return bucket;
    }

    private static class StorageClientService
    extends FirebaseService<StorageClient> {
        StorageClientService(FirebaseApp app) {
            super(SERVICE_ID, new StorageClient(app));
        }

        @Override
        public void destroy() {
        }
    }
}

