/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.annotations.VisibleForTesting;
import java.security.AccessControlException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevivingScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RevivingScheduledExecutor.class);
    private static final RuntimeException REVIVE_THREAD_EXCEPTION = new RuntimeException("Restarting Firebase Worker Thread. This exception is expected to occur periodically when deployed in the App Engine environment, and can be ignored.");
    private static final long PERIODIC_RESTART_INTERVAL_MS = TimeUnit.HOURS.toMillis(12L);
    private static final long PERIODIC_RESTART_OFFSET_MS = TimeUnit.MINUTES.toMillis(5L);
    private static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
    private final long initialDelayMs;
    private final long timeoutMs;
    private AtomicBoolean requestedRestart = new AtomicBoolean();

    public RevivingScheduledExecutor(ThreadFactory threadFactory, String threadName, boolean periodicRestart) {
        this(threadFactory, threadName, periodicRestart ? PERIODIC_RESTART_OFFSET_MS * (long)INSTANCE_COUNTER.get() : 0L, periodicRestart ? PERIODIC_RESTART_INTERVAL_MS : -1L);
    }

    @VisibleForTesting
    RevivingScheduledExecutor(final ThreadFactory threadFactory, final String threadName, long initialDelayMs, long timeoutMs) {
        super(0);
        INSTANCE_COUNTER.incrementAndGet();
        this.initialDelayMs = initialDelayMs;
        this.timeoutMs = timeoutMs;
        this.setRemoveOnCancelPolicy(true);
        this.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                logger.debug("Creating new thread for: {}", (Object)threadName);
                Thread thread = threadFactory.newThread(r);
                try {
                    thread.setName(threadName);
                    thread.setDaemon(true);
                }
                catch (AccessControlException accessControlException) {
                    // empty catch block
                }
                if (RevivingScheduledExecutor.this.requestedRestart.getAndSet(false)) {
                    RevivingScheduledExecutor.this.afterRestart();
                }
                return thread;
            }
        });
    }

    @Override
    public void execute(Runnable runnable) {
        this.ensureRunning();
        super.execute(runnable);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        this.ensureRunning();
        return task;
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        this.ensureRunning();
        return task;
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        if (throwable == null && runnable instanceof Future) {
            Future future = (Future)((Object)runnable);
            try {
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException ee) {
                throwable = ee.getCause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (throwable == REVIVE_THREAD_EXCEPTION) {
            throw (RuntimeException)throwable;
        }
        if (throwable != null) {
            this.handleException(throwable);
        }
    }

    protected void handleException(Throwable throwable) {
    }

    protected void beforeRestart() {
    }

    protected void afterRestart() {
    }

    private synchronized void ensureRunning() {
        if (this.getCorePoolSize() == 0) {
            this.setCorePoolSize(1);
            this.schedulePeriodicShutdown();
        }
    }

    private void schedulePeriodicShutdown() {
        if (this.timeoutMs >= 0L) {
            ScheduledFuture<?> scheduledFuture = this.schedule(new Runnable(){

                @Override
                public void run() {
                    ScheduledFuture<?> possiblyIgnoredError1 = RevivingScheduledExecutor.this.schedule(this, RevivingScheduledExecutor.this.timeoutMs, TimeUnit.MILLISECONDS);
                    RevivingScheduledExecutor.this.requestedRestart.set(true);
                    RevivingScheduledExecutor.this.beforeRestart();
                    throw REVIVE_THREAD_EXCEPTION;
                }
            }, this.initialDelayMs + this.timeoutMs, TimeUnit.MILLISECONDS);
        }
    }
}

