/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.DownloadAccountResponse;
import com.google.firebase.auth.internal.GetAccountInfoResponse;
import com.google.firebase.internal.SdkUtils;
import java.io.IOException;
import java.util.List;

class FirebaseUserManager {
    static final String USER_NOT_FOUND_ERROR = "USER_NOT_FOUND_ERROR";
    static final String USER_CREATE_ERROR = "USER_CREATE_ERROR";
    static final String USER_UPDATE_ERROR = "USER_UPDATE_ERROR";
    static final String USER_DELETE_ERROR = "USER_DELETE_ERROR";
    static final String LIST_USERS_ERROR = "LIST_USERS_ERROR";
    static final String INTERNAL_ERROR = "INTERNAL_ERROR";
    static final int MAX_LIST_USERS_RESULTS = 1000;
    static final List<String> RESERVED_CLAIMS = ImmutableList.of((Object)"amr", (Object)"at_hash", (Object)"aud", (Object)"auth_time", (Object)"azp", (Object)"cnf", (Object)"c_hash", (Object)"exp", (Object)"iat", (Object)"iss", (Object)"jti", (Object)"nbf", (Object[])new String[]{"nonce", "sub", "firebase"});
    private static final String ID_TOOLKIT_URL = "https://www.googleapis.com/identitytoolkit/v3/relyingparty/";
    private static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    private final JsonFactory jsonFactory;
    private final HttpRequestFactory requestFactory;
    private final String clientVersion = "Java/Admin/" + SdkUtils.getVersion();
    private HttpResponseInterceptor interceptor;

    FirebaseUserManager(JsonFactory jsonFactory, HttpTransport transport, GoogleCredentials credentials) {
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)jsonFactory, (Object)"jsonFactory must not be null");
        this.requestFactory = transport.createRequestFactory((HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)credentials));
    }

    @VisibleForTesting
    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    UserRecord getUserById(String uid) throws FirebaseAuthException {
        GetAccountInfoResponse response;
        ImmutableMap payload = ImmutableMap.of((Object)"localId", (Object)ImmutableList.of((Object)uid));
        try {
            response = this.post("getAccountInfo", payload, GetAccountInfoResponse.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "IO error while retrieving user with ID: " + uid, e);
        }
        if (response == null || response.getUsers() == null || response.getUsers().isEmpty()) {
            throw new FirebaseAuthException(USER_NOT_FOUND_ERROR, "No user record found for the provided user ID: " + uid);
        }
        return new UserRecord(response.getUsers().get(0), this.jsonFactory);
    }

    UserRecord getUserByEmail(String email) throws FirebaseAuthException {
        GetAccountInfoResponse response;
        ImmutableMap payload = ImmutableMap.of((Object)"email", (Object)ImmutableList.of((Object)email));
        try {
            response = this.post("getAccountInfo", payload, GetAccountInfoResponse.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "IO error while retrieving user with email: " + email, e);
        }
        if (response == null || response.getUsers() == null || response.getUsers().isEmpty()) {
            throw new FirebaseAuthException(USER_NOT_FOUND_ERROR, "No user record found for the provided email: " + email);
        }
        return new UserRecord(response.getUsers().get(0), this.jsonFactory);
    }

    UserRecord getUserByPhoneNumber(String phoneNumber) throws FirebaseAuthException {
        GetAccountInfoResponse response;
        ImmutableMap payload = ImmutableMap.of((Object)"phoneNumber", (Object)ImmutableList.of((Object)phoneNumber));
        try {
            response = this.post("getAccountInfo", payload, GetAccountInfoResponse.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "IO error while retrieving user with phone number: " + phoneNumber, e);
        }
        if (response == null || response.getUsers() == null || response.getUsers().isEmpty()) {
            throw new FirebaseAuthException(USER_NOT_FOUND_ERROR, "No user record found for the provided phone number: " + phoneNumber);
        }
        return new UserRecord(response.getUsers().get(0), this.jsonFactory);
    }

    String createUser(UserRecord.CreateRequest request) throws FirebaseAuthException {
        String uid;
        GenericJson response;
        try {
            response = this.post("signupNewUser", request.getProperties(), GenericJson.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(USER_CREATE_ERROR, "IO error while creating user account", e);
        }
        if (response != null && !Strings.isNullOrEmpty((String)(uid = (String)response.get((Object)"localId")))) {
            return uid;
        }
        throw new FirebaseAuthException(USER_CREATE_ERROR, "Failed to create new user");
    }

    void updateUser(UserRecord.UpdateRequest request, JsonFactory jsonFactory) throws FirebaseAuthException {
        GenericJson response;
        try {
            response = this.post("setAccountInfo", request.getProperties(jsonFactory), GenericJson.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(USER_UPDATE_ERROR, "IO error while updating user: " + request.getUid(), e);
        }
        if (response == null || !request.getUid().equals(response.get((Object)"localId"))) {
            throw new FirebaseAuthException(USER_UPDATE_ERROR, "Failed to update user: " + request.getUid());
        }
    }

    void deleteUser(String uid) throws FirebaseAuthException {
        GenericJson response;
        ImmutableMap payload = ImmutableMap.of((Object)"localId", (Object)uid);
        try {
            response = this.post("deleteAccount", payload, GenericJson.class);
        }
        catch (IOException e) {
            throw new FirebaseAuthException(USER_DELETE_ERROR, "IO error while deleting user: " + uid, e);
        }
        if (response == null || !response.containsKey((Object)"kind")) {
            throw new FirebaseAuthException(USER_DELETE_ERROR, "Failed to delete user: " + uid);
        }
    }

    DownloadAccountResponse listUsers(int maxResults, String pageToken) throws FirebaseAuthException {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"maxResults", (Object)maxResults);
        if (pageToken != null) {
            Preconditions.checkArgument((!pageToken.equals("") ? 1 : 0) != 0, (Object)"invalid end of list page token");
            builder.put((Object)"nextPageToken", (Object)pageToken);
        }
        try {
            DownloadAccountResponse response = this.post("downloadAccount", builder.build(), DownloadAccountResponse.class);
            if (response == null) {
                throw new FirebaseAuthException(LIST_USERS_ERROR, "Unexpected response from download user account API.");
            }
            return response;
        }
        catch (IOException e) {
            throw new FirebaseAuthException(LIST_USERS_ERROR, "IO error while downloading user accounts.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T post(String path, Object content, Class<T> clazz) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)path) ? 1 : 0) != 0, (Object)"path must not be null or empty");
        Preconditions.checkNotNull((Object)content, (Object)"content must not be null");
        Preconditions.checkNotNull(clazz, (Object)"response class must not be null");
        GenericUrl url = new GenericUrl(ID_TOOLKIT_URL + path);
        HttpRequest request = this.requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(this.jsonFactory, content));
        request.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
        request.getHeaders().set(CLIENT_VERSION_HEADER, (Object)this.clientVersion);
        request.setResponseInterceptor(this.interceptor);
        HttpResponse response = request.execute();
        try {
            Object object = response.parseAs(clazz);
            return (T)object;
        }
        finally {
            response.disconnect();
        }
    }
}

