/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.Clock;
import com.google.common.base.Preconditions;
import com.google.firebase.auth.internal.FirebaseCustomAuthToken;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Map;

public class FirebaseTokenFactory {
    private static FirebaseTokenFactory instance;
    private JsonFactory factory;
    private Clock clock;

    public FirebaseTokenFactory(JsonFactory factory, Clock clock) {
        this.factory = factory;
        this.clock = clock;
    }

    public static FirebaseTokenFactory getInstance() {
        if (null == instance) {
            instance = new FirebaseTokenFactory((JsonFactory)new GsonFactory(), Clock.SYSTEM);
        }
        return instance;
    }

    public String createSignedCustomAuthTokenForUser(String uid, String issuer, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        return this.createSignedCustomAuthTokenForUser(uid, null, issuer, privateKey);
    }

    public String createSignedCustomAuthTokenForUser(String uid, Map<String, Object> developerClaims, String issuer, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        Preconditions.checkState((uid != null ? 1 : 0) != 0, (Object)"Uid must be provided.");
        Preconditions.checkState((issuer != null && !"".equals(issuer) ? 1 : 0) != 0, (Object)"Must provide an issuer.");
        Preconditions.checkState((uid.length() <= 128 ? 1 : 0) != 0, (Object)"Uid must be shorter than 128 characters.");
        JsonWebSignature.Header header = new JsonWebSignature.Header().setAlgorithm("RS256");
        long issuedAt = this.clock.currentTimeMillis() / 1000L;
        FirebaseCustomAuthToken.Payload payload = new FirebaseCustomAuthToken.Payload().setUid(uid).setIssuer(issuer).setSubject(issuer).setAudience("https://identitytoolkit.googleapis.com/google.identity.identitytoolkit.v1.IdentityToolkit").setIssuedAtTimeSeconds(issuedAt).setExpirationTimeSeconds(issuedAt + 3600L);
        if (developerClaims != null) {
            Collection reservedNames = payload.getClassInfo().getNames();
            for (String key : developerClaims.keySet()) {
                if (!reservedNames.contains(key)) continue;
                throw new IllegalArgumentException(String.format("developer_claims can not contain a reserved key: %s", key));
            }
            GenericJson jsonObject = new GenericJson();
            jsonObject.putAll(developerClaims);
            payload.setDeveloperClaims(jsonObject);
        }
        return JsonWebSignature.signUsingRsaSha256((PrivateKey)privateKey, (JsonFactory)this.factory, (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
    }
}

