/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.messaging.ApsAlert;

public class Aps {
    @Key(value="alert")
    private final Object alert;
    @Key(value="badge")
    private final Integer badge;
    @Key(value="sound")
    private final String sound;
    @Key(value="content-available")
    private final Integer contentAvailable;
    @Key(value="category")
    private final String category;
    @Key(value="thread-id")
    private final String threadId;

    private Aps(Builder builder) {
        Preconditions.checkArgument((Strings.isNullOrEmpty((String)builder.alertString) || builder.alert == null ? 1 : 0) != 0, (Object)"Multiple alert specifications (string and ApsAlert) found.");
        this.alert = builder.alert != null ? builder.alert : builder.alertString;
        this.badge = builder.badge;
        this.sound = builder.sound;
        this.contentAvailable = builder.contentAvailable ? Integer.valueOf(1) : null;
        this.category = builder.category;
        this.threadId = builder.threadId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String alertString;
        private ApsAlert alert;
        private Integer badge;
        private String sound;
        private boolean contentAvailable;
        private String category;
        private String threadId;

        private Builder() {
        }

        public Builder setAlert(String alert) {
            this.alertString = alert;
            return this;
        }

        public Builder setAlert(ApsAlert alert) {
            this.alert = alert;
            return this;
        }

        public Builder setBadge(int badge) {
            this.badge = badge;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setContentAvailable(boolean contentAvailable) {
            this.contentAvailable = contentAvailable;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setThreadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public Aps build() {
            return new Aps(this);
        }
    }
}

