/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.RuntimeExecutionException;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListener;
import com.google.firebase.tasks.TaskImpl;
import java.util.concurrent.Executor;

class ContinueWithCompletionListener<T, R>
implements TaskCompletionListener<T> {
    private final Executor executor;
    private final Continuation<T, R> continuation;
    private final TaskImpl<R> continuationTask;

    public ContinueWithCompletionListener(@NonNull Executor executor, @NonNull Continuation<T, R> continuation, @NonNull TaskImpl<R> continuationTask) {
        this.executor = executor;
        this.continuation = continuation;
        this.continuationTask = continuationTask;
    }

    @Override
    public void onComplete(final @NonNull Task<T> task) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = ContinueWithCompletionListener.this.continuation.then(task);
                }
                catch (RuntimeExecutionException e) {
                    if (e.getCause() instanceof Exception) {
                        ContinueWithCompletionListener.this.continuationTask.setException((Exception)e.getCause());
                    } else {
                        ContinueWithCompletionListener.this.continuationTask.setException(e);
                    }
                    return;
                }
                catch (Exception e) {
                    ContinueWithCompletionListener.this.continuationTask.setException(e);
                    return;
                }
                ContinueWithCompletionListener.this.continuationTask.setResult(result);
            }
        });
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException();
    }
}

