/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Clock;
import com.google.api.core.ApiFuture;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.ListUsersPage;
import com.google.firebase.auth.SessionCookieOptions;
import com.google.firebase.auth.UserRecord;
import com.google.firebase.auth.internal.FirebaseTokenFactory;
import com.google.firebase.auth.internal.FirebaseTokenVerifier;
import com.google.firebase.auth.internal.KeyManagers;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseAuth {
    private static final String ERROR_CUSTOM_TOKEN = "ERROR_CUSTOM_TOKEN";
    private static final String ERROR_INVALID_ID_TOKEN = "ERROR_INVALID_CREDENTIAL";
    private static final String ERROR_INVALID_SESSION_COOKIE = "ERROR_INVALID_COOKIE";
    private final Clock clock;
    private final FirebaseApp firebaseApp;
    private final KeyManagers keyManagers;
    private final GoogleCredentials credentials;
    private final String projectId;
    private final JsonFactory jsonFactory;
    private final FirebaseUserManager userManager;
    private final AtomicBoolean destroyed;
    private final Object lock;
    private static final String SERVICE_ID = FirebaseAuth.class.getName();

    private FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, KeyManagers.getDefault(firebaseApp, Clock.SYSTEM), Clock.SYSTEM);
    }

    @VisibleForTesting
    FirebaseAuth(FirebaseApp firebaseApp, KeyManagers keyManagers, Clock clock) {
        this.firebaseApp = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.keyManagers = (KeyManagers)Preconditions.checkNotNull((Object)keyManagers);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.credentials = ImplFirebaseTrampolines.getCredentials(firebaseApp);
        this.projectId = ImplFirebaseTrampolines.getProjectId(firebaseApp);
        this.jsonFactory = firebaseApp.getOptions().getJsonFactory();
        this.userManager = new FirebaseUserManager(firebaseApp);
        this.destroyed = new AtomicBoolean(false);
        this.lock = new Object();
    }

    public static FirebaseAuth getInstance() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseAuth getInstance(FirebaseApp app) {
        FirebaseAuthService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseAuthService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseAuthService(app));
        }
        return (FirebaseAuth)service.getInstance();
    }

    public String createSessionCookie(@NonNull String idToken, @NonNull SessionCookieOptions options) throws FirebaseAuthException {
        return this.createSessionCookieOp(idToken, options).call();
    }

    public ApiFuture<String> createSessionCookieAsync(@NonNull String idToken, @NonNull SessionCookieOptions options) {
        return this.createSessionCookieOp(idToken, options).callAsync(this.firebaseApp);
    }

    private CallableOperation<String, FirebaseAuthException> createSessionCookieOp(final String idToken, final SessionCookieOptions options) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)idToken) ? 1 : 0) != 0, (Object)"idToken must not be null or empty");
        Preconditions.checkNotNull((Object)options, (Object)"options must not be null");
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            protected String execute() throws FirebaseAuthException {
                return FirebaseAuth.this.userManager.createSessionCookie(idToken, options);
            }
        };
    }

    public FirebaseToken verifySessionCookie(String cookie) throws FirebaseAuthException {
        return this.verifySessionCookie(cookie, false);
    }

    public FirebaseToken verifySessionCookie(String cookie, boolean checkRevoked) throws FirebaseAuthException {
        return this.verifySessionCookieOp(cookie, checkRevoked).call();
    }

    public ApiFuture<FirebaseToken> verifySessionCookieAsync(String cookie) {
        return this.verifySessionCookieAsync(cookie, false);
    }

    public ApiFuture<FirebaseToken> verifySessionCookieAsync(String cookie, boolean checkRevoked) {
        return this.verifySessionCookieOp(cookie, checkRevoked).callAsync(this.firebaseApp);
    }

    private CallableOperation<FirebaseToken, FirebaseAuthException> verifySessionCookieOp(final String cookie, final boolean checkRevoked) {
        this.checkNotDestroyed();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)this.projectId) ? 1 : 0) != 0, (Object)"Must initialize FirebaseApp with a project ID to call verifySessionCookie()");
        return new CallableOperation<FirebaseToken, FirebaseAuthException>(){

            @Override
            public FirebaseToken execute() throws FirebaseAuthException {
                FirebaseToken firebaseToken;
                FirebaseTokenVerifier firebaseTokenVerifier = FirebaseTokenVerifier.createSessionCookieVerifier(FirebaseAuth.this.projectId, FirebaseAuth.this.keyManagers, FirebaseAuth.this.clock);
                try {
                    firebaseToken = FirebaseToken.parse(FirebaseAuth.this.jsonFactory, cookie);
                }
                catch (IOException e) {
                    throw new FirebaseAuthException(FirebaseAuth.ERROR_INVALID_SESSION_COOKIE, "Failed to parse cookie", e);
                }
                firebaseTokenVerifier.verifyTokenAndSignature(firebaseToken.getToken());
                if (checkRevoked) {
                    FirebaseAuth.this.checkRevoked(firebaseToken, "session cookie", "session-cookie-revoked");
                }
                return firebaseToken;
            }
        };
    }

    private void checkRevoked(FirebaseToken firebaseToken, String label, String errorCode) throws FirebaseAuthException {
        String uid = firebaseToken.getUid();
        UserRecord user = this.userManager.getUserById(uid);
        long issuedAt = (Long)firebaseToken.getClaims().get("iat");
        if (user.getTokensValidAfterTimestamp() > issuedAt * 1000L) {
            throw new FirebaseAuthException(errorCode, "Firebase " + label + " revoked");
        }
    }

    public String createCustomToken(@NonNull String uid) throws FirebaseAuthException {
        return this.createCustomToken(uid, null);
    }

    public String createCustomToken(@NonNull String uid, @Nullable Map<String, Object> developerClaims) throws FirebaseAuthException {
        return this.createCustomTokenOp(uid, developerClaims).call();
    }

    public ApiFuture<String> createCustomTokenAsync(@NonNull String uid) {
        return this.createCustomTokenAsync(uid, null);
    }

    public ApiFuture<String> createCustomTokenAsync(@NonNull String uid, @Nullable Map<String, Object> developerClaims) {
        return this.createCustomTokenOp(uid, developerClaims).callAsync(this.firebaseApp);
    }

    private CallableOperation<String, FirebaseAuthException> createCustomTokenOp(final String uid, final Map<String, Object> developerClaims) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        Preconditions.checkArgument((boolean)(this.credentials instanceof ServiceAccountCredentials), (Object)"Must initialize FirebaseApp with a service account credential to call createCustomToken()");
        return new CallableOperation<String, FirebaseAuthException>(){

            @Override
            public String execute() throws FirebaseAuthException {
                ServiceAccountCredentials serviceAccount = (ServiceAccountCredentials)FirebaseAuth.this.credentials;
                FirebaseTokenFactory tokenFactory = FirebaseTokenFactory.getInstance();
                try {
                    return tokenFactory.createSignedCustomAuthTokenForUser(uid, developerClaims, serviceAccount.getClientEmail(), serviceAccount.getPrivateKey());
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new FirebaseAuthException(FirebaseAuth.ERROR_CUSTOM_TOKEN, "Failed to generate a custom token", e);
                }
            }
        };
    }

    public FirebaseToken verifyIdToken(@NonNull String token) throws FirebaseAuthException {
        return this.verifyIdToken(token, false);
    }

    public FirebaseToken verifyIdToken(@NonNull String token, boolean checkRevoked) throws FirebaseAuthException {
        return this.verifyIdTokenOp(token, checkRevoked).call();
    }

    public ApiFuture<FirebaseToken> verifyIdTokenAsync(@NonNull String token) {
        return this.verifyIdTokenAsync(token, false);
    }

    public ApiFuture<FirebaseToken> verifyIdTokenAsync(@NonNull String token, boolean checkRevoked) {
        return this.verifyIdTokenOp(token, checkRevoked).callAsync(this.firebaseApp);
    }

    private CallableOperation<FirebaseToken, FirebaseAuthException> verifyIdTokenOp(final String token, final boolean checkRevoked) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0, (Object)"ID token must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.projectId) ? 1 : 0) != 0, (Object)"Must initialize FirebaseApp with a project ID to call verifyIdToken()");
        return new CallableOperation<FirebaseToken, FirebaseAuthException>(){

            @Override
            protected FirebaseToken execute() throws FirebaseAuthException {
                FirebaseToken firebaseToken;
                FirebaseTokenVerifier firebaseTokenVerifier = FirebaseTokenVerifier.createIdTokenVerifier(FirebaseAuth.this.projectId, FirebaseAuth.this.keyManagers, FirebaseAuth.this.clock);
                try {
                    firebaseToken = FirebaseToken.parse(FirebaseAuth.this.jsonFactory, token);
                }
                catch (IOException e) {
                    throw new FirebaseAuthException(FirebaseAuth.ERROR_INVALID_ID_TOKEN, "Failed to parse token", e);
                }
                firebaseTokenVerifier.verifyTokenAndSignature(firebaseToken.getToken());
                if (checkRevoked) {
                    FirebaseAuth.this.checkRevoked(firebaseToken, "auth token", "id-token-revoked");
                }
                return firebaseToken;
            }
        };
    }

    public void revokeRefreshTokens(@NonNull String uid) throws FirebaseAuthException {
        this.revokeRefreshTokensOp(uid).call();
    }

    public ApiFuture<Void> revokeRefreshTokensAsync(@NonNull String uid) {
        return this.revokeRefreshTokensOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> revokeRefreshTokensOp(final String uid) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                int currentTimeSeconds = (int)(System.currentTimeMillis() / 1000L);
                UserRecord.UpdateRequest request = new UserRecord.UpdateRequest(uid).setValidSince(currentTimeSeconds);
                FirebaseAuth.this.userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return null;
            }
        };
    }

    public UserRecord getUser(@NonNull String uid) throws FirebaseAuthException {
        return this.getUserOp(uid).call();
    }

    public ApiFuture<UserRecord> getUserAsync(@NonNull String uid) {
        return this.getUserOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserOp(final String uid) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return FirebaseAuth.this.userManager.getUserById(uid);
            }
        };
    }

    public UserRecord getUserByEmail(@NonNull String email) throws FirebaseAuthException {
        return this.getUserByEmailOp(email).call();
    }

    public ApiFuture<UserRecord> getUserByEmailAsync(@NonNull String email) {
        return this.getUserByEmailOp(email).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserByEmailOp(final String email) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email must not be null or empty");
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return FirebaseAuth.this.userManager.getUserByEmail(email);
            }
        };
    }

    public UserRecord getUserByPhoneNumber(@NonNull String phoneNumber) throws FirebaseAuthException {
        return this.getUserByPhoneNumberOp(phoneNumber).call();
    }

    public ApiFuture<UserRecord> getUserByPhoneNumberAsync(@NonNull String phoneNumber) {
        return this.getUserByPhoneNumberOp(phoneNumber).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> getUserByPhoneNumberOp(final String phoneNumber) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phoneNumber) ? 1 : 0) != 0, (Object)"phone number must not be null or empty");
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                return FirebaseAuth.this.userManager.getUserByPhoneNumber(phoneNumber);
            }
        };
    }

    public ListUsersPage listUsers(@Nullable String pageToken) throws FirebaseAuthException {
        return this.listUsers(pageToken, 1000);
    }

    public ListUsersPage listUsers(@Nullable String pageToken, int maxResults) throws FirebaseAuthException {
        return this.listUsersOp(pageToken, maxResults).call();
    }

    public ApiFuture<ListUsersPage> listUsersAsync(@Nullable String pageToken) {
        return this.listUsersAsync(pageToken, 1000);
    }

    public ApiFuture<ListUsersPage> listUsersAsync(@Nullable String pageToken, int maxResults) {
        return this.listUsersOp(pageToken, maxResults).callAsync(this.firebaseApp);
    }

    private CallableOperation<ListUsersPage, FirebaseAuthException> listUsersOp(@Nullable String pageToken, int maxResults) {
        this.checkNotDestroyed();
        final ListUsersPage.PageFactory factory = new ListUsersPage.PageFactory(new ListUsersPage.DefaultUserSource(this.userManager, this.jsonFactory), maxResults, pageToken);
        return new CallableOperation<ListUsersPage, FirebaseAuthException>(){

            @Override
            protected ListUsersPage execute() throws FirebaseAuthException {
                return factory.create();
            }
        };
    }

    public UserRecord createUser(@NonNull UserRecord.CreateRequest request) throws FirebaseAuthException {
        return this.createUserOp(request).call();
    }

    public ApiFuture<UserRecord> createUserAsync(@NonNull UserRecord.CreateRequest request) {
        return this.createUserOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> createUserOp(final UserRecord.CreateRequest request) {
        this.checkNotDestroyed();
        Preconditions.checkNotNull((Object)request, (Object)"create request must not be null");
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                String uid = FirebaseAuth.this.userManager.createUser(request);
                return FirebaseAuth.this.userManager.getUserById(uid);
            }
        };
    }

    public UserRecord updateUser(@NonNull UserRecord.UpdateRequest request) throws FirebaseAuthException {
        return this.updateUserOp(request).call();
    }

    public ApiFuture<UserRecord> updateUserAsync(@NonNull UserRecord.UpdateRequest request) {
        return this.updateUserOp(request).callAsync(this.firebaseApp);
    }

    private CallableOperation<UserRecord, FirebaseAuthException> updateUserOp(final UserRecord.UpdateRequest request) {
        this.checkNotDestroyed();
        Preconditions.checkNotNull((Object)request, (Object)"update request must not be null");
        return new CallableOperation<UserRecord, FirebaseAuthException>(){

            @Override
            protected UserRecord execute() throws FirebaseAuthException {
                FirebaseAuth.this.userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return FirebaseAuth.this.userManager.getUserById(request.getUid());
            }
        };
    }

    public void setCustomUserClaims(@NonNull String uid, @Nullable Map<String, Object> claims) throws FirebaseAuthException {
        this.setCustomUserClaimsOp(uid, claims).call();
    }

    public void setCustomClaims(@NonNull String uid, @Nullable Map<String, Object> claims) throws FirebaseAuthException {
        this.setCustomUserClaims(uid, claims);
    }

    public ApiFuture<Void> setCustomUserClaimsAsync(@NonNull String uid, @Nullable Map<String, Object> claims) {
        return this.setCustomUserClaimsOp(uid, claims).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> setCustomUserClaimsOp(final String uid, final Map<String, Object> claims) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                UserRecord.UpdateRequest request = new UserRecord.UpdateRequest(uid).setCustomClaims(claims);
                FirebaseAuth.this.userManager.updateUser(request, FirebaseAuth.this.jsonFactory);
                return null;
            }
        };
    }

    public void deleteUser(@NonNull String uid) throws FirebaseAuthException {
        this.deleteUserOp(uid).call();
    }

    public ApiFuture<Void> deleteUserAsync(String uid) {
        return this.deleteUserOp(uid).callAsync(this.firebaseApp);
    }

    private CallableOperation<Void, FirebaseAuthException> deleteUserOp(final String uid) {
        this.checkNotDestroyed();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        return new CallableOperation<Void, FirebaseAuthException>(){

            @Override
            protected Void execute() throws FirebaseAuthException {
                FirebaseAuth.this.userManager.deleteUser(uid);
                return null;
            }
        };
    }

    @VisibleForTesting
    FirebaseUserManager getUserManager() {
        return this.userManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotDestroyed() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((!this.destroyed.get() ? 1 : 0) != 0, (Object)"FirebaseAuth instance is no longer alive. This happens when the parent FirebaseApp instance has been deleted.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.destroyed.set(true);
        }
    }

    private static class FirebaseAuthService
    extends FirebaseService<FirebaseAuth> {
        FirebaseAuthService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseAuth(app));
        }

        @Override
        public void destroy() {
            ((FirebaseAuth)this.instance).destroy();
        }
    }
}

