/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.iid.FirebaseInstanceIdException;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.FirebaseRequestInitializer;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class FirebaseInstanceId {
    private static final String IID_SERVICE_URL = "https://console.firebase.google.com/v1";
    private static final Map<Integer, String> ERROR_CODES = ImmutableMap.builder().put((Object)400, (Object)"Malformed instance ID argument.").put((Object)401, (Object)"Request not authorized.").put((Object)403, (Object)"Project does not match instance ID or the client does not have sufficient privileges.").put((Object)404, (Object)"Failed to find the instance ID.").put((Object)409, (Object)"Already deleted.").put((Object)429, (Object)"Request throttled out by the backend server.").put((Object)500, (Object)"Internal server error.").put((Object)503, (Object)"Backend servers are over capacity. Try again later.").build();
    private final FirebaseApp app;
    private final HttpRequestFactory requestFactory;
    private final JsonFactory jsonFactory;
    private final String projectId;
    private HttpResponseInterceptor interceptor;
    private static final String SERVICE_ID = FirebaseInstanceId.class.getName();

    private FirebaseInstanceId(FirebaseApp app) {
        HttpTransport httpTransport = app.getOptions().getHttpTransport();
        this.app = app;
        this.requestFactory = httpTransport.createRequestFactory((HttpRequestInitializer)new FirebaseRequestInitializer(app));
        this.jsonFactory = app.getOptions().getJsonFactory();
        this.projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.projectId) ? 1 : 0) != 0, (Object)"Project ID is required to access instance ID service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GCLOUD_PROJECT environment variable.");
    }

    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseInstanceId getInstance(FirebaseApp app) {
        FirebaseInstanceIdService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseInstanceIdService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseInstanceIdService(app));
        }
        return (FirebaseInstanceId)service.getInstance();
    }

    @VisibleForTesting
    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void deleteInstanceId(@NonNull String instanceId) throws FirebaseInstanceIdException {
        this.deleteInstanceIdOp(instanceId).call();
    }

    public ApiFuture<Void> deleteInstanceIdAsync(@NonNull String instanceId) {
        return this.deleteInstanceIdOp(instanceId).callAsync(this.app);
    }

    private CallableOperation<Void, FirebaseInstanceIdException> deleteInstanceIdOp(final String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"instance ID must not be null or empty");
        return new CallableOperation<Void, FirebaseInstanceIdException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void execute() throws FirebaseInstanceIdException {
                String url = String.format("%s/project/%s/instanceId/%s", FirebaseInstanceId.IID_SERVICE_URL, FirebaseInstanceId.this.projectId, instanceId);
                HttpResponse response = null;
                try {
                    HttpRequest request = FirebaseInstanceId.this.requestFactory.buildDeleteRequest(new GenericUrl(url));
                    request.setParser((ObjectParser)new JsonObjectParser(FirebaseInstanceId.this.jsonFactory));
                    request.setResponseInterceptor(FirebaseInstanceId.this.interceptor);
                    response = request.execute();
                    ByteStreams.exhaust((InputStream)response.getContent());
                    FirebaseInstanceId.disconnectQuietly(response);
                }
                catch (Exception e) {
                    FirebaseInstanceId.this.handleError(instanceId, e);
                }
                finally {
                    FirebaseInstanceId.disconnectQuietly(response);
                }
                return null;
            }
        };
    }

    private static void disconnectQuietly(HttpResponse response) {
        if (response != null) {
            try {
                response.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleError(String instanceId, Exception e) throws FirebaseInstanceIdException {
        int statusCode;
        String msg = "Error while invoking instance ID service.";
        if (e instanceof HttpResponseException && ERROR_CODES.containsKey(statusCode = ((HttpResponseException)((Object)e)).getStatusCode())) {
            msg = String.format("Instance ID \"%s\": %s", instanceId, ERROR_CODES.get(statusCode));
        }
        throw new FirebaseInstanceIdException(msg, e);
    }

    private static class FirebaseInstanceIdService
    extends FirebaseService<FirebaseInstanceId> {
        FirebaseInstanceIdService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseInstanceId(app));
        }

        @Override
        public void destroy() {
        }
    }
}

