/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AndroidNotification {
    @Key(value="title")
    private final String title;
    @Key(value="body")
    private final String body;
    @Key(value="icon")
    private final String icon;
    @Key(value="color")
    private final String color;
    @Key(value="sound")
    private final String sound;
    @Key(value="tag")
    private final String tag;
    @Key(value="click_action")
    private final String clickAction;
    @Key(value="body_loc_key")
    private final String bodyLocKey;
    @Key(value="body_loc_args")
    private final List<String> bodyLocArgs;
    @Key(value="title_loc_key")
    private final String titleLocKey;
    @Key(value="title_loc_args")
    private final List<String> titleLocArgs;

    private AndroidNotification(Builder builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.icon = builder.icon;
        if (builder.color != null) {
            Preconditions.checkArgument((boolean)builder.color.matches("^#[0-9a-fA-F]{6}$"), (Object)"color must be in the form #RRGGBB");
        }
        this.color = builder.color;
        this.sound = builder.sound;
        this.tag = builder.tag;
        this.clickAction = builder.clickAction;
        this.bodyLocKey = builder.bodyLocKey;
        if (!builder.bodyLocArgs.isEmpty()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.bodyLocKey) ? 1 : 0) != 0, (Object)"bodyLocKey is required when specifying bodyLocArgs");
            this.bodyLocArgs = ImmutableList.copyOf((Collection)builder.bodyLocArgs);
        } else {
            this.bodyLocArgs = null;
        }
        this.titleLocKey = builder.titleLocKey;
        if (!builder.titleLocArgs.isEmpty()) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.titleLocKey) ? 1 : 0) != 0, (Object)"titleLocKey is required when specifying titleLocArgs");
            this.titleLocArgs = ImmutableList.copyOf((Collection)builder.titleLocArgs);
        } else {
            this.titleLocArgs = null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String body;
        private String icon;
        private String color;
        private String sound;
        private String tag;
        private String clickAction;
        private String bodyLocKey;
        private List<String> bodyLocArgs = new ArrayList<String>();
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder setColor(String color) {
            this.color = color;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setClickAction(String clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public Builder setBodyLocalizationKey(String bodyLocKey) {
            this.bodyLocKey = bodyLocKey;
            return this;
        }

        public Builder addBodyLocalizationArg(@NonNull String arg) {
            this.bodyLocArgs.add(arg);
            return this;
        }

        public Builder addAllBodyLocalizationArgs(@NonNull List<String> args) {
            this.bodyLocArgs.addAll(args);
            return this;
        }

        public Builder setTitleLocalizationKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public Builder addTitleLocalizationArg(@NonNull String arg) {
            this.titleLocArgs.add(arg);
            return this;
        }

        public Builder addAllTitleLocalizationArgs(@NonNull List<String> args) {
            this.titleLocArgs.addAll(args);
            return this;
        }

        public AndroidNotification build() {
            return new AndroidNotification(this);
        }
    }
}

