/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.multitenancy;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.AbstractFirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.SessionCookieOptions;
import java.util.concurrent.Executor;

public final class TenantAwareFirebaseAuth
extends AbstractFirebaseAuth {
    private final String tenantId;

    private TenantAwareFirebaseAuth(Builder builder) {
        super(builder);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.tenantId) ? 1 : 0) != 0);
        this.tenantId = builder.tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String createSessionCookie(String idToken, SessionCookieOptions options) throws FirebaseAuthException {
        this.verifyIdToken(idToken);
        return super.createSessionCookie(idToken, options);
    }

    @Override
    public ApiFuture<String> createSessionCookieAsync(final String idToken, final SessionCookieOptions options) {
        ApiFuture<FirebaseToken> future = this.verifyIdTokenAsync(idToken);
        return ApiFutures.transformAsync(future, (ApiAsyncFunction)new ApiAsyncFunction<FirebaseToken, String>(){

            public ApiFuture<String> apply(FirebaseToken input) {
                return TenantAwareFirebaseAuth.super.createSessionCookieAsync(idToken, options);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    protected void doDestroy() {
    }

    static TenantAwareFirebaseAuth fromApp(FirebaseApp app, String tenantId) {
        return TenantAwareFirebaseAuth.populateBuilderFromApp(TenantAwareFirebaseAuth.builder(), app, tenantId).setTenantId(tenantId).build();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends AbstractFirebaseAuth.Builder<Builder> {
        private String tenantId;

        private Builder() {
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        TenantAwareFirebaseAuth build() {
            return new TenantAwareFirebaseAuth(this);
        }
    }
}

